/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.util;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.jaxb.Group;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasServices;
import org.netbeans.modules.websvc.saas.model.wadl.Application;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.netbeans.modules.websvc.saas.model.wadl.Param;
import org.netbeans.modules.websvc.saas.model.wadl.ParamStyle;
import org.netbeans.modules.websvc.saas.model.wadl.Representation;
import org.netbeans.modules.websvc.saas.model.wadl.Resource;
import org.netbeans.modules.websvc.saas.model.wadl.Resources;
import org.netbeans.modules.websvc.saas.spi.MethodNodeActionsProvider;
import org.netbeans.modules.websvc.saas.spi.SaasNodeActionsProvider;
import org.netbeans.modules.xml.retriever.Retriever;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SaasUtil {
    public static final String APPLICATION_WADL = "resources/application.wadl";
    public static final String DEFAULT_SERVICE_NAME = "Service";
    public static final String CATALOG = "catalog";
    private static final ReadInputStream IS_READER = new InputStreamJaxbReader();
    public static final QName QNAME_GROUP = new QName("http://xml.netbeans.org/websvc/saas/services/1.0", "group");
    public static final QName QNAME_SAAS_SERVICES = new QName("http://xml.netbeans.org/websvc/saas/services/1.0", "saas-services");
    private static Lookup.Result<SaasNodeActionsProvider> extensionsResult = null;
    private static Lookup.Result<MethodNodeActionsProvider> methodsResult = null;

    public static <T> T loadJaxbObject(FileObject input, Class<T> type, boolean includeAware) throws IOException {
        return SaasUtil.loadJaxbObject(input, type, includeAware, IS_READER);
    }

    public static <T> T loadJaxbObject(FileObject input, Class<T> type, boolean includeAware, ReadInputStream reader) throws IOException {
        if (input == null) {
            return null;
        }
        InputStream in = null;
        try {
            Throwable jbex;
            block10: {
                T t;
                jbex = null;
                try {
                    in = input.getInputStream();
                    T t2 = reader.loadJaxbObject(in, type, includeAware);
                    if (t2 == null) break block10;
                    t = t2;
                }
                catch (JAXBException ex) {
                    jbex = ex;
                }
                catch (IOException ioe) {
                    jbex = ioe;
                }
                return t;
            }
            String msg = NbBundle.getMessage(SaasUtil.class, (String)"MSG_ErrorLoadingJaxb", (Object)type.getName(), (Object)input.getPath());
            IOException ioe = new IOException(msg);
            if (jbex != null) {
                ioe.initCause(jbex);
            }
            throw ioe;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static <T> T loadJaxbObject(InputStream in, Class<T> type) throws JAXBException {
        return SaasUtil.loadJaxbObject(in, type, false);
    }

    public static <T> T loadJaxbObject(Reader reader, Class<T> type, boolean includeAware) throws JAXBException {
        Object object;
        Unmarshaller unmarshaller = SaasUtil.getUnmarshaller(type);
        includeAware = false;
        if (includeAware) {
            SAXSource saxSource = SaasUtil.getSAXSourceWithXIncludeEnabled(reader);
            object = unmarshaller.unmarshal((Source)saxSource);
        } else {
            object = unmarshaller.unmarshal(reader);
        }
        return SaasUtil.cast(type, object);
    }

    public static <T> T loadJaxbObject(InputStream in, Class<T> type, boolean includeAware) throws JAXBException {
        Object object;
        Unmarshaller unmarshaller = SaasUtil.getUnmarshaller(type);
        includeAware = false;
        if (includeAware) {
            SAXSource saxSource = SaasUtil.getSAXSourceWithXIncludeEnabled(in);
            object = unmarshaller.unmarshal((Source)saxSource);
        } else {
            object = unmarshaller.unmarshal(in);
        }
        return SaasUtil.cast(type, object);
    }

    private static <T> T cast(Class<T> type, Object o) {
        if (type.equals(o.getClass())) {
            return type.cast(o);
        }
        if (o instanceof JAXBElement) {
            JAXBElement e = (JAXBElement)o;
            return type.cast(e.getValue());
        }
        throw new IllegalArgumentException("Expect: " + type.getName() + " get: " + o.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Unmarshaller getUnmarshaller(Class<T> type) throws JAXBException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SaasUtil.class.getClassLoader());
        JAXBContext jc = null;
        try {
            jc = JAXBContext.newInstance((String)type.getPackage().getName(), (ClassLoader)original);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        return unmarshaller;
    }

    public static SAXSource getSAXSourceWithXIncludeEnabled(InputStream in) {
        return SaasUtil.getSAXSourceWithXIncludeEnabled(new InputSource(in));
    }

    public static SAXSource getSAXSourceWithXIncludeEnabled(Reader reader) {
        return SaasUtil.getSAXSourceWithXIncludeEnabled(new InputSource(reader));
    }

    public static SAXSource getSAXSourceWithXIncludeEnabled(InputSource source) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setXIncludeAware(true);
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            return new SAXSource(xmlReader, source);
        }
        catch (ParserConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static SaasGroup loadSaasGroup(FileObject input) throws IOException {
        if (input == null) {
            return null;
        }
        Group g = SaasUtil.loadJaxbObject(input, Group.class, false);
        return new SaasGroup(null, g);
    }

    public static SaasGroup loadSaasGroup(InputStream input) throws JAXBException {
        Group g = SaasUtil.loadJaxbObject(input, Group.class);
        if (g != null) {
            return new SaasGroup(null, g);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSaasGroup(SaasGroup saasGroup, File outFile) throws IOException, JAXBException {
        FileOutputStream out = new FileOutputStream(outFile);
        try {
            SaasUtil.saveSaasGroup(saasGroup, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void saveSaasGroup(SaasGroup saasGroup, OutputStream output) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)Group.class.getPackage().getName());
        Marshaller marshaller = jc.createMarshaller();
        JAXBElement jbe = new JAXBElement(QNAME_GROUP, Group.class, (Object)saasGroup.getDelegate());
        marshaller.marshal((Object)jbe, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSaas(Saas saas, FileObject file) throws IOException, JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)SaasServices.class.getPackage().getName());
        Marshaller marshaller = jc.createMarshaller();
        JAXBElement jbe = new JAXBElement(QNAME_SAAS_SERVICES, SaasServices.class, (Object)saas.getDelegate());
        OutputStream out = null;
        FileLock lock = null;
        try {
            lock = file.lock();
            out = file.getOutputStream(lock);
            marshaller.marshal((Object)jbe, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public static Application loadWadl(FileObject wadlFile) throws IOException {
        return SaasUtil.loadJaxbObject(wadlFile, Application.class, true);
    }

    public static Application loadWadl(InputStream in) throws JAXBException {
        Reader reader = SaasUtil.getWadlReader(in);
        if (reader == null) {
            return null;
        }
        return SaasUtil.loadJaxbObject(reader, Application.class, true);
    }

    public static SaasServices loadSaasServices(FileObject wadlFile) throws IOException {
        return SaasUtil.loadJaxbObject(wadlFile, SaasServices.class, true);
    }

    public static SaasServices loadSaasServices(InputStream in) throws JAXBException {
        return SaasUtil.loadJaxbObject(in, SaasServices.class, true);
    }

    public static Collection<? extends SaasNodeActionsProvider> getSaasNodeActionsProviders() {
        if (extensionsResult == null) {
            extensionsResult = Lookup.getDefault().lookupResult(SaasNodeActionsProvider.class);
        }
        return extensionsResult.allInstances();
    }

    public static Collection<? extends MethodNodeActionsProvider> getMethodNodeActionsProviders() {
        if (methodsResult == null) {
            methodsResult = Lookup.getDefault().lookupResult(MethodNodeActionsProvider.class);
        }
        return methodsResult.allInstances();
    }

    public static Resource getParentResource(Application app, Method wm) {
        Resource r = null;
        for (Resources wadlResources : app.getResources()) {
            for (Resource base : wadlResources.getResource()) {
                r = SaasUtil.findParentResource(base, wm);
                if (r == null) continue;
                return r;
            }
        }
        return null;
    }

    static Resource findParentResource(Resource base, Method wm) {
        for (Object o : base.getMethodOrResource()) {
            Resource r;
            if (o instanceof Method) {
                Method m = (Method)o;
                if (m != wm) continue;
                return base;
            }
            if (!(o instanceof Resource) || (r = SaasUtil.findParentResource((Resource)o, wm)) == null) continue;
            return r;
        }
        return null;
    }

    public static Method wadlMethodFromIdRef(Application app, String methodIdRef) {
        String methodId = methodIdRef;
        if (methodId.charAt(0) == '#') {
            methodId = methodId.substring(1);
        }
        Method result = null;
        for (Object o : app.getResourceTypeOrMethodOrRepresentation()) {
            Method m;
            if (!(o instanceof Method) || !methodId.equals((m = (Method)o).getId())) continue;
            return m;
        }
        for (Resources wadlResources : app.getResources()) {
            for (Resource base : wadlResources.getResource()) {
                result = SaasUtil.findMethodById(base, methodId);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    static Method findMethodById(Resource base, String methodId) {
        for (Object o : base.getMethodOrResource()) {
            Method m;
            if (!(o instanceof Method ? methodId.equals((m = (Method)o).getId()) : (m = SaasUtil.findMethodById((Resource)o, methodId)) != null)) continue;
            return m;
        }
        return null;
    }

    public static Method wadlMethodFromXPath(Application app, String xpath) {
        String[] paths = xpath.split("/");
        Resource current = null;
        for (int pathIndex = 0; pathIndex < paths.length; ++pathIndex) {
            String path = paths[pathIndex];
            if ("application".equals(path) || path.length() == 0 || "resources".equals(path)) continue;
            if (path.startsWith("resource[")) {
                List<Resource> resources;
                int i = SaasUtil.getIndex(path);
                if (i > -1 && i < (resources = SaasUtil.getCurrentResources(app, current)).size()) {
                    current = resources.get(i);
                    continue;
                }
                return null;
            }
            if (!path.startsWith("method[")) continue;
            int iTarget = SaasUtil.getIndex(path);
            if (iTarget > -1) {
                int i = 0;
                for (Object o : current.getMethodOrResource()) {
                    if (!(o instanceof Method)) continue;
                    if (i == iTarget) {
                        if (pathIndex == paths.length - 1) {
                            return (Method)o;
                        }
                        return null;
                    }
                    if (i < iTarget) {
                        ++i;
                        continue;
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    static List<Resource> getCurrentResources(Application app, Resource current) {
        if (current == null) {
            LinkedList<Resource> result = new LinkedList<Resource>();
            for (Resources wadlResources : app.getResources()) {
                result.addAll(wadlResources.getResource());
            }
            return result;
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Object o : current.getMethodOrResource()) {
            if (!(o instanceof Resource)) continue;
            result.add((Resource)o);
        }
        return result;
    }

    static int getIndex(String path) {
        int iOpen = path.indexOf(91);
        int iClose = path.indexOf(93);
        if (iOpen < 0 || iClose < 0 || iClose <= iOpen) {
            return -1;
        }
        try {
            return Integer.valueOf(path.substring(iOpen + 1, iClose)) - 1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static Set<String> getMediaTypesFromJAXBElement(List<JAXBElement<Representation>> repElements) {
        HashSet<String> result = new HashSet<String>();
        for (JAXBElement<Representation> repElement : repElements) {
            result.add(((Representation)repElement.getValue()).getMediaType());
        }
        return result;
    }

    public static Set<String> getMediaTypes(List<Representation> repTypes) {
        HashSet<String> result = new HashSet<String>();
        for (Representation repType : repTypes) {
            result.add(repType.getMediaType());
        }
        return result;
    }

    public static String getSignature(WadlSaasMethod method) {
        WadlSaas saas = method.getSaas();
        Resource[] paths = method.getResourcePath();
        Method m = method.getWadlMethod();
        StringBuffer sb = new StringBuffer();
        sb.append(m.getName());
        sb.append(" : ");
        sb.append(saas.getBaseURL());
        for (Resource r : paths) {
            sb.append(r.getPath());
            sb.append('/');
        }
        Param[] params = null;
        if (m.getRequest() != null && m.getRequest().getParam() != null) {
            params = m.getRequest().getParam().toArray(new Param[m.getRequest().getParam().size()]);
            if (params.length > 0) {
                sb.append(" (");
            }
            for (int i = 0; i < params.length; ++i) {
                Param p = params[i];
                if (i > 0) {
                    sb.append(",");
                }
                if (p.getStyle() == ParamStyle.TEMPLATE) {
                    sb.append('{');
                    sb.append(p.getName());
                    sb.append('}');
                    continue;
                }
                if (p.getStyle() == ParamStyle.QUERY) {
                    sb.append('?');
                    sb.append(p.getName());
                    continue;
                }
                if (p.getStyle() == ParamStyle.MATRIX) {
                    sb.append('[');
                    sb.append(p.getName());
                    sb.append(']');
                    continue;
                }
                if (p.getStyle() == ParamStyle.HEADER) {
                    sb.append('<');
                    sb.append(p.getName());
                    sb.append('>');
                    continue;
                }
                sb.append(p.getName());
            }
            if (params.length > 0) {
                sb.append(" )");
            }
        }
        return sb.toString();
    }

    public static Image loadIcon(SaasGroup saasGroup, int type) {
        String path = saasGroup.getIcon16Path();
        if (type == 2 || type == 4) {
            path = saasGroup.getIcon32Path();
        }
        if (path != null) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(path);
            if (url != null) {
                return new ImageIcon(url).getImage();
            }
            return ImageUtilities.loadImage((String)path);
        }
        return null;
    }

    public static String deriveFileName(String path) {
        String name = null;
        try {
            URL url = new URL(path);
            name = url.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (name == null) {
            name = path;
        }
        name = name.substring(name.lastIndexOf(47) + 1);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject extractWadlFile(WadlSaas saas) throws IOException {
        FileObject wadlFile;
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(saas.getUrl());
        if (in == null) {
            return null;
        }
        OutputStream out = null;
        try {
            String wadlFileName;
            FileObject dir = saas.getSaasFolder();
            FileObject catalogDir = dir.getFileObject(CATALOG);
            if (catalogDir == null) {
                catalogDir = dir.createFolder(CATALOG);
            }
            if ((wadlFile = catalogDir.getFileObject(wadlFileName = SaasUtil.deriveFileName(saas.getUrl()))) == null) {
                wadlFile = catalogDir.createData(wadlFileName);
            }
            out = wadlFile.getOutputStream();
            FileUtil.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return wadlFile;
    }

    public static Saas getServiceByUrl(SaasGroup group, String url) {
        for (Saas s : group.getServices()) {
            if (!s.getUrl().equals(url)) continue;
            return s;
        }
        return null;
    }

    public static String getWadlServiceDirName(String wadlUrl) {
        int start;
        String name;
        String urlPath = wadlUrl.replace('\\', '/');
        if (urlPath.endsWith(APPLICATION_WADL)) {
            urlPath = urlPath.substring(0, urlPath.length() - APPLICATION_WADL.length() - 1);
        }
        if ((name = urlPath.substring(start = urlPath.lastIndexOf("/") + 1)).endsWith(".wadl") || name.endsWith(".WADL")) {
            name = name.substring(0, name.length() - 5);
        }
        name = name.replace('.', '-');
        return name;
    }

    public static String ensureUniqueServiceDirName(String name) {
        String result = name;
        for (int i = 0; i < 1000; ++i) {
            FileObject websvcHome = SaasServicesModel.getWebServiceHome();
            if (i > 0) {
                result = name + i;
            }
            if (websvcHome.getFileObject(result) != null) continue;
            try {
                websvcHome.createFolder(result);
            }
            catch (IOException e) {}
            break;
        }
        return result;
    }

    public static FileObject retrieveWadlFile(WadlSaas saas) {
        try {
            FileObject saasFolder = saas.getSaasFolder();
            File catalogFile = new File(FileUtil.toFile((FileObject)saasFolder), CATALOG);
            URI catalog = catalogFile.toURI();
            URI wadlUrl = new URI(saas.getUrl());
            return SaasUtil.getRetriever().retrieveResource(saasFolder, catalog, wadlUrl);
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    private static Retriever getRetriever() {
        Retriever r = (Retriever)Lookup.getDefault().lookup(Retriever.class);
        if (r != null) {
            return r;
        }
        return Retriever.getDefault();
    }

    public static String getSaasType(String url) {
        String urlLowerCase = url.toLowerCase();
        if (urlLowerCase.endsWith("wsdl") || urlLowerCase.endsWith("asmx")) {
            return "http://schemas.xmlsoap.org/wsdl/";
        }
        if (urlLowerCase.endsWith("http://research.sun.com/wadl/2006/10")) {
            return "http://research.sun.com/wadl/2006/10";
        }
        if (urlLowerCase.endsWith("http://wadl.dev.java.net/2009/02")) {
            return "http://wadl.dev.java.net/2009/02";
        }
        try {
            InputStream is = new URI(url).toURL().openStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int count = 0;
            while ((count = is.read(buffer)) != -1) {
                os.write(buffer, 0, count);
            }
            String doc = os.toString("UTF-8");
            if (doc.contains("http://schemas.xmlsoap.org/wsdl/") || doc.contains("wsdl")) {
                return "http://schemas.xmlsoap.org/wsdl/";
            }
            if (doc.contains("http://research.sun.com/wadl/2006/10")) {
                return "http://research.sun.com/wadl/2006/10";
            }
            if (doc.contains("http://wadl.dev.java.net/2009/02")) {
                return "http://wadl.dev.java.net/2009/02";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String filenameFromPath(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static String dirOnlyPath(String path) {
        int i = path.lastIndexOf(47);
        if (i > -1) {
            return path.substring(0, i);
        }
        return "";
    }

    public static FileObject saveResourceAsFile(FileObject baseDir, String destPath, String resourcePath) throws IOException {
        FileObject destDir = FileUtil.createFolder((FileObject)baseDir, (String)destPath);
        return SaasUtil.saveResourceAsFile(destDir, resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject saveResourceAsFile(FileObject destDir, String resourcePath) throws IOException {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
        String filename = SaasUtil.filenameFromPath(resourcePath);
        FileObject outFile = destDir.getFileObject(filename);
        if (outFile == null) {
            outFile = destDir.createData(filename);
        }
        OutputStream out = outFile.getOutputStream();
        if (in != null && out != null) {
            try {
                FileUtil.copy((InputStream)in, (OutputStream)out);
                FileObject fileObject = outFile;
                return fileObject;
            }
            finally {
                in.close();
                out.close();
            }
        }
        return null;
    }

    public static String toValidJavaName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            sb.append(name.charAt(0));
        }
        for (int i = 1; i < name.length(); ++i) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) continue;
            sb.append(name.charAt(i));
        }
        return sb.toString();
    }

    public static String deriveDefaultPackageName(Saas saas) {
        String pack1 = SaasUtil.toValidJavaName(saas.getTopLevelGroup().getName());
        String pack2 = SaasUtil.toValidJavaName(saas.getDisplayName());
        return (pack1 + "." + pack2).toLowerCase();
    }

    private static Reader getWadlReader(InputStream inputStream) throws JAXBException {
        StringReader iReader = null;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
            String xml = builder.toString();
            if (xml.contains("http://research.sun.com/wadl/2006/10")) {
                xml = xml.replace("http://research.sun.com/wadl/2006/10", "http://wadl.dev.java.net/2009/02");
            }
            iReader = new StringReader(xml);
        }
        catch (IOException e) {
            Logger.getLogger(SaasUtil.class.getName()).log(Level.WARNING, null, e);
            throw new JAXBException((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return iReader;
    }

    private static class InputStreamJaxbReader
    implements ReadInputStream {
        private InputStreamJaxbReader() {
        }

        @Override
        public <T> T loadJaxbObject(InputStream inputStream, Class<T> type, boolean includeAware) throws JAXBException {
            return SaasUtil.loadJaxbObject(inputStream, type, includeAware);
        }
    }

    private static class ApplicationReader
    implements ReadInputStream {
        private ApplicationReader() {
        }

        @Override
        public <T> T loadJaxbObject(InputStream inputStream, Class<T> type, boolean includeAware) throws JAXBException {
            return SaasUtil.loadJaxbObject(SaasUtil.getWadlReader(inputStream), type, includeAware);
        }
    }

    public static interface ReadInputStream {
        public <T> T loadJaxbObject(InputStream var1, Class<T> var2, boolean var3) throws JAXBException;
    }
}

