/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.modules.websvc.saas.model.CustomSaas;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.jaxb.Group;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasServices;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SaasServicesModel {
    public static final String PROP_GROUPS = "groups";
    public static final String PROP_SERVICES = "services";
    public static final String ROOT_GROUP = "Root";
    public static final String WEBSVC_HOME = System.getProperty("netbeans.user") + File.separator + "config" + File.separator + "WebServices";
    public static final String SERVICE_GROUP_XML = "service-groups.xml";
    public static final String PROFILE_PROPERTIES_FILE = "profile.properties";
    private SaasGroup rootGroup;
    private State state = State.UNINITIALIZED;
    private PropertyChangeSupport pps = new PropertyChangeSupport(this);
    private static SaasServicesModel instance;

    public static synchronized SaasServicesModel getInstance() {
        if (instance == null) {
            instance = new SaasServicesModel();
        }
        return instance;
    }

    private SaasServicesModel() {
    }

    public SaasGroup getInitialRootGroup() {
        if (this.rootGroup == null) {
            this.loadUserDefinedGroups();
        }
        return this.rootGroup;
    }

    public synchronized void initRootGroup() {
        if (this.state == State.READY) {
            return;
        }
        this.setState(State.INITIALIZING);
        this.getInitialRootGroup();
        this.loadFromDefaultFileSystem();
        this.loadFromWebServicesHome();
        WsdlUtil.ensureImportExisting60Services();
        this.setState(State.READY);
    }

    private void loadUserDefinedGroups() {
        FileObject input = FileUtil.toFileObject((File)new File(WEBSVC_HOME, SERVICE_GROUP_XML));
        try {
            if (input != null) {
                this.rootGroup = SaasUtil.loadSaasGroup(input);
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        if (this.rootGroup == null) {
            Group g = new Group();
            g.setName(ROOT_GROUP);
            this.rootGroup = new SaasGroup(null, g);
        }
    }

    private void loadFromDefaultFileSystem() {
        FileObject f = FileUtil.getConfigFile((String)"SaaSServices");
        if (f != null && f.isFolder()) {
            Enumeration en = f.getFolders(false);
            while (en.hasMoreElements()) {
                FileObject groupFolder = (FileObject)en.nextElement();
                for (FileObject fo : groupFolder.getChildren()) {
                    if (fo.isFolder() || PROFILE_PROPERTIES_FILE.equals(fo.getNameExt())) continue;
                    this.loadSaasServiceFile(fo, false);
                }
                SaasGroup g = this.rootGroup.getChildGroup(groupFolder.getName());
                if (g == null) continue;
                g.setIcon16Path((String)groupFolder.getAttribute("icon16"));
                g.setIcon32Path((String)groupFolder.getAttribute("icon32"));
            }
        }
    }

    public void saveRootGroup() {
        try {
            SaasUtil.saveSaasGroup(this.rootGroup, new File(WEBSVC_HOME, SERVICE_GROUP_XML));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static FileObject getWebServiceHome() {
        File websvcDir = new File(WEBSVC_HOME);
        if (!websvcDir.isFile()) {
            websvcDir.mkdirs();
        }
        return FileUtil.toFileObject((File)websvcDir);
    }

    private void loadFromWebServicesHome() {
        for (FileObject fo : SaasServicesModel.getWebServiceHome().getChildren()) {
            if (!fo.isFolder()) continue;
            for (FileObject file : fo.getChildren()) {
                if (!file.getNameExt().endsWith("-saas.xml")) continue;
                try {
                    this.loadSaasServiceFile(file, true);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private Saas createService(SaasGroup parent, SaasServices jaxbServiceObject) {
        if ("http://research.sun.com/wadl/2006/10".equals(jaxbServiceObject.getType()) || "http://wadl.dev.java.net/2009/02".equals(jaxbServiceObject.getType())) {
            return new WadlSaas(parent, jaxbServiceObject);
        }
        if ("http://schemas.xmlsoap.org/wsdl/".equals(jaxbServiceObject.getType())) {
            if (WsdlUtil.hasWsdlSupport()) {
                return new WsdlSaas(parent, jaxbServiceObject);
            }
        } else {
            return new CustomSaas(parent, jaxbServiceObject);
        }
        return null;
    }

    private void loadSaasServiceFile(FileObject saasFile, boolean userDefined) {
        try {
            SaasServices ss = SaasUtil.loadSaasServices(saasFile);
            Group g = ss.getSaasMetadata().getGroup();
            SaasGroup parent = this.rootGroup;
            Saas service = null;
            if (g == null || g.getName() == null || g.getName().trim().length() == 0) {
                service = this.createService(parent, ss);
                if (service != null) {
                    service.setUserDefined(userDefined);
                    parent.addService(service);
                }
            } else {
                while (g != null) {
                    SaasGroup child = parent.getChildGroup(g.getName());
                    if (child == null) {
                        child = new SaasGroup(parent, g);
                        parent.addChildGroup(child);
                    }
                    child.setUserDefined(userDefined);
                    if (g.getGroup().size() == 0) {
                        service = this.createService(child, ss);
                        if (service == null) break;
                        service.setUserDefined(userDefined);
                        child.addService(service);
                        break;
                    }
                    g = g.getGroup().get(0);
                    parent = child;
                }
            }
            if (service != null) {
                service.upgrade();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Error loading saas file: " + saasFile.getPath())));
        }
    }

    public SaasGroup getRootGroup() {
        this.initRootGroup();
        return this.rootGroup;
    }

    public State getState() {
        return this.state;
    }

    private synchronized void setState(State state) {
        this.state = state;
        if (state == State.READY) {
            this.fireChange(PROP_GROUPS, this.rootGroup, null, this.rootGroup.getChildrenGroups());
            this.fireChange(PROP_SERVICES, this.rootGroup, null, this.rootGroup.getServices());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pps.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pps.removePropertyChangeListener(l);
    }

    protected void fireChange(String propertyName, Object source, Object old, Object neu) {
        PropertyChangeEvent pce = new PropertyChangeEvent(source, propertyName, old, neu);
        this.pps.firePropertyChange(pce);
    }

    List<SaasGroup> getGroups() {
        return this.getRootGroup().getChildrenGroups();
    }

    public SaasGroup getTopGroup(String name) {
        return this.getRootGroup().getChildGroup(name);
    }

    public Saas getTopService(String name) {
        return this.getRootGroup().getChildService(name);
    }

    public synchronized SaasGroup createTopGroup(String groupName) {
        return this.createGroup(this.getInitialRootGroup(), groupName);
    }

    public synchronized SaasGroup createGroup(SaasGroup parent, String groupName) {
        this.initRootGroup();
        SaasGroup group = parent.createGroup(groupName);
        parent.addChildGroup(group);
        this.saveRootGroup();
        this.fireChange(PROP_GROUPS, parent, null, group);
        return group;
    }

    public synchronized void removeGroup(SaasGroup group) {
        this.initRootGroup();
        SaasGroup parent = group.getParent();
        if (parent == null || !parent.removeChildGroup(group)) {
            throw new IllegalArgumentException("Can't remove group " + group.getName());
        }
        this.saveRootGroup();
        this.fireChange(PROP_GROUPS, parent, group, null);
    }

    public synchronized WsdlSaas createWsdlService(SaasGroup parent, String displayName, String url, String packageName) {
        this.initRootGroup();
        WsdlSaas service = new WsdlSaas(parent, url, displayName, packageName);
        service.setUserDefined(true);
        parent.addService(service);
        service.save();
        this.fireChange(PROP_SERVICES, parent, null, service);
        return service;
    }

    public Saas createSaasService(SaasGroup parent, String url, String packageName) {
        String saasType = SaasUtil.getSaasType(url);
        if ("http://schemas.xmlsoap.org/wsdl/".equals(saasType)) {
            if (WsdlUtil.hasWsdlSupport()) {
                return this.createWsdlService(parent, url, packageName);
            }
            throw new RuntimeException(NbBundle.getMessage(SaasServicesModel.class, (String)"MSG_WsdlServiceNotSupported"));
        }
        if ("http://research.sun.com/wadl/2006/10".equals(saasType) || "http://wadl.dev.java.net/2009/02".equals(saasType)) {
            return this.createWadlService(parent, url, packageName);
        }
        throw new RuntimeException(NbBundle.getMessage(SaasServicesModel.class, (String)"MSG_UnknownSaasType"));
    }

    private WsdlSaas createWsdlService(SaasGroup parent, String url, String packageName) {
        return this.createWsdlService(parent, WsdlUtil.getServiceDirName(url), url, packageName);
    }

    private WadlSaas createWadlService(SaasGroup parent, String url, String packageName) {
        this.initRootGroup();
        String displayName = SaasUtil.getWadlServiceDirName(url);
        WadlSaas service = new WadlSaas(parent, url, displayName, packageName);
        service.toStateReady(false);
        service.setUserDefined(true);
        parent.addService(service);
        service.save();
        this.fireChange(PROP_SERVICES, parent, null, service);
        return service;
    }

    public synchronized void removeService(Saas service) {
        this.initRootGroup();
        SaasGroup parent = service.getParentGroup();
        parent.removeService(service);
        this._removeService(service);
        this.fireChange(PROP_SERVICES, parent, service, null);
    }

    void _removeService(Saas service) {
        try {
            FileObject saasFolder;
            if (service instanceof WsdlSaas) {
                WsdlSaas saas = (WsdlSaas)service;
                WsdlUtil.removeWsdlData(saas.getDelegate().getUrl());
            }
            if ((saasFolder = service.getSaasFolder()) != null) {
                saasFolder.delete();
            }
            service.setState(Saas.State.REMOVED);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public synchronized void renameGroup(SaasGroup group, String newName) {
        String oldName = group.getName();
        group.setName(newName);
        this.saveRootGroup();
        this.saveAllSaas(group);
        this.fireChange("groupName", group, oldName, newName);
    }

    private void saveAllSaas(SaasGroup group) {
        for (Saas s : group.getServices()) {
            s.save();
        }
        for (SaasGroup sg : group.getChildrenGroups()) {
            this.saveAllSaas(sg);
        }
    }

    public synchronized void refreshService(Saas saas) {
        saas.refresh();
    }

    void reset() {
        this.rootGroup = null;
        this.state = State.UNINITIALIZED;
    }

    public static enum State {
        UNINITIALIZED,
        INITIALIZING,
        READY;

    }
}

