/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

final class ExportSnapshotAction
extends AbstractAction {
    private static final String NPSS_EXT = ".npss";
    private static String LAST_DIRECTORY;
    private final FileObject snapshotFileObject;

    ExportSnapshotAction(FileObject snapshot) {
        this.snapshotFileObject = snapshot;
        this.putValue("Name", Bundle.ExportSnapshotAction_ActionName());
        this.putValue("ShortDescription", Bundle.ExportSnapshotAction_ActionDescr());
        this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Export"));
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Export"));
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser chooser = ExportSnapshotAction.createFileChooser();
                File file = FileUtil.toFile((FileObject)ExportSnapshotAction.this.snapshotFileObject);
                String filename = file.getName();
                File lastDir = LAST_DIRECTORY != null ? new File(LAST_DIRECTORY) : chooser.getCurrentDirectory();
                chooser.setSelectedFile(new File(lastDir, filename));
                Object parent = WindowManager.getDefault().getRegistry().getActivated();
                if (parent == null) {
                    parent = WindowManager.getDefault().getMainWindow();
                }
                if (chooser.showDialog((Component)parent, null) != 0) {
                    return;
                }
                File selected = chooser.getSelectedFile();
                if (selected.isDirectory()) {
                    LAST_DIRECTORY = selected.getAbsolutePath();
                    selected = new File(selected, filename);
                } else {
                    LAST_DIRECTORY = selected.getParent();
                }
                if (!ExportSnapshotAction.checkItselfOrOverwrite(file, selected)) {
                    ExportSnapshotAction.this.actionPerformed(e);
                } else {
                    ExportSnapshotAction.export(file, selected);
                }
            }
        });
    }

    private static void export(final File sourceFile, final File targetFile) {
        final ProgressHandle progress = ProgressHandleFactory.createHandle((String)Bundle.ExportSnapshotAction_ProgressMsg());
        progress.setInitialDelay(500);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                progress.start();
                try {
                    if (targetFile.exists() && !targetFile.delete()) {
                        ProfilerDialogs.displayError((String)Bundle.ExportSnapshotAction_CannotReplaceMsg(targetFile.getName()));
                    } else {
                        FileObject sourceFO = FileUtil.toFileObject((File)sourceFile);
                        FileObject targetFO = FileUtil.toFileObject((File)targetFile.getParentFile());
                        String targetName = targetFile.getName();
                        int targetExtIndex = targetName.indexOf(46);
                        if (targetExtIndex > -1) {
                            targetName = targetName.substring(0, targetExtIndex);
                        }
                        FileUtil.copyFile((FileObject)sourceFO, (FileObject)targetFO, (String)targetName);
                    }
                }
                catch (IOException e) {
                    ProfilerDialogs.displayError((String)Bundle.ExportSnapshotAction_ExportFailedMsg());
                    ProfilerLogger.log((String)("Failed to export NPSS snapshot: " + e.getMessage()));
                }
                finally {
                    progress.finish();
                }
            }
        });
    }

    private static JFileChooser createFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(Bundle.ExportSnapshotAction_FileChooserCaption());
        fileChooser.setDialogType(1);
        fileChooser.setApproveButtonText(Bundle.ExportSnapshotAction_ExportButtonText());
        fileChooser.removeChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(ExportSnapshotAction.NPSS_EXT);
            }

            @Override
            public String getDescription() {
                return Bundle.ExportSnapshotAction_NpssFileFilter(ExportSnapshotAction.NPSS_EXT);
            }
        });
        return fileChooser;
    }

    private static boolean checkItselfOrOverwrite(File source, File target) {
        if (!target.exists()) {
            return true;
        }
        if (source.equals(target)) {
            ProfilerDialogs.displayError((String)Bundle.ExportSnapshotAction_ExportToItselfMsg());
            return false;
        }
        return ProfilerDialogs.displayConfirmation((String)Bundle.ExportSnapshotAction_OverwriteFileMsg(target.getName()), (String)Bundle.ExportSnapshotAction_OverwriteFileCaption());
    }
}

