/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class PrintTable {
    private final String[] names;
    private final List<String[]> data;
    private int[] limits;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PrintTable(String[] fieldNames) {
        this.names = fieldNames;
        this.data = new ArrayList<String[]>();
    }

    public void setLimits(int[] limits) {
        if (!$assertionsDisabled && limits.length != this.names.length) {
            throw new AssertionError();
        }
        this.limits = limits;
    }

    public void addRow(String[] fields) {
        this.data.add(fields);
    }

    public void write(PrintStream ps) {
        String[] arr;
        int[] lengths = new int[this.names.length];
        PrintTable.length(this.names, lengths, this.limits);
        Iterator<String[]> i$ = this.data.iterator();
        while (i$.hasNext()) {
            arr = i$.next();
            PrintTable.length(arr, lengths, this.limits);
        }
        PrintTable.printRow(ps, this.names, lengths, this.limits);
        PrintTable.printSeparator(ps, lengths);
        i$ = this.data.iterator();
        while (i$.hasNext()) {
            arr = i$.next();
            PrintTable.printRow(ps, arr, lengths, this.limits);
        }
        PrintTable.printSeparator(ps, lengths);
    }

    private static void length(String[] data, int[] lengths, int[] limits) {
        if (!$assertionsDisabled && data.length != lengths.length) {
            throw new AssertionError();
        }
        for (int i = 0; i < data.length; ++i) {
            int l = data[i].length();
            if (limits != null && limits[i] >= 0 && l > limits[i]) {
                l = limits[i];
            }
            if (lengths[i] >= l) continue;
            lengths[i] = l;
        }
    }

    private static void printRow(PrintStream ps, String[] data, int[] lengths, int[] limits) {
        if (!$assertionsDisabled && data.length != lengths.length) {
            throw new AssertionError();
        }
        String sep = "";
        for (int i = 0; i < data.length; ++i) {
            ps.print(sep);
            String d = data[i];
            if (limits != null && limits[i] >= 0 && d.length() > limits[i]) {
                d = d.substring(0, limits[i]);
            }
            ps.print(d);
            int missing = lengths[i] - d.length();
            while (missing-- > 0) {
                ps.print(' ');
            }
            sep = " ";
        }
        ps.println();
    }

    private static void printSeparator(PrintStream ps, int[] lengths) {
        String sep = "";
        for (int i = 0; i < lengths.length; ++i) {
            ps.print(sep);
            for (int j = 0; j < lengths[i]; ++j) {
                ps.print('-');
            }
            sep = " ";
        }
        ps.println();
    }

    static {
        $assertionsDisabled = !PrintTable.class.desiredAssertionStatus();
    }
}

