/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.navigator.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.navigator.HtmlElementDescription;
import org.netbeans.modules.html.navigator.HtmlElementNode;
import org.netbeans.modules.html.navigator.actions.Bundle;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public final class OpenAction
extends AbstractAction {
    private HtmlElementNode node;

    public OpenAction(HtmlElementNode node) {
        this.node = node;
        this.putValue("Name", Bundle.goto_element());
    }

    private HtmlElementDescription getDesDescription() {
        HtmlElementDescription desc = (HtmlElementDescription)this.node.getDescription(1);
        if (desc != null) {
            return desc;
        }
        HtmlElementNode n = this.node;
        HtmlElementNode prev = this.node;
        while (desc == null) {
            prev = n;
            if ((n = (HtmlElementNode)n.getParentNode()) == null) {
                return null;
            }
            desc = (HtmlElementDescription)n.getDescription(1);
        }
        HtmlElementNode result = this.findPrevSource(n, prev);
        if (result != null) {
            return (HtmlElementDescription)result.getDescription(1);
        }
        return null;
    }

    private HtmlElementNode findPrevSource(HtmlElementNode root, HtmlElementNode prev) {
        HtmlElementNode last = null;
        for (Node no : root.getChildren().getNodes()) {
            HtmlElementNode htmlNode = (HtmlElementNode)no;
            if (htmlNode.getDescription(1) != null) {
                last = htmlNode;
            }
            if (!prev.equals((Object)htmlNode)) continue;
            return last == null ? root : last;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        final HtmlElementDescription description = this.getDesDescription();
        try {
            description.runTask(new HtmlElementDescription.Task(){

                @Override
                public void run(HtmlParserResult result) {
                    OffsetRange range = description.getOffsetRange((ParserResult)result);
                    UiUtils.open((FileObject)description.getFileObject(), (int)range.getStart());
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

