/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.navigator;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.html.navigator.DOMNodeDescription;
import org.netbeans.modules.html.navigator.Description;
import org.netbeans.modules.html.navigator.Diff;
import org.netbeans.modules.html.navigator.Utils;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.nodes.Children;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;

public class WebKitNodeDescription
extends DOMNodeDescription {
    private NodeListener nodeListener;
    private final Node webKitNode;
    private final String elementPath;
    private final Map<String, String> attributes;
    private Collection<WebKitNodeDescription> children;
    private Description parent;
    private org.openide.nodes.Node nbNode;
    private final transient ChangeSupport changeSupport = new ChangeSupport((Object)this);

    private void registerListener(org.openide.nodes.Node nbNode) {
        this.nodeListener = new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
                WebKitNodeDescription.this.fireChange();
            }

            public void childrenRemoved(NodeMemberEvent ev) {
                WebKitNodeDescription.this.fireChange();
            }

            public void childrenReordered(NodeReorderEvent ev) {
                WebKitNodeDescription.this.fireChange();
            }

            public void nodeDestroyed(NodeEvent ev) {
                WebKitNodeDescription.this.fireChange();
            }

            public void propertyChange(PropertyChangeEvent evt) {
                WebKitNodeDescription.this.fireChange();
            }
        };
        nbNode.addNodeListener(NodeOp.weakNodeListener((NodeListener)this.nodeListener, (Object)nbNode));
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removePropertyChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public static WebKitNodeDescription forNode(Description parent, org.openide.nodes.Node nbNode) {
        Node webKitNode = Utils.getWebKitNode(nbNode);
        if (webKitNode == null) {
            return null;
        }
        return new WebKitNodeDescription(parent, webKitNode, nbNode);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
        if (this.parent != null && this.parent instanceof WebKitNodeDescription) {
            ((WebKitNodeDescription)this.parent).fireChange();
        }
    }

    private WebKitNodeDescription(Description parent, Node webKitNode, org.openide.nodes.Node nbNode) {
        Parameters.notNull((CharSequence)"webKitNode", (Object)webKitNode);
        this.parent = parent;
        this.webKitNode = webKitNode;
        this.elementPath = new WebKitNodeTreePath(webKitNode).getElementPath();
        this.nbNode = nbNode;
        List attrs = webKitNode.getAttributes();
        if (attrs.isEmpty()) {
            this.attributes = Collections.emptyMap();
        } else {
            this.attributes = new HashMap<String, String>();
            for (Node.Attribute a : attrs) {
                String key = a.getName().toLowerCase();
                String val = a.getValue();
                this.attributes.put(key, val);
            }
        }
        this.registerListener(nbNode);
    }

    public org.openide.nodes.Node getOONNode() {
        return this.nbNode;
    }

    public Node getWebKitNode() {
        return this.webKitNode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebKitNodeDescription)) {
            return false;
        }
        WebKitNodeDescription descr = (WebKitNodeDescription)obj;
        return Diff.equals(this, descr, false);
    }

    public int hashCode() {
        return Diff.hashCode(this, false);
    }

    @Override
    public String getName() {
        return WebKitNodeDescription.getName(this.webKitNode);
    }

    private static String getName(Node webKitNode) {
        return Utils.getWebKitNodeName(webKitNode);
    }

    @Override
    protected String getElementPath() {
        return this.elementPath;
    }

    @Override
    protected Map<String, String> getAttributes() {
        return this.attributes;
    }

    public synchronized Collection<WebKitNodeDescription> getChildren() {
        if (this.children == null) {
            final List wkChildren = this.webKitNode.getChildren();
            if (wkChildren == null || wkChildren.isEmpty()) {
                return Collections.emptyList();
            }
            this.children = new ArrayList<WebKitNodeDescription>();
            Children.MUTEX.readAccess(new Runnable(){

                @Override
                public void run() {
                    org.openide.nodes.Node[] nodes = WebKitNodeDescription.this.nbNode.getChildren().getNodes();
                    for (Node child : wkChildren) {
                        int i;
                        for (i = 0; i < nodes.length && Utils.getWebKitNode(nodes[i]) != child; ++i) {
                        }
                        if (i >= nodes.length) continue;
                        switch (child.getNodeType()) {
                            case 1: 
                            case 9: {
                                WebKitNodeDescription.this.children.add(new WebKitNodeDescription(WebKitNodeDescription.this, child, nodes[i]));
                            }
                        }
                    }
                }
            });
        }
        return this.children == null ? Collections.EMPTY_LIST : this.children;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public Description getParent() {
        return this.parent;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<").append(this.getName()).append(">");
        buffer.append("{");
        for (WebKitNodeDescription desc : this.getChildren()) {
            buffer.append(desc.toString());
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static class WebKitNodeTreePath {
        private static final char ELEMENT_PATH_ELEMENTS_DELIMITER = '/';
        private static final char ELEMENT_PATH_INDEX_DELIMITER = '|';
        private Node first;
        private Node last;

        public WebKitNodeTreePath(Node last) {
            this(null, last);
        }

        public WebKitNodeTreePath(Node first, Node last) {
            this.first = first;
            this.last = last;
        }

        public Node first() {
            return this.first;
        }

        public Node last() {
            return this.last;
        }

        public List<Node> path() {
            ArrayList<Node> path = new ArrayList<Node>();
            for (Node node = this.last; node != null; node = node.getParent()) {
                path.add(node);
                if (node == this.first) break;
            }
            return path;
        }

        public String toString() {
            return this.getElementPath();
        }

        private static String getNodeId(Node node) {
            return Utils.getWebKitNodeName(node);
        }

        private String getElementPath() {
            StringBuilder sb = new StringBuilder();
            List<Node> p = this.path();
            for (int i = p.size() - 2; i >= 0; --i) {
                Node node = p.get(i);
                Node parent = node.getParent();
                int myIndex = parent == null ? 0 : WebKitNodeTreePath.getIndexInSimilarNodes(node.getParent(), node);
                sb.append(WebKitNodeTreePath.getNodeId(node));
                if (myIndex > 0) {
                    sb.append('|');
                    sb.append(myIndex);
                }
                if (i <= 0) continue;
                sb.append('/');
            }
            return sb.toString();
        }

        private static int getIndexInSimilarNodes(final Node parent, final Node node) {
            final int[] index = new int[]{-1};
            Children.MUTEX.readAccess(new Runnable(){

                @Override
                public void run() {
                    for (Node child : parent.getChildren()) {
                        String childId;
                        String nodeId = WebKitNodeTreePath.getNodeId(node);
                        if (nodeId.equals(childId = WebKitNodeTreePath.getNodeId(child)) && node.getNodeType() == child.getNodeType()) {
                            index[0] = index[0] + 1;
                        }
                        if (child != node) continue;
                        break;
                    }
                }
            });
            return index[0];
        }

        public boolean equals(Object o) {
            if (!(o instanceof WebKitNodeTreePath)) {
                return false;
            }
            WebKitNodeTreePath path = (WebKitNodeTreePath)o;
            return this.getElementPath().equals(path.getElementPath());
        }

        public int hashCode() {
            return this.getElementPath().hashCode();
        }
    }
}

