/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.navigator;

import java.util.Locale;
import java.util.StringTokenizer;
import org.netbeans.modules.html.navigator.Description;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;

public class Utils {
    private static final char ELEMENT_PATH_ELEMENTS_DELIMITER = '/';
    private static final char ELEMENT_PATH_INDEX_DELIMITER = '|';
    private static final String STRIPPED_TEXT_POSTFIX = "...";
    private static final int STRIPPED_TEXT_LEN = 30;

    private Utils() {
    }

    public static org.openide.nodes.Node findNode(org.openide.nodes.Node base, Description description) {
        String path = description.getElementPath();
        StringTokenizer st = new StringTokenizer(path, Character.toString('/'));
        org.openide.nodes.Node found = base;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int indexDelim = token.indexOf(124);
            String nodeName = indexDelim >= 0 ? token.substring(0, indexDelim) : token;
            nodeName = nodeName.toLowerCase(Locale.ENGLISH);
            String sindex = indexDelim >= 0 ? token.substring(indexDelim + 1, token.length()) : "0";
            int index = Integer.parseInt(sindex);
            int count = 0;
            org.openide.nodes.Node foundLocal = null;
            for (org.openide.nodes.Node child : found.getChildren().getNodes()) {
                if (!LexerUtils.equals((CharSequence)Utils.getWebKitNodeName(Utils.getWebKitNode(child)), (CharSequence)nodeName, (boolean)true, (boolean)false) || count++ != index) continue;
                foundLocal = child;
                break;
            }
            if (foundLocal != null) {
                found = foundLocal;
                if (st.hasMoreTokens()) continue;
                return found;
            }
            return null;
        }
        return null;
    }

    public static Node getWebKitNode(org.openide.nodes.Node node) {
        return (Node)node.getLookup().lookup(Node.class);
    }

    public static String getWebKitNodeName(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return node.getNodeName().toLowerCase();
            }
            case 9: {
                return "html";
            }
        }
        return Utils.strip(node.getNodeValue().trim(), 30);
    }

    private static String strip(String text, int maxLen) {
        if (text.length() <= maxLen) {
            return text;
        }
        return text.substring(0, maxLen).trim() + STRIPPED_TEXT_POSTFIX;
    }
}

