/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.navigator;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.navigator.HtmlNavigatorPanel;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public final class HtmlSourceTask
extends ParserResultTask<HtmlParserResult> {
    private HtmlParserResult last;
    private int lastCaret;

    public int getPriority() {
        return 500;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public void run(HtmlParserResult result, SchedulerEvent event) {
        int caret;
        if (this.last != result) {
            HtmlNavigatorPanel.ui.setParserResult(result);
            HtmlNavigatorPanel.ui.refreshDOM(300);
            this.last = result;
        }
        if (this.lastCaret != (caret = ((CursorMovedSchedulerEvent)event).getCaretOffset())) {
            HtmlNavigatorPanel.ui.setCaretOffset(caret);
            this.lastCaret = caret;
        }
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            String mimeType = snapshot.getSource().getMimeType();
            if (mimeType.equals("text/html") || mimeType.equals("text/xhtml")) {
                return Collections.singletonList(new HtmlSourceTask());
            }
            return Collections.emptyList();
        }
    }
}

