/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.navigator.Bundle;
import org.netbeans.modules.html.navigator.Description;
import org.netbeans.modules.html.navigator.HtmlElementDescription;
import org.netbeans.modules.html.navigator.HtmlElementNode;
import org.netbeans.modules.html.navigator.SourceDescription;
import org.netbeans.modules.html.navigator.WebKitNodeDescription;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.browser.api.Page;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class HtmlNavigatorPanelUI
extends JPanel
implements ExplorerManager.Provider {
    private static final Logger LOGGER = Logger.getLogger(HtmlNavigatorPanelUI.class.getSimpleName());
    public static RequestProcessor RP = new RequestProcessor(HtmlNavigatorPanelUI.class);
    private ExplorerManager manager;
    private BeanTreeView view;
    private Lookup lookup;
    private Page pageModel;
    private FileObject inspectedFileObject;
    private Action[] panelActions;
    private WaitNode waitNode = new WaitNode();
    private ChangeListener changeListener;
    private HashMap<Node, HtmlElementNode> domToNb = new HashMap();
    private RequestProcessor.Task domTask;
    private RequestProcessor.Task sourceTask;
    private FileObject lastInspectedFileObject;
    private int expandDepth;
    private int EXPAND_BY_DEFAULT = 100000;
    private final PropertyChangeListener pageInspectorListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("model".equals(propName)) {
                Page page = PageInspector.getDefault().getPage();
                HtmlNavigatorPanelUI.this.setPageModel(page);
                HtmlNavigatorPanelUI.this.refreshDOM();
            }
        }
    };
    private final PropertyChangeListener pageModelListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("document".equals(propName)) {
                HtmlNavigatorPanelUI.this.pageModelDocumentChanged();
            } else if ("selectedNodes".equals(propName)) {
                HtmlNavigatorPanelUI.this.updateSelection();
            } else if ("highlightedNodes".equals(propName)) {
                HtmlNavigatorPanelUI.this.updateHighlight();
            } else if ("browserSelectedNodes".equals(propName)) {
                HtmlNavigatorPanelUI.this.updateEditor();
            }
        }
    };
    private final LookupListener lookupListener = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            HtmlNavigatorPanelUI.this.refreshSource((Lookup.Result<Object>)((Lookup.Result)ev.getSource()));
        }
    };
    private Lookup.Result<Object> contextResult;
    private boolean updatingView = false;
    private final List highlightedTreeNodes = new ArrayList();

    public HtmlNavigatorPanelUI() {
        this.manager = new ExplorerManager();
        this.initTreeView();
        this.setLayout(new BorderLayout());
        this.add((Component)this.view, "Center");
        this.manager.setRootContext((Node)this.waitNode);
        this.panelActions = new Action[0];
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)this.getActionMap());
        PageInspector pageInspector = PageInspector.getDefault();
        if (pageInspector != null) {
            pageInspector.addPropertyChangeListener(this.pageInspectorListener);
        }
        this.manager.addPropertyChangeListener(this.createSelectedNodesListener());
    }

    private synchronized void setPageModel(Page model) {
        if (this.pageModel == model) {
            return;
        }
        if (this.pageModel != null) {
            this.pageModel.removePropertyChangeListener(this.pageModelListener);
        }
        this.pageModel = model;
        if (this.pageModel != null) {
            this.pageModel.addPropertyChangeListener(this.pageModelListener);
        } else {
            this.pageModelRemoved();
        }
        this.inspectedFileObject = this.getInspectedFile(this.pageModel);
    }

    private void pageModelRemoved() {
        HtmlElementNode root = this.getRootNode();
        if (root != null) {
            root.setDescription(Description.empty(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageModelDocumentChanged() {
        HtmlNavigatorPanelUI htmlNavigatorPanelUI = this;
        synchronized (htmlNavigatorPanelUI) {
            this.inspectedFileObject = this.getInspectedFile(this.pageModel);
        }
        this.inspectedFileChanged();
        RP.post(new Runnable(){

            @Override
            public void run() {
                if (HtmlNavigatorPanelUI.this.pageModel != null) {
                    List nodes = HtmlNavigatorPanelUI.this.translate(HtmlNavigatorPanelUI.this.manager.getSelectedNodes());
                    HtmlNavigatorPanelUI.this.pageModel.setSelectedNodes(nodes);
                }
            }
        });
    }

    private void inspectedFileChanged() {
        HtmlElementNode root = this.getRootNode();
        if (root != null) {
            if (root.getFileObject() == null || root.getFileObject().equals(this.inspectedFileObject)) {
                this.refreshDOM();
            } else {
                root.setDescription(Description.empty(2));
            }
        }
    }

    @CheckForNull
    private FileObject getInspectedFile(Page pageModel) {
        if (pageModel == null) {
            return null;
        }
        String inspectedURL = pageModel.getDocumentURL();
        if (inspectedURL == null) {
            return null;
        }
        try {
            URL url = new URL(inspectedURL);
            Project owner = this.getCurrentProject();
            if (owner == null) {
                return null;
            }
            return ServerURLMapping.fromServer((Project)owner, (URL)url);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public synchronized void refreshDOM() {
        this.refreshDOM(0);
    }

    public synchronized void refreshDOM(int delay) {
        if (this.domTask != null) {
            this.domTask.cancel();
        }
        this.domTask = RP.post(new Runnable(){

            @Override
            public void run() {
                HtmlNavigatorPanelUI.this.refreshNodeDOMStatus();
            }
        }, delay);
    }

    private synchronized void refreshSource(final Lookup.Result<Object> result) {
        if (this.sourceTask != null) {
            this.sourceTask.cancel();
        }
        this.sourceTask = RP.post(new Runnable(){

            @Override
            public void run() {
                HtmlNavigatorPanelUI.this.refresh((Lookup.Result<Object>)result);
            }
        });
    }

    private void cacheDomToNb(Node root) {
        HtmlElementNode htmlElementNode;
        Node res;
        if (root == null) {
            return;
        }
        if (root instanceof HtmlElementNode && (res = (htmlElementNode = (HtmlElementNode)root).getDOMNode()) != null) {
            this.domToNb.put(res, htmlElementNode);
        }
        for (Node n : root.getChildren().getNodes()) {
            this.cacheDomToNb(n);
        }
    }

    private void refreshNodeDOMStatus() {
        LOGGER.fine("refreshNodeDOMStatus()");
        HtmlElementNode root = this.getRootNode();
        if (this.pageModel == null) {
            return;
        }
        Node documentNode = this.pageModel.getDocumentNode();
        if (documentNode == null) {
            return;
        }
        WebKitNodeDescription domDescription = WebKitNodeDescription.forNode(null, documentNode);
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HtmlNavigatorPanelUI.this.refreshDOM();
            }
        };
        if (domDescription != null) {
            domDescription.addChangeListener(WeakListeners.change((ChangeListener)this.changeListener, (Object)domDescription));
        }
        if (root != null && domDescription != null && (root.getFileObject() == null && this.inspectedFileObject == null || this.inspectedFileObject != null && this.inspectedFileObject.equals(root.getFileObject()))) {
            root.setDescription(domDescription);
        } else {
            root.setDescription(WebKitNodeDescription.empty(2));
        }
        this.domToNb.clear();
        this.cacheDomToNb((Node)root);
        LOGGER.fine("root.refreshDOMStatus() called");
    }

    public Page getPageModel() {
        return this.pageModel;
    }

    public Action[] getActions() {
        return this.panelActions;
    }

    void activate(Lookup context) {
        this.contextResult = context.lookupResult(Object.class);
        this.contextResult.addLookupListener(this.lookupListener);
        this.refreshSource(this.contextResult);
    }

    private void refresh(Lookup.Result<Object> result) {
        PageInspector pageInspector;
        FileObject fo;
        Collection allInstances = result.allInstances();
        if (allInstances.isEmpty()) {
            return;
        }
        Project p = null;
        FileObject f = null;
        URL url = null;
        for (Object o : result.allInstances()) {
            if (o instanceof Project) {
                p = (Project)o;
                continue;
            }
            if (o instanceof FileObject) {
                f = (FileObject)o;
                continue;
            }
            if (!(o instanceof URL)) continue;
            url = (URL)o;
        }
        if (f == null) {
            return;
        }
        FileObject fileObject = fo = p == null || url == null ? f : ServerURLMapping.fromServer((Project)p, url);
        if (fo != null) {
            if (!"text/html".equals(FileUtil.getMIMEType((FileObject)fo)) && !"text/xhtml".equals(FileUtil.getMIMEType((FileObject)fo))) {
                return;
            }
            pageInspector = PageInspector.getDefault();
            if (pageInspector == null) {
                this.setPageModel(null);
            } else {
                this.setPageModel(pageInspector.getPage());
            }
            Source source = Source.create((FileObject)fo);
            if (source == null || !"text/html".equals(source.getMimeType()) && !"text/xhtml".equals(source.getMimeType())) {
                return;
            }
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        ResultIterator it = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                        if (it == null) {
                            return;
                        }
                        HtmlNavigatorPanelUI.this.setParserResult((HtmlParserResult)it.getParserResult());
                        HtmlNavigatorPanelUI.this.refreshDOM();
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            this.showWaitNode();
            pageInspector = PageInspector.getDefault();
            if (pageInspector == null) {
                this.setPageModel(null);
            } else {
                this.setPageModel(pageInspector.getPage());
            }
            this.setSourceDescription((SourceDescription)SourceDescription.empty(1));
            this.refreshDOM();
        }
    }

    void deactivate() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                HtmlNavigatorPanelUI.this.setPageModel(null);
            }
        });
        if (this.contextResult != null) {
            this.contextResult.removeLookupListener(this.lookupListener);
        }
        this.domToNb.clear();
    }

    private void showWaitNode() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                HtmlNavigatorPanelUI.this.view.setRootVisible(true);
                HtmlNavigatorPanelUI.this.manager.setRootContext((Node)HtmlNavigatorPanelUI.this.waitNode);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public HtmlElementNode getRootNode() {
        Node node = this.manager.getRootContext();
        return node instanceof HtmlElementNode ? (HtmlElementNode)node : null;
    }

    public void selectElementNode(int offset) {
        HtmlElementNode root = this.getRootNode();
        if (root == null) {
            return;
        }
        HtmlElementNode match = root.getNodeForOffset(offset);
        if (match == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable((Node)match){
            final /* synthetic */ Node val$match;
            {
                this.val$match = node;
            }

            @Override
            public void run() {
                Node[] selectedNodes = HtmlNavigatorPanelUI.this.manager.getSelectedNodes();
                if (selectedNodes == null || selectedNodes.length != 1 || selectedNodes[0] != this.val$match) {
                    try {
                        HtmlNavigatorPanelUI.this.manager.setSelectedNodes(new Node[]{this.val$match});
                        LOGGER.log(Level.FINE, "Selected node set to {0}", this.val$match.getDisplayName());
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        Exceptions.printStackTrace((Throwable)propertyVetoException);
                    }
                }
            }
        });
    }

    public void setParserResult(HtmlParserResult result) {
        FileObject file = result.getSnapshot().getSource().getFileObject();
        int length = result.getSnapshot().getText().length();
        this.expandDepth = length < this.EXPAND_BY_DEFAULT ? -1 : 3;
        this.setSourceDescription(new HtmlElementDescription(null, result.root(), file));
    }

    private void setSourceDescription(final SourceDescription description) {
        FileObject f = description instanceof HtmlElementDescription ? ((HtmlElementDescription)description).getFileObject() : null;
        final FileObject fileObject = f;
        final HtmlElementNode rootNode = this.getRootNode();
        if (rootNode != null && fileObject != null && fileObject.equals(rootNode.getFileObject())) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    long startTime = System.currentTimeMillis();
                    rootNode.setDescription(description);
                    long endTime = System.currentTimeMillis();
                    Logger.getLogger("TIMER").log(Level.FINE, "Navigator Merge", new Object[]{fileObject, endTime - startTime});
                    LOGGER.fine("refresh() - same file, descriptions updated");
                }
            };
            RP.post(r);
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    HtmlNavigatorPanelUI.this.view.setRootVisible(false);
                    HtmlNavigatorPanelUI.this.view.setAutoWaitCursor(false);
                    HtmlElementNode root = new HtmlElementNode(description, HtmlNavigatorPanelUI.this, fileObject);
                    HtmlNavigatorPanelUI.this.manager.setRootContext((Node)root);
                    LOGGER.fine("refresh() - new file, set new explorer root node");
                    HtmlNavigatorPanelUI.this.expandNodeByDefaultRecursively(HtmlNavigatorPanelUI.this.manager.getRootContext(), 0, HtmlNavigatorPanelUI.this.expandDepth);
                    HtmlNavigatorPanelUI.this.view.setAutoWaitCursor(true);
                }
            };
            RP.post(r);
        }
    }

    public void setCaretOffset(final int offset) {
        if (offset != -1) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    HtmlNavigatorPanelUI.this.selectElementNode(offset);
                }
            });
        }
    }

    void performExpansion(final Collection<Node> expand, final Collection<Node> expandRec) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (Node n : expand) {
                    HtmlNavigatorPanelUI.this.expandNode(n);
                }
                for (Node n : expandRec) {
                    HtmlNavigatorPanelUI.this.expandNodeByDefaultRecursively(n);
                }
            }
        };
        RP.post(r);
    }

    public void expandNode(Node n) {
        this.view.expandNode(n);
    }

    private void expandNodeByDefaultRecursively(Node node) {
        this.expandNodeByDefaultRecursively(node, 0, this.expandDepth);
    }

    private void expandNodeByDefaultRecursively(Node node, int currentDepth, int maxDepth) {
        if (maxDepth >= 0 && currentDepth >= maxDepth) {
            return;
        }
        this.expandNode(node);
        for (Node subNode : node.getChildren().getNodes()) {
            this.expandNodeByDefaultRecursively(subNode, currentDepth + 1, maxDepth);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private Project getCurrentProject() {
        Project owner;
        if (this.inspectedFileObject != null && (owner = FileOwnerQuery.getOwner((FileObject)this.inspectedFileObject)) != null) {
            this.lastInspectedFileObject = this.inspectedFileObject;
            return owner;
        }
        if (this.getRootNode() != null && this.getRootNode().getFileObject() != null) {
            this.lastInspectedFileObject = this.getRootNode().getFileObject();
            return FileOwnerQuery.getOwner((FileObject)this.lastInspectedFileObject);
        }
        Node rootContext = this.manager.getRootContext();
        FileObject fo = null;
        if (rootContext instanceof HtmlElementNode) {
            fo = ((HtmlElementNode)rootContext).getFileObject();
        } else {
            LOGGER.log(Level.WARNING, "Root context is not HtmlElementNode");
        }
        if (fo == null && (fo = this.lastInspectedFileObject) == null) {
            LOGGER.log(Level.WARNING, "Cannot find current project");
            return null;
        }
        Project owner2 = FileOwnerQuery.getOwner((FileObject)fo);
        return owner2;
    }

    private void initTreeView() {
        this.view = new BeanTreeView(){
            {
                MouseAdapter listener = HtmlNavigatorPanelUI.this.createTreeMouseListener();
                this.tree.addMouseListener(listener);
                this.tree.addMouseMotionListener(listener);
                this.tree.setCellRenderer(HtmlNavigatorPanelUI.this.createTreeCellRenderer(this.tree.getCellRenderer()));
            }
        };
        this.view.setAllowedDragActions(0);
        this.view.setAllowedDropActions(0);
        this.view.setRootVisible(false);
    }

    private MouseAdapter createTreeMouseListener() {
        return new MouseAdapter(){
            private Object lastHover = null;

            @Override
            public void mouseEntered(MouseEvent e) {
                this.processEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.processEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.processEvent(null);
                this.lastHover = new Object();
            }

            private void processEvent(MouseEvent e) {
                JTree tree;
                TreePath path;
                Object hover = null;
                if (e != null && (path = (tree = (JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null) {
                    hover = path.getLastPathComponent();
                }
                if (hover != this.lastHover) {
                    Node domNode;
                    Node node;
                    this.lastHover = hover;
                    final List<Object> highlight = hover != null ? ((node = Visualizer.findNode(hover)) instanceof HtmlElementNode ? ((domNode = ((HtmlElementNode)node).getDOMNode()) != null ? Arrays.asList(domNode) : Collections.EMPTY_LIST) : Arrays.asList(node)) : Collections.EMPTY_LIST;
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            if (HtmlNavigatorPanelUI.this.pageModel != null) {
                                HtmlNavigatorPanelUI.this.pageModel.setHighlightedNodes(highlight);
                            }
                        }
                    });
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateHighlight() {
        if (this.pageModel == null) {
            return;
        }
        List list = this.highlightedTreeNodes;
        synchronized (list) {
            this.highlightedTreeNodes.clear();
            for (Node node : this.pageModel.getHighlightedNodes()) {
                HtmlElementNode n = this.getHtmlNode(node);
                if (n == null) continue;
                TreeNode visualizer = Visualizer.findVisualizer((Node)n);
                this.highlightedTreeNodes.add(visualizer);
            }
        }
        this.view.repaint();
    }

    private HtmlElementNode getHtmlNode(Node node) {
        HtmlElementNode result = node instanceof HtmlElementNode ? (HtmlElementNode)node : this.domToNb.get(node);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHighlighted(Object treeNode) {
        List list = this.highlightedTreeNodes;
        synchronized (list) {
            return this.highlightedTreeNodes.contains(treeNode);
        }
    }

    private TreeCellRenderer createTreeCellRenderer(final TreeCellRenderer delegate) {
        Color origColor = UIManager.getColor("Tree.selectionBackground");
        Color color = origColor.brighter().brighter();
        if (color.equals(Color.WHITE)) {
            color = origColor.darker();
        }
        final Color hoverColor = color;
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel component;
                if (!selected && HtmlNavigatorPanelUI.this.isHighlighted(value)) {
                    component = (JLabel)delegate.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, hasFocus);
                    component.setBackground(hoverColor);
                    component.setOpaque(true);
                } else {
                    component = (JLabel)delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                }
                return component;
            }
        };
    }

    private void update() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                Node node = HtmlNavigatorPanelUI.this.pageModel.getDocumentNode();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HtmlNavigatorPanelUI.this.updateSelection();
                        HtmlNavigatorPanelUI.this.updateHighlight();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelection() {
        if (EventQueue.isDispatchThread()) {
            List nodes = this.pageModel == null ? Collections.EMPTY_LIST : this.pageModel.getSelectedNodes();
            ArrayList<HtmlElementNode> selection = new ArrayList<HtmlElementNode>();
            boolean i = false;
            for (Node n : nodes) {
                HtmlElementNode htmlNode = this.getHtmlNode(n);
                if (htmlNode == null) continue;
                selection.add(htmlNode);
            }
            this.updatingView = true;
            try {
                this.manager.setSelectedNodes(selection.toArray(new Node[0]));
            }
            catch (PropertyVetoException pvex) {
                Logger.getLogger(HtmlNavigatorPanelUI.class.getName()).log(Level.FINE, null, pvex);
            }
            finally {
                this.updatingView = false;
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlNavigatorPanelUI.this.updateSelection();
                }
            });
        }
    }

    private void updateEditor() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                List nodes = HtmlNavigatorPanelUI.this.pageModel == null ? Collections.EMPTY_LIST : HtmlNavigatorPanelUI.this.pageModel.getSelectedNodes();
                for (Node n : nodes) {
                    HtmlElementNode htmlNode = HtmlNavigatorPanelUI.this.getHtmlNode(n);
                    if (htmlNode == null) continue;
                    HtmlNavigatorPanelUI.this.updateCaretInEditor(htmlNode);
                    break;
                }
            }
        });
    }

    private void updateCaretInEditor(HtmlElementNode node) {
        FileObject fileObject = node.getFileObject();
        if (fileObject != null) {
            try {
                JEditorPane[] openedPanes;
                DataObject d = DataObject.find((FileObject)fileObject);
                EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
                if (ec != null && (openedPanes = ec.getOpenedPanes()) != null && openedPanes.length > 0) {
                    int offset;
                    JEditorPane pane = openedPanes[0];
                    SourceDescription description = node.getSourceDescription();
                    if (description != null && (offset = description.getFrom()) != -1) {
                        pane.setCaretPosition(offset);
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private PropertyChangeListener createSelectedNodesListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("selectedNodes".equals(propName)) {
                    if (HtmlNavigatorPanelUI.this.updatingView) {
                        return;
                    }
                    final List nodes = HtmlNavigatorPanelUI.this.translate(HtmlNavigatorPanelUI.this.manager.getSelectedNodes());
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            if (HtmlNavigatorPanelUI.this.pageModel != null) {
                                HtmlNavigatorPanelUI.this.pageModel.setSelectedNodes(nodes);
                            }
                        }
                    });
                }
            }
        };
    }

    private List translate(Node[] selectedNodes) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node n : selectedNodes) {
            if (!(n instanceof HtmlElementNode)) continue;
            Node domNode = ((HtmlElementNode)n).getDOMNode();
            if (domNode == null) {
                result.add(n);
                continue;
            }
            result.add(domNode);
        }
        return result;
    }

    public <T> Future<T> performTest(Callable<T> task) {
        return RP.submit(task);
    }

    private static class WaitNode
    extends AbstractNode {
        private Image waitIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/html/navigator/resources/wait.png");
        private String displayName = Bundle.lbl_wait_node();

        WaitNode() {
            super(Children.LEAF);
        }

        public Image getIcon(int type) {
            return this.waitIcon;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

