/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.navigator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.html.navigator.Bundle;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;

public class HtmlElementProperties {

    private static class NewAttributeProperty
    extends PropertySupport<String> {
        private static final String EMPTY = "";
        private String attrName;
        private Document doc;
        private Snapshot snap;
        private OpenTag ot;

        public NewAttributeProperty(Document doc, Snapshot snap, String attrName, OpenTag ot) {
            super(attrName, String.class, attrName, Bundle.new_attribute_tooltip(), true, doc != null);
            this.doc = doc;
            this.snap = snap;
            this.ot = ot;
            this.attrName = attrName;
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return EMPTY;
        }

        public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val.length() == 0) {
                return;
            }
            int astFrom = this.ot.from() + 1 + this.ot.name().length();
            final int docFrom = this.snap.getOriginalOffset(astFrom);
            if (docFrom != -1) {
                final StringBuilder insertBuilder = new StringBuilder().append(' ').append(this.attrName).append('=').append('\"').append(val).append('\"');
                ((BaseDocument)this.doc).runAtomicAsUser(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (NewAttributeProperty.this.doc.getText(docFrom, 1).trim().length() != 0) {
                                insertBuilder.append(' ');
                            }
                            NewAttributeProperty.this.doc.insertString(docFrom, insertBuilder.toString(), null);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
        }
    }

    private static class AttributeProperty
    extends PropertySupport<String> {
        private Attribute attr;
        private Document doc;
        private Snapshot snap;

        public AttributeProperty(Document doc, Snapshot snap, Attribute attr) {
            super(((Object)attr.name()).toString(), String.class, ((Object)attr.name()).toString(), Bundle.edit_attribute_tooltip(), true, doc != null);
            this.doc = doc;
            this.snap = snap;
            this.attr = attr;
        }

        public String getHtmlDisplayName() {
            return "<b>" + this.attr.name() + "</b>";
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return ((Object)this.attr.unquotedValue()).toString();
        }

        public void setValue(final String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            int astTo;
            int astFrom;
            if (val.length() == 0) {
                astFrom = this.attr.nameOffset() - 1;
                astTo = this.attr.valueOffset() + this.attr.value().length();
            } else {
                astFrom = this.attr.valueOffset() + (this.attr.isValueQuoted() ? 1 : 0);
                astTo = astFrom + this.attr.unquotedValue().length();
            }
            final int docFrom = this.snap.getOriginalOffset(astFrom);
            final int docTo = this.snap.getOriginalOffset(astTo);
            if (docFrom != -1 && docTo != -1) {
                ((BaseDocument)this.doc).runAtomicAsUser(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AttributeProperty.this.doc.remove(docFrom, docTo - docFrom);
                            if (val.length() > 0) {
                                AttributeProperty.this.doc.insertString(docFrom, val, null);
                            }
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
        }
    }

    public static class PropertiesPropertySet
    extends Node.PropertySet {
        private OpenTag openTag;
        private HtmlParserResult res;

        public PropertiesPropertySet(HtmlParserResult res, OpenTag openTag) {
            this.res = res;
            this.openTag = openTag;
            this.setName(Bundle.element_element_attributes_title());
        }

        public Node.Property<String>[] getProperties() {
            Snapshot s = this.res.getSnapshot();
            Document doc = s.getSource().getDocument(false);
            ArrayList<PropertySupport> props = new ArrayList<PropertySupport>();
            HashSet<String> existingAttrNames = new HashSet<String>();
            for (Attribute a : this.openTag.attributes()) {
                props.add(new AttributeProperty(doc, s, a));
                existingAttrNames.add(((Object)a.name()).toString().toLowerCase(Locale.ENGLISH));
            }
            HtmlModel model = HtmlModelFactory.getModel((HtmlVersion)this.res.getHtmlVersion());
            HtmlTag tagModel = model.getTag(((Object)this.openTag.name()).toString());
            if (tagModel != null) {
                ArrayList<String> attrNames = new ArrayList<String>();
                for (HtmlTagAttribute htmlTagAttr : tagModel.getAttributes()) {
                    String name = htmlTagAttr.getName().toLowerCase();
                    if (existingAttrNames.contains(name)) continue;
                    attrNames.add(name);
                }
                Collections.sort(attrNames);
                for (String attrName : attrNames) {
                    props.add(new NewAttributeProperty(doc, s, attrName, this.openTag));
                }
            }
            return props.toArray(new Node.Property[0]);
        }
    }
}

