/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.navigator;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.navigator.Description;
import org.netbeans.modules.html.navigator.DescriptionSetWrapper;
import org.netbeans.modules.html.navigator.Diff;
import org.netbeans.modules.html.navigator.HtmlElementDescription;
import org.netbeans.modules.html.navigator.HtmlElementProperties;
import org.netbeans.modules.html.navigator.HtmlNavigatorPanelUI;
import org.netbeans.modules.html.navigator.SourceDescription;
import org.netbeans.modules.html.navigator.WebKitNodeDescription;
import org.netbeans.modules.html.navigator.actions.OpenAction;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class HtmlElementNode
extends AbstractNode {
    private static final Logger LOGGER = Logger.getLogger(HtmlElementNode.class.getSimpleName());
    private static final Image SOURCE_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/html/navigator/resources/html_element_bw.png");
    private static final Image SOURCE_AND_DOM_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/html/navigator/resources/html_element.png");
    private static final Image DOM_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/html/navigator/resources/html_element_live.png");
    private static final String DOM_ACTIONS_PATH = "Navigation/DOM/Actions";
    private HtmlNavigatorPanelUI ui;
    private FileObject fileObject;
    private OpenAction openAction;
    private SourceDescription source;
    private Description dom;
    private final NodeLookupProvider lookupProvider;

    public HtmlElementNode(SourceDescription sourceDescription, HtmlNavigatorPanelUI ui, FileObject fileObject) {
        this(ui, fileObject);
        this.source = sourceDescription;
        this.updateNodeLookup(null);
        this.getElementChildren().setStaticKeys(sourceDescription.getChildren(), true);
    }

    public HtmlElementNode(Description domDescription, HtmlNavigatorPanelUI ui, FileObject fileObject) {
        this(ui, fileObject);
        this.dom = domDescription;
        this.updateNodeLookup(domDescription);
        this.getElementChildren().setDynamicKeys(domDescription.getChildren(), true);
    }

    private HtmlElementNode(HtmlNavigatorPanelUI ui, FileObject fileObject) {
        this(ui, fileObject, HtmlElementNode.createLookupProvider());
    }

    private HtmlElementNode(HtmlNavigatorPanelUI ui, FileObject fileObject, NodeLookupProvider lookupProvider) {
        super((Children)new ElementChildren(ui, fileObject), Lookups.proxy((Lookup.Provider)lookupProvider));
        this.ui = ui;
        this.fileObject = fileObject;
        this.lookupProvider = lookupProvider;
        this.openAction = new OpenAction(this);
    }

    private static NodeLookupProvider createLookupProvider() {
        return new NodeLookupProvider(Lookups.fixed((Object[])new Object[0]));
    }

    private void updateNodeLookup(Description newDescription) {
        Node domNode = null;
        if (newDescription instanceof WebKitNodeDescription) {
            domNode = (Node)((WebKitNodeDescription)newDescription).getOONNode().getLookup().lookup(Node.class);
        }
        InstanceContent ic = new InstanceContent();
        ic.add((Object)this);
        if (this.fileObject != null) {
            ic.add((Object)this.fileObject);
        }
        if (domNode != null) {
            ic.add((Object)domNode);
        }
        if (this.source != null) {
            ic.add((Object)this.source);
        }
        this.lookupProvider.setLookup((Lookup)new AbstractLookup((AbstractLookup.Content)ic));
    }

    public org.openide.nodes.Node getDOMNode() {
        Description domDescription = this.getDOMDescription();
        if (domDescription instanceof WebKitNodeDescription) {
            return ((WebKitNodeDescription)domDescription).getOONNode();
        }
        return null;
    }

    private State getState() {
        SourceDescription s = this.getSourceDescription();
        Description d = this.getDOMDescription();
        if (s != null && s != Description.empty(1)) {
            if (d != null && d != Description.empty(2)) {
                return State.SOURCE_AND_DOM;
            }
            return State.SOURCE;
        }
        if (d != null && d != Description.empty(2)) {
            return State.DOM;
        }
        return State.NON;
    }

    public void setDescription(Description description) {
        LinkedList<org.openide.nodes.Node> nodesToExpand = new LinkedList<org.openide.nodes.Node>();
        LinkedList<org.openide.nodes.Node> nodesToExpandRec = new LinkedList<org.openide.nodes.Node>();
        this.updateRecursively(description, nodesToExpand, nodesToExpandRec);
        this.ui.performExpansion(nodesToExpand, nodesToExpandRec);
    }

    public SourceDescription getSourceDescription() {
        return this.source;
    }

    public Description getDOMDescription() {
        return this.dom;
    }

    public Description getDescription() {
        switch (this.getState()) {
            case DOM: {
                return this.getDOMDescription();
            }
            case SOURCE: 
            case SOURCE_AND_DOM: {
                return this.getSourceDescription();
            }
        }
        return null;
    }

    public Description getDescription(int type) {
        switch (type) {
            case 2: {
                return this.getDOMDescription();
            }
            case 1: {
                return this.getSourceDescription();
            }
        }
        return null;
    }

    private ElementChildren getElementChildren() {
        return (ElementChildren)this.getChildren();
    }

    public Node.PropertySet[] getPropertySets() {
        switch (this.getState()) {
            case SOURCE: 
            case SOURCE_AND_DOM: {
                return this.getSourcePropertySets();
            }
        }
        return super.getPropertySets();
    }

    private Node.PropertySet[] getSourcePropertySets() {
        final HtmlElementDescription htmlD = (HtmlElementDescription)this.getSourceDescription();
        if (htmlD.getElementType() == ElementType.OPEN_TAG) {
            final AtomicReference pset_ref = new AtomicReference();
            try {
                htmlD.runTask(new HtmlElementDescription.Task(){

                    @Override
                    public void run(HtmlParserResult result) {
                        OpenTag openTag = (OpenTag)htmlD.resolve((Parser.Result)result);
                        if (openTag != null) {
                            HtmlElementProperties.PropertiesPropertySet pset = new HtmlElementProperties.PropertiesPropertySet(result, openTag);
                            pset_ref.set(pset);
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            HtmlElementProperties.PropertiesPropertySet pset = (HtmlElementProperties.PropertiesPropertySet)((Object)pset_ref.get());
            if (pset == null) {
                return super.getPropertySets();
            }
            return new Node.PropertySet[]{pset};
        }
        return super.getPropertySets();
    }

    public String getDisplayName() {
        switch (this.getState()) {
            case SOURCE: 
            case SOURCE_AND_DOM: {
                return this.source.getName();
            }
            case DOM: {
                return this.dom.getName();
            }
            case NON: {
                return "NON";
            }
        }
        throw new IllegalStateException();
    }

    public boolean canRename() {
        return false;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getHtmlDisplayName() {
        boolean debug;
        Description d;
        Description dd = this.getDOMDescription();
        SourceDescription sd = this.getSourceDescription();
        StringBuilder b = new StringBuilder();
        b.append(this.getDisplayName());
        Description description = d = sd != null ? sd : dd;
        if (d != null) {
            String classVal;
            String idVal = d.getAttributeValue("id");
            if (idVal != null) {
                b.append("&nbsp;");
                b.append("<font color=\"#777777\">");
                b.append("id=");
                b.append(idVal);
                b.append("</font>");
            }
            if ((classVal = d.getAttributeValue("class")) != null) {
                b.append("&nbsp;");
                b.append("<font color=\"#777777\">");
                b.append("class=");
                b.append(classVal);
                b.append("</font>");
            }
        }
        if (debug = false) {
            b.append(" [");
            if (this.getSourceDescription() != null) {
                b.append("SOURCE:");
                b.append("hc:");
                b.append(Diff.hashCode(this.getSourceDescription(), false));
            }
            b.append(' ');
            if (this.getDOMDescription() != null) {
                b.append("DOM:");
                b.append("hc:");
                b.append(Diff.hashCode(this.getDOMDescription(), false));
            }
            b.append("]");
        }
        return b.toString();
    }

    public Image getIcon(int type) {
        switch (this.getState()) {
            case SOURCE: {
                return SOURCE_ICON;
            }
            case SOURCE_AND_DOM: {
                return SOURCE_AND_DOM_ICON;
            }
            case DOM: {
                return DOM_ICON;
            }
        }
        return null;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (context || this.getDescription().getName() == null) {
            actions.addAll(Arrays.asList(this.ui.getActions()));
        } else {
            actions.add(this.openAction);
            actions.add(null);
            actions.addAll(Arrays.asList(this.ui.getActions()));
        }
        for (Action action : Utilities.actionsForPath((String)DOM_ACTIONS_PATH)) {
            if (action instanceof ContextAwareAction) {
                actions.add(((ContextAwareAction)action).createContextAwareInstance(this.getLookup()));
                continue;
            }
            actions.add(action);
        }
        return actions.toArray(new Action[0]);
    }

    public Action getPreferredAction() {
        return this.openAction;
    }

    public HtmlElementNode getNodeForOffset(int offset) {
        if (this.getSourceDescription().getFrom() > offset) {
            return null;
        }
        Children ch = this.getChildren();
        if (ch instanceof ElementChildren) {
            org.openide.nodes.Node[] children = ch.getNodes();
            for (int i = 0; i < children.length; ++i) {
                SourceDescription sourceDescription;
                long start;
                HtmlElementNode c;
                SourceDescription sd;
                if (!(children[i] instanceof HtmlElementNode) || (sd = (c = (HtmlElementNode)children[i]).getSourceDescription()) == null || (start = (long)sd.getFrom()) > (long)offset) continue;
                long end = sd.getTo();
                if (end == (long)offset && i + 1 < children.length && (sourceDescription = ((HtmlElementNode)children[i + 1]).getSourceDescription()) != null && sourceDescription.getFrom() == offset) {
                    return ((HtmlElementNode)children[i + 1]).getNodeForOffset(offset);
                }
                if (end < (long)offset) continue;
                return c.getNodeForOffset(offset);
            }
        }
        return this;
    }

    private void updateRecursively(Description newDescription, List<org.openide.nodes.Node> nodesToExpand, List<org.openide.nodes.Node> nodesToExpandRec) {
        DescriptionSetWrapper wrapper;
        boolean descriptionChanged;
        Description originalDescription;
        LOGGER.log(Level.FINE, "{0}: entering updateRecursively()", this.getDisplayName());
        State currentState = this.getState();
        int descriptionType = newDescription.getType();
        ElementChildren ch = this.getElementChildren();
        switch (descriptionType) {
            case 1: {
                originalDescription = this.getSourceDescription();
                this.source = (SourceDescription)newDescription;
                break;
            }
            case 2: {
                originalDescription = this.getDOMDescription();
                this.dom = newDescription;
                this.updateNodeLookup(newDescription);
                break;
            }
            default: {
                originalDescription = null;
            }
        }
        org.openide.nodes.Node[] nodes = ch.getNodes(true);
        HashMap<DescriptionSetWrapper, HtmlElementNode> oldD2node = new HashMap<DescriptionSetWrapper, HtmlElementNode>();
        for (org.openide.nodes.Node node : nodes) {
            HtmlElementNode htmlElementNode = (HtmlElementNode)node;
            oldD2node.put(new DescriptionSetWrapper(htmlElementNode.getDescription()), htmlElementNode);
        }
        switch (newDescription.getType()) {
            case 1: {
                Collection<? extends Description> newSourceKeys = Diff.mergeOldAndNew(ch.staticKeys, this.source.getChildren(), this);
                ch.setStaticKeys(newSourceKeys, false);
                break;
            }
            case 2: {
                Collection<? extends Description> newDOMKeys = Diff.mergeOldAndNew(ch.dynamicKeys, this.dom.getChildren(), this);
                ch.setDynamicKeys(newDOMKeys, false);
            }
        }
        Collection<? extends Description> newKeys = Diff.mergeSourceAndDOM(ch.staticKeys, ch.dynamicKeys, this);
        ch.resetKeys(newKeys);
        boolean stateChanged = currentState != this.getState();
        boolean bl = descriptionChanged = originalDescription == null && newDescription != null || originalDescription.hashCode() != newDescription.hashCode();
        if (stateChanged) {
            this.fireIconChange();
        }
        if (stateChanged || descriptionChanged) {
            this.fireDisplayNameChange(null, this.getDisplayName());
        }
        nodes = ch.getNodes(true);
        Collection<? extends Description> newChildrenDescriptions = newDescription.getChildren();
        Collection<Object> originalChildrenDescriptions = originalDescription != null ? originalDescription.getChildren() : Collections.emptyList();
        HashSet removedKeys = new HashSet(originalChildrenDescriptions);
        removedKeys.removeAll(newChildrenDescriptions);
        for (Description description : removedKeys) {
            wrapper = new DescriptionSetWrapper(description);
            org.openide.nodes.Node n = (org.openide.nodes.Node)oldD2node.get(wrapper);
            if (n == null) continue;
            ((HtmlElementNode)n).updateRecursively(Description.empty(descriptionType), nodesToExpand, nodesToExpandRec);
        }
        block10: for (Description description : newChildrenDescriptions) {
            wrapper = new DescriptionSetWrapper(description);
            HtmlElementNode node = (HtmlElementNode)((Object)oldD2node.get(wrapper));
            if (node != null) {
                if (!originalChildrenDescriptions.contains(description)) {
                    nodesToExpand.add((org.openide.nodes.Node)node);
                }
                node.updateRecursively(description, nodesToExpand, nodesToExpandRec);
                continue;
            }
            for (org.openide.nodes.Node newNode : nodes) {
                if (((HtmlElementNode)newNode).getDescription(descriptionType) != description) continue;
                nodesToExpandRec.add(newNode);
                continue block10;
            }
        }
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    private static class ElementChildren
    extends Children.Keys<Description> {
        private HtmlNavigatorPanelUI ui;
        private FileObject fileObject;
        private Collection<? extends Description> staticKeys = Collections.emptyList();
        private Collection<? extends Description> dynamicKeys = Collections.emptyList();

        public ElementChildren(HtmlNavigatorPanelUI ui, FileObject fileObject) {
            this.ui = ui;
            this.fileObject = fileObject;
        }

        protected org.openide.nodes.Node[] createNodes(Description key) {
            HtmlElementNode newNode;
            switch (key.getType()) {
                case 1: {
                    newNode = new HtmlElementNode((SourceDescription)key, this.ui, this.fileObject);
                    break;
                }
                case 2: {
                    newNode = new HtmlElementNode(key, this.ui, this.fileObject);
                    break;
                }
                default: {
                    return null;
                }
            }
            return new org.openide.nodes.Node[]{newNode};
        }

        void setStaticKeys(Collection<? extends Description> staticDescriptions, boolean resetKeys) {
            this.staticKeys = Collections.unmodifiableCollection(staticDescriptions);
            if (resetKeys) {
                this.resetKeys(staticDescriptions);
            }
        }

        void setDynamicKeys(Collection<? extends Description> dynamicDescriptions, boolean resetKeys) {
            this.dynamicKeys = Collections.unmodifiableCollection(dynamicDescriptions);
            if (resetKeys) {
                this.resetKeys(dynamicDescriptions);
            }
        }

        void resetKeys(Collection<? extends Description> keys) {
            this.setKeys(keys);
        }
    }

    private static class NodeLookupProvider
    implements Lookup.Provider {
        private Lookup lookup;

        NodeLookupProvider(Lookup lookup) {
            this.lookup = lookup;
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        void setLookup(Lookup lookup) {
            this.lookup = lookup;
        }
    }

    private static enum State {
        SOURCE,
        SOURCE_AND_DOM,
        DOM,
        NON;

    }
}

