/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.SourceElementHandle;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.elements.TreePath;
import org.netbeans.modules.html.navigator.Description;
import org.netbeans.modules.html.navigator.Diff;
import org.netbeans.modules.html.navigator.SourceDescription;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;

public class HtmlElementDescription
extends SourceDescription
implements SourceElementHandle {
    private final String elementPath;
    private final Map<String, String> attributes;
    private final int from;
    private final int to;
    private final ElementType type;
    private final FileObject file;
    private List<HtmlElementDescription> children;
    private final boolean isLeaf;
    private final String name;
    private HtmlElementDescription parent;

    public HtmlElementDescription(HtmlElementDescription parent, Node element, FileObject file) {
        OpenTag openTag;
        this.parent = parent;
        this.file = file;
        this.type = element.type();
        this.from = element.from();
        this.elementPath = ElementUtils.encodeToString((TreePath)new TreePath((Element)element));
        this.isLeaf = element instanceof Node ? element.children(OpenTag.class).isEmpty() : true;
        OpenTag openTag2 = openTag = element instanceof OpenTag ? (OpenTag)element : null;
        if (openTag != null) {
            Collection attrs = openTag.attributes();
            if (attrs.isEmpty()) {
                this.attributes = Collections.emptyMap();
            } else {
                this.attributes = new HashMap<String, String>();
                for (Attribute a : attrs) {
                    String key = ((Object)a.name()).toString().toLowerCase();
                    String val = a.unquotedValue() != null ? ((Object)a.unquotedValue()).toString() : null;
                    this.attributes.put(key, val);
                }
            }
        } else {
            this.attributes = Collections.emptyMap();
        }
        this.to = openTag != null ? openTag.semanticEnd() : element.to();
        String string = this.name = openTag != null ? ((Object)openTag.name()).toString() : null;
        if (element != null) {
            this.children = new ArrayList<HtmlElementDescription>();
            List<OpenTag> nonVirtualChildren = this.gatherNonVirtualChildren(element);
            for (OpenTag child : nonVirtualChildren) {
                this.children.add(new HtmlElementDescription(this, (Node)child, file));
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HtmlElementDescription)) {
            return false;
        }
        HtmlElementDescription descr = (HtmlElementDescription)obj;
        return Diff.equals(this, descr, false);
    }

    public int hashCode() {
        return Diff.hashCode(this, false);
    }

    @Override
    protected String getElementPath() {
        return this.elementPath;
    }

    @Override
    public Description getParent() {
        return this.parent;
    }

    public FileObject getFileObject() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public ElementType getElementType() {
        return this.type;
    }

    @Override
    public int getFrom() {
        return this.from;
    }

    @Override
    public int getTo() {
        return this.to;
    }

    @Override
    protected Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Node resolve(Parser.Result result) {
        if (!(result instanceof HtmlParserResult)) {
            return null;
        }
        HtmlParserResult htmlParserResult = (HtmlParserResult)result;
        Node root = htmlParserResult.root();
        if (this.getElementType() == ElementType.ROOT) {
            return root;
        }
        return ElementUtils.query((Node)root, (String)this.elementPath);
    }

    public OffsetRange getOffsetRange(ParserResult result) {
        Node node = this.resolve((Parser.Result)result);
        if (node == null) {
            return OffsetRange.NONE;
        }
        Snapshot snapshot = result.getSnapshot();
        int dfrom = snapshot.getOriginalOffset(node.from());
        int dto = snapshot.getOriginalOffset(node instanceof OpenTag ? ((OpenTag)node).semanticEnd() : node.to());
        return dfrom != -1 && dto != -1 ? new OffsetRange(dfrom, dto) : OffsetRange.NONE;
    }

    public void runTask(final Task task) throws ParseException {
        Source source = Source.create((FileObject)this.file);
        if (source == null) {
            return;
        }
        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                ResultIterator it = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                if (it == null) {
                    return;
                }
                task.run((HtmlParserResult)it.getParserResult());
            }
        });
    }

    public synchronized List<HtmlElementDescription> getChildren() {
        return this.children == null ? Collections.EMPTY_LIST : this.children;
    }

    private List<OpenTag> gatherNonVirtualChildren(Node element) {
        LinkedList<OpenTag> collected = new LinkedList<OpenTag>();
        for (OpenTag child : element.children(OpenTag.class)) {
            if (child.type() != ElementType.OPEN_TAG) continue;
            if (!ElementUtils.isVirtualNode((Element)child)) {
                collected.add(child);
                continue;
            }
            collected.addAll(this.gatherNonVirtualChildren((Node)child));
        }
        return collected;
    }

    public static interface Task {
        public void run(HtmlParserResult var1);
    }
}

