/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.navigator.Description;
import org.netbeans.modules.html.navigator.DescriptionSetWrapper;
import org.netbeans.modules.html.navigator.HtmlElementNode;

public class Diff {
    private static final Logger LOGGER = Logger.getLogger(Diff.class.getSimpleName());
    private static final String ID_ATTR_NAME = "id";

    public static Collection<? extends Description> mergeOldAndNew(Collection<? extends Description> old, Collection<? extends Description> neww, HtmlElementNode sourceNode) {
        return neww;
    }

    public static Collection<? extends Description> mergeSourceAndDOM(Collection<? extends Description> source, Collection<? extends Description> dom, HtmlElementNode sourceNode) {
        LOGGER.log(Level.FINE, "Diff.merge(''{0}'')", sourceNode.getDisplayName());
        LinkedHashSet<DescriptionSetWrapper> wrappers = new LinkedHashSet<DescriptionSetWrapper>();
        StringBuilder sb = new StringBuilder();
        sb.append("Static Keys (");
        sb.append(source.size());
        sb.append("): ");
        for (Description description : source) {
            sb.append(description.toString());
            sb.append(',');
            wrappers.add(new DescriptionSetWrapper(description));
        }
        LOGGER.log(Level.FINE, sb.toString());
        sb = new StringBuilder();
        sb.append("DOM Keys (");
        sb.append(dom.size());
        sb.append("): ");
        for (Description description : dom) {
            sb.append(description.toString());
            sb.append(',');
            wrappers.add(new DescriptionSetWrapper(description));
        }
        LOGGER.log(Level.FINE, sb.toString());
        sb = new StringBuilder();
        sb.append("Merged Keys (");
        sb.append(wrappers.size());
        sb.append("): ");
        ArrayList<Description> result = new ArrayList<Description>();
        for (DescriptionSetWrapper w : wrappers) {
            sb.append(w.getPeer().toString());
            result.add(w.getPeer());
            sb.append(',');
        }
        LOGGER.log(Level.FINE, sb.toString());
        return result;
    }

    public static boolean equals(Description d1, Description d2, boolean forceIdAttrEquality) {
        if (!d1.getName().equals(d2.getName())) {
            return false;
        }
        if ("html".equalsIgnoreCase(d1.getName())) {
            return true;
        }
        if (forceIdAttrEquality) {
            String d1IdAttrVal = d1.getAttributeValue(ID_ATTR_NAME);
            String d2IdAttrVal = d2.getAttributeValue(ID_ATTR_NAME);
            if (d1IdAttrVal != null && d1IdAttrVal.equals(d2IdAttrVal)) {
                return true;
            }
        }
        Map<String, String> d1Attrs = d1.getAttributes();
        Map<String, String> d2Attrs = d2.getAttributes();
        if (d1Attrs.size() != d2Attrs.size()) {
            return false;
        }
        HashSet<Map.Entry<String, String>> attrsSet = new HashSet<Map.Entry<String, String>>();
        attrsSet.addAll(d1Attrs.entrySet());
        attrsSet.removeAll(d2Attrs.entrySet());
        if (!attrsSet.isEmpty()) {
            return false;
        }
        return d1.getElementPath().equals(d2.getElementPath());
    }

    public static int hashCode(Description d, boolean forceIdAttrEquality) {
        int hash = 11;
        hash = 37 * hash + d.getName().hashCode();
        if ("html".equalsIgnoreCase(d.getName())) {
            return hash;
        }
        String idAttrVal = d.getAttributeValue(ID_ATTR_NAME);
        if (idAttrVal != null) {
            hash = 37 * hash + idAttrVal.hashCode();
            return hash;
        }
        Map<String, String> d1Attrs = d.getAttributes();
        for (Map.Entry<String, String> entry : d1Attrs.entrySet()) {
            String name = entry.getKey();
            hash = 37 * hash + name.hashCode();
            String value = entry.getValue();
            if (value == null) continue;
            hash = 37 * hash + value.hashCode();
        }
        hash = 37 * hash + d.getElementPath().hashCode();
        return hash;
    }
}

