/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.navigator;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.navigator.DOMNodeDescription;
import org.netbeans.modules.html.navigator.SourceDescription;

public abstract class Description {
    private static Description EMPTY_SOURCE_DESCRIPTION = new EmptySourceDescription();
    private static Description EMPTY_DOM_DESCRIPTION = new EmptyDOMNodeDescription();
    public static final int SOURCE = 1;
    public static final int DOM = 2;

    public static Description empty(int type) {
        switch (type) {
            case 1: {
                return EMPTY_SOURCE_DESCRIPTION;
            }
            case 2: {
                return EMPTY_DOM_DESCRIPTION;
            }
        }
        throw new IllegalStateException();
    }

    public abstract Collection<? extends Description> getChildren();

    public abstract Description getParent();

    public abstract String getName();

    public abstract int getType();

    protected abstract String getElementPath();

    protected abstract Map<String, String> getAttributes();

    public final String getAttributeValue(String attributeName) {
        return this.getAttributes().get(attributeName);
    }

    private int getAttributesHash() {
        int hash = 11;
        for (Map.Entry<String, String> a : this.getAttributes().entrySet()) {
            hash = 37 * hash + a.getKey().hashCode();
            CharSequence value = a.getValue();
            hash = 37 * hash + (value != null ? value.hashCode() : 0);
        }
        return hash;
    }

    public String toString() {
        return (this.getType() == 1 ? "source" : "dom") + ':' + this.getName() + "(ahash=" + this.getAttributesHash() + ')';
    }

    private static final class EmptyDOMNodeDescription
    extends DOMNodeDescription {
        private EmptyDOMNodeDescription() {
        }

        @Override
        public Collection<? extends Description> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public String getName() {
            return "empty_dom_node_description";
        }

        @Override
        protected String getElementPath() {
            return "";
        }

        @Override
        protected Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }

        @Override
        public Description getParent() {
            return null;
        }
    }

    private static final class EmptySourceDescription
    extends SourceDescription {
        private EmptySourceDescription() {
        }

        @Override
        public Collection<? extends Description> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public String getName() {
            return "empty_source_node_description";
        }

        @Override
        protected String getElementPath() {
            return "";
        }

        @Override
        protected Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }

        public ElementType getElementType() {
            return ElementType.ERROR;
        }

        @Override
        public int getFrom() {
            return 0;
        }

        @Override
        public int getTo() {
            return 0;
        }

        @Override
        public Description getParent() {
            return null;
        }
    }
}

