/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modeldiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.spi.configurations.PkgConfigManager;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class PkgConfigImpl
implements PkgConfigManager.PkgConfig {
    private static final boolean TRACE = false;
    private HashMap<String, PackageConfigurationImpl> configurations = new HashMap();
    private Map<String, List<Pair>> seachBase;
    private String drivePrefix;
    private final ExecutionEnvironment env;

    public PkgConfigImpl(ExecutionEnvironment env) {
        this.env = env;
        this.initPackages();
    }

    private boolean isWindows() {
        try {
            return HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env).getOSFamily() == HostInfo.OSFamily.WINDOWS;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return false;
        }
    }

    private boolean isLinux() {
        try {
            return HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env).getOSFamily() == HostInfo.OSFamily.LINUX;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return false;
        }
    }

    private List<String> envPaths(String folder, String ... foders) {
        ArrayList<String> res = new ArrayList<String>();
        String pkg_config = this.isWindows() ? "pkg-config.exe" : "pkg-config";
        ProcessUtils.ExitStatus status = ProcessUtils.execute((ExecutionEnvironment)this.env, (String)pkg_config, (String[])new String[]{"--variable", "pc_path", "pkg-config"});
        if (status.isOK()) {
            this.addPaths(res, status.output);
        }
        res.add(folder);
        Collections.addAll(res, foders);
        this.addPaths(res, (String)HostInfoProvider.getEnv((ExecutionEnvironment)this.env).get("PKG_CONFIG_PATH"));
        return res;
    }

    private void addPaths(List<String> res, String additionalPaths) {
        if (additionalPaths != null && additionalPaths.length() > 0) {
            StringTokenizer st = this.isWindows() ? new StringTokenizer(additionalPaths, ";") : new StringTokenizer(additionalPaths, ":");
            while (st.hasMoreTokens()) {
                res.add(st.nextToken());
            }
        }
    }

    private void initPackages() {
        if (this.isWindows()) {
            String baseDirectory = this.getPkgConfihPath();
            if (baseDirectory == null) {
                CompilerSet set = null;
                for (CompilerSet cs : CompilerSetManager.get((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).getCompilerSets()) {
                    if (!cs.getCompilerFlavor().isCygwinCompiler()) continue;
                    set = cs;
                    break;
                }
                if (set != null && (baseDirectory = set.getDirectory()) != null && baseDirectory.endsWith("bin")) {
                    this.drivePrefix = baseDirectory.substring(0, baseDirectory.length() - 4);
                    baseDirectory = baseDirectory.substring(0, baseDirectory.length() - 3) + "lib/pkgconfig/";
                }
                if (baseDirectory == null) {
                    this.drivePrefix = "c:/cygwin";
                    baseDirectory = "c:/cygwin/lib/pkgconfig/";
                }
            } else {
                String suffix = "/lib/pkgconfig/";
                if (baseDirectory.endsWith(suffix)) {
                    this.drivePrefix = baseDirectory.substring(0, baseDirectory.length() - suffix.length());
                }
            }
            this.initPackages(this.envPaths(baseDirectory, new String[0]), true);
        } else if (this.isLinux()) {
            HostInfo hostinfo = null;
            try {
                if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)this.env)) {
                    hostinfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ConnectionManager.CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (hostinfo != null && hostinfo.getOS().getBitness() == HostInfo.Bitness._64) {
                this.initPackages(this.envPaths("/usr/lib64/pkgconfig", "/usr/share/pkgconfig"), false);
            } else {
                this.initPackages(this.envPaths("/usr/lib/pkgconfig", "/usr/share/pkgconfig"), false);
            }
        } else {
            this.initPackages(this.envPaths("/usr/lib/pkgconfig", "/usr/share/pkgconfig"), false);
        }
    }

    private String getPkgConfihPath() {
        for (String path : Path.getPath()) {
            int i;
            File file = new File(path + File.separator + "pkg-config.exe");
            if (!file.exists()) continue;
            if ((path = path.replace('\\', '/')).endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if ((i = path.lastIndexOf(47)) > 0) {
                path = path.substring(0, i + 1) + "lib/pkgconfig/";
                return path;
            }
            return null;
        }
        return null;
    }

    private void initPackages(List<String> folders, boolean isWindows) {
        HashSet<FileObject> done = new HashSet<FileObject>();
        for (String folder : folders) {
            FileObject file = RemoteFileUtil.getFileObject((String)RemoteFileUtil.normalizeAbsolutePath((String)folder, (ExecutionEnvironment)this.env), (ExecutionEnvironment)this.env);
            if (file == null || done.contains(file)) continue;
            done.add(file);
            if (!file.isValid() || !file.isFolder() || !file.canRead()) continue;
            for (FileObject fpc : file.getChildren()) {
                String name = fpc.getNameExt();
                if (!name.endsWith(".pc") || !fpc.canRead() || !fpc.isData()) continue;
                String pkgName = name.substring(0, name.length() - 3);
                PackageConfigurationImpl pc = new PackageConfigurationImpl(pkgName);
                this.readConfig(fpc, pc, isWindows);
                this.configurations.put(pkgName, pc);
            }
        }
    }

    public PkgConfigManager.PackageConfiguration getPkgConfig(String pkg) {
        return this.getConfig(pkg);
    }

    public List<PkgConfigManager.PackageConfiguration> getAvaliablePkgConfigs() {
        return new ArrayList<PkgConfigManager.PackageConfiguration>(this.configurations.values());
    }

    public Collection<PkgConfigManager.ResolvedPath> getResolvedPath(String include) {
        Map<String, List<Pair>> map = this.getLibraryItems();
        List<Pair> pairs = map.get(include);
        if (pairs != null && pairs.size() > 0) {
            ArrayList<PkgConfigManager.ResolvedPath> res = new ArrayList<PkgConfigManager.ResolvedPath>(pairs.size());
            for (Pair p : pairs) {
                res.add(new ResolvedPathImpl(p.path, p.configurations));
            }
            return res;
        }
        return null;
    }

    void trace() {
        ArrayList<String> sort = new ArrayList<String>(this.configurations.keySet());
        Collections.sort(sort);
        for (String pkg : sort) {
            this.traceConfig(pkg, false);
        }
        Map<String, List<Pair>> res = this.getLibraryItems();
        System.out.println("Known includes size: " + res.size());
        sort = new ArrayList<String>(res.keySet());
        Collections.sort(sort);
        for (String key : sort) {
            List<Pair> pairs = res.get(key);
            if (pairs == null) continue;
            for (Pair value : pairs) {
                StringBuilder buf = new StringBuilder();
                for (PkgConfigManager.PackageConfiguration pc : value.configurations) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(pc.getName());
                }
                System.out.println(key + "\t" + value.path + "\t[" + buf.toString() + "]");
            }
        }
    }

    void traceConfig(String pkg, boolean recursive) {
        this.traceConfig(pkg, recursive, new HashSet<String>(), "");
    }

    private void traceConfig(String pkg, boolean recursive, Set<String> visited, String tab) {
        if (visited.contains(pkg)) {
            return;
        }
        visited.add(pkg);
        PackageConfigurationImpl pc = this.configurations.get(pkg);
        if (pc != null) {
            System.out.println(tab + "Package definition");
            System.out.println(tab + "Name:     " + pkg);
            System.out.println(tab + "Requires: " + pc.requires);
            System.out.println(tab + "Macros:   " + pc.macros);
            System.out.println(tab + "Paths:    " + pc.paths);
            if (recursive) {
                for (String p : pc.requires) {
                    this.traceConfig(p, recursive, visited, tab + "    ");
                }
            }
        } else {
            System.out.println("Not found package definition " + pkg);
        }
    }

    void traceRecursiveConfig(String pkg) {
        PkgConfigManager.PackageConfiguration pc = this.getConfig(pkg);
        if (pc != null) {
            System.out.println("Recursive package definition");
            System.out.println("Name:    " + pkg);
            System.out.println("Package: " + pkg);
            System.out.println("Macros:  " + pc.getMacros());
            System.out.println("Paths:   " + pc.getIncludePaths());
        }
    }

    private PkgConfigManager.PackageConfiguration getConfig(String pkg) {
        PackageConfigurationImpl master = new PackageConfigurationImpl(pkg);
        this.getConfig(master, this.configurations.get(pkg));
        return master;
    }

    private void getConfig(PackageConfigurationImpl master, PackageConfigurationImpl pc) {
        if (pc != null) {
            for (String m : pc.macros) {
                if (master.macros.contains(m)) continue;
                master.macros.add(m);
            }
            for (String p : pc.paths) {
                if (master.paths.contains(p)) continue;
                master.paths.add(p);
            }
            for (String require : pc.requires) {
                this.getConfig(master, this.configurations.get(require));
            }
        }
    }

    private synchronized Map<String, List<Pair>> getLibraryItems() {
        Map<String, List<Pair>> res = this.seachBase;
        if (res == null) {
            this.seachBase = res = this._getLibraryItems();
        }
        return res;
    }

    private Map<String, List<Pair>> _getLibraryItems() {
        HashMap<String, HashSet<PackageConfigurationImpl>> map = new HashMap<String, HashSet<PackageConfigurationImpl>>();
        for (String pkg : this.configurations.keySet()) {
            PackageConfigurationImpl pc = this.configurations.get(pkg);
            if (pc == null) continue;
            for (String p : pc.paths) {
                if (this.drivePrefix == null ? p.equals("/usr/include") || p.equals("/usr/sfw/include") : p.substring(this.drivePrefix.length()).equals("/usr/include") || p.substring(this.drivePrefix.length()).equals("/usr/sfw/include")) continue;
                HashSet<PackageConfigurationImpl> set = (HashSet<PackageConfigurationImpl>)map.get(p);
                if (set == null) {
                    set = new HashSet<PackageConfigurationImpl>();
                    map.put(p, set);
                }
                set.add(pc);
            }
        }
        HashMap<String, List<Pair>> res = new HashMap<String, List<Pair>>();
        for (Map.Entry entry : map.entrySet()) {
            Pair pair = new Pair((String)entry.getKey(), (Set)entry.getValue());
            if (this.isWindows() ? ((String)entry.getKey()).length() < 2 || ((String)entry.getKey()).charAt(1) != ':' : !((String)entry.getKey()).startsWith("/")) continue;
            String normalizedPath = RemoteFileUtil.normalizeAbsolutePath((String)((String)entry.getKey()), (ExecutionEnvironment)this.env);
            FileObject dir = RemoteFileUtil.getFileObject((String)normalizedPath, (ExecutionEnvironment)this.env);
            this.addLibraryItem(res, pair, "", dir, 0);
        }
        return res;
    }

    private void addLibraryItem(Map<String, List<Pair>> res, Pair pkg, String prefix, FileObject dir, int loop) {
        if (dir == null) {
            return;
        }
        if (loop > 2) {
            return;
        }
        if (dir.isFolder() && dir.canRead()) {
            for (FileObject f : dir.getChildren()) {
                if (!f.canRead()) continue;
                if (f.isFolder()) {
                    if (loop == 0) {
                        this.addLibraryItem(res, pkg, f.getNameExt(), f, loop + 1);
                        continue;
                    }
                    this.addLibraryItem(res, pkg, prefix + "/" + f.getNameExt(), f, loop + 1);
                    continue;
                }
                if (!f.isData()) continue;
                String key = prefix.length() == 0 ? f.getNameExt() : prefix + "/" + f.getNameExt();
                List<Pair> list = res.get(key);
                if (list == null) {
                    list = new ArrayList<Pair>(1);
                    res.put(key, list);
                }
                if (list.contains(pkg)) continue;
                list.add(pkg);
            }
        }
    }

    private void readConfig(FileObject file, PackageConfigurationImpl pc, boolean isWindows) {
        try {
            String line;
            String rootName = null;
            String rootValue = null;
            HashMap<String, String> vars = new HashMap<String, String>();
            if (file.getParent() != null) {
                vars.put("pcfiledir", file.getParent().getPath());
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream()));
            while ((line = in.readLine()) != null) {
                String s;
                StringTokenizer st;
                if ((line = line.trim()).startsWith("#")) continue;
                int sharp = line.indexOf(35);
                if (sharp > 0) {
                    line = line.substring(0, sharp).trim();
                }
                if (line.startsWith("Requires:")) {
                    String value = line.substring(9).trim();
                    value = this.expandMacros(value, vars);
                    st = new StringTokenizer(value, " ,");
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        if (s.startsWith("<") || s.startsWith(">") || s.startsWith("=") || Character.isDigit(s.charAt(0))) continue;
                        pc.requires.add(s);
                    }
                    continue;
                }
                if (line.startsWith("Requires.private:")) {
                    String value = line.substring(17).trim();
                    value = this.expandMacros(value, vars);
                    st = new StringTokenizer(value, " ,");
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        if (s.startsWith("<") || s.startsWith(">") || s.startsWith("=") || Character.isDigit(s.charAt(0))) continue;
                        pc.requires.add(s);
                    }
                    continue;
                }
                if (line.startsWith("Version:")) {
                    pc.version = line.substring(8).trim();
                    continue;
                }
                if (line.startsWith("Description:")) {
                    pc.displayName = line.substring(12).trim();
                    continue;
                }
                if (line.startsWith("Libs:")) {
                    String value = line.substring(5).trim();
                    pc.libs = value = this.expandMacros(value, vars);
                    continue;
                }
                if (line.startsWith("Cflags:")) {
                    String value = line.substring(7).trim();
                    value = this.expandMacros(value, vars);
                    st = new StringTokenizer(value, " ");
                    while (st.hasMoreTokens()) {
                        String v = st.nextToken();
                        if (v.startsWith("-I")) {
                            v = v.substring(2);
                            if (isWindows) {
                                if (v.length() > 2 && v.charAt(1) == ':') {
                                    if (rootName != null && v.startsWith(rootName)) {
                                        if (rootValue != null) {
                                            v = rootValue + v.substring(rootName.length());
                                        } else if (this.drivePrefix != null) {
                                            v = this.drivePrefix + v.substring(rootName.length());
                                        }
                                    }
                                } else {
                                    if (rootValue != null) {
                                        v = v.startsWith(rootName) ? rootValue + v.substring(rootName.length()) : rootValue + v;
                                    } else if (this.drivePrefix != null) {
                                        v = this.drivePrefix + v;
                                    }
                                    if (v.indexOf("/usr/lib/") > 0) {
                                        v = v.replace("/usr/lib/", "/lib/");
                                    }
                                }
                            }
                            pc.paths.add(v);
                            continue;
                        }
                        if (!v.startsWith("-D")) continue;
                        pc.macros.add(v.substring(2));
                    }
                    continue;
                }
                if (line.indexOf(61) <= 0) continue;
                int i = line.indexOf(61);
                String name = line.substring(0, i).trim();
                String value = line.substring(i + 1).trim();
                if (isWindows && name.equals("prefix")) {
                    rootName = value;
                    rootValue = this.fixPrefixPath(value, file);
                }
                vars.put(name, this.expandMacros(value, vars));
            }
            in.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private String fixPrefixPath(String value, FileObject file) {
        StringTokenizer st = new StringTokenizer(value, "\\/");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.length() != 32) continue;
            boolean isHashCode = true;
            block4: for (int i = 0; i < 32; ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        continue block4;
                    }
                    default: {
                        isHashCode = false;
                    }
                }
            }
            if (!isHashCode) continue;
            if ((file = file.getParent()) != null) {
                file = file.getParent();
            }
            if (file != null) {
                file = file.getParent();
            }
            if (file == null) continue;
            return file.getPath();
        }
        if (value.startsWith("/")) {
            if ((file = file.getParent()) != null) {
                file = file.getParent();
            }
            if (file != null) {
                file = file.getParent();
            }
            if (file != null) {
                FileObject fileObject = file.getFileObject(value.substring(1));
                if (fileObject != null && fileObject.isValid() && fileObject.isFolder()) {
                    return fileObject.getPath();
                }
                return file.getPath();
            }
        }
        return null;
    }

    private String expandMacros(String value, Map<String, String> vars) {
        if (value.indexOf("${") >= 0) {
            while (value.indexOf("${") >= 0) {
                String macro;
                String v;
                int i = value.indexOf("${");
                int j = value.indexOf(125);
                if (j < i || (v = vars.get(macro = value.substring(i + 2, j))) == null || v.indexOf("${") >= 0) break;
                value = value.substring(0, i) + v + value.substring(j + 1);
            }
        }
        return value;
    }

    private static class Pair {
        private String path;
        private Set<PkgConfigManager.PackageConfiguration> configurations;

        private Pair(String path, Set<PkgConfigManager.PackageConfiguration> configurations) {
            this.path = path;
            this.configurations = configurations;
        }
    }

    class ResolvedPathImpl
    implements PkgConfigManager.ResolvedPath {
        private String path;
        private Set<PkgConfigManager.PackageConfiguration> packages;

        private ResolvedPathImpl(String path, Set<PkgConfigManager.PackageConfiguration> packages) {
            this.path = path;
            this.packages = packages;
        }

        public String getIncludePath() {
            return this.path;
        }

        public Collection<PkgConfigManager.PackageConfiguration> getPackages() {
            ArrayList<PkgConfigManager.PackageConfiguration> res = new ArrayList<PkgConfigManager.PackageConfiguration>(this.packages.size());
            for (PkgConfigManager.PackageConfiguration pc : this.packages) {
                res.add(PkgConfigImpl.this.getPkgConfig(pc.getName()));
            }
            return res;
        }
    }

    static class PackageConfigurationImpl
    implements PkgConfigManager.PackageConfiguration {
        List<String> requires = new ArrayList<String>();
        List<String> macros = new ArrayList<String>();
        List<String> paths = new ArrayList<String>();
        String libs = "";
        private final String name;
        private String version;
        private String displayName;

        private PackageConfigurationImpl(String name) {
            this.name = name;
        }

        public Collection<String> getIncludePaths() {
            return new ArrayList<String>(this.paths);
        }

        public Collection<String> getMacros() {
            return new ArrayList<String>(this.macros);
        }

        public String getLibs() {
            return this.libs;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return this.name + " " + this.paths + " " + this.macros;
        }
    }
}

