/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.highlight.InterrupterImpl;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.ReferenceCollector;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntitiesProvider;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntity;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.cnd.utils.ui.NamedOption;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.PositionsBag;

public final class SemanticHighlighter
extends HighlighterBase {
    private static final Logger LOG = Logger.getLogger(SemanticHighlighter.class.getName());
    private static final int MAX_LINE_NUMBER;

    public SemanticHighlighter(Document doc) {
        super(doc);
        this.init(doc);
    }

    @Override
    protected void updateFontColors(FontColorProvider provider) {
        for (SemanticEntity semanticEntity : SemanticEntitiesProvider.instance().get()) {
            semanticEntity.updateFontColors(provider);
        }
    }

    public static PositionsBag getHighlightsBag(Document doc) {
        if (doc == null) {
            return null;
        }
        PositionsBag bag = (PositionsBag)doc.getProperty(SemanticHighlighter.class);
        if (bag == null) {
            bag = new PositionsBag(doc);
            doc.putProperty(SemanticHighlighter.class, bag);
        }
        return bag;
    }

    public static boolean isVeryBigDocument(Document doc) {
        if (!(doc instanceof BaseDocument) || MAX_LINE_NUMBER < 0) {
            return false;
        }
        try {
            if (doc.getLength() < MAX_LINE_NUMBER) {
                return false;
            }
            return Utilities.getLineOffset((BaseDocument)((BaseDocument)doc), (int)(doc.getLength() - 1)) > MAX_LINE_NUMBER;
        }
        catch (BadLocationException ex) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(final CsmReferenceRepository.Interrupter interrupter) {
        BaseDocument doc = this.getDocument();
        if (doc != null) {
            DocumentListener listener = null;
            if (interrupter instanceof InterrupterImpl) {
                listener = new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        ((InterrupterImpl)interrupter).cancel();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        ((InterrupterImpl)interrupter).cancel();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                    }
                };
                doc.addDocumentListener(listener);
            }
            try {
                this.update(doc, interrupter);
            }
            finally {
                if (listener != null) {
                    doc.removeDocumentListener(listener);
                }
            }
        }
    }

    private void update(BaseDocument doc, final CsmReferenceRepository.Interrupter interrupter) {
        boolean macroExpansionView = doc.getProperty((Object)"macro-expansion-view-document") != null;
        PositionsBag newBag = new PositionsBag((Document)doc);
        newBag.clear();
        final CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
        long start = System.currentTimeMillis();
        if (csmFile != null && csmFile.isParsed()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Semantic Highlighting update() have started for file {0}", csmFile.getAbsolutePath());
            }
            ArrayList<SemanticEntity> entities = new ArrayList<SemanticEntity>(SemanticEntitiesProvider.instance().get());
            final ArrayList<ReferenceCollector> collectors = new ArrayList<ReferenceCollector>(entities.size());
            Iterator i = entities.iterator();
            while (i.hasNext()) {
                SemanticEntity se = (SemanticEntity)((Object)i.next());
                if (!(!NamedOption.getAccessor().getBoolean(se.getName()) || macroExpansionView && se.getName().equals("macros"))) {
                    ReferenceCollector collector = se.getCollector();
                    if (collector != null) {
                        collectors.add(collector);
                        continue;
                    }
                    this.addHighlightsToBag(newBag, se.getBlocks(csmFile), se);
                    i.remove();
                    continue;
                }
                i.remove();
            }
            PositionsBag old = SemanticHighlighter.getHighlightsBag((Document)doc);
            if (old != null) {
                PositionsBag tempBag = new PositionsBag((Document)doc);
                tempBag.addAllHighlights(newBag);
                HighlightsSequence seq = newBag.getHighlights(0, Integer.MAX_VALUE);
                HashSet<AttributeSet> set = new HashSet<AttributeSet>();
                while (seq.moveNext()) {
                    set.add(seq.getAttributes());
                }
                seq = old.getHighlights(0, Integer.MAX_VALUE);
                while (seq.moveNext()) {
                    if (set.contains(seq.getAttributes())) continue;
                    int startOffset = SemanticHighlighter.getDocumentOffset((Document)doc, seq.getStartOffset());
                    int endOffset = SemanticHighlighter.getDocumentOffset((Document)doc, seq.getEndOffset());
                    if (startOffset >= doc.getLength() || endOffset <= 0) continue;
                    this.addHighlightsToBag(tempBag, startOffset, endOffset, seq.getAttributes(), "cached");
                }
                SemanticHighlighter.getHighlightsBag((Document)doc).setHighlights(tempBag);
            } else {
                SemanticHighlighter.getHighlightsBag((Document)doc).setHighlights(newBag);
            }
            if (!entities.isEmpty() && !SemanticHighlighter.isVeryBigDocument((Document)doc)) {
                CsmFileReferences.getDefault().accept((CsmScope)csmFile, new CsmFileReferences.Visitor(){

                    public void visit(CsmReferenceContext context) {
                        CsmReference ref = context.getReference();
                        for (ReferenceCollector c : collectors) {
                            if (interrupter.cancelled()) break;
                            c.visit(ref, csmFile);
                        }
                    }
                }, CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE_AND_PREPROCESSOR);
                for (int i2 = 0; i2 < entities.size(); ++i2) {
                    this.addHighlightsToBag(newBag, ((ReferenceCollector)collectors.get(i2)).getReferences(), (SemanticEntity)((Object)entities.get(i2)));
                }
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Semantic Highlighting update() done in {0}ms for file {1}", new Object[]{System.currentTimeMillis() - start, csmFile.getAbsolutePath()});
            }
        }
        if (!interrupter.cancelled()) {
            SemanticHighlighter.getHighlightsBag((Document)doc).setHighlights(newBag);
        }
    }

    private void addHighlightsToBag(PositionsBag bag, List<? extends CsmOffsetable> blocks, SemanticEntity entity) {
        BaseDocument doc = this.getDocument();
        if (doc != null) {
            String mimeType = DocumentUtilities.getMimeType((Document)doc);
            if (mimeType == null) {
                mimeType = "text/x-c++";
            }
            for (CsmOffsetable csmOffsetable : blocks) {
                int startOffset = SemanticHighlighter.getDocumentOffset((Document)doc, csmOffsetable.getStartOffset());
                int endOffset = csmOffsetable.getEndOffset();
                endOffset = SemanticHighlighter.getDocumentOffset((Document)doc, endOffset == Integer.MAX_VALUE ? doc.getLength() + 1 : endOffset);
                if (startOffset >= doc.getLength() || endOffset <= 0) continue;
                AttributeSet attributes = entity.getAttributes(csmOffsetable, mimeType);
                if (attributes == null) {
                    assert (false) : "Color attributes set is not found for MIME " + mimeType + ". Document " + doc;
                    return;
                }
                this.addHighlightsToBag(bag, startOffset, endOffset, attributes, entity.getName());
            }
        }
    }

    private void addHighlightsToBag(PositionsBag bag, int start, int end, AttributeSet attr, String nameToStateInLog) {
        try {
            BaseDocument doc = this.getDocument();
            if (doc != null) {
                bag.addHighlight(doc.createPosition(start), doc.createPosition(end), attr);
            }
        }
        catch (BadLocationException ex) {
            LOG.log(Level.FINE, "Can't add highlight <" + start + ", " + end + ", " + nameToStateInLog + ">", ex);
        }
    }

    private static int getDocumentOffset(Document doc, int fileOffset) {
        return CsmMacroExpansion.getOffsetInExpandedText((Document)doc, (int)fileOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
        BaseDocument doc;
        if (phase == CsmFileTaskFactory.PhaseRunner.Phase.PARSED || phase == CsmFileTaskFactory.PhaseRunner.Phase.INIT || phase == CsmFileTaskFactory.PhaseRunner.Phase.PROJECT_PARSED) {
            InterrupterImpl interrupter = new InterrupterImpl();
            try {
                this.addCancelListener(interrupter);
                this.update(interrupter);
            }
            catch (AssertionError ex) {
                ((Throwable)((Object)ex)).printStackTrace(System.err);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            finally {
                this.removeCancelListener(interrupter);
            }
        } else if (phase == CsmFileTaskFactory.PhaseRunner.Phase.CLEANUP && (doc = this.getDocument()) != null) {
            SemanticHighlighter.getHighlightsBag((Document)doc).clear();
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean isHighPriority() {
        return false;
    }

    public String toString() {
        return "SemanticHighlighter runner";
    }

    static {
        String limit = System.getProperty("cnd.semantic.line.limit");
        int userInput = 5000;
        if (limit != null) {
            try {
                userInput = Integer.parseInt(limit);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MAX_LINE_NUMBER = userInput;
    }
}

