/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.ModelUtils;
import org.netbeans.modules.cnd.highlight.semantic.ReferenceCollector;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntity;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.cnd.utils.ui.NamedOption;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class SemanticEntitiesProvider {
    private final List<SemanticEntity> list;

    public List<SemanticEntity> get() {
        return this.list;
    }

    private SemanticEntitiesProvider() {
        Collection lookupAll = Lookup.getDefault().lookupAll(SemanticEntity.class);
        if (HighlighterBase.MINIMAL) {
            this.list = new ArrayList<SemanticEntity>();
            this.list.add((SemanticEntity)((Object)lookupAll.iterator().next()));
        } else {
            this.list = new ArrayList<SemanticEntity>(Lookup.getDefault().lookupAll(SemanticEntity.class));
        }
    }

    public static SemanticEntitiesProvider instance() {
        return Instantiator.instance;
    }

    private static class Instantiator {
        static SemanticEntitiesProvider instance = new SemanticEntitiesProvider();

        private Instantiator() {
        }
    }

    private static abstract class AbstractSemanticEntity
    extends SemanticEntity {
        private final ConcurrentHashMap<String, AttributeSet> color = new ConcurrentHashMap();
        private final FontColorProvider.Entity entity;
        private static final AttributeSet cleanUp = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Underline, null, StyleConstants.StrikeThrough, null, StyleConstants.Background, null, EditorStyleConstants.WaveUnderlineColor, null, EditorStyleConstants.Tooltip, null});

        public AbstractSemanticEntity() {
            this.entity = null;
        }

        public AbstractSemanticEntity(FontColorProvider.Entity entity) {
            this.entity = entity;
        }

        protected AttributeSet getColor(String mimeType) {
            return this.color.get(mimeType);
        }

        @Override
        public void updateFontColors(FontColorProvider provider) {
            assert (this.entity != null);
            this.color.put(provider.getMimeType(), AbstractSemanticEntity.getFontColor(provider, this.entity));
        }

        protected static AttributeSet getFontColor(FontColorProvider provider, FontColorProvider.Entity entity) {
            AttributeSet attributes = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{provider.getColor(entity), cleanUp});
            return attributes;
        }

        @Override
        public AttributeSet getAttributes(CsmOffsetable obj, String mimeType) {
            return this.color.get(mimeType);
        }

        @Override
        public ReferenceCollector getCollector() {
            return null;
        }

        public NamedOption.OptionKind getKind() {
            return NamedOption.OptionKind.Boolean;
        }

        public Object getDefaultValue() {
            return true;
        }
    }

    public static final class UnusedVariablesCodeProvider
    extends AbstractSemanticEntity {
        private final ConcurrentHashMap<String, AttributeSet> unusedToolTipColors = new ConcurrentHashMap();
        private final AttributeSet UNUSED_TOOLTIP = AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"UNUSED_VARIABLE_TOOLTIP")});

        public UnusedVariablesCodeProvider() {
            super(FontColorProvider.Entity.UNUSED_VARIABLES);
        }

        public String getName() {
            return "unused-variables";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-unused-variables");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-unused-variables-AD");
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
            return ModelUtils.collect(csmFile, this.getCollector());
        }

        @Override
        public ReferenceCollector getCollector() {
            return new ModelUtils.UnusedVariableCollector();
        }

        @Override
        protected AttributeSet getColor(String mimeType) {
            return this.unusedToolTipColors.get(mimeType);
        }

        @Override
        public void updateFontColors(FontColorProvider provider) {
            super.updateFontColors(provider);
            this.unusedToolTipColors.put(provider.getMimeType(), AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{this.UNUSED_TOOLTIP, super.getColor(provider.getMimeType())}));
        }
    }

    public static final class TypedefsCodeProvider
    extends AbstractSemanticEntity {
        public TypedefsCodeProvider() {
            super(FontColorProvider.Entity.TYPEDEF);
        }

        public String getName() {
            return "typedefs";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-typedefs");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-typedefs-AD");
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
            return ModelUtils.collect(csmFile, this.getCollector());
        }

        @Override
        public ReferenceCollector getCollector() {
            return new ModelUtils.TypedefReferenceCollector();
        }
    }

    public static final class MacrosCodeProvider
    extends AbstractSemanticEntity {
        private Map<String, AttributeSet> sysMacroColors = new HashMap<String, AttributeSet>();
        private Map<String, AttributeSet> userMacroColors = new HashMap<String, AttributeSet>();

        public MacrosCodeProvider() {
            super(FontColorProvider.Entity.DEFINED_MACRO);
        }

        public String getName() {
            return "macros";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-macros");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-macros-AD");
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
            return ModelUtils.getMacroBlocks(csmFile);
        }

        @Override
        public AttributeSet getAttributes(CsmOffsetable obj, String mimePath) {
            CsmMacro macro = (CsmMacro)((CsmReference)obj).getReferencedObject();
            if (macro == null) {
                return this.getColor(mimePath);
            }
            switch (macro.getKind()) {
                case USER_SPECIFIED: {
                    return this.userMacroColors.get(mimePath);
                }
                case COMPILER_PREDEFINED: 
                case POSITION_PREDEFINED: {
                    return this.sysMacroColors.get(mimePath);
                }
                case DEFINED: {
                    return this.getColor(mimePath);
                }
            }
            throw new IllegalArgumentException("unexpected macro kind:" + macro.getKind() + " in macro:" + macro);
        }

        @Override
        public void updateFontColors(FontColorProvider provider) {
            super.updateFontColors(provider);
            this.sysMacroColors.put(provider.getMimeType(), MacrosCodeProvider.getFontColor(provider, FontColorProvider.Entity.SYSTEM_MACRO));
            this.userMacroColors.put(provider.getMimeType(), MacrosCodeProvider.getFontColor(provider, FontColorProvider.Entity.USER_MACRO));
        }
    }

    public static final class FunctionsCodeProvider
    extends AbstractSemanticEntity {
        private Map<String, AttributeSet> funUsageColors = new HashMap<String, AttributeSet>();

        public FunctionsCodeProvider() {
            super(FontColorProvider.Entity.FUNCTION);
        }

        public String getName() {
            return "functions-names";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-functions-names");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-functions-names-AD");
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
            return ModelUtils.collect(csmFile, this.getCollector());
        }

        @Override
        public ReferenceCollector getCollector() {
            return new ModelUtils.FunctionReferenceCollector();
        }

        @Override
        public AttributeSet getAttributes(CsmOffsetable obj, String mimePath) {
            CsmReference ref = (CsmReference)obj;
            CsmFunction fun = (CsmFunction)ref.getReferencedObject();
            if (fun == null) {
                return this.getColor(mimePath);
            }
            if (CsmReferenceResolver.getDefault().isKindOf(ref, CsmReferenceKind.FUNCTION_DECLARATION_KINDS)) {
                return this.getColor(mimePath);
            }
            return this.funUsageColors.get(mimePath);
        }

        @Override
        public void updateFontColors(FontColorProvider provider) {
            super.updateFontColors(provider);
            this.funUsageColors.put(provider.getMimeType(), FunctionsCodeProvider.getFontColor(provider, FontColorProvider.Entity.FUNCTION_USAGE));
        }
    }

    public static final class FastFunctionsCodeProvider
    extends AbstractSemanticEntity {
        private Map<String, AttributeSet> funUsageColors = new HashMap<String, AttributeSet>();

        public FastFunctionsCodeProvider() {
            super(FontColorProvider.Entity.FUNCTION);
        }

        public String getName() {
            return "fast-functions-names";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-fast-functions-names");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-fast-functions-names-AD");
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
            Collection references = CsmReferenceResolver.getDefault().getReferences(csmFile);
            ArrayList<CsmReference> res = new ArrayList<CsmReference>();
            for (CsmReference ref : references) {
                if (!CsmKindUtilities.isFunction((CsmObject)ref.getReferencedObject())) continue;
                res.add(ref);
            }
            return res;
        }

        @Override
        public ReferenceCollector getCollector() {
            return null;
        }

        @Override
        public AttributeSet getAttributes(CsmOffsetable obj, String mimePath) {
            CsmReference ref = (CsmReference)obj;
            CsmFunction fun = (CsmFunction)ref.getReferencedObject();
            if (fun == null) {
                return this.getColor(mimePath);
            }
            if (CsmReferenceResolver.getDefault().isKindOf(ref, CsmReferenceKind.FUNCTION_DECLARATION_KINDS)) {
                return this.getColor(mimePath);
            }
            return this.funUsageColors.get(mimePath);
        }

        @Override
        public void updateFontColors(FontColorProvider provider) {
            super.updateFontColors(provider);
            this.funUsageColors.put(provider.getMimeType(), FastFunctionsCodeProvider.getFontColor(provider, FontColorProvider.Entity.FUNCTION_USAGE));
        }
    }

    public static final class FieldCodeProvider
    extends AbstractSemanticEntity {
        public FieldCodeProvider() {
            super(FontColorProvider.Entity.CLASS_FIELD);
        }

        public String getName() {
            return "class-fields";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-class-fields");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-class-fields-AD");
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
            return ModelUtils.collect(csmFile, this.getCollector());
        }

        @Override
        public ReferenceCollector getCollector() {
            return new ModelUtils.FieldReferenceCollector();
        }
    }

    public static final class FastFieldCodeProvider
    extends AbstractSemanticEntity {
        public FastFieldCodeProvider() {
            super(FontColorProvider.Entity.CLASS_FIELD);
        }

        public String getName() {
            return "fast-class-fields";
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
            Collection references = CsmReferenceResolver.getDefault().getReferences(csmFile);
            ArrayList<CsmReference> res = new ArrayList<CsmReference>();
            for (CsmReference ref : references) {
                if (!CsmKindUtilities.isField((CsmObject)ref.getReferencedObject())) continue;
                res.add(ref);
            }
            return res;
        }

        @Override
        public ReferenceCollector getCollector() {
            return null;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-fast-class-fields");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-fast-class-fields-AD");
        }
    }

    public static final class InactiveCodeProvider
    extends AbstractSemanticEntity {
        public InactiveCodeProvider() {
            super(FontColorProvider.Entity.INACTIVE_CODE);
        }

        public String getName() {
            return "inactive";
        }

        @Override
        public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
            return ModelUtils.getInactiveCodeBlocks(csmFile);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-inactive");
        }

        public String getDescription() {
            return NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"Show-inactive-AD");
        }
    }
}

