/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.highlight.semantic.ReferenceCollector;

public class ModelUtils {
    public static final int HIGHLIGHT_DELAY = ModelUtils.getInt("cnd.reparce.delay", 500);
    public static final int RESCHEDULE_HIGHLIGHT_DELAY = ModelUtils.getInt("cnd.reschedule.task.delay", 500);
    public static final int OCCURRENCES_DELAY = ModelUtils.getInt("cnd.reparce.delay", 300);
    public static final int RESCHEDULE_OCCURRENCES_DELAY = ModelUtils.getInt("cnd.reschedule.task.delay", 300);
    public static final int SEMANTIC_DELAY = ModelUtils.getInt("cnd.reparce.delay", 500);
    public static final int RESCHEDULE_SEMANTIC_DELAY = ModelUtils.getInt("cnd.reschedule.task.delay", 500);

    private ModelUtils() {
    }

    private static int getInt(String name, int result) {
        String text = System.getProperty(name);
        if (text != null) {
            try {
                result = Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    static List<CsmReference> collect(final CsmFile csmFile, final ReferenceCollector collector) {
        CsmFileReferences.getDefault().accept((CsmScope)csmFile, new CsmFileReferences.Visitor(){

            public void visit(CsmReferenceContext context) {
                collector.visit(context.getReference(), csmFile);
            }
        });
        return collector.getReferences();
    }

    static List<CsmOffsetable> getInactiveCodeBlocks(CsmFile file) {
        return CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(file);
    }

    static List<CsmReference> getMacroBlocks(CsmFile file) {
        return CsmFileInfoQuery.getDefault().getMacroUsages(file);
    }

    private static class ReferenceCounter {
        private CsmReference reference;
        private int count;

        public ReferenceCounter(CsmReference reference) {
            this.reference = reference;
            this.count = 1;
        }

        public CsmReference getFirstReference() {
            return this.reference;
        }

        public int getCount() {
            return this.count;
        }

        public void increment() {
            ++this.count;
            this.reference = null;
        }
    }

    static class UnusedVariableCollector
    implements ReferenceCollector {
        private final Map<CsmVariable, ReferenceCounter> counters = new LinkedHashMap<CsmVariable, ReferenceCounter>();
        private Set<CsmParameter> parameters;

        public String getEntityName() {
            return "unused-variables";
        }

        @Override
        public void visit(CsmReference ref, CsmFile file) {
            CsmObject obj = ref.getReferencedObject();
            if (this.isWanted(obj, file)) {
                CsmVariable var = (CsmVariable)obj;
                ReferenceCounter counter = this.counters.get(var);
                if (counter == null) {
                    counter = new ReferenceCounter(ref);
                    this.counters.put(var, counter);
                } else {
                    counter.increment();
                }
            }
        }

        @Override
        public List<CsmReference> getReferences() {
            ArrayList<CsmReference> result = new ArrayList<CsmReference>();
            for (ReferenceCounter counter : this.counters.values()) {
                if (counter.getCount() != 1) continue;
                result.add(counter.getFirstReference());
            }
            return result;
        }

        private boolean isWanted(CsmObject obj, CsmFile file) {
            if (!CsmKindUtilities.isLocalVariable((CsmObject)obj)) {
                return false;
            }
            CsmVariable var = (CsmVariable)obj;
            if (!var.getContainingFile().equals(file)) {
                return false;
            }
            if (CsmKindUtilities.isParameter((CsmObject)obj)) {
                CsmParameter prm = (CsmParameter)var;
                Set<CsmParameter> set = this.getFunctionDefinitionParameters(file);
                return set.contains(prm);
            }
            return true;
        }

        private Set<CsmParameter> getFunctionDefinitionParameters(CsmFile file) {
            if (this.parameters == null) {
                this.parameters = new HashSet<CsmParameter>();
                CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION});
                Iterator i = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
                while (i.hasNext()) {
                    CsmFunctionDefinition fundef = (CsmFunctionDefinition)i.next();
                    this.parameters.addAll(fundef.getParameters());
                }
            }
            return this.parameters;
        }
    }

    static class FunctionReferenceCollector
    extends AbstractReferenceCollector {
        FunctionReferenceCollector() {
        }

        public String getEntityName() {
            return "functions-names";
        }

        @Override
        public void visit(CsmReference ref, CsmFile file) {
            if (this.isWanted(ref, file)) {
                this.list.add(ref);
            }
        }

        private boolean isWanted(CsmReference ref, CsmFile file) {
            CsmObject csmObject = ref.getReferencedObject();
            return CsmKindUtilities.isFunction((CsmObject)csmObject);
        }
    }

    static class TypedefReferenceCollector
    extends AbstractReferenceCollector {
        TypedefReferenceCollector() {
        }

        public String getEntityName() {
            return "typedefs";
        }

        @Override
        public void visit(CsmReference ref, CsmFile file) {
            CsmObject obj = ref.getReferencedObject();
            if (CsmKindUtilities.isTypedef((CsmObject)obj)) {
                this.list.add(ref);
            }
        }
    }

    static class FieldReferenceCollector
    extends AbstractReferenceCollector {
        FieldReferenceCollector() {
        }

        public String getEntityName() {
            return "class-fields";
        }

        @Override
        public void visit(CsmReference ref, CsmFile file) {
            CsmObject obj = ref.getReferencedObject();
            if (CsmKindUtilities.isField((CsmObject)obj)) {
                this.list.add(ref);
            }
        }
    }

    private static abstract class AbstractReferenceCollector
    implements ReferenceCollector {
        protected final List<CsmReference> list = new ArrayList<CsmReference>();

        @Override
        public List<CsmReference> getReferences() {
            return this.list;
        }
    }
}

