/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.openide.util.NbBundle;

public class IncludeErrorProvider
extends CsmErrorProvider {
    public String getName() {
        return "include-errors";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(IncludeErrorProvider.class, (String)"Show-include-errors");
    }

    public String getDescription() {
        return NbBundle.getMessage(IncludeErrorProvider.class, (String)"Show-include-errors-AD");
    }

    private static String decorateWithExtraHyperlinkTip(String tooltip) {
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)"text/x-c++").lookup(Preferences.class);
        int altShortCut = prefs.getInt("hyperlink-activation-modifiers", 128);
        return NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_HyperlinkActionsHints", (Object)tooltip, (Object)InputEvent.getModifiersExText(altShortCut));
    }

    protected void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        CsmFile file = request.getFile();
        Thread currentThread = Thread.currentThread();
        currentThread.setName("Provider " + this.getName() + " prosess " + file.getAbsolutePath());
        for (CsmInclude incl : CsmFileInfoQuery.getDefault().getBrokenIncludes(file)) {
            if (request.isCancelled()) break;
            if (incl.getIncludeState() == CsmInclude.IncludeState.Recursive) {
                response.addError((CsmErrorInfo)new IncludeErrorInfo(incl));
                continue;
            }
            if (incl.getIncludeFile() != null) continue;
            response.addError((CsmErrorInfo)new IncludeErrorInfo(incl));
        }
        for (CsmErrorDirective error : file.getErrors()) {
            response.addError((CsmErrorInfo)new ErrorDirectiveInfo(error));
        }
        HashSet<CsmFile> visited = new HashSet<CsmFile>();
        for (CsmInclude incl : file.getIncludes()) {
            CsmFile newFile = incl.getIncludeFile();
            if (newFile == null || !this.hasBrokenIncludes(newFile, visited)) continue;
            response.addError((CsmErrorInfo)new IncludeWarningInfo(incl));
        }
    }

    private boolean hasBrokenIncludes(CsmFile file, Collection<CsmFile> visited) {
        if (visited.contains(file)) {
            return false;
        }
        visited.add(file);
        if (CsmFileInfoQuery.getDefault().hasBrokenIncludes(file)) {
            return true;
        }
        for (CsmInclude incl : file.getIncludes()) {
            CsmFile newFile = incl.getIncludeFile();
            if (newFile == null || !this.hasBrokenIncludes(newFile, visited)) continue;
            return true;
        }
        return false;
    }

    private static final class ErrorDirectiveInfo
    extends OffsetableErrorInfo
    implements CsmErrorInfo {
        private String message = NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_ErrorDirective");

        public ErrorDirectiveInfo(CsmErrorDirective error) {
            super((CsmOffsetable)error, CsmErrorInfo.Severity.ERROR);
        }

        public String getMessage() {
            return this.message;
        }
    }

    private static final class IncludeWarningInfo
    extends OffsetableErrorInfo
    implements CsmErrorInfo {
        private String message;

        public IncludeWarningInfo(CsmInclude incl) {
            super((CsmOffsetable)incl, CsmErrorInfo.Severity.WARNING);
            this.message = IncludeErrorProvider.decorateWithExtraHyperlinkTip(NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_IncludeMissedWarning", (Object)IncludeWarningInfo.getIncludeText(incl)));
        }

        public String getMessage() {
            return this.message;
        }

        private static String getIncludeText(CsmInclude incl) {
            if (incl.isSystem()) {
                return "<" + incl.getIncludeName() + ">";
            }
            return "\"" + incl.getIncludeName() + "\"";
        }
    }

    private static final class IncludeErrorInfo
    extends OffsetableErrorInfo
    implements CsmErrorInfo {
        private String message;

        public IncludeErrorInfo(CsmInclude incl) {
            super((CsmOffsetable)incl, CsmErrorInfo.Severity.ERROR);
            this.message = incl.getIncludeState() == CsmInclude.IncludeState.Recursive ? IncludeErrorProvider.decorateWithExtraHyperlinkTip(NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_IncludeRecursive")) : IncludeErrorProvider.decorateWithExtraHyperlinkTip(NbBundle.getMessage(IncludeErrorProvider.class, (String)"HighlightProvider_IncludeMissed", (Object)IncludeErrorInfo.getIncludeText(incl)));
        }

        public String getMessage() {
            return this.message;
        }

        private static String getIncludeText(CsmInclude incl) {
            if (incl.isSystem()) {
                return "<" + incl.getIncludeName() + ">";
            }
            return "\"" + incl.getIncludeName() + "\"";
        }
    }

    private static abstract class OffsetableErrorInfo
    implements CsmErrorInfo {
        private int start;
        private int end;
        private CsmErrorInfo.Severity severity;

        public OffsetableErrorInfo(CsmOffsetable offsetable, CsmErrorInfo.Severity severity) {
            this.start = offsetable.getStartOffset();
            this.end = offsetable.getEndOffset();
            this.severity = severity;
        }

        public int getEndOffset() {
            return this.end;
        }

        public int getStartOffset() {
            return this.start;
        }

        public CsmErrorInfo.Severity getSeverity() {
            return this.severity;
        }
    }
}

