/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.junit.nodes;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.maven.junit.nodes.JUnitTestMethodNode;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;

final class OutputUtils {
    private static final Logger LOG = Logger.getLogger(OutputUtils.class.getName());
    static final Action[] NO_ACTIONS = new Action[0];
    static final String CALLSTACK_LINE_PREFIX = "at ";
    static final String CALLSTACK_LINE_PREFIX_CATCH = "[catch] ";
    private static final String JAVA_ID_START_REGEX = "\\p{javaJavaIdentifierStart}";
    private static final String JAVA_ID_PART_REGEX = "\\p{javaJavaIdentifierPart}";
    public static final String JAVA_ID_REGEX = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*";
    public static final String JAVA_ID_REGEX_FULL = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*";
    static final String LOCATION_IN_FILE_REGEX = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*(?:\\:[0-9]+)?";
    static final Pattern LOC_PATTERN = Pattern.compile("(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*(?:\\:[0-9]+)?");

    private OutputUtils() {
    }

    static String specialTrim(String string) {
        char c;
        int lead;
        int len = string.length();
        if (len == 0) {
            return string;
        }
        char[] chars = string.toCharArray();
        for (lead = 0; lead < len && ((c = chars[lead]) == ' ' || c == '\t'); ++lead) {
        }
        if (lead == len) {
            return string.substring(len);
        }
        int trail = len;
        while ((c = chars[--trail]) == ' ' || c == '\t') {
        }
        if (lead == 0 && trail == len - 1) {
            return string;
        }
        return string.substring(lead, trail + 1);
    }

    static void openTestsuite(TestsuiteNode node) {
        Node child;
        Children childrens = node.getChildren();
        if (childrens != null && (child = childrens.getNodeAt(0)) != null && child instanceof JUnitTestMethodNode) {
            FileObject fo = ((JUnitTestMethodNode)child).getTestcaseFileObject();
            OutputUtils.openFile(fo, 1);
        }
    }

    static void openTestMethod(final JUnitTestMethodNode node) {
        final FileObject fo = node.getTestcaseFileObject();
        if (fo != null) {
            final long[] line = new long[]{0L};
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            Trees trees = compilationController.getTrees();
                            CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                            List<? extends Tree> typeDecls = compilationUnitTree.getTypeDecls();
                            block0: for (Tree tree : typeDecls) {
                                Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                                if (element == null || element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(fo.getName())) continue;
                                List<ExecutableElement> methodElements = ElementFilter.methodsIn(element.getEnclosedElements());
                                for (ExecutableElement child : methodElements) {
                                    if (!child.getSimpleName().contentEquals(node.getTestcase().getName())) continue;
                                    long pos = trees.getSourcePositions().getStartPosition(compilationUnitTree, trees.getTree((Element)child));
                                    line[0] = compilationUnitTree.getLineMap().getLineNumber(pos);
                                    break block0;
                                }
                            }
                        }
                    }, true);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
            OutputUtils.openFile(fo, (int)line[0]);
        }
    }

    static void openCallstackFrame(Node node, String frameInfo) {
        String[] st;
        JUnitTestMethodNode methodNode = OutputUtils.getTestMethodNode(node);
        LineConvertors.FileLocator locator = methodNode.getTestcase().getSession().getFileLocator();
        if (locator == null) {
            return;
        }
        FileObject testfo = methodNode.getTestcaseFileObject();
        if (testfo == null) {
            StringBuilder stack = new StringBuilder();
            if (methodNode.getTestcase().getTrouble() != null) {
                String[] st2 = methodNode.getTestcase().getTrouble().getStackTrace();
                if (st2 != null) {
                    stack.append("\n");
                    for (String s : st2) {
                        stack.append(s).append("\n");
                    }
                } else {
                    stack.append("<none>");
                }
            } else {
                stack.append("<none>");
            }
            LOG.log(Level.INFO, "#221053: unknown location: {0} classname:{1}, stacktrace:", new Object[]{methodNode.getTestcase().getLocation(), methodNode.getTestcase().getClassName(), stack});
        }
        int[] lineNumStorage = new int[1];
        FileObject file = OutputUtils.getFile(frameInfo, lineNumStorage, locator);
        if (testfo != null && file == null && methodNode.getTestcase().getTrouble() != null && lineNumStorage[0] == -1 && (st = methodNode.getTestcase().getTrouble().getStackTrace()) != null && st.length > 0) {
            for (int index = st.length - 1; !testfo.equals(file) && index != -1; --index) {
                file = OutputUtils.getFile(st[index], lineNumStorage, locator);
            }
        }
        OutputUtils.openFile(file, lineNumStorage[0]);
    }

    static String determineStackFrame(Trouble trouble) {
        String[] frames = trouble.getStackTrace();
        return frames != null && frames.length != 0 ? frames[frames.length - 1] : null;
    }

    private static JUnitTestMethodNode getTestMethodNode(Node node) {
        while (!(node instanceof JUnitTestMethodNode)) {
            node = node.getParentNode();
        }
        return (JUnitTestMethodNode)node;
    }

    private static FileObject getFile(String callstackLine, int[] lineNumStorage, LineConvertors.FileLocator locator) {
        String ending;
        String slashName;
        int lastSlashIndex;
        int lineNum;
        String fileName;
        String clsName;
        block14: {
            String methodName;
            int bracketIndex;
            String line = OutputUtils.specialTrim(callstackLine);
            if (line.startsWith(CALLSTACK_LINE_PREFIX_CATCH)) {
                line = line.substring(CALLSTACK_LINE_PREFIX_CATCH.length());
            }
            if (line.startsWith(CALLSTACK_LINE_PREFIX)) {
                line = line.substring(CALLSTACK_LINE_PREFIX.length());
            }
            String beforeBrackets = (bracketIndex = line.indexOf(40)) == -1 ? line : line.substring(0, bracketIndex).trim();
            int endBracketIndex = line.lastIndexOf(41);
            String inBrackets = bracketIndex == -1 || endBracketIndex < bracketIndex ? (String)null : line.substring(bracketIndex + 1, endBracketIndex);
            int lastDotIndex = beforeBrackets.lastIndexOf(46);
            if (lastDotIndex != -1) {
                clsName = beforeBrackets.substring(0, lastDotIndex);
                methodName = beforeBrackets.substring(lastDotIndex + 1);
            } else {
                clsName = beforeBrackets;
                methodName = "";
            }
            fileName = null;
            lineNum = -1;
            if (inBrackets != null && LOC_PATTERN.matcher(inBrackets).matches()) {
                int ddotIndex = inBrackets.lastIndexOf(58);
                if (ddotIndex == -1) {
                    fileName = inBrackets;
                } else {
                    fileName = inBrackets.substring(0, ddotIndex);
                    try {
                        lineNum = Integer.parseInt(inBrackets.substring(ddotIndex + 1));
                        if (lineNum <= 0) {
                            lineNum = 1;
                        }
                    }
                    catch (NumberFormatException ex) {
                        if ($assertionsDisabled) break block14;
                        throw new AssertionError();
                    }
                }
            }
        }
        String clsNameSlash = clsName.replace('.', '/');
        if (fileName == null) {
            lastSlashIndex = clsNameSlash.length();
            slashName = clsNameSlash;
            ending = ".java";
        } else {
            lastSlashIndex = clsNameSlash.lastIndexOf(47);
            slashName = lastSlashIndex != -1 ? clsNameSlash.substring(0, lastSlashIndex) : clsNameSlash;
            ending = '/' + fileName;
        }
        String thePath = slashName + ending;
        FileObject file = locator.find(thePath);
        while (file == null && lastSlashIndex != -1) {
            thePath = (slashName = slashName.substring(0, lastSlashIndex)) + ending;
            file = locator.find(thePath);
            if (file != null) continue;
            lastSlashIndex = slashName.lastIndexOf(47, lastSlashIndex - 1);
        }
        if (file == null && fileName != null) {
            thePath = fileName;
            file = locator.find(thePath);
        }
        lineNumStorage[0] = lineNum;
        return file;
    }

    public static void openFile(FileObject file, int lineNum) {
        block8: {
            if (file == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dob = DataObject.find((FileObject)file);
                EditorCookie ed = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
                if (ed != null && file == dob.getPrimaryFile()) {
                    if (lineNum == -1) {
                        ed.open();
                        break block8;
                    }
                    ed.openDocument();
                    try {
                        Line l = ed.getLineSet().getOriginal(lineNum - 1);
                        if (!l.isDeleted()) {
                            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        }
                        break block8;
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        ed.open();
                    }
                    break block8;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

