/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.junit;

import java.io.File;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.junit.nodes.JUnitTestRunnerNodeFactory;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class JUnitOutputListenerProvider
implements OutputProcessor {
    TestSession session;
    private Pattern runningPattern = Pattern.compile("(?:\\[surefire\\] )?Running (.*)", 32);
    private Pattern outDirPattern2;
    private Pattern outDirPattern = Pattern.compile("Surefire report directory\\: (.*)", 32);
    private File outputDir;
    String runningTestClass;
    private final Set<String> usedNames;
    private final long startTimeStamp;
    private static final Logger LOG = Logger.getLogger(JUnitOutputListenerProvider.class.getName());
    private RunConfig config;
    private static Pattern COMPARISON_PATTERN = Pattern.compile(".*expected:<(.*)> but was:<(.*)>$");

    public JUnitOutputListenerProvider(RunConfig config) {
        this.outDirPattern2 = Pattern.compile("Setting reports dir\\: (.*)", 32);
        this.config = config;
        this.usedNames = new HashSet<String>();
        this.startTimeStamp = System.currentTimeMillis();
    }

    public String[] getRegisteredOutputSequences() {
        return new String[]{"mojo-execute#surefire:test"};
    }

    public void processLine(String line, OutputVisitor visitor) {
        Matcher match = this.outDirPattern.matcher(line);
        if (match.matches()) {
            this.outputDir = new File(match.group(1));
            if (this.session == null) {
                this.createSession(this.outputDir);
            }
            return;
        }
        match = this.outDirPattern2.matcher(line);
        if (match.matches()) {
            this.outputDir = new File(match.group(1));
            if (this.session == null) {
                this.createSession(this.outputDir);
            }
            return;
        }
        if (this.session == null) {
            return;
        }
        match = this.runningPattern.matcher(line);
        if (match.matches()) {
            if (this.runningTestClass != null && this.outputDir != null) {
                this.generateTest();
            }
            this.runningTestClass = match.group(1);
        }
    }

    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
        this.session = null;
    }

    private String createSessionName(String projectId) {
        String name = projectId;
        int index = 2;
        while (this.usedNames.contains(name)) {
            name = projectId + "_" + index;
            ++index;
        }
        this.usedNames.add(name);
        return name;
    }

    private void createSession(File nonNormalizedFile) {
        NbMavenProject mvnprj;
        File fil;
        Project prj;
        if (this.session == null && (prj = FileOwnerQuery.getOwner((URI)Utilities.toURI((File)(fil = FileUtil.normalizeFile((File)nonNormalizedFile))))) != null && (mvnprj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class)) != null) {
            TestSession.SessionType type = TestSession.SessionType.TEST;
            String action = this.config.getActionName();
            if (action != null && action.contains("debug")) {
                type = TestSession.SessionType.DEBUG;
            }
            final TestSession.SessionType fType = type;
            this.session = new TestSession(this.createSessionName(mvnprj.getMavenProject().getId()), prj, TestSession.SessionType.TEST, (TestRunnerNodeFactory)new JUnitTestRunnerNodeFactory(this.session, prj));
            this.session.setRerunHandler(new RerunHandler(){

                public void rerun() {
                    RunUtils.executeMaven((RunConfig)JUnitOutputListenerProvider.this.config);
                }

                public void rerun(Set<Testcase> tests) {
                    RunConfig brc = RunUtils.cloneRunConfig((RunConfig)JUnitOutputListenerProvider.this.config);
                    StringBuilder tst = new StringBuilder();
                    HashMap<String, ArrayList<String>> methods = new HashMap<String, ArrayList<String>>();
                    int windowslimitcount = 0;
                    for (Testcase tc : tests) {
                        if (tc.getClassName() == null) continue;
                        ArrayList<String> lst = (ArrayList<String>)methods.get(tc.getClassName());
                        if (lst == null) {
                            lst = new ArrayList<String>();
                            methods.put(tc.getClassName(), lst);
                            windowslimitcount = windowslimitcount + tc.getClassName().length() + 1;
                        }
                        lst.add(tc.getName());
                        windowslimitcount = windowslimitcount + tc.getName().length() + 1;
                    }
                    boolean exceedsWindowsLimit = Utilities.isWindows() && windowslimitcount > 6000;
                    for (Map.Entry ent : methods.entrySet()) {
                        tst.append(",");
                        if (exceedsWindowsLimit) {
                            String clazzName = (String)ent.getKey();
                            int lastDot = ((String)ent.getKey()).lastIndexOf(".");
                            if (lastDot > -1) {
                                clazzName = clazzName.substring(lastDot + 1);
                            }
                            tst.append(clazzName);
                        } else {
                            tst.append((String)ent.getKey());
                        }
                        tst.append("#");
                        boolean first = true;
                        for (String meth : (Collection)ent.getValue()) {
                            if (!first) {
                                tst.append("+");
                            }
                            first = false;
                            tst.append(meth);
                        }
                    }
                    if (tst.length() > 0) {
                        brc.setProperty("test", tst.substring(1));
                    }
                    RunUtils.executeMaven((RunConfig)brc);
                }

                public boolean enabled(RerunType type) {
                    if (fType.equals((Object)TestSession.SessionType.TEST)) {
                        if (RerunType.ALL.equals((Object)type)) {
                            return true;
                        }
                        if (RerunType.CUSTOM.equals((Object)type)) {
                            if (JUnitOutputListenerProvider.this.usingTestNG(JUnitOutputListenerProvider.this.config.getMavenProject())) {
                                return JUnitOutputListenerProvider.this.usingSurefire28(JUnitOutputListenerProvider.this.config.getMavenProject());
                            }
                            if (JUnitOutputListenerProvider.this.usingJUnit4(JUnitOutputListenerProvider.this.config.getMavenProject())) {
                                return JUnitOutputListenerProvider.this.usingSurefire2121(JUnitOutputListenerProvider.this.config.getMavenProject());
                            }
                        }
                    }
                    return false;
                }

                public void addChangeListener(ChangeListener listener) {
                }

                public void removeChangeListener(ChangeListener listener) {
                }
            });
            Manager.getInstance().testStarted(this.session);
        }
    }

    private boolean usingSurefire2121(MavenProject prj) {
        String v = PluginPropertyUtils.getPluginVersion((MavenProject)prj, (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin");
        return v != null && new ComparableVersion(v).compareTo(new ComparableVersion("2.12.1")) >= 0;
    }

    private boolean usingSurefire28(MavenProject prj) {
        String v = PluginPropertyUtils.getPluginVersion((MavenProject)prj, (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin");
        return v != null && new ComparableVersion(v).compareTo(new ComparableVersion("2.8")) >= 0;
    }

    private boolean usingTestNG(MavenProject prj) {
        for (Artifact a : prj.getArtifacts()) {
            if (!"org.testng".equals(a.getGroupId()) || !"testng".equals(a.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private boolean usingJUnit4(MavenProject prj) {
        for (Artifact a : prj.getArtifacts()) {
            String version;
            if (!"junit".equals(a.getGroupId()) || !"junit".equals(a.getArtifactId()) && !"junit-dep".equals(a.getArtifactId()) || (version = a.getVersion()) == null || new ComparableVersion(version).compareTo(new ComparableVersion("4.8")) < 0) continue;
            return true;
        }
        return false;
    }

    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
        if (this.session == null) {
            return;
        }
        if (this.runningTestClass != null && this.outputDir != null) {
            this.generateTest();
        }
        Manager.getInstance().sessionFinished(this.session);
        this.runningTestClass = null;
        this.outputDir = null;
        this.session = null;
    }

    static Trouble constructTrouble(String type, String message, String text, boolean error) {
        Matcher match;
        Trouble t = new Trouble(error);
        if (message != null && (match = COMPARISON_PATTERN.matcher(message)).matches()) {
            t.setComparisonFailure(new Trouble.ComparisonFailure(match.group(1), match.group(2)));
        }
        if (text != null) {
            String[] strs = StringUtils.split((String)text, (String)"\n");
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(message);
            lines.add(type);
            for (int i = 1; i < strs.length; ++i) {
                lines.add(strs[i]);
            }
            t.setStackTrace(lines.toArray(new String[0]));
        }
        return t;
    }

    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
        this.sequenceEnd(sequenceId, visitor);
    }

    private void generateTest() {
        String reportNameSuffix = PluginPropertyUtils.getPluginProperty((MavenProject)this.config.getMavenProject(), (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin", (String)"reportNameSuffix", (String)"test", (String)"surefire.reportNameSuffix");
        String suffix = reportNameSuffix;
        suffix = suffix == null ? "" : "-" + suffix;
        File report = new File(this.outputDir, "TEST-" + this.runningTestClass + suffix + ".xml");
        if (!report.isFile() || report.lastModified() < this.startTimeStamp) {
            return;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(report);
            Element testSuite = document.getRootElement();
            assert ("testsuite".equals(testSuite.getName())) : "Root name " + testSuite.getName();
            TestSuite suite = new TestSuite(testSuite.getAttributeValue("name"));
            this.session.addSuite(suite);
            Manager.getInstance().displaySuiteRunning(this.session, suite.getName());
            List testcases = testSuite.getChildren("testcase");
            String nameSuffix = reportNameSuffix != null ? "(" + reportNameSuffix + ")" : "";
            for (Element testcase : testcases) {
                String classname;
                String time;
                Element error;
                String name = testcase.getAttributeValue("name");
                if (name.endsWith(nameSuffix)) {
                    name = name.substring(0, name.length() - nameSuffix.length());
                }
                Testcase test = new Testcase(name, null, this.session);
                Element stdout = testcase.getChild("system-out");
                if (stdout != null) {
                    this.logText(stdout.getText(), test, false);
                }
                Element failure = testcase.getChild("failure");
                Status status = Status.PASSED;
                Trouble trouble = null;
                if (failure != null) {
                    status = Status.FAILED;
                    trouble = JUnitOutputListenerProvider.constructTrouble(failure.getAttributeValue("type"), failure.getAttributeValue("message"), failure.getText(), false);
                }
                if ((error = testcase.getChild("error")) != null) {
                    status = Status.ERROR;
                    trouble = JUnitOutputListenerProvider.constructTrouble(error.getAttributeValue("type"), error.getAttributeValue("message"), error.getText(), true);
                }
                test.setStatus(status);
                if (trouble != null) {
                    test.setTrouble(trouble);
                }
                if ((time = testcase.getAttributeValue("time")) != null) {
                    float fl = NumberFormat.getNumberInstance(Locale.ENGLISH).parse(time).floatValue();
                    test.setTimeMillis((long)(fl * 1000.0f));
                }
                if ((classname = testcase.getAttributeValue("classname")) != null) {
                    if (classname.endsWith(nameSuffix)) {
                        classname = classname.substring(0, classname.length() - nameSuffix.length());
                    }
                    test.setClassName(classname);
                    test.setLocation(test.getClassName().replace('.', '/') + ".java");
                }
                this.session.addTestCase(test);
            }
            String time = testSuite.getAttributeValue("time");
            float fl = NumberFormat.getNumberInstance(Locale.ENGLISH).parse(time).floatValue();
            long timeinmilis = (long)(fl * 1000.0f);
            Manager.getInstance().displayReport(this.session, this.session.getReport(timeinmilis));
            File output = new File(this.outputDir, this.runningTestClass + suffix + "-output.txt");
            if (output.isFile()) {
                Manager.getInstance().displayOutput(this.session, FileUtils.fileRead((File)output), false);
            }
        }
        catch (JDOMException x) {
            LOG.log(Level.INFO, "parsing " + report, x);
        }
        catch (Exception x) {
            LOG.log(Level.WARNING, "parsing " + report, x);
        }
    }

    private void logText(String text, Testcase test, boolean failure) {
        StringTokenizer tokens = new StringTokenizer(text, "\n");
        ArrayList<String> lines = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            lines.add(tokens.nextToken());
        }
        Manager.getInstance().displayOutput(this.session, text, failure);
        test.addOutputLines(lines);
    }
}

