/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ant;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.swing.JFileChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.project.ant.FileChooserAccessory;
import org.netbeans.modules.project.ant.ProjectLibraryProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class FileChooser
extends JFileChooser {
    private FileChooserAccessory accessory;

    public FileChooser(AntProjectHelper helper, boolean copyAllowed) {
        URL u;
        LibraryManager lm = ProjectLibraryProvider.getProjectLibraryManager(helper);
        if (lm != null && (u = lm.getLocation()) != null) {
            File libBase = Utilities.toFile((URI)URI.create(u.toExternalForm())).getParentFile();
            this.accessory = new FileChooserAccessory(this, FileUtil.toFile((FileObject)helper.getProjectDirectory()), libBase, copyAllowed);
            this.setAccessory(this.accessory);
        }
    }

    public FileChooser(File baseFolder, File sharedLibrariesFolder) {
        if (baseFolder != null) {
            this.accessory = new FileChooserAccessory(this, baseFolder, sharedLibrariesFolder, sharedLibrariesFolder != null);
            this.setAccessory(this.accessory);
        }
    }

    public void enableVariableBasedSelection(boolean enable) {
        if (this.accessory != null) {
            this.accessory.enableVariableBasedSelection(enable);
        }
    }

    public String[] getSelectedPaths() throws IOException {
        if (this.accessory != null) {
            this.accessory.copyFilesIfNecessary();
            if (this.accessory.isRelative()) {
                return this.accessory.getFiles();
            }
        }
        if (this.isMultiSelectionEnabled()) {
            File[] sels = this.getSelectedFiles();
            String[] toRet = new String[sels.length];
            int index = 0;
            for (File fil : sels) {
                toRet[index] = fil.getAbsolutePath();
                ++index;
            }
            return toRet;
        }
        if (this.getSelectedFile() != null) {
            return new String[]{this.getSelectedFile().getAbsolutePath()};
        }
        return new String[0];
    }

    public String[] getSelectedPathVariables() {
        if (this.accessory != null && this.accessory.isVariableBased()) {
            return this.accessory.getVariableBasedFiles();
        }
        return null;
    }

    @Override
    public void approveSelection() {
        if (this.accessory != null && !this.accessory.canApprove()) {
            return;
        }
        super.approveSelection();
    }
}

