/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.utilities;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.utilities.Bundle;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExClipboard;

public final class CopyPathToClipboardAction
implements ActionListener,
ClipboardOwner {
    private final List<Lookup.Provider> context;

    public CopyPathToClipboardAction(List<Lookup.Provider> context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String pathListString;
        TreeSet<String> paths = new TreeSet<String>();
        paths.addAll(this.getSelectedPathsForDataObjects());
        paths.addAll(this.getSelectedPathsForProjects());
        StringBuilder sb = new StringBuilder();
        int items = 0;
        for (String path : paths) {
            if (items > 0) {
                sb.append(" ");
            }
            sb.append(this.quoteIfNeeded(path));
            ++items;
        }
        if (items > 0 && !(pathListString = sb.toString()).isEmpty()) {
            this.setClipboardContents(pathListString, items);
        }
    }

    Collection<String> getSelectedPathsForDataObjects() {
        TreeSet<String> paths = new TreeSet<String>();
        for (Lookup.Provider lookupProvider : this.context) {
            if (!(lookupProvider instanceof DataObject)) continue;
            paths.add(this.getAbsolutePath((DataObject)lookupProvider));
        }
        return paths;
    }

    private String quoteIfNeeded(String s) {
        if (s.contains(" ")) {
            return "\"" + s + "\"";
        }
        return s;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public String getAbsolutePath(DataObject dataObject) {
        String fileName = null;
        if (null != dataObject) {
            FileObject primaryFile = this.getFileObjectWithShadowSupport(dataObject);
            fileName = this.getNativePath(primaryFile);
            if (null != FileUtil.getArchiveFile((FileObject)primaryFile)) {
                String fullJARPath = this.getNativePath(FileUtil.getArchiveFile((FileObject)primaryFile));
                String archiveFileName = primaryFile.getPath();
                fileName = !archiveFileName.isEmpty() ? fullJARPath + File.pathSeparator + archiveFileName : fullJARPath;
            }
        }
        return fileName;
    }

    private String getNativePath(FileObject fo) {
        File f = FileUtil.toFile((FileObject)fo);
        return f != null ? f.getAbsolutePath() : fo.getPath();
    }

    private FileObject getFileObjectWithShadowSupport(DataObject dataObject) {
        if (dataObject instanceof DataShadow) {
            DataShadow dataShadow = (DataShadow)dataObject;
            return dataShadow.getOriginal().getPrimaryFile();
        }
        return dataObject.getPrimaryFile();
    }

    private String getProjectDirectory(Project project) {
        try {
            FileObject projectDirectory = project.getProjectDirectory();
            return this.getNativePath(projectDirectory);
        }
        catch (Exception e) {
            Logger.getLogger(CopyPathToClipboardAction.class.getName()).log(Level.FINE, null, e);
            return null;
        }
    }

    Collection<String> getSelectedPathsForProjects() {
        TreeSet<String> paths = new TreeSet<String>();
        for (Lookup.Provider object : this.context) {
            String projectDir;
            if (!(object instanceof Project) || null == (projectDir = this.getProjectDirectory((Project)object))) continue;
            paths.add(projectDir);
        }
        return paths;
    }

    private void setClipboardContents(String content, int items) {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(ExClipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        if (clipboard != null) {
            String statusText = items > 1 ? Bundle.CTL_Status_CopyToClipboardMulti(items) : Bundle.CTL_Status_CopyToClipboardSingle(content);
            StatusDisplayer.getDefault().setStatusText(statusText);
            clipboard.setContents(new StringSelection(content), null);
        }
    }
}

