/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.projectui.wizard.cnd;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.actions.CMakeAction;
import org.netbeans.modules.cnd.actions.MakeAction;
import org.netbeans.modules.cnd.actions.QMakeAction;
import org.netbeans.modules.cnd.actions.ShellRunAction;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.builds.CMakeExecSupport;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.builds.MakeExecSupport;
import org.netbeans.modules.cnd.builds.QMakeExecSupport;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.wizard.api.support.DiscoveryProjectGenerator;
import org.netbeans.modules.cnd.execution.ExecutionSupport;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.remote.projectui.wizard.cnd.CreateProjectFromBinary;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class ImportRemoteProject
implements PropertyChangeListener {
    private static final boolean TRACE = Boolean.getBoolean("cnd.discovery.trace.projectimport");
    public static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.discovery.projectimport.ImportProject");
    private static final RequestProcessor RP;
    private final String nativeProjectPath;
    private final FileObject nativeProjectFO;
    private final FSPath projectFolder;
    private String projectName;
    private String makefilePath;
    private String configurePath;
    private String configureRunFolder;
    private String configureArguments;
    private boolean runConfigure = false;
    private boolean manualCA = false;
    private boolean buildArifactWasAnalyzed = false;
    private final String hostUID;
    private final ExecutionEnvironment executionEnvironment;
    private final ExecutionEnvironment fileSystemExecutionEnvironment;
    private final MakeProjectOptions.PathMode pathMode;
    private CompilerSet toolchain;
    private boolean defaultToolchain;
    private String workingDir;
    private String buildCommand = "${MAKE} -f Makefile";
    private String cleanCommand = "${MAKE} -f Makefile clean";
    private String buildResult = "";
    private Project makeProject;
    private boolean runMake;
    private String includeDirectories = "";
    private String macros = "";
    private Iterator<SourceFolderInfo> sources;
    private Iterator<SourceFolderInfo> tests;
    private String sourceFoldersFilter = null;
    private FileObject configureFileObject;
    private Map<Step, State> importResult = new EnumMap<Step, State>(Step.class);
    private static final String CND_TOOLS = "__CND_TOOLS__";
    private static final String CND_TOOLS_VALUE;
    private static final String CND_BUILD_LOG = "__CND_BUILD_LOG__";
    private boolean useBuildTrace = true;
    private boolean isFinished = false;
    private boolean isUILessMode = false;
    private File configureLog = null;
    private File makeLog = null;
    private File execLog = null;
    private String remoteExecLog = null;
    private String remoteMakeLog = null;
    private static final Map<CsmProject, CsmProgressListener> listeners;

    public ImportRemoteProject(WizardDescriptor wizard) {
        this.pathMode = MakeProjectOptions.getPathMode();
        this.projectFolder = (FSPath)wizard.getProperty("projdir");
        this.nativeProjectPath = (String)wizard.getProperty("nativeProjDir");
        this.nativeProjectFO = (FileObject)wizard.getProperty("nativeProjFO");
        if (Boolean.TRUE.equals(wizard.getProperty("simpleMode"))) {
            this.simpleSetup(wizard);
        } else {
            this.customSetup(wizard);
        }
        this.hostUID = (String)wizard.getProperty("hostUID");
        this.executionEnvironment = this.hostUID == null ? ServerList.getDefaultRecord().getExecutionEnvironment() : ExecutionEnvironmentFactory.fromUniqueID((String)this.hostUID);
        this.fileSystemExecutionEnvironment = this.executionEnvironment;
        assert (this.nativeProjectPath != null);
        Preferences makeProjectPref = NbPreferences.root().node("/org/netbeans/modules/cnd/makeproject");
        if (makeProjectPref != null) {
            this.useBuildTrace = makeProjectPref.getBoolean("useBuildTrace", true);
        }
    }

    private void simpleSetup(WizardDescriptor wizard) {
        this.projectName = CndPathUtilitities.getBaseName((String)this.projectFolder.getPath());
        this.workingDir = this.nativeProjectPath;
        this.configurePath = (String)wizard.getProperty("configureName");
        if (this.configurePath != null) {
            this.configureArguments = (String)wizard.getProperty("realFlags");
            this.runConfigure = true;
            this.makefilePath = (String)wizard.getProperty("makefileName");
            if (this.makefilePath == null) {
                this.makefilePath = this.nativeProjectPath + "/Makefile";
            }
            this.configureRunFolder = (String)wizard.getProperty("configureRunFolder");
        } else {
            this.makefilePath = (String)wizard.getProperty("makefileName");
        }
        this.runMake = Boolean.TRUE.equals(wizard.getProperty("buildProject"));
        this.toolchain = (CompilerSet)wizard.getProperty("toolchain");
        this.defaultToolchain = Boolean.TRUE.equals(wizard.getProperty("toolchainDefault"));
        ArrayList<1> list = new ArrayList<1>();
        list.add(new SourceFolderInfo(){

            public FileObject getFileObject() {
                return ImportRemoteProject.this.nativeProjectFO;
            }

            public String getFolderName() {
                return ImportRemoteProject.this.nativeProjectFO.getNameExt();
            }

            public boolean isAddSubfoldersSelected() {
                return true;
            }
        });
        this.sources = list.iterator();
        this.sourceFoldersFilter = "^(nbproject)$";
    }

    private void customSetup(WizardDescriptor wizard) {
        Iterator it2;
        Iterator it;
        this.projectName = (String)wizard.getProperty("name");
        this.workingDir = (String)wizard.getProperty("buildCommandWorkingDirTextField");
        this.buildCommand = (String)wizard.getProperty("buildCommandTextField");
        this.cleanCommand = (String)wizard.getProperty("cleanCommandTextField");
        this.buildResult = (String)wizard.getProperty("outputTextField");
        this.includeDirectories = (String)wizard.getProperty("includeTextField");
        this.macros = (String)wizard.getProperty("macroTextField");
        this.makefilePath = (String)wizard.getProperty("makefileName");
        this.configurePath = (String)wizard.getProperty("configureName");
        this.configureRunFolder = (String)wizard.getProperty("configureRunFolder");
        this.configureArguments = (String)wizard.getProperty("configureArguments");
        this.runConfigure = "true".equals(wizard.getProperty("runConfigure"));
        this.sources = it = (Iterator)wizard.getProperty("sourceFolders");
        this.tests = it2 = (Iterator)wizard.getProperty("testFolders");
        this.sourceFoldersFilter = (String)wizard.getProperty("sourceFoldersFilter");
        this.runConfigure = "true".equals(wizard.getProperty("runConfigure"));
        this.runMake = this.runConfigure ? true : "true".equals(wizard.getProperty("makeProject"));
        this.manualCA = "true".equals(wizard.getProperty("manualCA"));
        this.toolchain = (CompilerSet)wizard.getProperty("toolchain");
        this.defaultToolchain = Boolean.TRUE.equals(wizard.getProperty("toolchainDefault"));
    }

    public Set<FileObject> create() throws IOException {
        Iterator importantItemsIterator;
        StringTokenizer tokenizer;
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        String aHostUID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        MakeConfiguration extConf = new MakeConfiguration(this.projectFolder.getPath(), "Default", 0, aHostUID, this.toolchain, this.defaultToolchain);
        int platform = CompilerSetManager.get((ExecutionEnvironment)this.executionEnvironment).getPlatform();
        extConf.getDevelopmentHost().setBuildPlatform(platform);
        String workingDirRel = ProjectSupport.toProperPath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.workingDir), (MakeProjectOptions.PathMode)this.pathMode);
        workingDirRel = CndPathUtilitities.normalizeSlashes((String)workingDirRel);
        extConf.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(workingDirRel);
        extConf.getMakefileConfiguration().getBuildCommand().setValue(this.buildCommand);
        extConf.getMakefileConfiguration().getCleanCommand().setValue(this.cleanCommand);
        if (this.buildResult != null && this.buildResult.length() > 0) {
            this.buildResult = ProjectSupport.toProperPath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.buildResult), (MakeProjectOptions.PathMode)this.pathMode);
            this.buildResult = CndPathUtilitities.normalizeSlashes((String)this.buildResult);
            extConf.getMakefileConfiguration().getOutput().setValue(this.buildResult);
        }
        extConf.getProfile().setRunDirectory(workingDirRel);
        if (this.includeDirectories != null && this.includeDirectories.length() > 0) {
            tokenizer = new StringTokenizer(this.includeDirectories, ";");
            ArrayList<String> includeDirectoriesVector = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String includeDirectory = tokenizer.nextToken();
                includeDirectory = CndPathUtilitities.toRelativePath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)includeDirectory));
                includeDirectory = CndPathUtilitities.normalizeSlashes((String)includeDirectory);
                includeDirectoriesVector.add(includeDirectory);
            }
            extConf.getCCompilerConfiguration().getIncludeDirectories().setValue(includeDirectoriesVector);
            extConf.getCCCompilerConfiguration().getIncludeDirectories().setValue(new ArrayList(includeDirectoriesVector));
        }
        if (this.macros != null && this.macros.length() > 0) {
            tokenizer = new StringTokenizer(this.macros, "; ");
            ArrayList<String> list = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
            extConf.getCCompilerConfiguration().getPreprocessorConfiguration().getValue().addAll(list);
            extConf.getCCCompilerConfiguration().getPreprocessorConfiguration().getValue().addAll(list);
        }
        ArrayList<String> importantItems = new ArrayList<String>();
        if (this.makefilePath != null && this.makefilePath.length() > 0) {
            this.makefilePath = ProjectSupport.toProperPath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.makefilePath), (MakeProjectOptions.PathMode)this.pathMode);
            this.makefilePath = CndPathUtilitities.normalizeSlashes((String)this.makefilePath);
        }
        if (this.configurePath != null && this.configurePath.length() > 0) {
            String normPath = RemoteFileUtil.normalizeAbsolutePath((String)this.configurePath, (ExecutionEnvironment)this.fileSystemExecutionEnvironment);
            this.configureFileObject = RemoteFileUtil.getFileObject((String)normPath, (ExecutionEnvironment)this.fileSystemExecutionEnvironment);
            this.configurePath = ProjectSupport.toProperPath((String)this.projectFolder.getPath(), (String)CndPathUtilitities.naturalizeSlashes((String)this.configurePath), (MakeProjectOptions.PathMode)this.pathMode);
            this.configurePath = CndPathUtilitities.normalizeSlashes((String)this.configurePath);
            importantItems.add(this.configurePath);
        }
        if (!(importantItemsIterator = importantItems.iterator()).hasNext()) {
            importantItemsIterator = null;
        }
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(this.projectName, this.projectFolder);
        prjParams.setConfiguration(extConf).setSourceFolders(this.sources).setSourceFoldersFilter(this.sourceFoldersFilter).setTestFolders(this.tests).setImportantFiles(importantItemsIterator).setFullRemoteNativeProjectPath(this.nativeProjectPath).setHostUID(aHostUID);
        if (this.makefilePath != null) {
            prjParams.setMakefileName(this.makefilePath);
        } else {
            prjParams.setMakefileName("");
        }
        this.makeProject = ProjectGenerator.createProject((ProjectGenerator.ProjectParameters)prjParams);
        FileObject dir = this.projectFolder.getFileObject();
        this.importResult.put(Step.Project, State.Successful);
        this.switchModel(false);
        resultSet.add(dir);
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        return resultSet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("openProjects") && evt.getNewValue() instanceof Project[]) {
            Project[] projects = (Project[])evt.getNewValue();
            if (projects.length == 0) {
                return;
            }
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ImportRemoteProject.this.doWork();
                }
            });
        }
    }

    boolean isProjectOpened() {
        for (Project p : OpenProjects.getDefault().getOpenProjects()) {
            if (p != this.makeProject) continue;
            return true;
        }
        return false;
    }

    private void doWork() {
        try {
            if (this.makeProject instanceof Runnable) {
                ((Runnable)this.makeProject).run();
            }
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
            pdp.getConfigurationDescriptor();
            if (pdp.gotDescriptor()) {
                if (pdp.getConfigurationDescriptor().getActiveConfiguration() != null) {
                    if (this.runConfigure && this.configurePath != null && this.configurePath.length() > 0 && this.configureFileObject != null && this.configureFileObject.isValid()) {
                        this.postConfigure();
                    } else if (this.runMake) {
                        this.makeProject(true, null);
                    } else {
                        this.discovery(0, null, null);
                    }
                } else {
                    this.isFinished = true;
                }
            } else {
                this.isFinished = true;
            }
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static File createTempFile(String prefix) {
        try {
            File file = File.createTempFile(prefix, ".log");
            file.deleteOnExit();
            return file;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void postConfigure() {
        try {
            Future task;
            String mime;
            Node node;
            BufferedWriter outputListener;
            block38: {
                if (!this.isProjectOpened()) {
                    this.isFinished = true;
                    return;
                }
                if (this.configureLog == null) {
                    this.configureLog = ImportRemoteProject.createTempFile("configure");
                }
                outputListener = null;
                try {
                    outputListener = new BufferedWriter(new FileWriter(this.configureLog));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                DataObject dObj = DataObject.find((FileObject)this.configureFileObject);
                node = dObj.getNodeDelegate();
                mime = FileUtil.getMIMEType((FileObject)this.configureFileObject);
                if (this.configureArguments != null) {
                    List vars;
                    ShellExecSupport ses;
                    if ("text/sh".equals(mime)) {
                        ses = (ShellExecSupport)node.getLookup().lookup(ShellExecSupport.class);
                        try {
                            ses.setArguments(new String[]{this.configureArguments});
                            vars = ImportUtils.parseEnvironment((String)this.configureArguments);
                            ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                            if (this.configureRunFolder != null) {
                                FileObject createdFolder = this.mkDir(this.configureFileObject.getParent(), this.configureRunFolder);
                                if (createdFolder != null) {
                                    ses.setRunDirectory(createdFolder.getPath());
                                }
                                break block38;
                            }
                            ses.setRunDirectory(this.configureFileObject.getParent().getPath());
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    } else if ("text/x-cmake".equals(mime)) {
                        ses = (CMakeExecSupport)node.getLookup().lookup(CMakeExecSupport.class);
                        try {
                            vars = ImportUtils.parseEnvironment((String)this.configureArguments);
                            for (String s : ImportUtils.quoteList((List)vars)) {
                                int i = this.configureArguments.indexOf(s);
                                if (i < 0) continue;
                                this.configureArguments = this.configureArguments.substring(0, i) + this.configureArguments.substring(i + s.length());
                            }
                            ses.setArguments(new String[]{this.configureArguments});
                            ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                            if (this.configureRunFolder != null) {
                                FileObject createdFolder = this.mkDir(this.configureFileObject.getParent(), this.configureRunFolder);
                                if (createdFolder != null) {
                                    ses.setRunDirectory(createdFolder.getPath());
                                }
                                break block38;
                            }
                            ses.setRunDirectory(this.configureFileObject.getParent().getPath());
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    } else if ("text/x-qtproject".equals(mime)) {
                        ses = (QMakeExecSupport)node.getLookup().lookup(QMakeExecSupport.class);
                        try {
                            ses.setArguments(new String[]{this.configureArguments});
                            if (this.configureRunFolder != null) {
                                FileObject createdFolder = this.mkDir(this.configureFileObject.getParent(), this.configureRunFolder);
                                if (createdFolder != null) {
                                    ses.setRunDirectory(createdFolder.getPath());
                                }
                            } else {
                                ses.setRunDirectory(this.configureFileObject.getParent().getPath());
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
            ExecutionListener listener = new ExecutionListener(){

                public void executionStarted(int pid) {
                }

                public void executionFinished(int rc) {
                    if (rc == 0) {
                        ImportRemoteProject.this.importResult.put(Step.Configure, State.Successful);
                    } else {
                        ImportRemoteProject.this.importResult.put(Step.Configure, State.Fail);
                    }
                    if (ImportRemoteProject.this.runMake && rc == 0) {
                        ImportRemoteProject.this.makeProject(true, ImportRemoteProject.this.configureLog);
                    } else {
                        ImportRemoteProject.this.switchModel(true);
                    }
                }
            };
            if (TRACE) {
                logger.log(Level.INFO, "#{0} {1}", new Object[]{this.configureFileObject, this.configureArguments});
            }
            if ("text/sh".equals(mime)) {
                task = ShellRunAction.performAction((Node)node, (ExecutionListener)listener, (Writer)outputListener, (Project)this.makeProject, null);
                if (task == null) {
                    throw new Exception("Cannot execute configure script");
                }
            } else if ("text/x-cmake".equals(mime)) {
                task = CMakeAction.performAction((Node)node, (ExecutionListener)listener, null, (Project)this.makeProject, null);
                if (task == null) {
                    throw new Exception("Cannot execute cmake");
                }
            } else if ("text/x-qtproject".equals(mime)) {
                task = QMakeAction.performAction((Node)node, (ExecutionListener)listener, null, (Project)this.makeProject, null);
                if (task == null) {
                    throw new Exception("Cannot execute qmake");
                }
            } else {
                if (TRACE) {
                    logger.log(Level.INFO, "#Configure script does not supported");
                }
                this.importResult.put(Step.Configure, State.Fail);
                this.importResult.put(Step.MakeClean, State.Skiped);
                this.switchModel(true);
            }
        }
        catch (DataObjectNotFoundException e) {
            logger.log(Level.INFO, "Cannot configure project", e);
            this.isFinished = true;
        }
        catch (Throwable e) {
            logger.log(Level.INFO, "Cannot configure project", e);
            this.isFinished = true;
        }
    }

    private FileObject mkDir(FileObject parent, String relative) {
        if (relative != null) {
            try {
                relative = relative.replace('\\', '/');
                for (String segment : relative.split("/")) {
                    FileObject test;
                    if (parent == null) {
                        return null;
                    }
                    if (segment.isEmpty() || ".".equals(segment)) continue;
                    parent = "..".equals(segment) ? parent.getParent() : ((test = parent.getFileObject(segment, null)) != null ? test : parent.createFolder(segment));
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            return parent;
        }
        return null;
    }

    private void makeProject(boolean doClean, File logFile) {
        block11: {
            if (!this.isProjectOpened()) {
                this.isFinished = true;
                return;
            }
            FileObject makeFileObject = null;
            if (this.makefilePath != null && this.makefilePath.length() > 0) {
                this.nativeProjectFO.refresh();
                makeFileObject = CndFileUtils.toFileObject((FileSystem)this.projectFolder.getFileSystem(), (CharSequence)CndPathUtilitities.toAbsolutePath((FileObject)this.projectFolder.getFileObject(), (String)this.makefilePath));
            }
            if (makeFileObject != null && makeFileObject.isValid()) {
                try {
                    DataObject dObj = DataObject.find(makeFileObject);
                    Node node = dObj.getNodeDelegate();
                    MakeExecSupport mes = (MakeExecSupport)node.getLookup().lookup(MakeExecSupport.class);
                    if (mes != null) {
                        mes.setBuildDirectory(makeFileObject.getParent().getPath());
                    }
                    if (doClean) {
                        this.postClean(node);
                        break block11;
                    }
                    this.postMake(node);
                }
                catch (DataObjectNotFoundException ex) {
                    this.isFinished = true;
                }
            } else {
                String path = this.nativeProjectPath;
                File file = new File(path + "/Makefile");
                if (file.exists() && file.isFile() && file.canRead()) {
                    this.makefilePath = file.getAbsolutePath();
                } else {
                    file = new File(path + "/makefile");
                    if (file.exists() && file.isFile() && file.canRead()) {
                        this.makefilePath = file.getAbsolutePath();
                    }
                }
                this.switchModel(true);
            }
        }
    }

    private void postClean(final Node node) {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        ExecutionListener listener = new ExecutionListener(){

            public void executionStarted(int pid) {
            }

            public void executionFinished(int rc) {
                if (rc == 0) {
                    ImportRemoteProject.this.importResult.put(Step.MakeClean, State.Successful);
                } else {
                    ImportRemoteProject.this.importResult.put(Step.MakeClean, State.Fail);
                }
                ImportRemoteProject.this.postMake(node);
            }
        };
        String arguments = "";
        if (this.cleanCommand != null) {
            arguments = this.getArguments(this.cleanCommand);
        }
        if (arguments.length() == 0) {
            arguments = "clean";
        }
        if (TRACE) {
            logger.log(Level.INFO, "#make {0}", arguments);
        }
        try {
            Future task = MakeAction.execute((Node)node, (String)arguments, (ExecutionListener)listener, null, (Project)this.makeProject, null, null);
            if (task == null) {
                logger.log(Level.INFO, "Cannot execute make clean");
                this.isFinished = true;
            }
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void postMake(Node node) {
        HostInfo hostInfo;
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        if (this.makeLog == null) {
            this.makeLog = ImportRemoteProject.createTempFile("make");
            try {
                hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment);
                switch (hostInfo.getOSFamily()) {
                    case SUNOS: 
                    case LINUX: {
                        if (!this.fileSystemExecutionEnvironment.isRemote()) break;
                        this.remoteMakeLog = hostInfo.getTempDir() + "/" + this.makeLog.getName();
                    }
                }
            }
            catch (IOException ex) {
            }
            catch (ConnectionManager.CancellationException ex) {
                // empty catch block
            }
        }
        if (this.useBuildTrace) {
            try {
                hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment);
                switch (hostInfo.getOSFamily()) {
                    case SUNOS: 
                    case LINUX: {
                        this.execLog = ImportRemoteProject.createTempFile("exec");
                        this.execLog.deleteOnExit();
                        if (!this.executionEnvironment.isRemote()) break;
                        this.remoteExecLog = hostInfo.getTempDir() + "/" + this.execLog.getName();
                    }
                }
            }
            catch (IOException ex) {
            }
            catch (ConnectionManager.CancellationException ex) {
                // empty catch block
            }
        }
        ExecutionListener listener = new ExecutionListener(){

            public void executionStarted(int pid) {
            }

            public void executionFinished(int rc) {
                Future task;
                if (rc == 0) {
                    ImportRemoteProject.this.importResult.put(Step.Make, State.Successful);
                } else {
                    ImportRemoteProject.this.importResult.put(Step.Make, State.Fail);
                }
                if (ImportRemoteProject.this.executionEnvironment.isRemote() && ImportRemoteProject.this.execLog != null) {
                    try {
                        if (HostInfoUtils.fileExists((ExecutionEnvironment)ImportRemoteProject.this.executionEnvironment, (String)ImportRemoteProject.this.remoteExecLog)) {
                            task = CommonTasksSupport.downloadFile((String)ImportRemoteProject.this.remoteExecLog, (ExecutionEnvironment)ImportRemoteProject.this.executionEnvironment, (String)ImportRemoteProject.this.execLog.getAbsolutePath(), null);
                            if (TRACE) {
                                logger.log(Level.INFO, "#download file {0}", ImportRemoteProject.this.execLog.getAbsolutePath());
                            }
                            task.get();
                        }
                    }
                    catch (Throwable ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        ImportRemoteProject.this.execLog = null;
                    }
                }
                if (ImportRemoteProject.this.fileSystemExecutionEnvironment.isRemote() && ImportRemoteProject.this.remoteMakeLog != null) {
                    try {
                        task = CommonTasksSupport.uploadFile((File)ImportRemoteProject.this.makeLog, (ExecutionEnvironment)ImportRemoteProject.this.fileSystemExecutionEnvironment, (String)ImportRemoteProject.this.remoteMakeLog, (int)365);
                        if (TRACE) {
                            logger.log(Level.INFO, "#upload file {0}", ImportRemoteProject.this.remoteMakeLog);
                        }
                        task.get();
                    }
                    catch (Throwable ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        ImportRemoteProject.this.execLog = null;
                    }
                }
                ImportRemoteProject.this.discovery(rc, ImportRemoteProject.this.remoteMakeLog, ImportRemoteProject.this.execLog);
            }
        };
        BufferedWriter outputListener = null;
        if (this.makeLog != null) {
            try {
                outputListener = new BufferedWriter(new FileWriter(this.makeLog));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        String arguments = "";
        if (this.buildCommand != null) {
            arguments = this.getArguments(this.buildCommand);
        }
        ExecutionSupport ses = (ExecutionSupport)node.getLookup().lookup(ExecutionSupport.class);
        List vars = ImportUtils.parseEnvironment((String)this.configureArguments);
        if (ses != null) {
            try {
                ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                if (this.execLog != null) {
                    vars.add("__CND_TOOLS__=" + CND_TOOLS_VALUE);
                    if (this.executionEnvironment.isLocal()) {
                        vars.add("__CND_BUILD_LOG__=" + this.execLog.getAbsolutePath());
                    } else {
                        vars.add("__CND_BUILD_LOG__=" + this.remoteExecLog);
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (TRACE) {
            logger.log(Level.INFO, "#make {0}", arguments);
        }
        try {
            Future task = MakeAction.execute((Node)node, (String)arguments, (ExecutionListener)listener, (Writer)outputListener, (Project)this.makeProject, (List)vars, null);
            if (task == null) {
                logger.log(Level.INFO, "Cannot execute make");
                this.isFinished = true;
            }
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private String getArguments(String command) {
        String arguments = this._getArguments(command);
        int i = arguments.indexOf("-f ");
        if (i >= 0) {
            String res = arguments.substring(0, i);
            int j = (arguments = arguments.substring(i + 3).trim()).indexOf(32);
            if (j < 0) {
                return res;
            }
            return res + arguments.substring(j).trim();
        }
        return arguments;
    }

    private String _getArguments(String command) {
        if (command.startsWith("\"")) {
            int i = command.indexOf(34, 1);
            if (i > 0) {
                return command.substring(i).trim();
            }
            return "";
        }
        if (command.startsWith("'")) {
            int i = command.indexOf(39, 1);
            if (i > 0) {
                return command.substring(i).trim();
            }
            return "";
        }
        int i = command.indexOf(32);
        if (i > 0) {
            return command.substring(i).trim();
        }
        return "";
    }

    private void waitConfigurationDescriptor() {
        ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        provider.getConfigurationDescriptor(true);
    }

    private void discovery(int rc, String makeLog, File execLog) {
        try {
            String ROOT_FOLDER = "DW:rootFolder";
            String EXEC_LOG_FILE = "DW:execLogFile";
            String CONSOLIDATION_STRATEGY = "DW:consolidationLevel";
            if (!this.isProjectOpened()) {
                this.isFinished = true;
                return;
            }
            this.waitConfigurationDescriptor();
            boolean done = false;
            boolean exeLogDone = false;
            if (!this.manualCA) {
                DiscoveryExtensionInterface extension = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class);
                if (rc == 0) {
                    if (execLog != null && extension != null) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(ROOT_FOLDER, this.nativeProjectPath);
                        map.put(EXEC_LOG_FILE, execLog.getAbsolutePath());
                        map.put(CONSOLIDATION_STRATEGY, "file");
                        if (extension.canApply(map, this.makeProject)) {
                            if (TRACE) {
                                logger.log(Level.INFO, "#start discovery by exec log file {0}", execLog.getAbsolutePath());
                            }
                            try {
                                done = true;
                                exeLogDone = true;
                                extension.apply(map, this.makeProject);
                                this.importResult.put(Step.DiscoveryLog, State.Successful);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace(System.err);
                            }
                        } else if (TRACE) {
                            logger.log(Level.INFO, "#discovery cannot be done by exec log file {0}", execLog.getAbsolutePath());
                        }
                        map.put(EXEC_LOG_FILE, null);
                    }
                    if (extension != null && !done) {
                        if (TRACE) {
                            logger.log(Level.INFO, "#start remote discovery by log file {0}", makeLog);
                        }
                        this.updateRemoteProjectImpl(makeLog);
                        this.buildArifactWasAnalyzed = true;
                    }
                }
            }
            this.switchModel(true);
            this.postModelDiscovery();
        }
        catch (Throwable ex) {
            this.isFinished = true;
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRemoteProjectImpl(String makeLog) {
        ProgressHandle createHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CreateProjectFromBinary.class, (String)"CONFIGURING_PROJECT_CREATOR", (Object)this.executionEnvironment.getDisplayName()));
        createHandle.start();
        try {
            Type genericSuperclass1;
            FileObject projectCreator = this.findProjectCreator();
            if (projectCreator == null) {
                if (TRACE) {
                    logger.log(Level.INFO, NbBundle.getMessage(CreateProjectFromBinary.class, (String)"ERROR_FIND_PROJECT_CREATOR", (Object)this.executionEnvironment.getDisplayName()));
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE) {
                logger.log(Level.INFO, "#{0} --netbeans-project={1} --project-reconfigure build-log={2}", new Object[]{projectCreator.getPath(), this.projectFolder.getPath(), makeLog});
            }
            DiscoveryProjectGenerator.saveMakeConfigurationDescriptor((Project)this.makeProject, null);
            FileObject conf1 = this.projectFolder.getFileObject().getFileObject("nbproject/configurations.xml");
            ProcessUtils.ExitStatus execute = ProcessUtils.execute((ExecutionEnvironment)this.executionEnvironment, (String)projectCreator.getPath(), (String[])new String[]{"--netbeans-project=" + this.projectFolder.getPath(), "--project-reconfigure", "build-log=" + makeLog});
            if (TRACE) {
                logger.log(Level.INFO, "#exitCode={0}", execute.exitCode);
                logger.log(Level.INFO, execute.error);
                logger.log(Level.INFO, execute.output);
            }
            if (!execute.isOK()) {
                String java = null;
                try {
                    java = (String)HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment).getEnvironment().get("JDK_HOME");
                    if (java == null || java.isEmpty()) {
                        java = (String)HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment).getEnvironment().get("JAVA_HOME");
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ConnectionManager.CancellationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (java != null) {
                    execute = ProcessUtils.execute((ExecutionEnvironment)this.executionEnvironment, (String)projectCreator.getPath(), (String[])new String[]{"--netbeans-project=" + this.projectFolder.getPath(), "--project-reconfigure", "build-log=" + makeLog});
                }
                if (!execute.isOK()) {
                    if (TRACE) {
                        logger.log(Level.INFO, NbBundle.getMessage(CreateProjectFromBinary.class, (String)"ERROR_RUN_PROJECT_CREATOR", (Object)this.executionEnvironment.getDisplayName()));
                    }
                    boolean ex = false;
                    return ex;
                }
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.makeProject.getProjectDirectory().refresh(true);
            Type genericSuperclass = conf1.getClass().getGenericSuperclass();
            if (genericSuperclass instanceof Class && (genericSuperclass1 = ((Class)genericSuperclass).getGenericSuperclass()) instanceof Class) {
                Method[] declaredMethods;
                for (Method method : declaredMethods = ((Class)genericSuperclass1).getDeclaredMethods()) {
                    String name = method.getName();
                    if (!"getListeners".equals(name)) continue;
                    try {
                        method.setAccessible(true);
                        Object invoke = method.invoke((Object)conf1, new Object[0]);
                        if (invoke == null) break;
                        Enumeration aListeners = (Enumeration)invoke;
                        while (aListeners.hasMoreElements()) {
                            FileChangeListener nextElement = (FileChangeListener)aListeners.nextElement();
                            nextElement.fileChanged(new FileEvent(conf1));
                        }
                        break;
                    }
                    catch (IllegalAccessException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        break;
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        break;
                    }
                    catch (InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        break;
                    }
                }
            }
            this.waitConfigurationDescriptor();
            boolean bl = true;
            return bl;
        }
        finally {
            createHandle.finish();
        }
    }

    private FileObject findProjectCreator() {
        FileSystem fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)this.fileSystemExecutionEnvironment);
        for (CompilerSet set : CompilerSetManager.get((ExecutionEnvironment)this.fileSystemExecutionEnvironment).getCompilerSets()) {
            String directory;
            FileObject projectCreator;
            if (!set.getCompilerFlavor().isSunStudioCompiler() || (projectCreator = fileSystem.findResource((directory = set.getDirectory()) + "/../lib/ide_project/bin/ide_project")) == null || !projectCreator.isValid()) continue;
            return projectCreator;
        }
        return null;
    }

    private void postModelDiscovery() {
        if (!this.isProjectOpened()) {
            this.isFinished = true;
            return;
        }
        CsmModel model = CsmModelAccessor.getModel();
        if (model instanceof ModelImpl && this.makeProject != null) {
            NativeProject np = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class);
            final CsmProject p = model.getProject((Object)np);
            if (p == null) {
                if (TRACE) {
                    logger.log(Level.INFO, "#discovery cannot be done by model");
                }
                this.isFinished = true;
                return;
            }
            CsmProgressAdapter listener = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject project) {
                    if (project.equals(p)) {
                        try {
                            listeners.remove(p);
                            CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                            if (TRACE) {
                                logger.log(Level.INFO, "#model ready, explore model");
                            }
                            DiscoveryProjectGenerator.fixExcludedHeaderFiles((Project)ImportRemoteProject.this.makeProject, (Logger)logger);
                        }
                        catch (Throwable ex) {
                            ImportRemoteProject.this.isFinished = true;
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            };
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
            listeners.put(p, (CsmProgressListener)listener);
        } else {
            this.isFinished = true;
        }
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public Map<Step, State> getState() {
        return new EnumMap<Step, State>(this.importResult);
    }

    public Project getProject() {
        return this.makeProject;
    }

    public void setUILessMode() {
        this.isUILessMode = true;
    }

    public void setConfigureLog(File configureLog) {
        this.configureLog = configureLog;
    }

    public void setMakeLog(File makeLog) {
        this.makeLog = makeLog;
    }

    Project getMakeProject() {
        return this.makeProject;
    }

    Map<Step, State> getImportResult() {
        return this.importResult;
    }

    private void switchModel(boolean state) {
        CsmModel model = CsmModelAccessor.getModel();
        if (model instanceof ModelImpl && this.makeProject != null) {
            NativeProject np = (NativeProject)this.makeProject.getLookup().lookup(NativeProject.class);
            if (state) {
                if (TRACE) {
                    logger.log(Level.INFO, "#enable model for {0}", np.getProjectDisplayName());
                }
                ((ModelImpl)model).enableProject(np);
            } else {
                if (TRACE) {
                    logger.log(Level.INFO, "#disable model for {0}", np.getProjectDisplayName());
                }
                ((ModelImpl)model).disableProject(np);
            }
        }
    }

    static {
        if (TRACE) {
            logger.setLevel(Level.ALL);
        }
        RP = new RequestProcessor(ImportRemoteProject.class.getName(), 2);
        CND_TOOLS_VALUE = System.getProperty("cnd.buildtrace.tools", "gcc:c++:g++:gfortran:g77:g90:g95:cc:CC:ffortran:f77:f90:f95");
        listeners = new WeakHashMap<CsmProject, CsmProgressListener>();
    }

    public static enum Step {
        Project,
        Configure,
        MakeClean,
        Make,
        DiscoveryDwarf,
        DiscoveryLog,
        FixMacros,
        DiscoveryModel,
        FixExcluded;

    }

    public static enum State {
        Successful,
        Fail,
        Skiped;

    }
}

