/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.projectui.wizard.cnd;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateProjectFromBinary
implements PropertyChangeListener {
    private static final boolean TRACE_REMOTE_CREATION = Boolean.getBoolean("cnd.discovery.trace.projectimport");
    public static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.makeproject.api.RunDialogPanel");
    private static final RequestProcessor RP;
    private final FileSystem fileSystem;
    private final String projectFolder;
    private final String executablePath;
    private final boolean sourcesUsed;
    private final String libraries;
    private final IteratorExtension.ProjectKind kind;
    private final IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
    private Project lastSelectedProject;

    public CreateProjectFromBinary(FileSystem fileSystem, String projectFolder, String executablePath, boolean sourcesUsed, String libraries, IteratorExtension.ProjectKind kind) {
        this.fileSystem = fileSystem;
        this.projectFolder = projectFolder;
        this.executablePath = executablePath;
        this.sourcesUsed = sourcesUsed;
        this.libraries = libraries;
        this.kind = kind;
    }

    public Project createRemoteProject() {
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)CreateProjectFromBinary.this.fileSystem);
                ProgressHandle createHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CreateProjectFromBinary.class, (String)"RUN_PROJECT_CREATOR", (Object)executionEnvironment.getDisplayName()));
                createHandle.start();
                try {
                    CreateProjectFromBinary.this.createRemoteProjectImpl();
                }
                finally {
                    createHandle.finish();
                }
            }
        });
        return null;
    }

    private Project createRemoteProjectImpl() {
        ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)this.fileSystem);
        FileObject projectFO = null;
        try {
            projectFO = FileUtil.createFolder((FileObject)this.fileSystem.getRoot(), (String)this.projectFolder);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        FileObject projectCreator = this.findProjectCreator();
        if (projectCreator == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CreateProjectFromBinary.class, (String)"ERROR_FIND_PROJECT_CREATOR", (Object)executionEnvironment.getDisplayName()), 0));
            return null;
        }
        String sources = this.sourcesUsed ? "--sources=used" : "--sources=all";
        if (TRACE_REMOTE_CREATION) {
            if (this.libraries == null) {
                logger.log(Level.INFO, "#{0} --netbeans-project={1} --project-create binary={2} " + sources, new Object[]{projectCreator.getPath(), this.projectFolder, this.executablePath});
            } else {
                logger.log(Level.INFO, "#{0} --netbeans-project={1} --project-create binary={2} " + sources + " --additional-libraries=" + this.libraries, new Object[]{projectCreator.getPath(), this.projectFolder, this.executablePath});
            }
        }
        ProcessUtils.ExitStatus execute = this.libraries == null ? ProcessUtils.execute((ExecutionEnvironment)executionEnvironment, (String)projectCreator.getPath(), (String[])new String[]{"--netbeans-project=" + this.projectFolder, "--project-create", "binary=" + this.executablePath, sources}) : ProcessUtils.execute((ExecutionEnvironment)executionEnvironment, (String)projectCreator.getPath(), (String[])new String[]{"--netbeans-project=" + this.projectFolder, "--project-create", "binary=" + this.executablePath, sources, "--additional-libraries=" + this.libraries});
        if (TRACE_REMOTE_CREATION) {
            logger.log(Level.INFO, "#exitCode={0}", execute.exitCode);
            logger.log(Level.INFO, execute.error);
            logger.log(Level.INFO, execute.output);
        }
        if (!execute.isOK()) {
            String java = null;
            try {
                java = (String)HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getEnvironment().get("JDK_HOME");
                if (java == null || java.isEmpty()) {
                    java = (String)HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getEnvironment().get("JAVA_HOME");
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ConnectionManager.CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (java != null) {
                execute = this.libraries == null ? ProcessUtils.execute((ExecutionEnvironment)executionEnvironment, (String)projectCreator.getPath(), (String[])new String[]{"--netbeans-project=" + this.projectFolder, "--project-create", "binary=" + this.executablePath, sources}) : ProcessUtils.execute((ExecutionEnvironment)executionEnvironment, (String)projectCreator.getPath(), (String[])new String[]{"--netbeans-project=" + this.projectFolder, "--project-create", "binary=" + this.executablePath, sources, "--additional-libraries=" + this.libraries});
            }
            if (!execute.isOK()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CreateProjectFromBinary.class, (String)"ERROR_RUN_PROJECT_CREATOR", (Object)executionEnvironment.getDisplayName()), 0));
                return null;
            }
        }
        if (projectFO != null) {
            projectFO.refresh();
        } else {
            String baseDir = this.projectFolder;
            while ((baseDir = PathUtilities.getDirName((String)baseDir)) != null && baseDir.length() > 1) {
                FileObject toRefresh = this.fileSystem.findResource(baseDir);
                if (toRefresh == null) continue;
                toRefresh.refresh();
                break;
            }
            projectFO = this.fileSystem.findResource(this.projectFolder);
        }
        if (projectFO == null) {
            return null;
        }
        Project project = null;
        try {
            project = ProjectManager.getDefault().findProject(projectFO);
            if (project == null) {
                return null;
            }
            this.lastSelectedProject = project;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        OpenProjects.getDefault().open(new Project[]{project}, false);
        OpenProjects.getDefault().setMainProject(project);
        return project;
    }

    private FileObject findProjectCreator() {
        ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileSystem)this.fileSystem);
        for (CompilerSet set : CompilerSetManager.get((ExecutionEnvironment)executionEnvironment).getCompilerSets()) {
            String directory;
            FileObject projectCreator;
            if (!set.getCompilerFlavor().isSunStudioCompiler() || (projectCreator = this.fileSystem.findResource((directory = set.getDirectory()) + "/../lib/ide_project/bin/ide_project")) == null || !projectCreator.isValid()) continue;
            return projectCreator;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("openProjects") && evt.getNewValue() instanceof Project[]) {
            Project[] projects = (Project[])evt.getNewValue();
            if (projects.length == 0) {
                return;
            }
            OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            if (this.lastSelectedProject == null) {
                return;
            }
            this.fillConfiguration();
        }
    }

    private void fillConfiguration() {
        if (this.extension != null) {
            this.extension.discoverHeadersByModel(this.lastSelectedProject);
        }
    }

    static {
        if (TRACE_REMOTE_CREATION) {
            logger.setLevel(Level.ALL);
        }
        RP = new RequestProcessor("Create Remote Project Worker", 1);
    }
}

