/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.projectui.actions;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.remote.actions.base.RemoteActionPerformer;
import org.netbeans.modules.cnd.remote.projectui.wizard.ide.NewProjectWizard;
import org.netbeans.modules.cnd.remote.projectui.wizard.ide.OpenProjectList;
import org.netbeans.modules.cnd.remote.projectui.wizard.ide.OpenProjectListSettings;
import org.netbeans.modules.cnd.remote.projectui.wizard.ide.ProjectUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class NewRemoteProjectPerformer
extends RemoteActionPerformer {
    private final RequestProcessor.Task bodyTask = new RequestProcessor("NewProjectBody").create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                NewRemoteProjectPerformer.this.doPerform();
            }
            finally {
                NewRemoteProjectPerformer.this.running = false;
            }
        }
    });
    private volatile boolean running = false;
    private ExecutionEnvironment env;

    protected void actionPerformedRemote(ExecutionEnvironment anEnv) {
        if (anEnv.isLocal()) {
            return;
        }
        this.env = anEnv;
        if (!this.running) {
            this.running = true;
            this.bodyTask.schedule(0);
        }
    }

    NewProjectWizard prepareWizardDescriptor(FileObject fo) {
        NewProjectWizard wizard = new NewProjectWizard(fo, this.env);
        wizard.putProperty("PRESELECT_CATEGORY", null);
        wizard.putProperty("PRESELECT_TEMPLATE", null);
        wizard.putProperty("PRESELECT_TEMPLATE", null);
        wizard.putProperty("REMOTE_FILE_ENV", this.env);
        FileObject folder = (FileObject)this.presenter.getValue("existingSourcesFolder");
        if (folder != null) {
            wizard.putProperty("existingSourcesFolder", folder);
        }
        return wizard;
    }

    private void doPerform() {
        FileObject fo = FileUtil.getConfigFile((String)"CND/RemoteProject");
        final NewProjectWizard wizard = this.prepareWizardDescriptor(fo);
        Runnable createWorker = new Runnable(){

            @Override
            public void run() {
                try {
                    File prjDir;
                    Set newObjects = wizard.instantiate();
                    Preferences prefs = NbPreferences.forModule(OpenProjectListSettings.class);
                    String nbPrjDirPath = prefs.get("createdProjectsFolderInWizard", null);
                    prefs.remove("createdProjectsFolderInWizard");
                    if (nbPrjDirPath != null && (prjDir = new File(nbPrjDirPath)).exists() && prjDir.isDirectory() && prjDir.listFiles() != null && prjDir.listFiles().length == 0) {
                        prjDir.delete();
                    }
                    ProjectManager.getDefault().clearNonProjectCache();
                    ProjectUtilities.WaitCursor.show();
                    CndFileUtils.clearFileExistenceCache();
                    if (newObjects != null && !newObjects.isEmpty()) {
                        LinkedList<DataObject> filesToOpen = new LinkedList<DataObject>();
                        LinkedList<Project> projectsToOpen = new LinkedList<Project>();
                        for (Object obj : newObjects) {
                            FileObject newFo;
                            DataObject newDo;
                            block17: {
                                if (obj instanceof DataObject) {
                                    newDo = (DataObject)obj;
                                    newFo = newDo.getPrimaryFile();
                                } else {
                                    if (obj instanceof FileObject) {
                                        newFo = (FileObject)obj;
                                        try {
                                            newDo = DataObject.find((FileObject)newFo);
                                            break block17;
                                        }
                                        catch (DataObjectNotFoundException e) {
                                            ErrorManager.getDefault().notify(1, (Throwable)e);
                                            continue;
                                        }
                                    }
                                    ErrorManager.getDefault().log(16, "Found unrecognized object " + obj + " in result set from instantiate()");
                                    continue;
                                }
                            }
                            if (newFo.isFolder()) {
                                try {
                                    Project p = ProjectManager.getDefault().findProject(newFo);
                                    if (p != null) {
                                        projectsToOpen.add(p);
                                        continue;
                                    }
                                    filesToOpen.add(newDo);
                                }
                                catch (IOException e) {
                                    ErrorManager.getDefault().notify(1, (Throwable)e);
                                }
                                continue;
                            }
                            filesToOpen.add(newDo);
                        }
                        Project lastProject = projectsToOpen.size() > 0 ? (Project)projectsToOpen.get(0) : null;
                        Project mainProject = null;
                        if (Templates.getDefinesMainProject((WizardDescriptor)wizard) && lastProject != null) {
                            mainProject = lastProject;
                        }
                        OpenProjectList.getDefault().open(projectsToOpen.toArray(new Project[projectsToOpen.size()]), false, true, mainProject);
                        ProjectUtilities.makeProjectTabVisible();
                        if (lastProject != null) {
                            ProjectUtilities.selectAndExpandProject(lastProject);
                        }
                        for (DataObject d : filesToOpen) {
                            ProjectUtilities.openAndSelectNewObject(d);
                        }
                    }
                    ProjectUtilities.WaitCursor.hide();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        };
        try {
            ConnectionManager.getInstance().connectTo(this.env);
            SwingUtilities.invokeLater(createWorker);
        }
        catch (IOException ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(NewRemoteProjectPerformer.class, (String)"ErrorConnectingHost", (Object)NewRemoteProjectPerformer.this.env.getDisplayName(), (Object)ex.getMessage()));
                }
            });
        }
        catch (ConnectionManager.CancellationException ex) {
            // empty catch block
        }
    }
}

