/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.shelve;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.subversion.OutputLogger;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.diff.ExportDiffAction;
import org.netbeans.modules.subversion.ui.diff.Setup;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.shelve.ShelveChangesActionsRegistry;
import org.netbeans.modules.versioning.shelve.ShelveChangesSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ShelveChangesAction
extends ContextAction {
    private static final int enabledForStatus = 6548;
    private static ShelveChangesActionsRegistry.ShelveChangesActionProvider ACTION_PROVIDER;

    @Override
    public boolean enable(Node[] nodes) {
        if (!Subversion.getInstance().getStatusCache().ready()) {
            return false;
        }
        Context ctx = this.getCachedContext(nodes);
        if (!Subversion.getInstance().getStatusCache().containsFiles(ctx, 6548, true)) {
            return false;
        }
        return super.enable(nodes);
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_ShelveChanges_Title";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        Context ctx = this.getContext(nodes);
        File[] roots = ctx.getRootFiles();
        if (roots == null || roots.length == 0) {
            Subversion.LOG.log(Level.FINE, "No versioned folder in the selected context for {0}", nodes);
            return;
        }
        File root = roots[0];
        SVNUrl repositoryUrl = null;
        try {
            repositoryUrl = SvnUtils.getRepositoryRootUrl(root);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        if (repositoryUrl == null) {
            Subversion.LOG.log(Level.WARNING, "Could not retrieve repository root for context file {0}", new Object[]{root});
            return;
        }
        SvnShelveChangesSupport supp = new SvnShelveChangesSupport(roots);
        if (supp.prepare("org.netbeans.modules.subversion.ui.shelve.ShelveChangesPanel")) {
            RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
            supp.startAsync(rp, repositoryUrl);
        }
    }

    public static ShelveChangesActionsRegistry.ShelveChangesActionProvider getProvider() {
        if (ACTION_PROVIDER == null) {
            ACTION_PROVIDER = new ShelveChangesActionsRegistry.ShelveChangesActionProvider(){

                public Action getAction() {
                    SystemAction a = SystemAction.get(ShelveChangesAction.class);
                    Utils.setAcceleratorBindings((String)"Actions/Subversion", (Action[])new Action[]{a});
                    return a;
                }
            };
        }
        return ACTION_PROVIDER;
    }

    private static class SvnShelveChangesSupport
    extends ShelveChangesSupport {
        private SvnProgressSupport support;
        private final File[] roots;
        private File[] filteredRoots;
        private Context context;
        private OutputLogger logger;

        public SvnShelveChangesSupport(File[] roots) {
            this.roots = roots;
        }

        protected void exportPatch(File toFile, File commonParent) throws IOException {
            this.support.setDisplayName(NbBundle.getMessage(ShelveChangesAction.class, (String)"MSG_ShelveChanges.progress.exporting"));
            File[] files = SvnUtils.getModifiedFiles(this.context, 22996);
            ArrayList<Setup> setups = new ArrayList<Setup>(files.length);
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                Setup setup = new Setup(file, null, 0);
                setups.add(setup);
            }
            ((ExportDiffAction)SystemAction.get(ExportDiffAction.class)).exportDiff(setups, toFile, commonParent, this.support);
            this.logger.logMessage(NbBundle.getMessage(ShelveChangesAction.class, (String)"MSG_ShelveChangesAction.output.exporting", (Object)toFile.getAbsolutePath()));
        }

        protected void postExportCleanup() {
            this.support.setDisplayName(NbBundle.getMessage(ShelveChangesAction.class, (String)"MSG_ShelveChanges.progress.reverting"));
            RevertModificationsAction.performRevert(null, true, false, this.context, this.support);
        }

        protected boolean isCanceled() {
            return this.support == null ? false : this.support.isCanceled();
        }

        private void startAsync(RequestProcessor rp, SVNUrl repositoryUrl) {
            this.support = new SvnProgressSupport(){

                @Override
                protected void perform() {
                    LinkedList<File> l = new LinkedList<File>();
                    for (File file : SvnShelveChangesSupport.this.roots) {
                        if (!SvnUtils.isManaged(file)) continue;
                        l.add(file);
                    }
                    if (!l.isEmpty()) {
                        SvnShelveChangesSupport.access$202(SvnShelveChangesSupport.this, l.toArray(new File[l.size()]));
                        SvnShelveChangesSupport.this.context = new Context(SvnShelveChangesSupport.this.filteredRoots);
                        SvnShelveChangesSupport.this.logger = this.getLogger();
                        SvnShelveChangesSupport.this.shelveChanges(SvnShelveChangesSupport.this.filteredRoots);
                    }
                }
            };
            this.support.start(rp, repositoryUrl, NbBundle.getMessage(ShelveChangesAction.class, (String)"LBL_ShelveChanges_Progress"));
        }

        static /* synthetic */ File[] access$202(SvnShelveChangesSupport x0, File[] x1) {
            x0.filteredRoots = x1;
            return x1;
        }
    }
}

