/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.diff.DiffNode;
import org.netbeans.modules.subversion.ui.diff.DiffStreamSource;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public final class Setup
extends AbstractDiffSetup {
    public static final int DIFFTYPE_LOCAL = 0;
    public static final int DIFFTYPE_REMOTE = 1;
    public static final int DIFFTYPE_ALL = 2;
    public static final String REVISION_PRISTINE = "PRISTINE";
    public static final String REVISION_BASE = "BASE";
    public static final String REVISION_CURRENT = "LOCAL";
    public static final String REVISION_HEAD = "HEAD";
    private final File baseFile;
    private final String propertyName;
    private String firstRevision;
    private final String secondRevision;
    private FileInformation info;
    private DiffStreamSource firstSource;
    private DiffStreamSource secondSource;
    private DiffController view;
    private DiffNode node;
    private String title;

    public Setup(File baseFile, String propertyName, int type) {
        String secondTitle;
        String firstTitle;
        this.baseFile = baseFile;
        this.propertyName = propertyName;
        this.info = Subversion.getInstance().getStatusCache().getStatus(baseFile);
        int status = this.info.getStatus();
        ResourceBundle loc = NbBundle.getBundle(Setup.class);
        switch (type) {
            case 0: 
            case 1: {
                if (Setup.match(status, 4100)) {
                    this.firstRevision = null;
                    firstTitle = loc.getString("MSG_DiffPanel_NoBaseRevision");
                    break;
                }
                if (Setup.match(status, 512)) {
                    this.firstRevision = null;
                    firstTitle = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(status, 2304)) {
                    this.firstRevision = REVISION_BASE;
                    firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                    break;
                }
                this.firstRevision = REVISION_BASE;
                firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                break;
            }
            case 2: {
                if (Setup.match(status, 512)) {
                    this.firstRevision = REVISION_HEAD;
                    firstTitle = loc.getString("MSG_DiffPanel_RemoteNew");
                    break;
                }
                if (Setup.match(status, 4100)) {
                    this.firstRevision = null;
                    firstTitle = loc.getString("MSG_DiffPanel_NoBaseRevision");
                    break;
                }
                if (Setup.match(status, 1024)) {
                    this.firstRevision = null;
                    firstTitle = loc.getString("MSG_DiffPanel_RemoteDeleted");
                    break;
                }
                this.firstRevision = REVISION_HEAD;
                firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_RemoteModified"), this.firstRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + type);
            }
        }
        switch (type) {
            case 0: 
            case 2: {
                if (Setup.match(status, 16448)) {
                    this.secondRevision = REVISION_CURRENT;
                    secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_LocalConflict"), this.secondRevision);
                    break;
                }
                if (Setup.match(status, 4100)) {
                    this.secondRevision = REVISION_CURRENT;
                    secondTitle = loc.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(status, 512)) {
                    this.secondRevision = null;
                    secondTitle = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(status, 2304)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_LocalDeleted");
                    break;
                }
                this.secondRevision = REVISION_CURRENT;
                secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_LocalModified"), this.secondRevision);
                break;
            }
            case 1: {
                if (Setup.match(status, 4100)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(status, 512)) {
                    this.secondRevision = REVISION_HEAD;
                    secondTitle = loc.getString("MSG_DiffPanel_RemoteNew");
                    break;
                }
                if (Setup.match(status, 1024)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_RemoteDeleted");
                    break;
                }
                this.secondRevision = REVISION_HEAD;
                secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_RemoteModified"), this.secondRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + type);
            }
        }
        if (propertyName != null && REVISION_HEAD.equals(this.firstRevision)) {
            this.firstRevision = REVISION_BASE;
        }
        this.firstSource = new DiffStreamSource(baseFile, propertyName, this.firstRevision, firstTitle);
        this.secondSource = new DiffStreamSource(baseFile, propertyName, this.secondRevision, secondTitle);
        this.title = "<html>" + Subversion.getInstance().getAnnotator().annotateNameHtml(baseFile, this.info);
    }

    public Setup(File baseFile, String firstRevision, String secondRevision, final boolean forceNonEditable) {
        this.baseFile = baseFile;
        this.propertyName = null;
        this.firstRevision = firstRevision;
        this.secondRevision = secondRevision;
        this.firstSource = new DiffStreamSource(baseFile, this.propertyName, firstRevision, firstRevision);
        this.secondSource = new DiffStreamSource(baseFile, this.propertyName, secondRevision, secondRevision){

            @Override
            public boolean isEditable() {
                return !forceNonEditable && super.isEditable();
            }
        };
    }

    public Setup(File baseFile, ISVNStatus status) {
        String headTitle;
        this.baseFile = baseFile;
        this.propertyName = null;
        this.secondRevision = null;
        ResourceBundle loc = NbBundle.getBundle(Setup.class);
        if (status.getRepositoryTextStatus().equals((Object)SVNStatusKind.ADDED)) {
            this.firstRevision = REVISION_HEAD;
            headTitle = loc.getString("MSG_DiffPanel_RemoteNew");
        } else if (status.getRepositoryTextStatus().equals((Object)SVNStatusKind.DELETED)) {
            this.firstRevision = null;
            headTitle = loc.getString("MSG_DiffPanel_RemoteDeleted");
        } else if (status.getRepositoryTextStatus().equals((Object)SVNStatusKind.MODIFIED)) {
            this.firstRevision = REVISION_HEAD;
            headTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_RemoteModified"), this.firstRevision);
        } else {
            this.firstRevision = REVISION_HEAD;
            headTitle = REVISION_HEAD.toString();
        }
        this.firstSource = new DiffStreamSource(baseFile, this.propertyName, REVISION_HEAD, headTitle);
        this.secondSource = new DiffStreamSource(baseFile, this.propertyName, REVISION_CURRENT, REVISION_CURRENT);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public FileInformation getInfo() {
        return this.info;
    }

    public void setView(DiffController view) {
        this.view = view;
    }

    public DiffController getView() {
        return this.view;
    }

    public StreamSource getFirstSource() {
        return this.firstSource;
    }

    public StreamSource getSecondSource() {
        return this.secondSource;
    }

    public void setNode(DiffNode node) {
        this.node = node;
    }

    public DiffNode getNode() {
        return this.node;
    }

    public String toString() {
        return this.title;
    }

    void initSources() throws IOException {
        if (this.firstSource != null) {
            this.firstSource.init();
        }
        if (this.secondSource != null) {
            this.secondSource.init();
        }
    }

    private static boolean match(int status, int mask) {
        return (status & mask) != 0;
    }
}

