/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.diff.Setup;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.netbeans.modules.versioning.diff.DiffLookup;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class DiffNode
extends AbstractNode {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_PROPERTY = "property";
    static final String COLUMN_NAME_STATUS = "status";
    static final String COLUMN_NAME_LOCATION = "location";
    private final Setup setup;
    private String htmlDisplayName;
    private int displayStatuses;
    private static final String[] zeros = new String[]{"", "00", "0", ""};

    DiffNode(Setup setup, SvnFileNode node, int displayStatuses) {
        super(Children.LEAF, DiffNode.getLookupFor(setup, node.getLookupObjects()));
        this.setup = setup;
        this.displayStatuses = displayStatuses;
        this.setName(setup.getBaseFile().getName());
        this.initProperties();
        this.refreshHtmlDisplayName();
    }

    private void refreshHtmlDisplayName() {
        FileInformation info = this.setup.getInfo();
        int status = info.getStatus();
        if (status == 128) {
            status = 64;
        }
        String oldHtmlDisplayName = this.htmlDisplayName;
        this.htmlDisplayName = Subversion.getInstance().getAnnotator().annotateNameHtml(this.setup.getBaseFile().getName(), info, null);
        this.fireDisplayNameChange(oldHtmlDisplayName, this.htmlDisplayName);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    Setup getSetup() {
        return this.setup;
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return null;
        }
        return new Action[0];
    }

    public Node.Cookie getCookie(Class klass) {
        FileObject fo = (FileObject)this.getLookup().lookup(FileObject.class);
        if (fo != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                if (fo.equals(dobj.getPrimaryFile())) {
                    return dobj.getCookie(klass);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return super.getCookie(klass);
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new NameProperty());
        ps.put((Node.Property)new LocationProperty());
        ps.put((Node.Property)new StatusProperty());
        if (this.setup.getPropertyName() != null) {
            ps.put((Node.Property)new PropertyNameProperty());
        }
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private static Lookup getLookupFor(Setup setup, Object[] lookupObjects) {
        Object[] allLookupObjects;
        EditorCookie eCookie = DiffUtils.getEditorCookie((AbstractDiffSetup)setup);
        if (eCookie == null) {
            allLookupObjects = new Object[lookupObjects.length + 1];
        } else {
            allLookupObjects = new Object[lookupObjects.length + 2];
            allLookupObjects[allLookupObjects.length - 1] = eCookie;
        }
        allLookupObjects[0] = setup;
        System.arraycopy(lookupObjects, 0, allLookupObjects, 1, lookupObjects.length);
        DiffLookup lkp = new DiffLookup();
        lkp.setData(allLookupObjects);
        return lkp;
    }

    private class StatusProperty
    extends DiffNodeProperty {
        public StatusProperty() {
            super(DiffNode.COLUMN_NAME_STATUS, DiffNode.COLUMN_NAME_STATUS, DiffNode.COLUMN_NAME_STATUS);
            String shortPath = null;
            try {
                shortPath = SvnUtils.getRelativePath(DiffNode.this.setup.getBaseFile());
            }
            catch (SVNClientException e) {
                shortPath = "";
            }
            String sortable = Integer.toString(SvnUtils.getComparableStatus(DiffNode.this.setup.getInfo().getStatus()));
            this.setValue("sortkey", zeros[sortable.length()] + sortable + "\t" + shortPath + "\t" + DiffNode.this.getName().toUpperCase());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            FileInformation finfo = DiffNode.this.setup.getInfo();
            finfo.getEntry(DiffNode.this.setup.getBaseFile());
            return finfo.getStatusText(DiffNode.this.displayStatuses);
        }
    }

    private class LocationProperty
    extends DiffNodeProperty {
        private String location;

        public LocationProperty() {
            super(DiffNode.COLUMN_NAME_LOCATION, DiffNode.COLUMN_NAME_LOCATION, DiffNode.COLUMN_NAME_LOCATION);
            try {
                this.location = SvnModuleConfig.getDefault().isRepositoryPathPrefixed() ? SvnUtils.getRepositoryUrl(DiffNode.this.setup.getBaseFile()).toString() : SvnUtils.getRelativePath(DiffNode.this.setup.getBaseFile());
            }
            catch (SVNClientException e) {
                this.location = "";
            }
            this.setValue("sortkey", this.location + "\t" + DiffNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return this.location;
        }
    }

    private class PropertyNameProperty
    extends DiffNodeProperty {
        public PropertyNameProperty() {
            super(DiffNode.COLUMN_NAME_PROPERTY, DiffNode.COLUMN_NAME_PROPERTY, DiffNode.COLUMN_NAME_PROPERTY);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return DiffNode.this.setup.getPropertyName();
        }
    }

    private class NameProperty
    extends DiffNodeProperty {
        public NameProperty() {
            super(DiffNode.COLUMN_NAME_NAME, DiffNode.COLUMN_NAME_NAME, DiffNode.COLUMN_NAME_NAME);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return DiffNode.this.getName();
        }
    }

    private abstract class DiffNodeProperty
    extends PropertySupport.ReadOnly<String> {
        protected DiffNodeProperty(String name, String displayName, String shortDescription) {
            super(name, String.class, displayName, shortDescription);
        }

        public String toString() {
            try {
                return ((String)this.getValue()).toString();
            }
            catch (Exception e) {
                Subversion.LOG.log(Level.INFO, null, e);
                return e.getLocalizedMessage();
            }
        }
    }
}

