/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.io.File;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.copy.Merge;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Merge";
    }

    @Override
    protected int getFileEnabledStatus() {
        return -8;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return nodes != null && nodes.length == 1 && this.getCachedContext(nodes).getRoots().size() > 0;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        SVNUrl url;
        SVNUrl rootUrl;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context ctx = this.getContext(nodes);
        final File[] roots = SvnUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        File interestingFile = roots.length == 1 ? roots[0] : SvnUtils.getPrimaryFile(roots[0]);
        try {
            rootUrl = SvnUtils.getRepositoryRootUrl(interestingFile);
            url = SvnUtils.getRepositoryUrl(interestingFile);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        final RepositoryFile repositoryRoot = new RepositoryFile(rootUrl, url, SVNRevision.HEAD);
        final Merge merge = new Merge(repositoryRoot, interestingFile);
        if (merge.showDialog()) {
            ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes, ctx){

                @Override
                public void perform() {
                    for (File root : roots) {
                        MergeAction.this.performMerge(merge, repositoryRoot, root, this, roots.length > 1);
                    }
                }
            };
            support.start(this.createRequestProcessor(ctx));
        }
    }

    private void performMerge(Merge merge, RepositoryFile repositoryRoot, File file, SvnProgressSupport support, boolean partOfMultiFile) {
        File[][] split = Utils.splitFlatOthers((File[])new File[]{file});
        boolean recursive = split[0].length <= 0;
        try {
            SVNRevision startRevision;
            SVNUrl startUrl;
            SvnClient client;
            try {
                client = Subversion.getInstance().getClient(repositoryRoot.getRepositoryUrl());
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            if (support.isCanceled()) {
                return;
            }
            SVNUrl endUrl = merge.getMergeEndRepositoryFile().getFileUrl();
            SVNRevision endRevision = merge.getMergeEndRevision();
            RepositoryFile mergeStartRepositoryFile = merge.getMergeStartRepositoryFile();
            SVNUrl sVNUrl = startUrl = mergeStartRepositoryFile != null ? mergeStartRepositoryFile.getFileUrl() : null;
            if (file.isFile() && partOfMultiFile) {
                endUrl = merge.getMergeEndRepositoryFile().replaceLastSegment(file.getName(), 0).getFileUrl();
                SVNUrl sVNUrl2 = startUrl = mergeStartRepositoryFile != null ? mergeStartRepositoryFile.replaceLastSegment(file.getName(), 0).getFileUrl() : null;
            }
            if (startUrl != null) {
                startRevision = merge.getMergeStartRevision();
                if (merge.isStartRevisionIncluded()) {
                    if (startRevision.getKind() == 1) {
                        startRevision = new SVNRevision.Number(((SVNRevision.Number)startRevision).getNumber() - 1L);
                    } else {
                        ISVNInfo info = client.getInfo(startUrl, startRevision, startRevision);
                        if (info != null) {
                            startRevision = new SVNRevision.Number(info.getRevision().getNumber() - 1L);
                        }
                    }
                }
            } else {
                startUrl = endUrl;
                ISVNLogMessage[] log = client.getLogMessages(startUrl, null, (SVNRevision)new SVNRevision.Number(0L), SVNRevision.HEAD, true, false, 0L);
                startRevision = log[0].getRevision();
            }
            if (support.isCanceled()) {
                return;
            }
            client.merge(startUrl, startRevision, endUrl, endRevision, file, false, recursive);
        }
        catch (SVNClientException ex) {
            support.annotate(ex);
        }
    }
}

