/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.util.Context;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class DeleteLocalAction
extends ContextAction {
    public static final int LOCALLY_DELETABLE_MASK = 4100;

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "Delete";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 4100;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Prompt"));
        descriptor.setTitle(NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Title"));
        descriptor.setMessageType(2);
        descriptor.setOptionType(0);
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (res != NotifyDescriptor.YES_OPTION) {
            return;
        }
        final Context ctx = this.getContext(nodes);
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes, ctx){

            @Override
            public void perform() {
                DeleteLocalAction.performDelete(ctx, this);
            }
        };
        support.start(this.createRequestProcessor(ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performDelete(Context ctx, SvnProgressSupport support) {
        SvnClient client;
        try {
            client = Subversion.getInstance().getClient(ctx, support);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        if (support.isCanceled()) {
            return;
        }
        File[] files = ctx.getFiles();
        for (int i = 0; i < files.length; ++i) {
            if (support.isCanceled()) {
                return;
            }
            File file = files[i];
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) continue;
            FileLock lock = null;
            try {
                try {
                    client.revert(file, false);
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                }
                lock = fo.lock();
                fo.delete(lock);
                continue;
            }
            catch (IOException e) {
                Subversion.LOG.log(Level.SEVERE, NbBundle.getMessage(DeleteLocalAction.class, (String)"MSG_Cannot_lock", (Object)file.getAbsolutePath()), e);
                continue;
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }
}

