/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.options.AnnotationSettings;
import org.netbeans.modules.subversion.options.LabelsPanel;
import org.netbeans.modules.subversion.options.SvnOptionsPanel;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.modules.versioning.util.VCSOptionsKeywordsProvider;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class SvnOptionsController
extends OptionsPanelController
implements ActionListener,
VCSOptionsKeywordsProvider {
    private final SvnOptionsPanel panel;
    private Repository repository;
    private final AnnotationSettings annotationSettings = new AnnotationSettings();
    private static final HashSet<String> allowedExecutables = new HashSet<String>(Arrays.asList("svn", "svn.exe"));
    private static final HashSet<String> allowedLibs = new HashSet<String>(Arrays.asList("libsvnjavahl-1.dll", "libsvnjavahl-1.so"));

    public SvnOptionsController() {
        this.panel = new SvnOptionsPanel();
        this.panel.browseButton.addActionListener(this);
        this.panel.browseJavahlButton.addActionListener(this);
        this.panel.manageConnSettingsButton.addActionListener(this);
        this.panel.manageLabelsButton.addActionListener(this);
        String tooltip = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettingsPanel.annotationTextField.toolTipText", (Object[])Annotator.LABELS);
        this.panel.annotationTextField.setToolTipText(tooltip);
        this.panel.addButton.addActionListener(this);
        this.panel.cmbPreferredClient.addActionListener(this);
        this.panel.cmbPreferredClient.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == ((SvnOptionsController)SvnOptionsController.this).panel.panelCLI) {
                    value = NbBundle.getMessage(SvnOptionsPanel.class, (String)"LBL_PreferredClient.CLI");
                } else if (value == ((SvnOptionsController)SvnOptionsController.this).panel.panelJavahl) {
                    value = NbBundle.getMessage(SvnOptionsPanel.class, (String)"LBL_PreferredClient.JAVAHL");
                } else if (value == ((SvnOptionsController)SvnOptionsController.this).panel.panelSvnkit) {
                    value = NbBundle.getMessage(SvnOptionsPanel.class, (String)"LBL_PreferredClient.SVNKIT");
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.panel.cmbPreferredClient.setModel(new DefaultComboBoxModel<Object>(new Object[]{this.panel.panelCLI, this.panel.panelJavahl, this.panel.panelSvnkit}));
        this.panel.textPaneClient.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                URL url = e.getURL();
                assert (url != null);
                HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                assert (displayer != null) : "HtmlBrowser.URLDisplayer found.";
                if (displayer != null) {
                    displayer.showURL(url);
                } else {
                    Subversion.LOG.info("No URLDisplayer found.");
                }
            }
        });
    }

    public boolean acceptKeywords(List<String> keywords) {
        HashSet<String> allKeywords = new HashSet<String>(this.panel.getKeywords());
        allKeywords.retainAll(keywords);
        return !allKeywords.isEmpty();
    }

    private void createRepository() throws MissingResourceException {
        int repositoryModeMask = 20;
        String title = NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_Repository_Location");
        this.repository = new Repository(repositoryModeMask, title);
    }

    public void update() {
        this.panel.executablePathTextField.setText(SvnModuleConfig.getDefault().getExecutableBinaryPath());
        this.panel.javahlPathTextField.setText(SvnModuleConfig.getDefault().getExecutableBinaryPath());
        this.panel.annotationTextField.setText(SvnModuleConfig.getDefault().getAnnotationFormat());
        this.panel.cbOpenOutputWindow.setSelected(SvnModuleConfig.getDefault().getAutoOpenOutput());
        this.panel.cbGetRemoteLocks.setSelected(SvnModuleConfig.getDefault().isGetRemoteLocks());
        this.panel.cbAutoLockFiles.setSelected(SvnModuleConfig.getDefault().isAutoLock());
        this.annotationSettings.update();
        if (this.repository != null) {
            this.repository.refreshUrlHistory();
        }
        this.panel.excludeNewFiles.setSelected(SvnModuleConfig.getDefault().getExludeNewFiles());
        this.panel.prefixRepositoryPath.setSelected(SvnModuleConfig.getDefault().isRepositoryPathPrefixed());
        if (SvnClientFactory.isJavaHl()) {
            this.panel.cmbPreferredClient.setSelectedItem(this.panel.panelJavahl);
        } else if (SvnClientFactory.isSvnKit()) {
            this.panel.cmbPreferredClient.setSelectedItem(this.panel.panelSvnkit);
        } else {
            this.panel.cmbPreferredClient.setSelectedItem(this.panel.panelCLI);
        }
    }

    public void applyChanges() {
        boolean clientChanged = this.isClientChanged();
        if (this.panel.cmbPreferredClient.getSelectedItem() == this.panel.panelCLI) {
            SvnModuleConfig.getDefault().setExecutableBinaryPath(this.panel.executablePathTextField.getText());
            SvnModuleConfig.getDefault().setPreferredFactoryType("commandline");
        } else if (this.panel.cmbPreferredClient.getSelectedItem() == this.panel.panelJavahl) {
            SvnModuleConfig.getDefault().setExecutableBinaryPath(this.panel.javahlPathTextField.getText());
            SvnModuleConfig.getDefault().setPreferredFactoryType("javahl");
        } else if (this.panel.cmbPreferredClient.getSelectedItem() == this.panel.panelSvnkit) {
            SvnModuleConfig.getDefault().setPreferredFactoryType("svnkit");
        }
        SvnModuleConfig.getDefault().setAnnotationFormat(this.panel.annotationTextField.getText());
        SvnModuleConfig.getDefault().setAutoOpenOutputo(this.panel.cbOpenOutputWindow.isSelected());
        SvnModuleConfig.getDefault().setGetRemoteLocks(this.panel.cbGetRemoteLocks.isSelected());
        SvnModuleConfig.getDefault().setAutoLock(this.panel.cbAutoLockFiles.isSelected());
        SvnModuleConfig.getDefault().setExcludeNewFiles(this.panel.excludeNewFiles.isSelected());
        SvnModuleConfig.getDefault().setRepositoryPathPrefixed(this.panel.prefixRepositoryPath.isSelected());
        if (clientChanged) {
            SvnClientFactory.resetClient();
        }
        this.annotationSettings.applyChanges();
        Subversion.getInstance().getAnnotator().refresh();
        Subversion.getInstance().refreshAllAnnotations();
    }

    public void cancel() {
        if (this.repository != null) {
            this.repository.refreshUrlHistory();
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean isChanged() {
        return !this.panel.executablePathTextField.getText().equals(SvnModuleConfig.getDefault().getExecutableBinaryPath()) || !this.panel.annotationTextField.getText().equals(SvnModuleConfig.getDefault().getAnnotationFormat()) || this.panel.cbGetRemoteLocks.isSelected() != SvnModuleConfig.getDefault().isGetRemoteLocks() || this.repository != null && this.repository.isChanged() || this.annotationSettings.isChanged() || this.isClientChanged();
    }

    private boolean isClientChanged() {
        Object selectedPanel = this.panel.cmbPreferredClient.getSelectedItem();
        return SvnClientFactory.isCLI() && selectedPanel != this.panel.panelCLI || SvnClientFactory.isSvnKit() && selectedPanel != this.panel.panelSvnkit || SvnClientFactory.isJavaHl() && selectedPanel != this.panel.panelJavahl;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.panel.browseButton) {
            this.onBrowseClick();
        } else if (evt.getSource() == this.panel.browseJavahlButton) {
            this.onBrowseJavahlClick();
        } else if (evt.getSource() == this.panel.manageConnSettingsButton) {
            this.onManageConnClick();
        } else if (evt.getSource() == this.panel.manageLabelsButton) {
            this.onManageLabelsClick();
        } else if (evt.getSource() == this.panel.addButton) {
            this.onAddClick();
        } else if (evt.getSource() == this.panel.cmbPreferredClient) {
            this.onPreferredClientChanged();
        }
    }

    private void onPreferredClientChanged() {
        Object selectedClient = this.panel.cmbPreferredClient.getSelectedItem();
        this.panel.panelCLI.setVisible(false);
        this.panel.panelJavahl.setVisible(false);
        this.panel.panelSvnkit.setVisible(false);
        this.panel.lblRestartWarning.setVisible(false);
        if (selectedClient == this.panel.panelCLI) {
            this.panel.panelCLI.setVisible(true);
        } else if (selectedClient == this.panel.panelJavahl) {
            this.panel.panelJavahl.setVisible(true);
        } else if (selectedClient == this.panel.panelSvnkit) {
            this.panel.panelSvnkit.setVisible(true);
        }
    }

    private File getExecutableFile() {
        String execPath = this.panel.executablePathTextField.getText();
        return FileUtil.normalizeFile((File)new File(execPath));
    }

    private File getJavahlFolder() {
        String execPath = this.panel.javahlPathTextField.getText();
        return FileUtil.normalizeFile((File)new File(execPath));
    }

    private void onBrowseClick() {
        File oldFile = this.getExecutableFile();
        this.onBrowse(oldFile, allowedExecutables, this.panel.executablePathTextField, NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_BrowseFolder"), NbBundle.getMessage(SvnOptionsController.class, (String)"Browse_title"), NbBundle.getMessage(SvnOptionsController.class, (String)"FileChooser.SvnExecutables.desc"));
    }

    private void onBrowse(File oldFile, final Set<String> allowedFileNames, JTextField textField, String acsd, String browseTitle, final String fileTypeDesc) {
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(acsd, oldFile);
        fileChooser.setDialogTitle(browseTitle);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || allowedFileNames.contains(f.getName());
            }

            @Override
            public String getDescription() {
                return fileTypeDesc;
            }
        });
        fileChooser.showDialog(this.panel, NbBundle.getMessage(SvnOptionsController.class, (String)"OK_Button"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            if (f.isFile()) {
                f = f.getParentFile();
            }
            textField.setText(f.getAbsolutePath());
        }
    }

    private void onBrowseJavahlClick() {
        this.onBrowse(this.getJavahlFolder(), allowedLibs, this.panel.javahlPathTextField, NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_BrowseJavahlFolder"), NbBundle.getMessage(SvnOptionsController.class, (String)"Browse_Javahl_title"), NbBundle.getMessage(SvnOptionsController.class, (String)"FileChooser.SvnLibs.desc"));
    }

    private void onManageConnClick() {
        if (this.repository == null) {
            this.panel.manageConnSettingsButton.setEnabled(false);
            new SvnProgressSupport(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    try {
                        SvnOptionsController.this.createRepository();
                    }
                    catch (Throwable throwable) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((SvnOptionsController)SvnOptionsController.this).panel.manageConnSettingsButton.setEnabled(true);
                                if (SvnOptionsController.this.repository != null) {
                                    SvnOptionsController.this.onManageConnClick();
                                }
                            }
                        });
                        throw throwable;
                    }
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }.start(Subversion.getInstance().getParallelRequestProcessor(), null, NbBundle.getMessage(SvnOptionsController.class, (String)"MSG_ManageConnections.initializing"));
        } else {
            boolean ok = this.repository.show(NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_ManageConnections"), new HelpCtx(Repository.class), true);
            if (ok) {
                this.repository.storeRecentUrls();
            } else {
                this.repository.refreshUrlHistory();
            }
        }
    }

    private void onManageLabelsClick() {
        String labelFormat = this.panel.annotationTextField.getText().replaceAll(" ", "");
        this.annotationSettings.show(labelFormat != null && labelFormat.indexOf("{folder}") > -1);
    }

    private void onAddClick() {
        LabelsPanel labelsPanel = new LabelsPanel();
        ArrayList<LabelVariable> variables = new ArrayList<LabelVariable>(Annotator.LABELS.length);
        for (int i = 0; i < Annotator.LABELS.length; ++i) {
            LabelVariable variable = new LabelVariable(Annotator.LABELS[i], "{" + Annotator.LABELS[i] + "} - " + NbBundle.getMessage(AnnotationSettings.class, (String)("AnnotationSettings.label." + Annotator.LABELS[i])));
            variables.add(variable);
        }
        labelsPanel.labelsList.setListData(variables.toArray(new LabelVariable[variables.size()]));
        String title = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.labelVariables.title");
        String acsd = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.labelVariables.acsd");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)labelsPanel, title);
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(true);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(acsd);
        labelsPanel.labelsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            Object[] selection = labelsPanel.labelsList.getSelectedValues();
            String variable = "";
            for (int i = 0; i < selection.length; ++i) {
                variable = variable + "{" + ((LabelVariable)selection[i]).getVariable() + "}";
            }
            String annotation = this.panel.annotationTextField.getText();
            int pos = this.panel.annotationTextField.getCaretPosition();
            if (pos < 0) {
                pos = annotation.length();
            }
            StringBuilder sb = new StringBuilder(annotation.length() + variable.length());
            sb.append(annotation.substring(0, pos));
            sb.append(variable);
            if (pos < annotation.length()) {
                sb.append(annotation.substring(pos, annotation.length()));
            }
            this.panel.annotationTextField.setText(sb.toString());
            this.panel.annotationTextField.requestFocus();
            this.panel.annotationTextField.setCaretPosition(pos + variable.length());
        }
    }

    private class LabelVariable {
        private String description;
        private String variable;

        public LabelVariable(String variable, String description) {
            this.description = description;
            this.variable = variable;
        }

        public String toString() {
            return this.description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

