/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.api.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.history.SearchHistoryAction;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.history.HistoryAction;
import org.netbeans.modules.versioning.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.util.FileUtils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class HistoryProvider
implements VCSHistoryProvider {
    private final List<VCSHistoryProvider.HistoryChangeListener> listeners = new LinkedList<VCSHistoryProvider.HistoryChangeListener>();
    private Action[] actions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public VCSHistoryProvider.HistoryEntry[] getHistory(File[] files, Date fromDate) {
        try {
            SvnClient client = org.netbeans.modules.subversion.Subversion.getInstance().getClient(files[0]);
            LinkedList<VCSHistoryProvider.HistoryEntry> ret = new LinkedList<VCSHistoryProvider.HistoryEntry>();
            HashMap<String, HashSet<File>> rev2FileMap = new HashMap<String, HashSet<File>>();
            HashMap<String, ISVNLogMessage> rev2LMMap = new HashMap<String, ISVNLogMessage>();
            HashMap<File, SVNUrl> file2Copy = new HashMap<File, SVNUrl>();
            SVNUrl repoUrl = null;
            for (File file : files) {
                ISVNLogMessage[] messages;
                FileInformation fi = org.netbeans.modules.subversion.Subversion.getInstance().getStatusCache().getStatus(file);
                if ((fi.getStatus() & 0x5DF8) == 0) continue;
                if (fi.getStatus() == 4096 && fi.getEntry(file).isCopied()) {
                    ISVNInfo info = SvnUtils.getInfoFromWorkingCopy(client, file);
                    SVNUrl copyUrl = info.getCopyUrl();
                    repoUrl = info.getRepository();
                    messages = client.getLogMessages(copyUrl, (SVNRevision)(fromDate == null ? new SVNRevision.Number(1L) : new SVNRevision.DateSpec(fromDate)), SVNRevision.HEAD);
                    file2Copy.put(file, copyUrl);
                } else {
                    messages = client.getLogMessages(file, (SVNRevision)(fromDate == null ? new SVNRevision.Number(1L) : new SVNRevision.DateSpec(fromDate)), SVNRevision.HEAD);
                }
                for (ISVNLogMessage m : messages) {
                    String r = m.getRevision().toString();
                    rev2LMMap.put(r, m);
                    HashSet<File> s = (HashSet<File>)rev2FileMap.get(r);
                    if (s == null) {
                        s = new HashSet<File>();
                        rev2FileMap.put(r, s);
                    }
                    s.add(file);
                }
            }
            for (ISVNLogMessage m : rev2LMMap.values()) {
                Set s = (Set)rev2FileMap.get(m.getRevision().toString());
                File[] involvedFiles = s.toArray(new File[s.size()]);
                VCSHistoryProvider.HistoryEntry e = new VCSHistoryProvider.HistoryEntry(involvedFiles, m.getDate(), m.getMessage(), m.getAuthor(), m.getAuthor(), m.getRevision().toString(), m.getRevision().toString(), this.getActions(), (VCSHistoryProvider.RevisionProvider)new RevisionProviderImpl((SVNRevision)m.getRevision(), repoUrl, file2Copy));
                ret.add(e);
            }
            return ret.toArray(new VCSHistoryProvider.HistoryEntry[ret.size()]);
        }
        catch (SVNClientException e) {
            if (SvnClientExceptionHandler.isCancelledAction(e.getMessage())) {
                org.netbeans.modules.subversion.Subversion.LOG.log(Level.FINE, null, e);
            } else {
                SvnClientExceptionHandler.notifyException((Exception)((Object)e), true, true);
            }
            return null;
        }
    }

    public Action createShowHistoryAction(File[] files) {
        return new OpenHistoryAction(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHistoryChange(final File[] files) {
        VCSHistoryProvider.HistoryChangeListener[] la;
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            la = this.listeners.toArray(new VCSHistoryProvider.HistoryChangeListener[this.listeners.size()]);
        }
        org.netbeans.modules.subversion.Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                for (VCSHistoryProvider.HistoryChangeListener l : la) {
                    l.fireHistoryChanged(new VCSHistoryProvider.HistoryEvent((VCSHistoryProvider)HistoryProvider.this, files));
                }
            }
        });
    }

    private synchronized Action[] getActions() {
        if (this.actions == null) {
            this.actions = new Action[]{new RollbackAction(), new ViewAction(), new AnnotateAction()};
        }
        return this.actions;
    }

    private void view(final SVNRevision revision, final boolean showAnnotations, final File ... files) {
        if (files == null || files.length == 0) {
            return;
        }
        org.netbeans.modules.subversion.Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                try {
                    SVNUrl repoUrl = SvnUtils.getRepositoryRootUrl(files[0]);
                    for (File file : files) {
                        SvnClient client = org.netbeans.modules.subversion.Subversion.getInstance().getClient(false);
                        ISVNInfo info = client.getInfo(file);
                        SVNUrl fileUrl = info.getUrl();
                        SvnUtils.openInRevision(file, repoUrl, fileUrl, revision, revision, showAnnotations);
                    }
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
        });
    }

    private class RollbackAction
    extends HistoryAction {
        private RollbackAction() {
        }

        protected void perform(final VCSHistoryProvider.HistoryEntry entry, final Set<File> files) {
            SVNUrl repository;
            final File file = files.iterator().next();
            try {
                repository = SvnUtils.getRepositoryRootUrl(file);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                return;
            }
            RequestProcessor rp = org.netbeans.modules.subversion.Subversion.getInstance().getRequestProcessor(repository);
            SvnProgressSupport support = new SvnProgressSupport(){

                @Override
                public void perform() {
                    try {
                        SVNUrl repoUrl = SvnUtils.getRepositoryRootUrl(file);
                        for (File file2 : files) {
                            SvnClient client = org.netbeans.modules.subversion.Subversion.getInstance().getClient(false);
                            ISVNInfo info = client.getInfo(file2);
                            SVNUrl fileUrl = info.getUrl();
                            SVNRevision.Number svnRevision = new SVNRevision.Number(Long.parseLong(entry.getRevision()));
                            SvnUtils.rollback(file2, repoUrl, fileUrl, svnRevision, false, this.getLogger());
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                    }
                }
            };
            support.start(rp, repository, NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_Rollback_Progress"));
        }

        protected boolean isMultipleHistory() {
            return false;
        }

        public String getName() {
            String rev = this.getRevisionShort();
            if (rev == null) {
                rev = "";
            }
            return NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SummaryView_RollbackTo", (Object)rev);
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }

    private class AnnotateAction
    extends HistoryAction {
        public AnnotateAction() {
            super(NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SummaryView_ShowAnnotations"));
        }

        protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<File> files) {
            SVNRevision.Number svnRevision = new SVNRevision.Number(Long.parseLong(entry.getRevision()));
            HistoryProvider.this.view((SVNRevision)svnRevision, true, files.toArray(new File[files.size()]));
        }
    }

    private class ViewAction
    extends HistoryAction {
        public ViewAction() {
            super(NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SummaryView_View"));
        }

        protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<File> files) {
            SVNRevision.Number svnRevision = new SVNRevision.Number(Long.parseLong(entry.getRevision()));
            HistoryProvider.this.view((SVNRevision)svnRevision, false, files.toArray(new File[files.size()]));
        }
    }

    private static class OpenHistoryAction
    extends AbstractAction {
        private final File[] files;

        public OpenHistoryAction(File[] files) {
            this.files = files;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.openHistory(this.files);
        }

        public void openHistory(final File[] files) {
            if (files == null || files.length == 0) {
                return;
            }
            if (!Subversion.isClientAvailable(true)) {
                org.netbeans.modules.subversion.Subversion.LOG.log(Level.WARNING, "Subversion client is unavailable");
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchHistoryAction.openHistory(files);
                }
            });
        }
    }

    private static class RevisionProviderImpl
    implements VCSHistoryProvider.RevisionProvider {
        private final SVNRevision revision;
        private final Map<File, SVNUrl> file2Copy;
        private final SVNUrl repoUrl;

        public RevisionProviderImpl(SVNRevision svnRevision, SVNUrl repoUrl, Map<File, SVNUrl> file2Copy) {
            this.revision = svnRevision;
            this.file2Copy = file2Copy;
            this.repoUrl = repoUrl;
        }

        public void getRevisionFile(File originalFile, File revisionFile) {
            try {
                SVNUrl copyUrl = this.repoUrl != null ? this.file2Copy.get(originalFile) : null;
                File file = copyUrl != null ? VersionsCache.getInstance().getFileRevision(this.repoUrl, copyUrl, this.revision.toString(), originalFile.getName()) : VersionsCache.getInstance().getFileRevision(originalFile, this.revision.toString());
                FileUtils.copyFile((File)file, (File)revisionFile);
            }
            catch (IOException e) {
                Throwable ex = e;
                if (e.getCause() != null && e.getCause() instanceof SVNClientException) {
                    ex = (SVNClientException)e.getCause();
                }
                if (SvnClientExceptionHandler.isCancelledAction(ex.getMessage())) {
                    org.netbeans.modules.subversion.Subversion.LOG.log(Level.FINE, null, e);
                }
                SvnClientExceptionHandler.notifyException((Exception)ex, true, true);
            }
        }
    }
}

