/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.proxy.Base64Encoder;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.turbo.CacheIndex;
import org.netbeans.modules.turbo.TurboProvider;
import org.netbeans.modules.versioning.util.FileUtils;
import org.openide.modules.Places;

class DiskMapTurboProvider
implements TurboProvider {
    static final String ATTR_STATUS_MAP = "subversion.STATUS_MAP";
    private static final int STATUS_VALUABLE = -10;
    private static final String CACHE_DIRECTORY = "svncache";
    private File cacheStore;
    private int storeSerial;
    private CacheIndex index = DiskMapTurboProvider.createCacheIndex();
    private CacheIndex conflictedIndex = DiskMapTurboProvider.createCacheIndex();

    DiskMapTurboProvider() {
        this.initCacheStore();
    }

    File[] getIndexValues(File file, int includeStatus) {
        if (includeStatus == 16448) {
            return this.conflictedIndex.get(file);
        }
        return this.index.get(file);
    }

    File[] getAllIndexValues() {
        return this.index.getAllValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeIndex() {
        long ts = System.currentTimeMillis();
        long entriesCount = 0L;
        long failedReadCount = 0L;
        try {
            File[] files;
            if (!this.cacheStore.isDirectory()) {
                this.cacheStore.mkdirs();
            }
            DiskMapTurboProvider diskMapTurboProvider = this;
            synchronized (diskMapTurboProvider) {
                files = this.cacheStore.listFiles();
            }
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                DiskMapTurboProvider diskMapTurboProvider2 = this;
                synchronized (diskMapTurboProvider2) {
                    if (!file.getName().endsWith(".bin")) {
                        continue;
                    }
                    boolean readFailed = false;
                    int itemIndex = -1;
                    FilterInputStream dis = null;
                    try {
                        int retry = 0;
                        while (true) {
                            try {
                                dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                            }
                            catch (IOException ioex) {
                                if (++retry > 7) {
                                    throw ioex;
                                }
                                Thread.sleep(retry * 30);
                                continue;
                            }
                            break;
                        }
                        itemIndex = 0;
                        block31: while (true) {
                            int pathLen;
                            ++itemIndex;
                            try {
                                pathLen = ((DataInputStream)dis).readInt();
                            }
                            catch (EOFException e) {
                                break;
                            }
                            ((DataInputStream)dis).readInt();
                            String path = this.readChars((DataInputStream)dis, pathLen);
                            Map<File, FileInformation> value = this.readValue((DataInputStream)dis, path);
                            Iterator<File> j = value.keySet().iterator();
                            while (true) {
                                if (!j.hasNext()) continue block31;
                                ++entriesCount;
                                File f = j.next();
                                FileInformation info = value.get(f);
                                if ((info.getStatus() & 0x4040) != 0) {
                                    this.conflictedIndex.add(f);
                                }
                                if ((info.getStatus() & 0xFFFFFFF6) == 0) continue;
                                this.index.add(f);
                            }
                            break;
                        }
                    }
                    catch (EOFException e) {
                        this.logCorruptedCacheFile(file, itemIndex, e);
                        readFailed = true;
                    }
                    catch (Exception e) {
                        Subversion.LOG.log(Level.SEVERE, null, e);
                    }
                    finally {
                        if (dis != null) {
                            try {
                                dis.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    if (readFailed) {
                        file.delete();
                        ++failedReadCount;
                    }
                    continue;
                }
            }
        }
        finally {
            Subversion.LOG.info("Finished indexing svn cache with " + entriesCount + " entries. Elapsed time: " + (System.currentTimeMillis() - ts) + " ms.");
            if (failedReadCount > 0L) {
                Subversion.LOG.info(" read failed " + failedReadCount + " times.");
            }
        }
    }

    public boolean recognizesAttribute(String name) {
        return ATTR_STATUS_MAP.equals(name);
    }

    public boolean recognizesEntity(Object key) {
        return key instanceof File;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object readEntry(Object key, String name, TurboProvider.MemoryCache memoryCache) {
        assert (key instanceof File);
        assert (name != null);
        boolean readFailed = false;
        File dir = (File)key;
        File store = this.getStore(dir);
        if (!store.isFile()) {
            return null;
        }
        String dirPath = dir.getAbsolutePath();
        int dirPathLen = dirPath.length();
        FilterInputStream dis = null;
        int itemIndex = -1;
        try {
            int retry = 0;
            while (true) {
                try {
                    dis = new DataInputStream(new BufferedInputStream(new FileInputStream(store)));
                }
                catch (IOException ioex) {
                    if (++retry > 7) {
                        throw ioex;
                    }
                    Thread.sleep(retry * 30);
                    continue;
                }
                break;
            }
            itemIndex = 0;
            while (true) {
                int pathLen;
                ++itemIndex;
                try {
                    pathLen = ((DataInputStream)dis).readInt();
                }
                catch (EOFException e) {
                    break;
                }
                int mapLen = ((DataInputStream)dis).readInt();
                if (pathLen != dirPathLen) {
                    this.skip(dis, pathLen * 2 + mapLen);
                    continue;
                }
                String path = this.readChars((DataInputStream)dis, pathLen);
                if (dirPath.equals(path)) {
                    Map<File, FileInformation> map = this.readValue((DataInputStream)dis, path);
                    return map;
                }
                this.skip(dis, mapLen);
            }
        }
        catch (EOFException e) {
            this.logCorruptedCacheFile(store, itemIndex, e);
            readFailed = true;
        }
        catch (Exception e) {
            Subversion.LOG.log(Level.INFO, e.getMessage(), e);
            readFailed = true;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {}
            }
        }
        if (readFailed) {
            store.delete();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeEntry(Object key, String name, Object value) {
        boolean readFailed;
        File storeNew;
        File store;
        File dir;
        block52: {
            assert (key instanceof File);
            assert (name != null);
            if (value != null) {
                if (!(value instanceof Map)) {
                    return false;
                }
                if (!this.isValuable(value)) {
                    value = null;
                }
            }
            dir = (File)key;
            String dirPath = dir.getAbsolutePath();
            int dirPathLen = dirPath.length();
            store = this.getStore(dir);
            if (value == null && !store.exists()) {
                return true;
            }
            storeNew = new File(store.getParentFile(), store.getName() + ".new");
            if (!this.cacheStore.isDirectory()) {
                this.cacheStore.mkdirs();
            }
            FilterOutputStream oos = null;
            FilterInputStream dis = null;
            readFailed = false;
            int itemIndex = -1;
            try {
                oos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(storeNew)));
                if (value != null) {
                    this.writeEntry((DataOutputStream)oos, dirPath, value);
                }
                if (!store.exists()) break block52;
                int retry = 0;
                while (true) {
                    try {
                        dis = new DataInputStream(new BufferedInputStream(new FileInputStream(store)));
                    }
                    catch (IOException ioex) {
                        if (++retry > 7) {
                            throw ioex;
                        }
                        Thread.sleep(retry * 30);
                        continue;
                    }
                    break;
                }
                itemIndex = 0;
                while (true) {
                    int pathLen;
                    ++itemIndex;
                    try {
                        pathLen = ((DataInputStream)dis).readInt();
                    }
                    catch (EOFException e) {
                        break;
                    }
                    int mapLen = ((DataInputStream)dis).readInt();
                    if (pathLen == dirPathLen) {
                        String path = this.readChars((DataInputStream)dis, pathLen);
                        if (dirPath.equals(path)) {
                            this.skip(dis, mapLen);
                            continue;
                        }
                        ((DataOutputStream)oos).writeInt(pathLen);
                        ((DataOutputStream)oos).writeInt(mapLen);
                        ((DataOutputStream)oos).writeChars(path);
                        DiskMapTurboProvider.copyStreams(oos, dis, mapLen);
                        continue;
                    }
                    ((DataOutputStream)oos).writeInt(pathLen);
                    ((DataOutputStream)oos).writeInt(mapLen);
                    DiskMapTurboProvider.copyStreams(oos, dis, mapLen + pathLen * 2);
                }
            }
            catch (EOFException e) {
                this.logCorruptedCacheFile(store, itemIndex, e);
                readFailed = true;
            }
            catch (FileNotFoundException ex) {
                Subversion.LOG.log(Level.INFO, "File could not be created, check if you are running only a single instance of netbeans for this userdir", ex);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                Subversion.LOG.log(Level.INFO, "Copy: " + store.getAbsolutePath() + " to: " + storeNew.getAbsolutePath(), e);
                boolean bl = true;
                return bl;
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException e) {}
                }
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        this.adjustIndex(dir, value);
        ++this.storeSerial;
        if (readFailed) {
            store.delete();
            return true;
        }
        try {
            FileUtils.renameFile((File)storeNew, (File)store);
        }
        catch (FileNotFoundException ex) {
            Subversion.LOG.log(Level.INFO, "File could not be renamed, check if you are running only a single instance of netbeans for this userdir", ex);
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
        }
        return true;
    }

    private void adjustIndex(File dir, Object value) {
        assert (!dir.isFile());
        Map map = (Map)value;
        Set set = map != null ? map.keySet() : null;
        HashSet<File> conflictedSet = new HashSet<File>();
        HashSet<File> newSet = new HashSet<File>();
        if (set != null) {
            for (File file : set) {
                FileInformation info = (FileInformation)map.get(file);
                if ((info.getStatus() & 0x4040) != 0) {
                    conflictedSet.add(file);
                }
                if ((info.getStatus() & 0xFFFFFFF6) == 0) continue;
                newSet.add(file);
            }
        }
        this.index.add(dir, newSet);
        this.conflictedIndex.add(dir, conflictedSet);
    }

    private void logCorruptedCacheFile(File file, int itemIndex, EOFException e) {
        try {
            File tmpFile = File.createTempFile("svn_", ".bin");
            Subversion.LOG.log(Level.INFO, "Corrupted cache file " + file.getAbsolutePath() + " at position " + itemIndex, e);
            FileUtils.copyFile((File)file, (File)tmpFile);
            byte[] contents = FileUtils.getFileContentsAsByteArray((File)tmpFile);
            Subversion.LOG.log(Level.INFO, "Corrupted cache file length: " + contents.length);
            String encodedContent = Base64Encoder.encode((byte[])contents);
            Subversion.LOG.log(Level.INFO, "Corrupted cache file content:\n" + encodedContent + "\n");
            Exception ex = new Exception("Corrupted cache file \"" + file.getAbsolutePath() + "\", please report in subversion module issues and attach " + tmpFile.getAbsolutePath() + " plus the IDE message log", e);
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        catch (IOException ex) {
            Subversion.LOG.log(Level.SEVERE, null, ex);
        }
    }

    private void skip(InputStream is, long len) throws IOException {
        while (len > 0L) {
            long n = is.skip(len);
            if (n < 0L) {
                throw new EOFException("Missing " + len + " bytes.");
            }
            len -= n;
        }
    }

    private String readChars(DataInputStream dis, int len) throws IOException {
        if (len < 0 || len > 0xA00000) {
            throw new EOFException("Len: " + len);
        }
        StringBuilder sb = new StringBuilder(len);
        while (len-- > 0) {
            sb.append(dis.readChar());
        }
        return sb.toString();
    }

    private Map<File, FileInformation> readValue(DataInputStream dis, String dirPath) throws IOException {
        HashMap<File, FileInformation> map = new HashMap<File, FileInformation>();
        int len = dis.readInt();
        while (len-- > 0) {
            int status;
            int nameLen = dis.readInt();
            String name = this.readChars(dis, nameLen);
            File file = new File(dirPath, name);
            FileInformation info = new FileInformation(status & 0xFFFF, (status = dis.readInt()) > 65535);
            map.put(file, info);
        }
        return map;
    }

    private void writeEntry(DataOutputStream dos, String dirPath, Object value) throws IOException {
        Map map = (Map)value;
        Set set = map.keySet();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(set.size() * 50);
        DataOutputStream temp = new DataOutputStream(baos);
        temp.writeInt(set.size());
        for (File file : set) {
            FileInformation info = (FileInformation)map.get(file);
            temp.writeInt(file.getName().length());
            temp.writeChars(file.getName());
            temp.writeInt(info.getStatus() + (info.isDirectory() ? 65536 : 0));
        }
        temp.close();
        byte[] valueBytes = baos.toByteArray();
        dos.writeInt(dirPath.length());
        dos.writeInt(valueBytes.length);
        dos.writeChars(dirPath);
        dos.write(valueBytes);
    }

    private boolean isValuable(Object value) {
        Map map = (Map)value;
        for (FileInformation info : map.values()) {
            if ((info.getStatus() & 0xFFFFFFF6) == 0) continue;
            return true;
        }
        return false;
    }

    private File getStore(File dir) {
        String dirPath = dir.getAbsolutePath();
        int dirHash = dirPath.hashCode();
        return new File(this.cacheStore, Integer.toString(dirHash % 173 + 172) + ".bin");
    }

    private void initCacheStore() {
        this.cacheStore = Places.getCacheSubdirectory((String)CACHE_DIRECTORY);
    }

    private static void copyStreams(OutputStream out, InputStream in, int len) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        int totalLen = len;
        do {
            n = len >= 0 && len <= 4096 ? len : 4096;
            if ((n = in.read(buffer, 0, n)) < 0) {
                throw new EOFException("Missing " + len + " bytes from total " + totalLen + " bytes.");
            }
            out.write(buffer, 0, n);
        } while ((len -= n) != 0);
        out.flush();
    }

    private static CacheIndex createCacheIndex() {
        return new CacheIndex(){

            protected boolean isManaged(File file) {
                return SvnUtils.isManaged(file);
            }
        };
    }
}

