/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.io.IOException;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.wizard.RestFilterPanelVisual;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RestFilterPanel
implements WizardDescriptor.Panel<WizardDescriptor> {
    static final String HTTP_METHODS = "http-methods";
    static final String ORIGIN = "origin";
    static final String HEADERS = "headers";
    private RestFilterPanelVisual myComponent;
    private WizardDescriptor myDescriptor;

    RestFilterPanel(WizardDescriptor wizard) {
        this.myDescriptor = wizard;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public Component getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new RestFilterPanelVisual(this.myDescriptor);
        }
        return this.myComponent;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        Project project = Templates.getProject((WizardDescriptor)this.myDescriptor);
        WebRestSupport support = (WebRestSupport)project.getLookup().lookup(WebRestSupport.class);
        if (support != null) {
            ServletMapping object = null;
            try {
                object = support.getRestServletMapping(support.getWebApp());
            }
            catch (IOException e) {
                // empty catch block
            }
            if (object == null) {
                if (support.isRestSupportOn()) {
                    this.myDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RestFilterPanel.class, (String)"ERR_NoJerseyConfig"));
                } else {
                    this.myDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RestFilterPanel.class, (String)"ERR_NoRestConfig"));
                }
                return false;
            }
        }
        return true;
    }

    public void readSettings(WizardDescriptor wizard) {
        this.myDescriptor = wizard;
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    public void storeSettings(WizardDescriptor descriptor) {
        if (this.myComponent != null) {
            this.myComponent.store(descriptor);
        }
    }
}

