/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.GenericResourceGenerator;
import org.netbeans.modules.websvc.rest.codegen.model.GenericResourceBean;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.ClientStubsIterator;
import org.netbeans.modules.websvc.rest.wizard.PatternResourcesSetupPanel;
import org.netbeans.modules.websvc.rest.wizard.PatternSelectionPanel;
import org.netbeans.modules.websvc.rest.wizard.ProgressDialog;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PatternResourcesIterator
implements WizardDescriptor.InstantiatingIterator {
    private WizardDescriptor wizard;
    private int current;
    private transient AbstractPanel[] panels;
    private RequestProcessor.Task generatorTask;

    public Set instantiate() throws IOException {
        final HashSet result = new HashSet();
        try {
            Project project = Templates.getProject((WizardDescriptor)this.wizard);
            final RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
            String restAppPackage = null;
            String restAppClass = null;
            final ProgressDialog dialog = new ProgressDialog(NbBundle.getMessage(PatternResourcesIterator.class, (String)"LBL_RestServicesFromPatternsProgress"));
            final ProgressHandle pHandle = dialog.getProgressHandle();
            pHandle.start();
            pHandle.progress(NbBundle.getMessage(PatternResourcesIterator.class, (String)"MSG_EnableRestSupport"));
            if (restSupport instanceof WebRestSupport) {
                Object useJersey = this.wizard.getProperty("useJersey");
                if (useJersey != null && useJersey.toString().equals("true")) {
                    ((WebRestSupport)restSupport).enableRestSupport(WebRestSupport.RestConfig.DD);
                } else {
                    restAppPackage = (String)this.wizard.getProperty("restApplicationConfigPackage");
                    restAppClass = (String)this.wizard.getProperty("restApplicatoin");
                    if (restAppPackage != null && restAppClass != null) {
                        ((WebRestSupport)restSupport).enableRestSupport(WebRestSupport.RestConfig.IDE);
                    }
                }
            }
            if (restSupport != null) {
                restSupport.ensureRestDevelopmentReady();
            }
            FileObject tmpTargetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizard);
            SourceGroup sourceGroup = (SourceGroup)this.wizard.getProperty("sourceGroup");
            if (tmpTargetFolder == null) {
                String targetPackage = (String)this.wizard.getProperty("targetPackage");
                tmpTargetFolder = SourceGroupSupport.getFolderForPackage(sourceGroup, targetPackage, true);
            }
            final FileObject targetFolder = tmpTargetFolder;
            final GenericResourceBean[] resourceBeans = this.getResourceBeans(this.wizard);
            final FileObject restAppPack = restAppPackage == null ? null : SourceGroupSupport.getFolderForPackage(sourceGroup, restAppPackage, true);
            final String appClassName = restAppClass;
            this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (restAppPack != null && appClassName != null) {
                            RestUtils.createApplicationConfigClass(restAppPack, appClassName);
                        }
                        for (GenericResourceBean bean : resourceBeans) {
                            result.addAll(new GenericResourceGenerator(targetFolder, bean).generate(pHandle));
                        }
                        restSupport.configure(new String[]{PatternResourcesIterator.this.wizard.getProperty("resourcePackage").toString()});
                        for (FileObject fobj : result) {
                            DataObject dobj = DataObject.find((FileObject)fobj);
                            EditorCookie cookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
                            cookie.open();
                        }
                    }
                    catch (Exception iox) {
                        Exceptions.printStackTrace((Throwable)iox);
                    }
                    finally {
                        pHandle.finish();
                        dialog.close();
                    }
                }
            });
            this.generatorTask.schedule(50);
            Object[] params = new Object[5];
            params[0] = "JAX-RS";
            params[1] = project.getClass().getName();
            J2eeModule j2eeModule = RestUtils.getJ2eeModule(project);
            params[2] = j2eeModule == null ? null : j2eeModule.getModuleVersion() + "(WAR)";
            params[3] = "REST FROM PATTERNS";
            params[4] = ((PatternResourcesSetupPanel.Pattern)((Object)this.wizard.getProperty("SelectedPattern"))).toString();
            LogUtils.logWsWizard((Object[])params);
            dialog.open();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    private GenericResourceBean[] getResourceBeans(WizardDescriptor wizard) {
        PatternResourcesSetupPanel.Pattern p = (PatternResourcesSetupPanel.Pattern)((Object)wizard.getProperty("SelectedPattern"));
        if (p == PatternResourcesSetupPanel.Pattern.CONTAINER) {
            return this.getContainerItemBeans(wizard, GenericResourceBean.CONTAINER_METHODS);
        }
        if (p == PatternResourcesSetupPanel.Pattern.STANDALONE) {
            return this.getPlainResourceBeans(wizard);
        }
        if (p == PatternResourcesSetupPanel.Pattern.CLIENTCONTROLLED) {
            return this.getContainerItemBeans(wizard, GenericResourceBean.CLIENT_CONTROL_CONTAINER_METHODS);
        }
        throw new IllegalArgumentException("Invalid pattern " + (Object)((Object)p));
    }

    private GenericResourceBean[] getPlainResourceBeans(WizardDescriptor wizard) {
        String className = (String)wizard.getProperty("ResourceClass");
        String packageName = (String)wizard.getProperty("resourcePackage");
        String uriTemplate = (String)wizard.getProperty("ResourceURI");
        Constants.MimeType[] mimeTypes = (Constants.MimeType[])wizard.getProperty("MimeTypes");
        String[] types = Util.ensureTypes((String[])wizard.getProperty("RepresentationTypes"));
        Constants.HttpMethodType[] methods = GenericResourceBean.STAND_ALONE_METHODS;
        GenericResourceBean bean = new GenericResourceBean(className, packageName, uriTemplate, mimeTypes, types, methods);
        return new GenericResourceBean[]{bean};
    }

    private GenericResourceBean[] getContainerItemBeans(WizardDescriptor wizard, Constants.HttpMethodType[] containerMethods) {
        String className = (String)wizard.getProperty("ItemResourceClass");
        String packageName = (String)wizard.getProperty("resourcePackage");
        String uriTemplate = (String)wizard.getProperty("ItemResourceURI");
        Constants.MimeType[] mimeTypes = (Constants.MimeType[])wizard.getProperty("ItemMimeTypes");
        String[] types = Util.ensureTypes((String[])wizard.getProperty("RepresentationTypes"));
        Constants.HttpMethodType[] methods = GenericResourceBean.ITEM_METHODS;
        GenericResourceBean bean = new GenericResourceBean(className, packageName, uriTemplate, mimeTypes, types, methods);
        bean.setGenerateUriTemplate(false);
        bean.setRootResource(false);
        String containerName = (String)wizard.getProperty("ContainerResourceClass");
        String containerUri = (String)wizard.getProperty("ContainerResourceURI");
        types = Util.ensureTypes((String[])wizard.getProperty("ContainerRepresentationTypes"));
        GenericResourceBean containerBean = new GenericResourceBean(containerName, packageName, containerUri, mimeTypes, types, containerMethods);
        containerBean.addSubResource(bean);
        return new GenericResourceBean[]{bean, containerBean};
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        wizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(ClientStubsIterator.class, (String)"Templates/WebServices/RestServicesFromPatterns"));
        String step1Name = NbBundle.getMessage(PatternResourcesIterator.class, (String)"LBL_Select_Pattern");
        PatternSelectionPanel patternPanel = new PatternSelectionPanel(step1Name, wizard);
        String step2Name = NbBundle.getMessage(PatternResourcesIterator.class, (String)"LBL_Specify_Resource_Class");
        PatternResourcesSetupPanel containerPanel = new PatternResourcesSetupPanel(step2Name, wizard);
        this.panels = new AbstractPanel[]{patternPanel, containerPanel};
        this.current = 0;
        String[] names = new String[]{step1Name, step2Name};
        Util.mergeSteps(wizard, this.panels, names);
        containerPanel.saveStepsAndIndex();
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.panels = null;
        this.current = 0;
    }

    public AbstractPanel current() {
        return this.panels[this.current];
    }

    public String name() {
        return NbBundle.getMessage(PatternResourcesIterator.class, (String)"Templates/WebServices/RestServicesFromPatterns");
    }

    public boolean hasNext() {
        return this.current < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.current > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.current() instanceof PatternSelectionPanel) {
            PatternResourcesSetupPanel.Pattern p = ((PatternSelectionPanel)this.current()).getSelectedPattern();
            assert (this.panels[this.current + 1] instanceof PatternResourcesSetupPanel) : "Expecting GenericRestServicePanel after Pattern panel";
            ((PatternResourcesSetupPanel)this.panels[this.current + 1]).setCurrentPattern(p);
        }
        ++this.current;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.current;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

