/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.SourcePanel;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JerseyPanel
extends JPanel
implements ChangeListener,
AbstractPanel.Settings {
    private static final long serialVersionUID = 5841706512529345806L;
    private JSeparator jSeparator1;
    private JTextField restAppClass;
    private JLabel restAppClassLbl;
    private JComboBox restAppPackage;
    private JLabel restAppPckgLbl;
    private JCheckBox useJersey;
    private SourcePanel sourcePanel;
    private SourceGroup sourceGroup;
    private List<ChangeListener> listeners;

    public JerseyPanel(SourcePanel sourcePanel) {
        this.initComponents();
        this.listeners = new ArrayList<ChangeListener>(1);
        this.sourcePanel = sourcePanel;
        this.useJersey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (JerseyPanel.this.useJersey.isSelected()) {
                    JerseyPanel.this.setEnabledAppConfig(false);
                } else {
                    JerseyPanel.this.setEnabledAppConfig(true);
                }
                JerseyPanel.this.fireChange();
            }
        });
        this.restAppPackage.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JerseyPanel.this.fireChange();
            }
        });
        this.restAppPackage.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JerseyPanel.this.fireChange();
            }
        });
        this.restAppClass.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JerseyPanel.this.fireChange();
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        SourceGroup group = this.getSourceGroup();
        if (group != null && !group.equals(this.sourceGroup)) {
            this.sourceGroup = group;
            this.updateSourceGroupPackages();
        }
    }

    @Override
    public void read(WizardDescriptor wizard) {
        String appPackage;
        this.sourceGroup = this.getSourceGroup();
        this.restAppPackage.setRenderer(PackageView.listRenderer());
        this.updateSourceGroupPackages();
        Object property = wizard.getProperty("useJersey");
        if (property != null && property.toString().equals("true")) {
            this.useJersey.setSelected(true);
        }
        if ((appPackage = (String)wizard.getProperty("restApplicationConfigPackage")) != null) {
            ((JTextComponent)this.restAppPackage.getEditor().getEditorComponent()).setText(appPackage);
        } else {
            ((JTextComponent)this.restAppPackage.getEditor().getEditorComponent()).setText("org.netbeans.rest.application.config");
        }
        String appClass = (String)wizard.getProperty("restApplicatoin");
        if (appClass != null) {
            this.restAppClass.setText(appClass);
        }
    }

    @Override
    public void store(WizardDescriptor wizard) {
        wizard.putProperty("restApplicationConfigPackage", (Object)this.getPackage());
        wizard.putProperty("restApplicatoin", (Object)this.restAppClass.getText().trim());
        wizard.putProperty("useJersey", (Object)this.useJersey.isSelected());
    }

    @Override
    public boolean valid(WizardDescriptor wizard) {
        AbstractPanel.clearErrorMessage(wizard);
        if (this.useJersey.isSelected()) {
            return true;
        }
        String packageName = this.getPackage();
        String className = this.restAppClass.getText().trim();
        if (className.length() == 0 || !Utilities.isJavaIdentifier((String)className)) {
            AbstractPanel.setErrorMessage(wizard, "MSG_InvalidApplicationClassName");
            return false;
        }
        if (!Util.isValidPackageName(packageName)) {
            AbstractPanel.setErrorMessage(wizard, "MSG_InvalidPackageName");
            return false;
        }
        return true;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public double getRenderedHeight() {
        return this.restAppClass.getLocation().getY() + (double)this.restAppClass.getHeight() + this.getGap();
    }

    private double getGap() {
        double gap = this.restAppClass.getLocation().getY();
        return gap -= this.restAppPackage.getLocation().getY() + (double)this.restAppPackage.getHeight();
    }

    private SourceGroup getSourceGroup() {
        return this.sourcePanel.getSourceGroup();
    }

    private void updateSourceGroupPackages() {
        SourceGroup sourceGroup = this.getSourceGroup();
        if (sourceGroup != null) {
            ComboBoxModel model = PackageView.createListView((SourceGroup)sourceGroup);
            if (model.getSelectedItem() != null && model.getSelectedItem().toString().startsWith("META-INF") && model.getSize() > 1) {
                model.setSelectedItem(model.getElementAt(1));
            }
            this.restAppPackage.setModel(model);
        }
    }

    private String getPackage() {
        return ((JTextComponent)this.restAppPackage.getEditor().getEditorComponent()).getText();
    }

    private void setEnabledAppConfig(boolean enable) {
        this.restAppClass.setEnabled(enable);
        this.restAppClassLbl.setEnabled(enable);
        this.restAppPackage.setEnabled(enable);
        this.restAppPckgLbl.setEnabled(enable);
    }

    private void fireChange() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.useJersey = new JCheckBox();
        this.restAppPckgLbl = new JLabel();
        this.restAppPackage = new JComboBox();
        this.restAppClassLbl = new JLabel();
        this.restAppClass = new JTextField();
        this.setPreferredSize(new Dimension(450, 115));
        Mnemonics.setLocalizedText((AbstractButton)this.useJersey, (String)NbBundle.getMessage(JerseyPanel.class, (String)"LBL_UseJersey"));
        this.useJersey.setActionCommand(NbBundle.getMessage(JerseyPanel.class, (String)"JerseyPanel.useJersey.actionCommand"));
        this.restAppPckgLbl.setLabelFor(this.restAppPackage);
        Mnemonics.setLocalizedText((JLabel)this.restAppPckgLbl, (String)NbBundle.getMessage(JerseyPanel.class, (String)"LBL_AppConfigPackage"));
        this.restAppPackage.setEditable(true);
        this.restAppClassLbl.setLabelFor(this.restAppClass);
        Mnemonics.setLocalizedText((JLabel)this.restAppClassLbl, (String)NbBundle.getMessage(JerseyPanel.class, (String)"LBL_AppConfigClass"));
        this.restAppClass.setText(NbBundle.getMessage(JerseyPanel.class, (String)"JerseyPanel.restAppClass.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useJersey).addGroup(layout.createSequentialGroup().addComponent(this.restAppPckgLbl).addGap(25, 25, 25).addComponent(this.restAppPackage, 0, 288, Short.MAX_VALUE))).addGap(0, 10, 10)).addGroup(layout.createSequentialGroup().addComponent(this.restAppClassLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.restAppClass, -1, 285, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useJersey).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.restAppPckgLbl).addComponent(this.restAppPackage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.restAppClassLbl).addComponent(this.restAppClass, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.useJersey.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JerseyPanel.class, (String)"ACSN_UseJersey"));
        this.useJersey.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JerseyPanel.class, (String)"ACSD_UseJersey"));
        this.restAppPckgLbl.getAccessibleContext().setAccessibleName(this.restAppPackage.getAccessibleContext().getAccessibleName());
        this.restAppPckgLbl.getAccessibleContext().setAccessibleDescription(this.restAppPackage.getAccessibleContext().getAccessibleDescription());
        this.restAppPackage.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JerseyPanel.class, (String)"ACSN_AppConfigPackage"));
        this.restAppPackage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JerseyPanel.class, (String)"ACSD_AppConfigPackage"));
        this.restAppClassLbl.getAccessibleContext().setAccessibleName(this.restAppClass.getAccessibleContext().getAccessibleName());
        this.restAppClassLbl.getAccessibleContext().setAccessibleDescription(this.restAppClass.getAccessibleContext().getAccessibleDescription());
        this.restAppClass.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JerseyPanel.class, (String)"ACSN_AppConfigClass"));
        this.restAppClass.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JerseyPanel.class, (String)"ACSD_AppConfigClass"));
    }
}

