/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.SourceGroupUISupport;
import org.netbeans.modules.websvc.rest.wizard.SourcePanel;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class EntityResourcesSetupPanelVisual
extends JPanel
implements AbstractPanel.Settings,
SourcePanel {
    private static final long serialVersionUID = -2519548265504277682L;
    private Project project;
    private WizardDescriptor wizard;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean noController;
    private JComboBox controllerPackageComboBox;
    private JLabel controllerPackageLabel;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JComboBox resourcePackageComboBox;
    private JLabel resourcePackageLabel;

    public EntityResourcesSetupPanelVisual(String name, boolean noController) {
        this.noController = noController;
        this.initComponents();
        this.setName(name);
        this.resourcePackageComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                EntityResourcesSetupPanelVisual.this.changeSupport.fireChange();
            }
        });
        if (noController) {
            this.controllerPackageLabel.setVisible(false);
            this.controllerPackageComboBox.setVisible(false);
        } else {
            this.controllerPackageComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    EntityResourcesSetupPanelVisual.this.changeSupport.fireChange();
                }
            });
        }
    }

    @Override
    public SourceGroup getSourceGroup() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    private void initComponents() {
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.resourcePackageLabel = new JLabel();
        this.resourcePackageComboBox = new JComboBox();
        this.controllerPackageLabel = new JLabel();
        this.controllerPackageComboBox = new JComboBox();
        this.setPreferredSize(new Dimension(450, 100));
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        this.projectTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityResourcesSetupPanelVisual.this.projectTextFieldActionPerformed(evt);
            }
        });
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"LBL_SrcLocation"));
        this.locationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityResourcesSetupPanelVisual.this.locationComboBoxActionPerformed(evt);
            }
        });
        this.resourcePackageLabel.setLabelFor(this.resourcePackageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.resourcePackageLabel, (String)NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"LBL_Package"));
        this.resourcePackageComboBox.setEditable(true);
        this.resourcePackageComboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EntityResourcesSetupPanelVisual.this.resourcePackageComboBoxPropertyChange(evt);
            }
        });
        this.controllerPackageLabel.setLabelFor(this.controllerPackageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.controllerPackageLabel, (String)NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"LBL_ControllerDir"));
        this.controllerPackageComboBox.setEditable(true);
        this.controllerPackageComboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EntityResourcesSetupPanelVisual.this.controllerPackageComboBoxPropertyChange(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resourcePackageLabel).addComponent(this.controllerPackageLabel, -1, 124, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectLabel).addComponent(this.locationLabel)).addGap(79, 79, 79))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.locationComboBox, GroupLayout.Alignment.LEADING, 0, 320, Short.MAX_VALUE).addComponent(this.projectTextField, -1, 320, Short.MAX_VALUE).addComponent(this.resourcePackageComboBox, GroupLayout.Alignment.LEADING, 0, 320, Short.MAX_VALUE).addComponent(this.controllerPackageComboBox, GroupLayout.Alignment.LEADING, 0, 320, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.projectTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationLabel).addComponent(this.locationComboBox, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resourcePackageLabel).addComponent(this.resourcePackageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.controllerPackageLabel).addComponent(this.controllerPackageComboBox, -2, -1, -2))));
        this.projectLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"Project"));
        this.projectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_Project"));
        this.projectTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"Project"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_Project"));
        this.locationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"Location"));
        this.locationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_Location"));
        this.locationComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"Location"));
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_Location"));
        this.resourcePackageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"ResourcePackage"));
        this.resourcePackageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_ResourcePackage"));
        this.resourcePackageComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"ResourcePackage"));
        this.resourcePackageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_ResourcePackage"));
        this.controllerPackageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"ControllerPackage"));
        this.controllerPackageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityResourcesSetupPanelVisual.class, (String)"DESC_ControllerPackage"));
        this.controllerPackageComboBox.getAccessibleContext().setAccessibleName(this.controllerPackageLabel.getAccessibleContext().getAccessibleName());
        this.controllerPackageComboBox.getAccessibleContext().setAccessibleDescription(this.controllerPackageLabel.getAccessibleContext().getAccessibleDescription());
    }

    private void locationComboBoxActionPerformed(ActionEvent evt) {
        this.locationChanged();
    }

    private void resourcePackageComboBoxPropertyChange(PropertyChangeEvent evt) {
        this.changeSupport.fireChange();
    }

    private void controllerPackageComboBoxPropertyChange(PropertyChangeEvent evt) {
        this.changeSupport.fireChange();
    }

    private void projectTextFieldActionPerformed(ActionEvent evt) {
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public boolean valid(WizardDescriptor wizard) {
        AbstractPanel.clearErrorMessage(wizard);
        if (this.getSourceGroup() == null) {
            AbstractPanel.setErrorMessage(wizard, "MSG_NoJavaSourceRoots");
        } else {
            if (!Util.isValidPackageName(this.getResourcePackage())) {
                AbstractPanel.setErrorMessage(wizard, "MSG_InvalidResourcePackageName");
                return false;
            }
            if (!this.noController && !Util.isValidPackageName(this.getControllerPackage())) {
                AbstractPanel.setErrorMessage(wizard, "MSG_InvalidControllerPackageName");
                return false;
            }
        }
        return true;
    }

    public String getResourcePackage() {
        return ((JTextComponent)this.resourcePackageComboBox.getEditor().getEditorComponent()).getText();
    }

    public String getControllerPackage() {
        return ((JTextComponent)this.controllerPackageComboBox.getEditor().getEditorComponent()).getText();
    }

    private void setResourcePackage(String text) {
        ((JTextComponent)this.resourcePackageComboBox.getEditor().getEditorComponent()).setText(text);
    }

    private void setControllerPackage(String text) {
        ((JTextComponent)this.controllerPackageComboBox.getEditor().getEditorComponent()).setText(text);
    }

    private void locationChanged() {
        this.updateSourceGroupPackages();
        this.changeSupport.fireChange();
    }

    @Override
    public void read(WizardDescriptor settings) {
        if (this.project != null) {
            return;
        }
        this.wizard = settings;
        this.project = Templates.getProject((WizardDescriptor)settings);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        SourceGroup[] sourceGroups = SourceGroupSupport.getJavaSourceGroups(this.project);
        SourceGroupUISupport.connect(this.locationComboBox, sourceGroups);
        this.resourcePackageComboBox.setRenderer(PackageView.listRenderer());
        if (!this.noController) {
            this.controllerPackageComboBox.setRenderer(PackageView.listRenderer());
        }
        this.updateSourceGroupPackages();
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)settings);
        SourceGroup targetSourceGroup = null;
        String targetPackage = "";
        if (targetFolder != null && (targetSourceGroup = SourceGroupSupport.findSourceGroupForFile(sourceGroups, targetFolder)) != null) {
            this.locationComboBox.setSelectedItem(targetSourceGroup);
            targetPackage = SourceGroupSupport.getPackageForFolder(targetSourceGroup, targetFolder);
        }
        targetPackage = targetPackage.length() == 0 ? "" : targetPackage + ".";
        String resourcePackage = targetPackage + "service";
        this.setResourcePackage(resourcePackage);
        this.addComboBoxListener(this.resourcePackageComboBox);
        if (!this.noController) {
            String controllerPackage = targetPackage + "controller";
            this.setControllerPackage(controllerPackage);
            this.addComboBoxListener(this.controllerPackageComboBox);
        }
    }

    @Override
    public void store(WizardDescriptor settings) {
        settings.putProperty("resourcePackage", (Object)this.getResourcePackage());
        settings.putProperty("controllerPackage", (Object)this.getControllerPackage());
        settings.putProperty("targetSourceRoot", (Object)this.getSourceGroup().getRootFolder());
    }

    private void addComboBoxListener(JComboBox comboBox) {
        JTextComponent text = (JTextComponent)comboBox.getEditor().getEditorComponent();
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
            }
        });
    }

    private void updateSourceGroupPackages() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel model = PackageView.createListView((SourceGroup)sourceGroup);
            if (model.getSize() > 0) {
                model.setSelectedItem(model.getElementAt(0));
            }
            this.resourcePackageComboBox.setModel(model);
            model = PackageView.createListView((SourceGroup)sourceGroup);
            if (model.getSize() > 0) {
                model.setSelectedItem(model.getElementAt(0));
            }
            this.controllerPackageComboBox.setModel(model);
        }
    }
}

