/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.EntityResourcesSetupPanelVisual;
import org.netbeans.modules.websvc.rest.wizard.EntitySelectionPanel;
import org.netbeans.modules.websvc.rest.wizard.JerseyPanel;
import org.netbeans.modules.websvc.rest.wizard.PatternResourcesSetupPanel;
import org.netbeans.modules.websvc.rest.wizard.SourcePanel;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class EntityResourcesSetupPanel
extends AbstractPanel {
    private FinishEntityPanel component;
    private boolean withoutController;

    public EntityResourcesSetupPanel(String name, WizardDescriptor wizardDescriptor, boolean noController) {
        super(name, wizardDescriptor);
        this.withoutController = noController;
    }

    @Override
    public boolean isFinishPanel() {
        return true;
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            this.component = new FinishEntityPanel(this.panelName, this.withoutController);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    @Override
    public boolean isValid() {
        this.getComponent();
        return this.component.valid(this.wizardDescriptor);
    }

    @Override
    public void readSettings(Object settings) {
        super.readSettings(settings);
        if (this.wizardDescriptor.getProperty("createPersistenceUnit") != null) {
            Project project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
            try {
                org.netbeans.modules.j2ee.persistence.wizard.Util.createPersistenceUnitUsingWizard((Project)project, null, (PersistenceUnitWizardPanel.TableGeneration)PersistenceUnitWizardPanel.TableGeneration.NONE);
            }
            catch (InvalidPersistenceXmlException e) {
                Logger.getLogger(EntitySelectionPanel.class.getName()).log(Level.WARNING, null, e);
            }
        }
    }

    @Override
    public void storeSettings(Object settings) {
        super.storeSettings(settings);
        if (Util.getPersistenceUnit(this.wizardDescriptor, Templates.getProject((WizardDescriptor)this.wizardDescriptor)) != null) {
            this.wizardDescriptor.putProperty("createPersistenceUnit", null);
        }
    }

    static class FinishEntityPanel
    extends JPanel
    implements AbstractPanel.Settings,
    SourcePanel {
        private static final long serialVersionUID = -1899506976995286218L;
        private EntityResourcesSetupPanelVisual mainPanel;
        private JerseyPanel jerseyPanel;

        FinishEntityPanel(String name, boolean withoutController) {
            this.mainPanel = new EntityResourcesSetupPanelVisual(name, withoutController);
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.mainPanel);
            this.jerseyPanel = new JerseyPanel(this);
            this.mainPanel.addChangeListener(this.jerseyPanel);
            this.add(this.jerseyPanel);
            this.setName(name);
        }

        @Override
        public SourceGroup getSourceGroup() {
            return this.mainPanel.getSourceGroup();
        }

        @Override
        public void read(final WizardDescriptor wizard) {
            this.mainPanel.read(wizard);
            Project project = Templates.getProject((WizardDescriptor)wizard);
            final WebRestSupport restSupport = (WebRestSupport)project.getLookup().lookup(WebRestSupport.class);
            boolean hasSpringSupport = restSupport.hasSpringSupport();
            boolean hasJaxRs = restSupport.hasJaxRsApi();
            if (hasSpringSupport) {
                wizard.putProperty("useJersey", (Object)true);
            }
            if (this.jerseyPanel != null) {
                if (!hasJaxRs || hasSpringSupport || restSupport.isRestSupportOn()) {
                    this.remove(this.jerseyPanel);
                    this.jerseyPanel = null;
                }
                ScanDialog.runWhenScanFinished((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        List restApplications = restSupport.getRestApplications();
                        boolean configured = restApplications != null && !restApplications.isEmpty();
                        FinishEntityPanel.this.configureJersey(configured, wizard);
                    }
                }, (String)NbBundle.getMessage(PatternResourcesSetupPanel.class, (String)"LBL_SearchAppConfig"));
            }
        }

        @Override
        public void store(WizardDescriptor wizard) {
            this.mainPanel.store(wizard);
            if (this.hasJerseyPanel()) {
                this.jerseyPanel.store(wizard);
            }
        }

        @Override
        public boolean valid(WizardDescriptor wizard) {
            boolean isValid = this.mainPanel.valid(wizard);
            if (isValid && this.hasJerseyPanel()) {
                return this.jerseyPanel.valid(wizard);
            }
            return isValid;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.mainPanel.addChangeListener(l);
            if (this.hasJerseyPanel()) {
                this.jerseyPanel.addChangeListener(l);
            }
        }

        private boolean hasJerseyPanel() {
            return this.jerseyPanel != null;
        }

        private void configureJersey(boolean remove, WizardDescriptor wizard) {
            if (this.jerseyPanel == null) {
                return;
            }
            if (remove) {
                this.remove(this.jerseyPanel);
                this.jerseyPanel = null;
            } else {
                this.jerseyPanel.read(wizard);
            }
        }
    }
}

