/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.EntityResourcesGenerator;
import org.netbeans.modules.websvc.rest.codegen.EntityResourcesGeneratorFactory;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceModelBuilder;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.support.PersistenceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.EntityResourcesSetupPanel;
import org.netbeans.modules.websvc.rest.wizard.EntitySelectionPanel;
import org.netbeans.modules.websvc.rest.wizard.ProgressDialog;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EntityResourcesIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -1555851385128542149L;
    private int index;
    private transient WizardDescriptor.Panel<?>[] panels;
    private transient RequestProcessor.Task transformTask;

    public Set<DataObject> instantiate(TemplateWizard wizard) throws IOException {
        final Project project = Templates.getProject((WizardDescriptor)wizard);
        String restAppPackage = null;
        String restAppClass = null;
        final RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport instanceof WebRestSupport) {
            Object useJersey = wizard.getProperty("useJersey");
            if (useJersey != null && useJersey.toString().equals("true")) {
                ((WebRestSupport)restSupport).enableRestSupport(WebRestSupport.RestConfig.DD);
            } else {
                restAppPackage = (String)wizard.getProperty("restApplicationConfigPackage");
                restAppClass = (String)wizard.getProperty("restApplicatoin");
                if (restAppPackage != null && restAppClass != null) {
                    ((WebRestSupport)restSupport).enableRestSupport(WebRestSupport.RestConfig.IDE);
                }
            }
        }
        if (restSupport != null) {
            restSupport.ensureRestDevelopmentReady();
        }
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
        FileObject wizardSrcRoot = (FileObject)wizard.getProperty("targetSourceRoot");
        if (wizardSrcRoot != null) {
            targetFolder = wizardSrcRoot;
        }
        String targetPackage = SourceGroupSupport.packageForFolder(targetFolder);
        final String resourcePackage = (String)wizard.getProperty("resourcePackage");
        String controllerPackage = (String)wizard.getProperty("controllerPackage");
        List entities = (List)wizard.getProperty("EntityClass");
        PersistenceHelper.PersistenceUnit pu = (PersistenceHelper.PersistenceUnit)wizard.getProperty("PersistenceUnit");
        EntityResourceModelBuilder builder = new EntityResourceModelBuilder(project, entities);
        EntityResourceBeanModel model = builder.build();
        final EntityResourcesGenerator generator = EntityResourcesGeneratorFactory.newInstance(project);
        generator.initialize(model, project, targetFolder, targetPackage, resourcePackage, controllerPackage, pu);
        final ProgressDialog progressDialog = new ProgressDialog(NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_RestSevicicesFromEntitiesProgress"));
        final FileObject restAppPack = restAppPackage == null ? null : FileUtil.createFolder((FileObject)targetFolder, (String)restAppPackage.replace('.', '/'));
        final String appClassName = restAppClass;
        this.transformTask = RequestProcessor.getDefault().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (restAppPack != null && appClassName != null) {
                        RestUtils.createApplicationConfigClass(restAppPack, appClassName);
                    }
                    RestUtils.disableRestServicesChangeListner(project);
                    generator.generate(progressDialog.getProgressHandle());
                    restSupport.configure(new String[]{resourcePackage});
                }
                catch (Exception iox) {
                    Exceptions.printStackTrace((Throwable)iox);
                }
                finally {
                    RestUtils.enableRestServicesChangeListner(project);
                    progressDialog.close();
                }
            }
        });
        this.transformTask.schedule(50);
        Object[] params = new Object[5];
        params[0] = "JAX-RS";
        params[1] = project.getClass().getName();
        J2eeModule j2eeModule = RestUtils.getJ2eeModule(project);
        params[2] = j2eeModule == null ? null : j2eeModule.getModuleVersion() + "(WAR)";
        params[3] = "REST FROM ENTITY";
        LogUtils.logWsWizard((Object[])params);
        progressDialog.open();
        return Collections.singleton(DataFolder.findFolder((FileObject)targetFolder));
    }

    public void initialize(TemplateWizard wizard) {
        this.index = 0;
        EntitySelectionPanel secondPanel = new EntitySelectionPanel(NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_EntityClasses"), (WizardDescriptor)wizard);
        EntityResourcesSetupPanel thirdPanel = new EntityResourcesSetupPanel(NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_RestResourcesAndClasses"), (WizardDescriptor)wizard, RestUtils.isJavaEE6(Templates.getProject((WizardDescriptor)wizard)) || RestUtils.hasSpringSupport(Templates.getProject((WizardDescriptor)wizard)));
        this.panels = new WizardDescriptor.Panel[]{secondPanel, thirdPanel};
        String[] names = new String[]{NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_EntityClasses"), NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_RestResourcesAndClasses")};
        wizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(EntityResourcesIterator.class, (String)"Templates/WebServices/RestServicesFromEntities"));
        Util.mergeSteps((WizardDescriptor)wizard, this.panels, names);
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_WizardTitle_FromEntity");
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

