/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.netbeans.modules.websvc.rest.codegen.model.State;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.BrowseFolders;
import org.netbeans.modules.websvc.rest.wizard.SourceGroupUISupport;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ClientStubsSetupPanelVisual
extends JPanel
implements AbstractPanel.Settings {
    private Project project;
    private FileObject stubRootFolder;
    private SourceGroup[] sourceGroups;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private FileObject wadlFile;
    private boolean isProjectSelection = true;
    private JButton addButton;
    private JButton browseButton;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JComboBox locationCB;
    private JLabel locationLabel;
    private JCheckBox overwriteCheckBox;
    private JLabel projectLabel;
    private JList projectList;
    private JRadioButton projectRadioButton;
    private JTextField projectTextField;
    private JButton removeButton;
    private ButtonGroup sourceButtons;
    private JButton wadlBrowseButton;
    private JRadioButton wadlRadioButton;
    private JTextField wadlTextField;

    public ClientStubsSetupPanelVisual(String name) {
        super.setName(name);
        this.initComponents();
        this.sourceButtons.add(this.projectRadioButton);
        this.sourceButtons.add(this.wadlRadioButton);
        this.projectList.addListSelectionListener(new ProjectListSelectionListener());
        this.projectRadioButton.setSelected(this.isProjectSelection);
        this.projectSelection(this.isProjectSelection);
    }

    @Override
    public void read(WizardDescriptor wizard) {
        if (this.project == null) {
            this.project = Templates.getProject((WizardDescriptor)wizard);
            this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
            this.sourceGroups = Util.getSourceGroups(this.project);
            SourceGroupUISupport.connect(this.locationCB, this.sourceGroups);
            String folderName = "rest";
            this.folderTextField.setText(folderName);
        }
    }

    @Override
    public void store(WizardDescriptor wizard) {
        String path;
        DefaultListModel model = (DefaultListModel)this.projectList.getModel();
        Project[] projects = new Project[model.size()];
        for (int i = 0; i < projects.length; ++i) {
            projects[i] = ((ProjectInformation)model.get(i)).getProject();
        }
        wizard.putProperty("ProjectSelection", (Object)this.isProjectSelection);
        wizard.putProperty("ProjectToStub", (Object)projects);
        if (this.wadlFile != null) {
            wizard.putProperty("WadlToStub", (Object)this.wadlFile);
        }
        wizard.putProperty("OverwriteExisting", (Object)this.overwriteCheckBox.isSelected());
        if (this.stubRootFolder == null && this.sourceGroups.length > 0) {
            SourceGroup sg = (SourceGroup)this.locationCB.getSelectedItem();
            this.stubRootFolder = sg.getRootFolder();
        }
        if (this.stubRootFolder != null) {
            wizard.putProperty("StubRootFolder", (Object)this.stubRootFolder);
        }
        path = (path = this.folderTextField.getText()) != null && path.trim().length() > 0 ? this.folderTextField.getText() : "rest";
        wizard.putProperty("StubFolderName", (Object)path);
    }

    @Override
    public boolean valid(WizardDescriptor wizard) {
        RestSupport restSupport = (RestSupport)this.project.getLookup().lookup(RestSupport.class);
        if (restSupport == null || restSupport.getAntProjectHelper() == null) {
            AbstractPanel.setErrorMessage(wizard, "MSG_NotSupportedProjectType");
            return false;
        }
        if (this.isProjectSelection) {
            DefaultListModel model = (DefaultListModel)this.projectList.getModel();
            if (model.getSize() < 1) {
                AbstractPanel.setInfoMessage(wizard, "MSG_NoProjects");
                return false;
            }
        } else {
            if (this.wadlTextField.getText() == null || this.wadlTextField.getText().trim().equals("")) {
                AbstractPanel.setInfoMessage(wizard, "MSG_NoWadlFile");
                return false;
            }
            String fileName = this.wadlTextField.getText().trim();
            State state = this.validateWadlFile(fileName);
            if (state != State.VALID) {
                AbstractPanel.setErrorMessage(wizard, "MSG_" + state.value());
                return false;
            }
        }
        AbstractPanel.clearErrorMessage(wizard);
        return true;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChange() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private boolean addProject(File[] projectDirs) {
        boolean changed = false;
        ArrayList<Project> rejecteds = new ArrayList<Project>();
        DefaultListModel listModel = (DefaultListModel)this.projectList.getModel();
        for (File projectDir : projectDirs) {
            try {
                WebRestSupport webRestSupport;
                FileObject projectRoot = FileUtil.toFileObject((File)projectDir);
                Project p = ProjectManager.getDefault().findProject(projectRoot);
                boolean reject = true;
                RestSupport restSupport = (RestSupport)p.getLookup().lookup(RestSupport.class);
                if (restSupport != null && restSupport instanceof WebRestSupport && ((webRestSupport = (WebRestSupport)restSupport).getApplicationPathFromDD() != null || webRestSupport.getRestApplications().size() > 0)) {
                    reject = false;
                }
                if (reject) {
                    rejecteds.add(p);
                    continue;
                }
                ProjectInformation pInfo = ProjectUtils.getInformation((Project)p);
                if (listModel.contains(pInfo)) continue;
                listModel.addElement(pInfo);
                changed = true;
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        if (rejecteds.size() > 0) {
            String msg = NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"MSG_ProjectsWithoutREST");
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
        return changed;
    }

    private void initComponents() {
        this.sourceButtons = new ButtonGroup();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationCB = new JComboBox();
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.projectList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.overwriteCheckBox = new JCheckBox();
        this.projectRadioButton = new JRadioButton();
        this.wadlRadioButton = new JRadioButton();
        this.wadlBrowseButton = new JButton();
        this.wadlTextField = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        this.locationLabel.setLabelFor(this.locationCB);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_Location"));
        this.folderLabel.setLabelFor(this.folderTextField);
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_Folder"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_BrowseFolder"));
        this.browseButton.setToolTipText(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("HINT_BrowseFolder"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientStubsSetupPanelVisual.this.browseButtonActionPerformed(evt);
            }
        });
        this.projectList.setModel(new DefaultListModel());
        this.projectList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ProjectInformation pInfo = (ProjectInformation)value;
                super.getListCellRendererComponent((JList<?>)ClientStubsSetupPanelVisual.this.projectList, pInfo, index, isSelected, cellHasFocus);
                this.setIcon(pInfo.getIcon());
                this.setText(pInfo.getDisplayName());
                this.setToolTipText(pInfo.getDisplayName());
                return this;
            }
        });
        this.projectList.setPreferredSize(new Dimension(0, 200));
        this.jScrollPane1.setViewportView(this.projectList);
        this.projectList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"ProjectList"));
        this.projectList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_ProjectList"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_AddProject"));
        this.addButton.setToolTipText(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"HINT_CustomizerProjectReferences_AddProject"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientStubsSetupPanelVisual.this.addButtonshowProjectDialog(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_RemoveProject"));
        this.removeButton.setToolTipText(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"HINT_CustomizerProjectReferences_RemoveProject"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientStubsSetupPanelVisual.this.removeButtonremoveProject(evt);
            }
        });
        this.overwriteCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.overwriteCheckBox, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_OverwriteExisting"));
        Mnemonics.setLocalizedText((AbstractButton)this.projectRadioButton, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_ProjectsToGenerateStubFor"));
        this.projectRadioButton.setToolTipText(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("DESC_ProjectList"));
        this.projectRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientStubsSetupPanelVisual.this.projectRadioButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.wadlRadioButton, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_WADLToGenerateStubFor"));
        this.wadlRadioButton.setToolTipText(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("HINT_WADLToGenerateStubFor"));
        this.wadlRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientStubsSetupPanelVisual.this.wadlRadioButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.wadlBrowseButton, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_BrowseWadl"));
        this.wadlBrowseButton.setToolTipText(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("HINT_BrowseWadl"));
        this.wadlBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientStubsSetupPanelVisual.this.wadlBrowseButtonActionPerformed(evt);
            }
        });
        this.wadlTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ClientStubsSetupPanelVisual.this.wadlTextFieldFocusLost(evt);
            }
        });
        this.wadlTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ClientStubsSetupPanelVisual.this.wadlTextFieldKeyTyped(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                ClientStubsSetupPanelVisual.this.wadlTextFieldKeyReleased(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2, -1, 589, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.projectRadioButton, GroupLayout.Alignment.LEADING).addComponent(this.wadlRadioButton, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.wadlTextField, GroupLayout.Alignment.LEADING, -1, 434, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 434, Short.MAX_VALUE)).addGap(4, 4, 4)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.folderLabel, -1, -1, Short.MAX_VALUE).addComponent(this.projectLabel, -1, -1, Short.MAX_VALUE).addComponent(this.locationLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectTextField, GroupLayout.Alignment.TRAILING, -1, 374, Short.MAX_VALUE).addComponent(this.locationCB, GroupLayout.Alignment.TRAILING, 0, 374, Short.MAX_VALUE).addComponent(this.folderTextField, GroupLayout.Alignment.TRAILING, -1, 374, Short.MAX_VALUE)).addGap(6, 6, 6))).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.browseButton).addComponent(this.addButton).addComponent(this.removeButton).addComponent(this.wadlBrowseButton))).addComponent(this.jSeparator1, -1, 589, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.overwriteCheckBox).addContainerGap(376, Short.MAX_VALUE)));
        layout.linkSize(0, this.addButton, this.browseButton, this.removeButton, this.wadlBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectTextField, -2, -1, -2).addComponent(this.projectLabel)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationCB, -2, 25, -2).addComponent(this.locationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseButton).addComponent(this.folderTextField, -2, 23, -2).addComponent(this.folderLabel)).addGap(8, 8, 8).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 105, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wadlRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.wadlBrowseButton).addComponent(this.wadlTextField, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.overwriteCheckBox).addContainerGap()));
        this.projectLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Project"));
        this.projectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_Project"));
        this.projectTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Project"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_Project"));
        this.locationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Location"));
        this.locationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_Location"));
        this.locationCB.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Location"));
        this.locationCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_Location"));
        this.folderLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Folder"));
        this.folderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_Folder"));
        this.folderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Folder"));
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_Folder"));
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Browser"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_BrowseFolder"));
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"AddProject"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_AddProject"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"RemoveProject"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_RemoveProject"));
        this.overwriteCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"OverwriteExistingStubs"));
        this.overwriteCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_OverwriteExisting"));
        this.wadlTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("HINT_WADLToGenerateStubFor"));
        this.wadlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("HINT_WADLToGenerateStubFor"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("Templates/WebServices/RestClientStubs"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("Templates/WebServices/RestClientStubs"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        FileObject fo = BrowseFolders.showDialog(this.sourceGroups, DataFolder.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
        if (fo != null) {
            this.stubRootFolder = fo;
            SourceGroup sg = SourceGroupSupport.findSourceGroupForFile(this.sourceGroups, this.stubRootFolder);
            this.locationCB.getModel().setSelectedItem(sg);
            String path = FileUtil.getRelativePath((FileObject)sg.getRootFolder(), (FileObject)this.stubRootFolder);
            this.folderTextField.setText(path);
            this.fireChange();
        }
    }

    private void removeButtonremoveProject(ActionEvent evt) {
        ListSelectionModel selectionModel = this.projectList.getSelectionModel();
        DefaultListModel model = (DefaultListModel)this.projectList.getModel();
        ArrayList<ProjectInformation> toRemove = new ArrayList<ProjectInformation>();
        if (!selectionModel.isSelectionEmpty()) {
            for (int i = 0; i < model.getSize(); ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                toRemove.add((ProjectInformation)model.elementAt(i));
            }
            for (ProjectInformation pi : toRemove) {
                model.removeElement(pi);
            }
        }
        if (toRemove.size() > 0) {
            this.fireChange();
        }
    }

    private void addButtonshowProjectDialog(ActionEvent evt) {
        boolean changed;
        JFileChooser chooser = ProjectChooser.projectChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_ProjectChooserTitle"));
        chooser.setDialogType(2);
        String text = NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_SelectOK");
        chooser.setApproveButtonText(text);
        String mnemonic = NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"MNE_SelectOK");
        chooser.setApproveButtonMnemonic(mnemonic.charAt(0));
        chooser.setPreferredSize(new Dimension(650, 380));
        int option = chooser.showOpenDialog(this);
        if (option == 0 && (changed = this.addProject(chooser.getSelectedFiles()))) {
            this.fireChange();
        }
    }

    private void projectRadioButtonActionPerformed(ActionEvent evt) {
        this.isProjectSelection = true;
        this.projectSelection(this.isProjectSelection);
        this.fireChange();
    }

    private void projectSelection(boolean select) {
        this.addButton.setEnabled(select);
        this.wadlBrowseButton.setEnabled(!select);
    }

    private void wadlRadioButtonActionPerformed(ActionEvent evt) {
        this.isProjectSelection = false;
        this.projectSelection(this.isProjectSelection);
        this.fireChange();
    }

    private void wadlBrowseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_WadlChooserTitle"));
        chooser.setDialogType(2);
        String text = NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_SelectOK");
        chooser.setApproveButtonText(text);
        String mnemonic = NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"MNE_SelectOK");
        chooser.setApproveButtonMnemonic(mnemonic.charAt(0));
        chooser.setPreferredSize(new Dimension(650, 380));
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            File f = chooser.getSelectedFile();
            this.wadlTextField.setText(f.getAbsolutePath());
            this.fireChange();
        }
    }

    private void wadlTextFieldFocusLost(FocusEvent evt) {
        this.fireChange();
    }

    private void wadlTextFieldKeyTyped(KeyEvent evt) {
        this.fireChange();
    }

    private void wadlTextFieldKeyReleased(KeyEvent evt) {
        this.fireChange();
    }

    private State validateWadlFile(String fileName) {
        File f = new File(fileName);
        State state = State.INVALID;
        try {
            FileObject newWadl;
            if (f.isFile() && (newWadl = FileUtil.toFileObject((File)f)) != null && (state = new ClientStubModel().createModel(newWadl).validate()) == State.VALID) {
                this.wadlFile = newWadl;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return state;
    }

    private class ProjectListSelectionListener
    implements ListSelectionListener {
        private ProjectListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == ClientStubsSetupPanelVisual.this.projectList) {
                if (ClientStubsSetupPanelVisual.this.projectList.getSelectionModel().isSelectionEmpty()) {
                    ClientStubsSetupPanelVisual.this.removeButton.setEnabled(false);
                } else {
                    ClientStubsSetupPanelVisual.this.removeButton.setEnabled(true);
                }
            }
        }
    }
}

