/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.ClientStubsGenerator;
import org.netbeans.modules.websvc.rest.wizard.ClientStubsSetupPanel;
import org.netbeans.modules.websvc.rest.wizard.ProgressDialog;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ClientStubsIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;
    private RequestProcessor.Task generatorTask;

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            String name = NbBundle.getMessage(ClientStubsSetupPanel.class, (String)"LBL_SelectRestServiceProjects");
            this.panels = new WizardDescriptor.Panel[]{new ClientStubsSetupPanel(name, this.wizard)};
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        final FileObject stubRoot = (FileObject)this.wizard.getProperty("StubRootFolder");
        final String stubFolder = (String)this.wizard.getProperty("StubFolderName");
        final boolean isProjectSelected = (Boolean)this.wizard.getProperty("ProjectSelection");
        final Project[] projectsToStub = (Project[])this.wizard.getProperty("ProjectToStub");
        final FileObject wadlFile = (FileObject)this.wizard.getProperty("WadlToStub");
        final boolean overwrite = (Boolean)this.wizard.getProperty("OverwriteExisting");
        final HashSet result = new HashSet();
        try {
            final ProgressDialog dialog = new ProgressDialog(NbBundle.getMessage(ClientStubsIterator.class, (String)"LBL_ClientStubsProgress"));
            this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgressHandle pHandle = dialog.getProgressHandle();
                    pHandle.start();
                    try {
                        if (isProjectSelected) {
                            for (Project project : projectsToStub) {
                                result.addAll(new ClientStubsGenerator(stubRoot, stubFolder, project, overwrite).generate(pHandle));
                            }
                        } else {
                            result.addAll(new ClientStubsGenerator(stubRoot, stubFolder, wadlFile, overwrite).generate(pHandle));
                        }
                    }
                    catch (Exception iox) {
                        Exceptions.printStackTrace((Throwable)iox);
                    }
                    finally {
                        dialog.close();
                        pHandle.finish();
                    }
                }
            });
            this.generatorTask.schedule(50);
            Object[] params = new Object[5];
            params[0] = "JAX-RS";
            Project project = Templates.getProject((WizardDescriptor)this.wizard);
            params[1] = project.getClass().getName();
            J2eeModule j2eeModule = RestUtils.getJ2eeModule(project);
            params[2] = j2eeModule == null ? null : j2eeModule.getModuleVersion() + "(WAR)";
            params[3] = "REST CLIENT";
            params[4] = this.wizard.getProperty("WadlToStub") != null ? "FROM WADL" : "FROM PROJECT";
            LogUtils.logWsWizard((Object[])params);
            dialog.open();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        wizard.putProperty("NewFileWizard_Title", (Object)this.name());
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return NbBundle.getMessage(ClientStubsIterator.class, (String)"Templates/WebServices/RestClientStubs");
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] beforeSteps = null;
        Object prop = this.wizard.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        if (beforeSteps == null) {
            beforeSteps = new String[]{};
        }
        String[] res = new String[beforeSteps.length - 1 + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeSteps.length - 1 ? beforeSteps[i] : this.panels[i - beforeSteps.length + 1].getComponent().getName();
        }
        return res;
    }
}

