/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.project.SourceGroup;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

public class BrowseFolders
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private SourceGroup[] folders;
    private Class target;
    BeanTreeView btv;
    private static JScrollPane SAMPLE_SCROLL_PANE = new JScrollPane();
    private JPanel folderPanel;
    private JLabel jLabel1;

    public BrowseFolders(SourceGroup[] folders, Class target, String preselectedFileName) {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)(target == DataFolder.class ? "LBL_BrowseFolders" : "LBL_BrowseFiles")));
        this.folders = folders;
        this.target = target;
        this.manager = new ExplorerManager();
        AbstractNode rootNode = new AbstractNode((Children)new SourceGroupsChildren(folders));
        this.manager.setRootContext((Node)rootNode);
        this.btv = new BeanTreeView();
        this.btv.setRootVisible(false);
        this.btv.setSelectionMode(1);
        this.btv.setBorder(SAMPLE_SCROLL_PANE.getBorder());
        this.expandSelection(preselectedFileName);
        this.folderPanel.add((Component)this.btv, "Center");
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void expandSelection(String preselectedFileName) {
        int i;
        Node root = this.manager.getRootContext();
        Children ch = root.getChildren();
        if (ch == Children.LEAF) {
            return;
        }
        Node[] nodes = ch.getNodes(true);
        Node sel = null;
        if (preselectedFileName != null && preselectedFileName.length() > 0) {
            for (i = 0; i < nodes.length; ++i) {
                try {
                    sel = NodeOp.findPath((Node)nodes[i], (Enumeration)NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(preselectedFileName, "/"), String.class, (boolean)false));
                    break;
                }
                catch (NodeNotFoundException e) {
                    continue;
                }
            }
        }
        if (sel == null) {
            this.btv.expandNode(root);
            for (i = 0; i < nodes.length; ++i) {
                this.btv.expandNode(nodes[i]);
                if (i != 0) continue;
                sel = nodes[i];
            }
        }
        if (sel != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{sel});
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.folderPanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BrowseFolders.class, (String)"LBL_SelectFolder"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.folderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.folderPanel, gridBagConstraints);
    }

    public static FileObject showDialog(SourceGroup[] folders, Class target, String preselectedFileName) {
        BrowseFolders bf = new BrowseFolders(folders, target, preselectedFileName);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)bf, NbBundle.getMessage(BrowseFolders.class, (String)(target == DataFolder.class ? "LBL_BrowseFolders" : "LBL_BrowseFiles")), true, 2, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            return bf.getSelectectFileObject();
        }
        return null;
    }

    public FileObject getSelectectFileObject() {
        Node[] selectedNodes = this.getExplorerManager().getSelectedNodes();
        if (selectedNodes == null || selectedNodes.length < 1) {
            return null;
        }
        return (FileObject)selectedNodes[0].getLookup().lookup(FileObject.class);
    }

    private static class FileObjectComparator
    implements Comparator {
        private FileObjectComparator() {
        }

        public int compare(Object o1, Object o2) {
            FileObject fo1 = (FileObject)o1;
            FileObject fo2 = (FileObject)o2;
            return fo1.getName().compareTo(fo2.getName());
        }
    }

    private final class SourceGroupsChildren
    extends Children.Keys {
        private SourceGroup[] groups;
        private SourceGroup group;
        private FileObject fo;

        public SourceGroupsChildren(SourceGroup[] groups) {
            this.groups = groups;
        }

        public SourceGroupsChildren(FileObject fo, SourceGroup group) {
            this.fo = fo;
            this.group = group;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            FileObject fObj = null;
            SourceGroup group = null;
            boolean isFile = false;
            if (key instanceof SourceGroup) {
                fObj = ((SourceGroup)key).getRootFolder();
                group = (SourceGroup)key;
            } else if (key instanceof Key) {
                fObj = ((Key)key).folder;
                group = ((Key)key).group;
                if (!fObj.isFolder()) {
                    isFile = true;
                }
            }
            try {
                FilterNode fn;
                DataObject dobj = DataObject.find((FileObject)fObj);
                FilterNode filterNode = fn = isFile ? new FilterNode(dobj.getNodeDelegate(), Children.LEAF) : new FilterNode(dobj.getNodeDelegate(), (Children)new SourceGroupsChildren(fObj, group));
                if (key instanceof SourceGroup) {
                    fn.setDisplayName(group.getDisplayName());
                }
                return new Node[]{fn};
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
        }

        private Collection getKeys() {
            if (this.groups != null) {
                return Arrays.asList(this.groups);
            }
            FileObject[] files = this.fo.getChildren();
            Arrays.sort(files, new FileObjectComparator());
            ArrayList<Key> children = new ArrayList<Key>(files.length);
            if (BrowseFolders.this.target == DataFolder.class) {
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].isFolder() || !this.group.contains(files[i])) continue;
                    children.add(new Key(files[i], this.group));
                }
            } else {
                int i;
                for (i = 0; i < files.length; ++i) {
                    if (!this.group.contains(files[i]) || !files[i].isFolder()) continue;
                    children.add(new Key(files[i], this.group));
                }
                for (i = 0; i < files.length; ++i) {
                    if (!this.group.contains(files[i]) || files[i].isFolder()) continue;
                    children.add(new Key(files[i], this.group));
                }
            }
            return children;
        }

        private class Key {
            private FileObject folder;
            private SourceGroup group;

            private Key(FileObject folder, SourceGroup group) {
                this.folder = folder;
                this.group = group;
            }
        }
    }
}

