/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.support.DOMHelper;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Element;

public class WebXmlHelper {
    public static final String PERSISTENCE_FACTORY = "persistence-factory";
    private static final String PERSISTENCE_UNIT_REF_PREFIX = "persistence/";
    private static final String PERSISTENCE_UNIT_REF_TAG = "persistence-unit-ref";
    private static final String PERSISTENCE_UNIT_REF_NAME_TAG = "persistence-unit-ref-name";
    private static final String PERSISTENCE_UNIT_NAME_TAG = "persistence-unit-name";
    private static final String PERSISTENCE_CONTEXT_REF_TAG = "persistence-context-ref";
    private static final String PERSISTENCE_CONTEXT_REF_NAME_TAG = "persistence-context-ref-name";
    private static final String RESOURCE_REF_TAG = "resource-ref";
    private static final String RESOURCE_REF_NAME_TAG = "res-ref-name";
    private static final String RESOURCE_TYPE_TAG = "res-type";
    private static final String RESOURCE_AUTH_TAG = "res-auth";
    private static final String USER_TRANSACTION = "UserTransaction";
    private static final String USER_TRANSACTION_CLASS = "javax.transaction.UserTransaction";
    private static final String CONTAINER = "Container";
    private Project project;
    private String puName;
    private DOMHelper helper;

    public WebXmlHelper(Project project, String puName) {
        this.project = project;
        this.puName = puName;
    }

    public void configure() {
        FileObject fobj = this.getWebXml(this.project);
        if (fobj == null) {
            return;
        }
        this.helper = new DOMHelper(fobj);
        this.addPersistenceUnitRef();
        if (RestUtils.hasJTASupport(this.project) && !RestUtils.hasProfile(this.project, Profile.JAVA_EE_5, Profile.JAVA_EE_6_FULL, Profile.JAVA_EE_6_WEB)) {
            this.addUserTransactionResourceRef();
        }
        this.helper.save();
    }

    private void addPersistenceUnitRef() {
        Element refElement = this.helper.findElement(PERSISTENCE_UNIT_REF_NAME_TAG, PERSISTENCE_FACTORY);
        if (refElement != null) {
            return;
        }
        refElement = this.helper.createElement(PERSISTENCE_UNIT_REF_TAG);
        refElement.appendChild(this.helper.createElement(PERSISTENCE_UNIT_REF_NAME_TAG, PERSISTENCE_FACTORY));
        refElement.appendChild(this.helper.createElement(PERSISTENCE_UNIT_NAME_TAG, this.puName));
        this.helper.appendChild(refElement);
    }

    private void addPersistenceContextRef() {
        String refName = PERSISTENCE_UNIT_REF_PREFIX + this.puName;
        Element refElement = this.helper.findElement(PERSISTENCE_CONTEXT_REF_NAME_TAG, refName);
        if (refElement != null) {
            return;
        }
        refElement = this.helper.createElement(PERSISTENCE_CONTEXT_REF_TAG);
        refElement.appendChild(this.helper.createElement(PERSISTENCE_CONTEXT_REF_NAME_TAG, refName));
        refElement.appendChild(this.helper.createElement(PERSISTENCE_UNIT_NAME_TAG, this.puName));
        this.helper.appendChild(refElement);
    }

    private void addUserTransactionResourceRef() {
        Element refElement = this.helper.findElement(RESOURCE_REF_NAME_TAG, USER_TRANSACTION);
        if (refElement != null) {
            return;
        }
        refElement = this.helper.createElement(RESOURCE_REF_TAG);
        refElement.appendChild(this.helper.createElement(RESOURCE_REF_NAME_TAG, USER_TRANSACTION));
        refElement.appendChild(this.helper.createElement(RESOURCE_TYPE_TAG, USER_TRANSACTION_CLASS));
        refElement.appendChild(this.helper.createElement(RESOURCE_AUTH_TAG, CONTAINER));
        this.helper.appendChild(refElement);
    }

    private FileObject getWebXml(Project project) {
        try {
            RestSupport rs = RestUtils.getRestSupport(project);
            if (rs != null) {
                return ((WebRestSupport)rs).getWebXml();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

