/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public class SourceGroupSupport {
    private SourceGroupSupport() {
    }

    public static SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set testGroups = SourceGroupSupport.getTestSourceGroups(sourceGroups);
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        for (int i = 0; i < sourceGroups.length; ++i) {
            if (testGroups.contains(sourceGroups[i])) continue;
            result.add(sourceGroups[i]);
        }
        return result.toArray(new SourceGroup[result.size()]);
    }

    public static boolean isValidPackageName(String packageName) {
        if (packageName.length() > 0 && packageName.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(packageName, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFolderWritable(SourceGroup sourceGroup, String packageName) {
        try {
            FileObject fo = SourceGroupSupport.getFolderForPackage(sourceGroup, packageName, false);
            while (fo == null && packageName.lastIndexOf(46) != -1) {
                packageName = packageName.substring(0, packageName.lastIndexOf(46));
                fo = SourceGroupSupport.getFolderForPackage(sourceGroup, packageName, false);
            }
            return fo == null || fo.canWrite();
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static SourceGroup findSourceGroupForFile(Project project, FileObject folder) {
        return SourceGroupSupport.findSourceGroupForFile(SourceGroupSupport.getJavaSourceGroups(project), folder);
    }

    public static SourceGroup findSourceGroupForFile(SourceGroup[] sourceGroups, FileObject folder) {
        for (int i = 0; i < sourceGroups.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroups[i].getRootFolder(), (FileObject)folder) && !sourceGroups[i].getRootFolder().equals(folder)) continue;
            return sourceGroups[i];
        }
        return null;
    }

    public static String getPackageForFolder(SourceGroup sourceGroup, FileObject folder) {
        String relative = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)folder);
        if (relative != null) {
            return relative.replace('/', '.');
        }
        return "";
    }

    public static String packageForFolder(FileObject folder) {
        Project project = FileOwnerQuery.getOwner((FileObject)folder);
        SourceGroup[] sources = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        SourceGroup sg = SourceGroupSupport.findSourceGroupForFile(sources, folder);
        if (sg != null) {
            return SourceGroupSupport.getPackageForFolder(sg, folder);
        }
        return "";
    }

    public static FileObject getFolderForPackage(SourceGroup sourceGroup, String pgkName) throws IOException {
        return SourceGroupSupport.getFolderForPackage(sourceGroup, pgkName, false);
    }

    public static FileObject getFolderForPackage(SourceGroup sourceGroup, String pgkName, boolean create) throws IOException {
        if (sourceGroup == null || pgkName == null) {
            return null;
        }
        String relativePkgName = pgkName.replace('.', '/');
        FileObject folder = sourceGroup.getRootFolder().getFileObject(relativePkgName);
        if (folder != null) {
            return folder;
        }
        if (create) {
            return FileUtil.createFolder((FileObject)sourceGroup.getRootFolder(), (String)relativePkgName);
        }
        return null;
    }

    private static Map createFoldersToSourceGroupsMap(SourceGroup[] sourceGroups) {
        HashMap<FileObject, SourceGroup> result;
        if (sourceGroups.length == 0) {
            result = Collections.EMPTY_MAP;
        } else {
            result = new HashMap<FileObject, SourceGroup>(2 * sourceGroups.length, 0.5f);
            for (int i = 0; i < sourceGroups.length; ++i) {
                SourceGroup sourceGroup = sourceGroups[i];
                result.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return result;
    }

    private static Set getTestSourceGroups(SourceGroup[] sourceGroups) {
        Map foldersToSourceGroupsMap = SourceGroupSupport.createFoldersToSourceGroupsMap(sourceGroups);
        HashSet testGroups = new HashSet();
        for (int i = 0; i < sourceGroups.length; ++i) {
            testGroups.addAll(SourceGroupSupport.getTestTargets(sourceGroups[i], foldersToSourceGroupsMap));
        }
        return testGroups;
    }

    private static List getTestTargets(SourceGroup sourceGroup, Map foldersToSourceGroupsMap) {
        URL[] rootURLs = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (rootURLs.length == 0) {
            return new ArrayList();
        }
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        List sourceRoots = SourceGroupSupport.getFileObjects(rootURLs, true);
        for (int i = 0; i < sourceRoots.size(); ++i) {
            FileObject sourceRoot = (FileObject)sourceRoots.get(i);
            SourceGroup srcGroup = (SourceGroup)foldersToSourceGroupsMap.get(sourceRoot);
            if (srcGroup == null) continue;
            result.add(srcGroup);
        }
        return result;
    }

    private static List getFileObjects(URL[] urls, boolean quiet) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (int i = 0; i < urls.length; ++i) {
            FileObject sourceRoot = URLMapper.findFileObject((URL)urls[i]);
            if (sourceRoot != null) {
                result.add(sourceRoot);
                continue;
            }
            if (quiet) continue;
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("No FileObject found for the following URL: " + urls[i]));
        }
        return result;
    }

    public static String getPackageName(String qualifiedClassName) {
        int i = qualifiedClassName.lastIndexOf(46);
        return i > 0 ? qualifiedClassName.substring(0, i) : null;
    }

    public static String getClassName(String qualifiedClassName) {
        return qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
    }

    public static JavaSource getJavaSourceFromClassName(String qualifiedClassName, Project project) throws IOException {
        FileObject fo = SourceGroupSupport.getFileObjectFromClassName(qualifiedClassName, project);
        if (fo != null) {
            return JavaSource.forFileObject((FileObject)fo);
        }
        return null;
    }

    public static ElementHandle<TypeElement> getHandleClassName(String qualifiedClassName, Project project) throws IOException {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        FileObject root = restSupport.findSourceRoot();
        ClassPathProvider provider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        ClassPath sourceCp = provider.findClassPath(root, "classpath/source");
        ClassPath compileCp = provider.findClassPath(root, "classpath/compile");
        ClassPath bootCp = provider.findClassPath(root, "classpath/boot");
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)bootCp, (ClassPath)compileCp, (ClassPath)sourceCp);
        ClassIndex ci = cpInfo.getClassIndex();
        int beginIndex = qualifiedClassName.lastIndexOf(46) + 1;
        String simple = qualifiedClassName.substring(beginIndex);
        Set handles = ci.getDeclaredTypes(simple, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        for (ElementHandle handle : handles) {
            if (!qualifiedClassName.equals(handle.getQualifiedName())) continue;
            return handle;
        }
        return null;
    }

    public static FileObject getFileObjectFromClassName(String qualifiedClassName, Project project) throws IOException {
        final ElementHandle<TypeElement> handle = SourceGroupSupport.getHandleClassName(qualifiedClassName, project);
        if (handle == null) {
            return null;
        }
        ClassPathProvider provider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        FileObject root = restSupport.findSourceRoot();
        ClassPath sourceCp = provider.findClassPath(root, "classpath/source");
        final ClassPath compileCp = provider.findClassPath(root, "classpath/compile");
        ClassPath bootCp = provider.findClassPath(root, "classpath/boot");
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)bootCp, (ClassPath)compileCp, (ClassPath)sourceCp);
        if (qualifiedClassName.equals(handle.getQualifiedName())) {
            FileObject fo = SourceUtils.getFile(handle, (ClasspathInfo)cpInfo);
            if (fo != null) {
                return fo;
            }
            JavaSource javaSource = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
            final FileObject[] classFo = new FileObject[1];
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController controller) throws Exception {
                    TypeElement element = (TypeElement)handle.resolve((CompilationInfo)controller);
                    if (element == null) {
                        return;
                    }
                    PackageElement pack = controller.getElements().getPackageOf(element);
                    if (pack == null) {
                        return;
                    }
                    String packageName = pack.getQualifiedName().toString();
                    String fqn = ElementUtilities.getBinaryName((TypeElement)element);
                    String className = fqn.substring(packageName.length());
                    if (className.length() <= 0 || className.charAt(0) != '.') {
                        return;
                    }
                    className = className.substring(1);
                    int dotIndex = className.indexOf(46);
                    if (dotIndex != -1) {
                        className = className.substring(0, dotIndex);
                    }
                    String path = packageName.replace('.', '/') + '/' + className + ".class";
                    classFo[0] = compileCp.findResource(path);
                }
            }, true);
            return classFo[0];
        }
        return null;
    }

    public static FileObject findJavaSourceFile(Project project, String name) {
        for (SourceGroup group : SourceGroupSupport.getJavaSourceGroups(project)) {
            Enumeration files = group.getRootFolder().getChildren(true);
            while (files.hasMoreElements()) {
                FileObject fo = (FileObject)files.nextElement();
                if (!"java".equals(fo.getExt()) || !name.equals(fo.getName())) continue;
                return fo;
            }
        }
        return null;
    }

    public static List<ClassPath> gerClassPath(Project project) {
        ArrayList<ClassPath> paths = new ArrayList<ClassPath>();
        ArrayList<SourceGroup> groups = new ArrayList<SourceGroup>();
        groups.addAll(Arrays.asList(ProjectUtils.getSources((Project)project).getSourceGroups("java")));
        ClassPathProvider cpp = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        for (SourceGroup group : groups) {
            ClassPath cp = cpp.findClassPath(group.getRootFolder(), "classpath/compile");
            if (cp != null) {
                paths.add(cp);
            }
            if ((cp = cpp.findClassPath(group.getRootFolder(), "classpath/source")) == null) continue;
            paths.add(cp);
        }
        return paths;
    }
}

