/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.projects;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.javaee.specs.support.api.JaxRsStackSupport;
import org.netbeans.modules.websvc.api.jaxws.project.LogUtils;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.projects.AntFilesHelper;
import org.netbeans.modules.websvc.rest.projects.RestApplicationsPanel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WebProjectRestSupport
extends WebRestSupport {
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    String[] classPathTypes = new String[]{"classpath/compile"};

    public WebProjectRestSupport(Project project) {
        super(project);
    }

    public void ensureRestDevelopmentReady() throws IOException {
        JaxRsStackSupport support;
        boolean needsRefresh = false;
        WebRestSupport.RestConfig restConfig = null;
        boolean hasJaxRs = this.hasJaxRsApi();
        if (!hasJaxRs && !this.isRestSupportOn()) {
            needsRefresh = true;
            restConfig = this.setApplicationConfigProperty(RestUtils.isAnnotationConfigAvailable(this.project));
        }
        this.extendBuildScripts();
        String restConfigType = this.getProjectProperty("rest.config.type");
        if (!RestUtils.isJSR_311OnClasspath(this.project)) {
            boolean jsr311Added = false;
            if (restConfig != null && restConfig.isServerJerseyLibSelected() && (support = this.getJaxRsStackSupport()) != null) {
                jsr311Added = support.addJsr311Api(this.project);
            }
            if (!jsr311Added) {
                JaxRsStackSupport.getDefault().addJsr311Api(this.project);
            }
        }
        if (!hasJaxRs) {
            FileObject buildFo;
            if (restConfigType == null || "dd".equals(restConfigType)) {
                String resourceUrl = null;
                resourceUrl = restConfig != null ? restConfig.getResourcePath() : this.getApplicationPathFromDD();
                if (resourceUrl == null) {
                    resourceUrl = "/resources/*";
                }
                this.addResourceConfigToWebApp(resourceUrl);
            }
            if (needsRefresh && "ide".equals(restConfigType) && (buildFo = Utils.findBuildXml(this.project)) != null) {
                ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{"generate-rest-config"}, null);
            }
        }
        boolean added = false;
        if (restConfig != null) {
            if (restConfig.isServerJerseyLibSelected() && (support = this.getJaxRsStackSupport()) != null) {
                added = support.extendsJerseyProjectClasspath(this.project);
            }
            if (!added && restConfig.isJerseyLibSelected()) {
                JaxRsStackSupport.getDefault().extendsJerseyProjectClasspath(this.project);
            }
        }
        if (this.hasSpringSupport()) {
            this.addJerseySpringJar();
        }
        ProjectManager.getDefault().saveProject(this.getProject());
        if (needsRefresh) {
            this.refreshRestServicesMetadataModel();
        }
    }

    public void removeRestDevelopmentReadiness() throws IOException {
        this.removeResourceConfigFromWebApp();
        this.removeSwdpLibrary(new String[]{"classpath/compile", "classpath/execute"});
        this.removeProjectProperties(new String[]{"rest.config.type", "rest.resources.path"});
        ProjectManager.getDefault().saveProject(this.getProject());
    }

    public boolean isReady() {
        return this.isRestSupportOn() && this.hasSwdpLibrary() && this.hasRestServletAdaptor();
    }

    public J2eePlatform getPlatform() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return null;
        }
        try {
            String id = j2eeModuleProvider.getServerInstanceID();
            if (id == null) {
                return null;
            }
            return Deployment.getDefault().getServerInstance(id).getJ2eePlatform();
        }
        catch (InstanceRemovedException ex) {
            return null;
        }
    }

    private J2eePlatform getJ2eePlatform(J2eeModuleProvider j2eeModuleProvider) {
        String serverInstanceID = j2eeModuleProvider.getServerInstanceID();
        if (serverInstanceID != null && serverInstanceID.length() > 0) {
            try {
                return Deployment.getDefault().getServerInstance(serverInstanceID).getJ2eePlatform();
            }
            catch (InstanceRemovedException ex) {
                Logger.getLogger(WebProjectRestSupport.class.getName()).log(Level.INFO, "Failed to find J2eePlatform");
            }
        }
        return null;
    }

    public FileObject getPersistenceXml() {
        PersistenceScope ps = PersistenceScope.getPersistenceScope((FileObject)this.getProject().getProjectDirectory());
        if (ps != null) {
            return ps.getPersistenceXml();
        }
        return null;
    }

    public Datasource getDatasource(String jndiName) {
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        try {
            return provider.getConfigSupport().findDatasource(jndiName);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public void setDirectoryDeploymentProperty(Properties p) {
        String instance = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty(J2EE_SERVER_INSTANCE);
        if (instance != null) {
            J2eeModuleProvider jmp = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            String sdi = jmp.getServerInstanceID();
            J2eeModule mod = jmp.getJ2eeModule();
            if (sdi != null && mod != null) {
                boolean cFD = Deployment.getDefault().canFileDeploy(instance, mod);
                p.setProperty(DIRECTORY_DEPLOYMENT_SUPPORTED, String.valueOf(cFD));
            }
        }
    }

    public File getLocalTargetTestRest() {
        String path = "build/generated-sources/rest-test";
        AntProjectHelper helper = this.getAntProjectHelper();
        EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
        String path1 = projectProps.getProperty("restbeans.test.dir");
        if (path1 != null) {
            path = path1;
        }
        return helper.resolveFile(path);
    }

    public FileObject generateTestClient(File testdir, String url) throws IOException {
        FileObject fileObject = this.generateTestClient(testdir);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("___BASE_URL___", url);
        WebProjectRestSupport.modifyFile((FileObject)fileObject, map);
        return fileObject;
    }

    public String getBaseURL() throws IOException {
        String applicationPath = this.getApplicationPath();
        if (applicationPath != null && !applicationPath.startsWith("/")) {
            applicationPath = "/" + applicationPath;
        }
        return this.getContextRootURL() + "||" + applicationPath;
    }

    public void deploy() throws IOException {
        FileObject buildFo = Utils.findBuildXml(this.getProject());
        if (buildFo != null) {
            ExecutorTask task = ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{"run-deploy"}, (Properties)new Properties());
            task.waitFinished();
        }
    }

    protected void logResourceCreation(Project prj) {
        Object[] params = new Object[]{"JAX-RS", this.project.getClass().getName(), "REST RESOURCE"};
        LogUtils.logWsDetect((Object[])params);
    }

    protected String getApplicationPathFromAnnotations(final String applPathFromDD) {
        List restApplications = this.getRestApplications();
        if (applPathFromDD == null) {
            if (restApplications.size() == 0) {
                return null;
            }
            return WebProjectRestSupport.getApplicationPathFromDialog(restApplications);
        }
        if (restApplications.size() == 0) {
            return applPathFromDD;
        }
        boolean found = false;
        for (RestApplication appl : restApplications) {
            if (!applPathFromDD.equals(appl.getApplicationPath())) continue;
            found = true;
            break;
        }
        if (!found) {
            restApplications.add(new RestApplication(){

                public String getApplicationPath() {
                    return applPathFromDD;
                }

                public String getApplicationClass() {
                    return "web.xml";
                }
            });
        }
        return WebProjectRestSupport.getApplicationPathFromDialog(restApplications);
    }

    public static String getApplicationPathFromDialog(List<RestApplication> restApplications) {
        if (restApplications.size() == 1) {
            return restApplications.get(0).getApplicationPath();
        }
        RestApplicationsPanel panel = new RestApplicationsPanel(restApplications);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(WebProjectRestSupport.class, (String)"TTL_RestResourcesPath"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (NotifyDescriptor.OK_OPTION.equals(desc.getValue())) {
            return panel.getApplicationPath();
        }
        return null;
    }

    private void extendBuildScripts() throws IOException {
        new AntFilesHelper((RestSupport)this).initRestBuildExtension();
    }
}

