/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.rest.nodes.ResourceUriProvider;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class TestResourceUriAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(TestResourceUriAction.class, (String)"LBL_TestRestServicesUri");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        ResourceUriProvider resourceUriProvider = (ResourceUriProvider)activatedNodes[0].getLookup().lookup(ResourceUriProvider.class);
        if (resourceUriProvider == null) {
            return false;
        }
        String resourceUri = resourceUriProvider.getResourceUri();
        if (resourceUri == null || resourceUri.length() == 0) {
            return false;
        }
        Project prj = (Project)activatedNodes[0].getLookup().lookup(Project.class);
        return prj != null && prj.getLookup().lookup(J2eeModuleProvider.class) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] activatedNodes) {
        block13: {
            String uri = ((ResourceUriProvider)activatedNodes[0].getLookup().lookup(ResourceUriProvider.class)).getResourceUri();
            if (!uri.startsWith("/")) {
                uri = "/" + uri;
            }
            String resourceURL = this.getResourceURL((Project)activatedNodes[0].getLookup().lookup(Project.class), uri);
            try {
                boolean connectionOK;
                URL url;
                block14: {
                    url = new URL(resourceURL);
                    if (url == null) break block13;
                    connectionOK = false;
                    try {
                        URLConnection connection = url.openConnection();
                        if (!(connection instanceof HttpURLConnection)) break block14;
                        HttpURLConnection httpConnection = (HttpURLConnection)connection;
                        try {
                            httpConnection.setRequestMethod("GET");
                            httpConnection.connect();
                            int responseCode = httpConnection.getResponseCode();
                            if (200 == responseCode || 405 == responseCode) {
                                connectionOK = true;
                            }
                        }
                        catch (IOException ex) {
                            Logger.getLogger(TestResourceUriAction.class.getName()).log(Level.INFO, "URLConnection problem", ex);
                        }
                        finally {
                            httpConnection.disconnect();
                        }
                        Object[] params = new Object[]{"JAX-RS", "TEST RESOURCE"};
                        LogUtils.logWsAction((Object[])params);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TestResourceUriAction.class.getName()).log(Level.INFO, "URLConnection problem", ex);
                    }
                }
                if (connectionOK) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(TestResourceUriAction.class, (String)"MSG_UNABLE_TO_OPEN_TEST_PAGE", (Object)url), 2));
                }
            }
            catch (MalformedURLException ex) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TestResourceUriAction.class, (String)"TXT_ResourceUrl", (Object)resourceURL));
            }
        }
    }

    private String getResourceURL(Project project, String uri) {
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        String serverInstanceID = provider.getServerInstanceID();
        if (serverInstanceID == null) {
            Logger.getLogger(TestResourceUriAction.class.getName()).log(Level.INFO, "Can not detect target J2EE server");
            return "";
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(serverInstanceID);
        String portNumber = "8080";
        String hostName = "localhost";
        try {
            ServerInstance.Descriptor instanceDescriptor = serverInstance.getDescriptor();
            if (instanceDescriptor != null) {
                int port = instanceDescriptor.getHttpPort();
                portNumber = port == 0 ? "8080" : String.valueOf(port);
                String hstName = instanceDescriptor.getHostname();
                if (hstName != null) {
                    hostName = hstName;
                }
            }
        }
        catch (InstanceRemovedException ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "Removed ServerInstance", ex);
        }
        String contextRoot = null;
        J2eeModule.Type moduleType = provider.getJ2eeModule().getType();
        if (J2eeModule.Type.WAR.equals(moduleType)) {
            J2eeModuleProvider.ConfigSupport configSupport = provider.getConfigSupport();
            try {
                contextRoot = configSupport.getWebContextRoot();
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
            if (contextRoot != null && contextRoot.startsWith("/")) {
                contextRoot = contextRoot.substring(1);
            }
        }
        String applicationPath = "resources";
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            try {
                applicationPath = restSupport.getApplicationPath();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        StringBuilder builder = new StringBuilder("http://");
        builder.append(hostName);
        builder.append(':');
        builder.append(portNumber);
        builder.append('/');
        if (contextRoot != null && contextRoot.length() > 0) {
            builder.append(contextRoot);
        }
        builder.append('/');
        builder.append(applicationPath);
        if (uri.startsWith("/") && applicationPath.length() == 0) {
            builder.append(uri.substring(1));
        } else {
            builder.append(uri);
        }
        return builder.toString();
    }

    public boolean asynchronous() {
        return true;
    }
}

