/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.javaee.specs.support.api.JaxRsStackSupport;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.projects.WebProjectRestSupport;
import org.netbeans.modules.websvc.rest.spi.ApplicationConfigPanel;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RestConfigurationAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(RestConfigurationAction.class, (String)"LBL_RestConfigurationAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        Project project = (Project)activatedNodes[0].getLookup().lookup(Project.class);
        if (project == null) {
            return false;
        }
        return !RestUtils.isJavaEE6(project);
    }

    protected void performAction(Node[] activatedNodes) {
        block33: {
            Project project = (Project)activatedNodes[0].getLookup().lookup(Project.class);
            WebRestSupport restSupport = (WebRestSupport)project.getLookup().lookup(WebRestSupport.class);
            if (restSupport != null) {
                String oldJerseyConfig;
                String oldConfigType = restSupport.getProjectProperty("rest.config.type");
                if (oldConfigType == null) {
                    oldConfigType = "dd";
                }
                String oldApplicationPath = "/webresources";
                try {
                    String resourcesPath;
                    if (oldConfigType.equals("dd")) {
                        String oldPathFromDD = restSupport.getApplicationPathFromDD();
                        if (oldPathFromDD != null) {
                            oldApplicationPath = oldPathFromDD;
                        }
                    } else if (oldConfigType.equals("ide") && (resourcesPath = WebProjectRestSupport.getApplicationPathFromDialog(restSupport.getRestApplications())) != null && resourcesPath.length() > 0) {
                        oldApplicationPath = resourcesPath;
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                if (!oldApplicationPath.startsWith("/")) {
                    oldApplicationPath = "/" + oldApplicationPath;
                }
                boolean isJerseyLib = (oldJerseyConfig = restSupport.getProjectProperty("rest.jersey.type")) != null;
                try {
                    ApplicationConfigPanel configPanel = new ApplicationConfigPanel(oldConfigType, oldApplicationPath, isJerseyLib, restSupport.getAntProjectHelper() != null && RestUtils.isAnnotationConfigAvailable(project), restSupport.hasServerJerseyLibrary(), oldJerseyConfig);
                    DialogDescriptor desc = new DialogDescriptor((Object)configPanel, NbBundle.getMessage(RestConfigurationAction.class, (String)"TTL_ApplicationConfigPanel"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    if (!NotifyDescriptor.OK_OPTION.equals(desc.getValue())) break block33;
                    String newConfigType = configPanel.getConfigType();
                    String newApplicationPath = configPanel.getApplicationPath();
                    boolean addJersey = configPanel.isJerseyLibSelected();
                    if (!oldConfigType.equals(newConfigType) || !oldApplicationPath.equals(newApplicationPath)) {
                        if (!oldConfigType.equals(newConfigType)) {
                            restSupport.setProjectProperty("rest.config.type", newConfigType);
                            if (!"ide".equals(newConfigType)) {
                                restSupport.removeProjectProperties(new String[]{"rest.resources.path"});
                            }
                        }
                        if ("ide".equals(newConfigType)) {
                            FileObject srcRoot;
                            Library restApiLibrary;
                            if (newApplicationPath.startsWith("/")) {
                                newApplicationPath = newApplicationPath.substring(1);
                            }
                            restSupport.setProjectProperty("rest.resources.path", newApplicationPath);
                            try {
                                this.setRootResources(project);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                            if (!this.isOnClasspath(project, "javax/ws/rs/ApplicationPath.class") && (restApiLibrary = LibraryManager.getDefault().getLibrary("restapi")) != null && (srcRoot = WebRestSupport.findSourceRoot((Project)project)) != null) {
                                try {
                                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{restApiLibrary}, (FileObject)srcRoot, (String)"classpath/compile");
                                }
                                catch (UnsupportedOperationException ex) {
                                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("Can not add JSR311 Library.");
                                }
                            }
                        } else if ("dd".equals(newConfigType)) {
                            try {
                                restSupport.addResourceConfigToWebApp(newApplicationPath);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    boolean added = false;
                    JaxRsStackSupport support = restSupport.getJaxRsStackSupport();
                    if (configPanel.isServerJerseyLibSelected()) {
                        restSupport.setProjectProperty("rest.jersey.type", "server");
                        if (support != null) {
                            if ("ide".equals(oldJerseyConfig)) {
                                JaxRsStackSupport.getDefault().removeJaxRsLibraries(project);
                            }
                            added = support.extendsJerseyProjectClasspath(project);
                        }
                    }
                    if (!added && addJersey) {
                        restSupport.setProjectProperty("rest.jersey.type", "ide");
                        if ("server".equals(oldJerseyConfig) && support != null) {
                            support.removeJaxRsLibraries(project);
                        }
                        added = JaxRsStackSupport.getDefault().extendsJerseyProjectClasspath(project);
                    }
                    if (!added) {
                        if ("server".equals(oldJerseyConfig) && support != null) {
                            support.removeJaxRsLibraries(project);
                        }
                        if ("ide".equals(oldJerseyConfig)) {
                            JaxRsStackSupport.getDefault().removeJaxRsLibraries(project);
                        }
                        restSupport.removeProjectProperties(new String[]{"rest.jersey.type"});
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void setRootResources(Project prj) throws IOException {
        FileObject buildFo = Utils.findBuildXml(prj);
        if (buildFo != null) {
            ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{"generate-rest-config"}, null);
        }
    }

    public boolean asynchronous() {
        return true;
    }

    private boolean isOnClasspath(Project project, String classResource) {
        ClassPath cp;
        FileObject srcRoot = WebRestSupport.findSourceRoot((Project)project);
        return srcRoot != null && (cp = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/compile")) != null && cp.findResource(classResource) != null;
    }
}

