/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.client.ClientJavaSourceHelper;
import org.netbeans.modules.websvc.rest.client.HttpParams;
import org.netbeans.modules.websvc.rest.client.Security;
import org.netbeans.modules.websvc.rest.client.SecurityParams;
import org.netbeans.modules.websvc.rest.client.XmlDomUtils;
import org.netbeans.modules.websvc.rest.client.XmlStaxUtils;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.jaxb.FieldDescriptor;
import org.netbeans.modules.websvc.saas.model.jaxb.MethodDescriptor;
import org.netbeans.modules.websvc.saas.model.jaxb.ServletDescriptor;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.netbeans.modules.websvc.saas.model.wadl.Representation;
import org.netbeans.modules.websvc.saas.model.wadl.Request;
import org.netbeans.modules.websvc.saas.model.wadl.Response;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

class Wadl2JavaHelper {
    private static final String PROP_XML_SCHEMA = "xml_schema";
    private static final String PROP_PACKAGE_NAME = "package_name";
    private static final String PROP_SOURCE_ROOT = "source_root";
    private static final String SIGN_PARAMS_METHOD = "signParams";
    static final String PROJEC_TYPE_WEB = "web";
    static final String PROJEC_TYPE_DESKTOP = "desktop";
    static final String PROJEC_TYPE_NB_MODULE = "nb-module";

    Wadl2JavaHelper() {
    }

    static ClassTree addHttpMethods(WorkingCopy copy, ClassTree innerClass, WadlSaasResource saasResource, Security security) {
        MethodTree methodTree;
        ExpressionTree returnTree;
        ModifiersTree methodModifier;
        String body;
        String mvType;
        TypeElement mvMapEl;
        String mvMapClass;
        List saasMethods = saasResource.getMethods();
        ClassTree modifiedInnerClass = innerClass;
        TreeMaker maker = copy.getTreeMaker();
        boolean hasMultipleParamsInList = false;
        boolean hasOptionalQueryParams = false;
        boolean hasFormParams = false;
        HttpParams globalParams = new HttpParams(saasResource);
        for (WadlSaasMethod saasMethod : saasMethods) {
            HttpParams httpParams = new HttpParams(saasMethod);
            httpParams.mergeQueryandHeaderParams(globalParams);
            if (httpParams.hasMultipleParamsInList()) {
                hasMultipleParamsInList = true;
            }
            if (httpParams.hasOptionalQueryParams() && httpParams.hasRequiredQueryParams() || httpParams.hasDefaultQueryParams()) {
                hasOptionalQueryParams = true;
            }
            if (httpParams.hasFormParams()) {
                hasFormParams = true;
            }
            List<MethodTree> httpMethods = Wadl2JavaHelper.createHttpMethods(copy, saasMethod, httpParams, security);
            for (MethodTree httpMethod : httpMethods) {
                modifiedInnerClass = maker.addClassMember(modifiedInnerClass, (Tree)httpMethod);
            }
        }
        if (hasMultipleParamsInList || hasFormParams) {
            mvMapClass = "javax.ws.rs.core.MultivaluedMap";
            mvMapEl = copy.getElements().getTypeElement(mvMapClass);
            mvType = mvMapEl == null ? mvMapClass : "MultivaluedMap";
            body = "{" + mvType + "<String,String> qParams = new com.sun.jersey.api.representation.Form();" + "for (int i=0;i< paramNames.length;i++) {" + "    if (paramValues[i] != null) {" + "        qParams.add(paramNames[i], paramValues[i]);" + "    }" + "}" + "return qParams;" + "}";
            methodModifier = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
            returnTree = mvMapEl == null ? copy.getTreeMaker().Identifier((CharSequence)mvMapClass) : copy.getTreeMaker().QualIdent((Element)mvMapEl);
            ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
            ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
            paramList.add(maker.Variable(paramModifier, (CharSequence)"paramNames", (Tree)maker.Identifier((CharSequence)"String[]"), null));
            paramList.add(maker.Variable(paramModifier, (CharSequence)"paramValues", (Tree)maker.Identifier((CharSequence)"String[]"), null));
            methodTree = maker.Method(methodModifier, (CharSequence)"getQueryOrFormParams", (Tree)returnTree, Collections.emptyList(), paramList, Collections.emptyList(), body, null);
            modifiedInnerClass = maker.addClassMember(modifiedInnerClass, (Tree)methodTree);
        }
        if (hasOptionalQueryParams) {
            mvMapClass = "javax.ws.rs.core.MultivaluedMap";
            mvMapEl = copy.getElements().getTypeElement(mvMapClass);
            mvType = mvMapEl == null ? mvMapClass : "MultivaluedMap";
            body = "{" + mvType + "<String,String> qParams = new com.sun.jersey.api.representation.Form();" + "for (String qParam : optionalParams) {" + "    String[] qPar = qParam.split(\"=\");" + "    if (qPar.length > 1) qParams.add(qPar[0], qPar[1])" + "}" + "return qParams;" + "}";
            methodModifier = maker.Modifiers(Collections.singleton(Modifier.PRIVATE));
            returnTree = mvMapEl == null ? copy.getTreeMaker().Identifier((CharSequence)mvMapClass) : copy.getTreeMaker().QualIdent((Element)mvMapEl);
            ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
            VariableTree param = maker.Variable(paramModifier, (CharSequence)"optionalParams", (Tree)maker.Identifier((CharSequence)"String..."), null);
            methodTree = maker.Method(methodModifier, (CharSequence)"getQParams", (Tree)returnTree, Collections.emptyList(), Collections.singletonList(param), Collections.emptyList(), body, null);
            modifiedInnerClass = maker.addClassMember(modifiedInnerClass, (Tree)methodTree);
        }
        return modifiedInnerClass;
    }

    static List<MethodTree> createHttpMethods(WorkingCopy copy, WadlSaasMethod saasMethod, HttpParams httpParams, Security security) {
        ArrayList<MethodTree> httpMethods = new ArrayList<MethodTree>();
        Method wadlMethod = saasMethod.getWadlMethod();
        String methodType = wadlMethod.getName();
        if ("GET".equals(methodType)) {
            ArrayList produces = new ArrayList();
            for (Response wadlResponse : wadlMethod.getResponse()) {
                if (wadlResponse == null) continue;
                List representations = wadlResponse.getRepresentation();
                produces.addAll(representations);
            }
            boolean found = false;
            boolean multipleMimeTypes = produces.size() > 1;
            block1: for (Representation prod : produces) {
                String mediaType = prod.getMediaType();
                if (mediaType == null) continue;
                for (ClientJavaSourceHelper.HttpMimeType mimeType : ClientJavaSourceHelper.HttpMimeType.values()) {
                    if (!mediaType.equals(mimeType.getMimeType())) continue;
                    MethodTree method = Wadl2JavaHelper.createHttpGETMethod(copy, saasMethod, mimeType, multipleMimeTypes, httpParams, security);
                    if (method != null) {
                        httpMethods.add(method);
                    }
                    found = true;
                    continue block1;
                }
            }
            if (!found) {
                httpMethods.add(Wadl2JavaHelper.createHttpGETMethod(copy, saasMethod, null, false, httpParams, security));
            }
        } else if ("PUT".equals(methodType) || "POST".equals(methodType) || "DELETE".equals(methodType)) {
            ArrayList<Representation> consumes = new ArrayList<Representation>();
            Request wadlRequest = wadlMethod.getRequest();
            if (wadlRequest != null) {
                List representationTypes = wadlRequest.getRepresentation();
                for (Representation reprType : representationTypes) {
                    consumes.add(reprType);
                }
            }
            boolean found = false;
            boolean multipleMimeTypes = consumes.size() > 1;
            block4: for (Representation cons : consumes) {
                String mediaType = cons.getMediaType();
                if (mediaType == null) continue;
                for (ClientJavaSourceHelper.HttpMimeType mimeType : ClientJavaSourceHelper.HttpMimeType.values()) {
                    if (!mediaType.equals(mimeType.getMimeType())) continue;
                    MethodTree method = Wadl2JavaHelper.createHttpPOSTMethod(copy, saasMethod, mimeType, multipleMimeTypes, httpParams, security);
                    if (method != null) {
                        httpMethods.add(method);
                    }
                    found = true;
                    continue block4;
                }
            }
            if (!found) {
                httpMethods.add(Wadl2JavaHelper.createHttpPOSTMethod(copy, saasMethod, null, false, httpParams, security));
            }
        }
        return httpMethods;
    }

    static MethodTree createHttpGETMethod(WorkingCopy copy, WadlSaasMethod saasMethod, ClientJavaSourceHelper.HttpMimeType mimeType, boolean multipleMimeTypes, HttpParams httpParams, Security security) {
        MethodTree method;
        String methodName = Wadl2JavaHelper.makeJavaIdentifier(saasMethod.getName()) + (multipleMimeTypes ? "_" + mimeType.name() : "");
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        VariableTree classParam = maker.Variable(paramModifier, (CharSequence)"responseType", (Tree)maker.Identifier((CharSequence)"Class<T>"), null);
        IdentifierTree responseTree = maker.Identifier((CharSequence)"T");
        String bodyParam = "responseType";
        List<TypeParameterTree> typeParams = Collections.singletonList(maker.TypeParameter((CharSequence)"T", Collections.emptyList()));
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        if (classParam != null) {
            paramList.add(classParam);
        }
        StringBuffer queryP = new StringBuffer();
        StringBuffer queryParamPart = new StringBuffer();
        StringBuffer commentBuffer = new StringBuffer("@param responseType Class representing the response\n");
        if (httpParams.hasQueryParams() || httpParams.hasHeaderParams()) {
            Wadl2JavaHelper.addQueryAndHeaderParams(maker, httpParams, security, paramList, queryP, queryParamPart, commentBuffer);
        }
        commentBuffer.append("@return response object (instance of responseType class)");
        String body = "{" + queryParamPart + (mimeType == null ? "   return webResource" + queryP + ".get(" + bodyParam + ");" : "   return webResource" + queryP + ".accept(" + mimeType.getMediaType() + ").get(" + bodyParam + ");") + "}";
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        ExpressionTree throwsTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.UniformInterfaceException");
        throwsList.add(throwsTree);
        if (Security.Authentication.SESSION_KEY == security.getAuthentication()) {
            ExpressionTree ioExceptionTree = JavaSourceHelper.createTypeTree(copy, "java.io.IOException");
            throwsList.add(ioExceptionTree);
        }
        if ((method = maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, throwsList, body, null)) != null) {
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)commentBuffer.toString());
            maker.addComment((Tree)method, comment, true);
        }
        return method;
    }

    static MethodTree createHttpPOSTMethod(WorkingCopy copy, WadlSaasMethod saasMethod, ClientJavaSourceHelper.HttpMimeType requestMimeType, boolean multipleMimeTypes, HttpParams httpParams, Security security) {
        String body;
        MethodTree method;
        String methodName = saasMethod.getName() + (multipleMimeTypes ? "_" + requestMimeType.name() : "");
        String methodPrefix = saasMethod.getWadlMethod().getName().toLowerCase();
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree methodModifier = maker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        List response = saasMethod.getWadlMethod().getResponse();
        ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
        IdentifierTree responseTree = null;
        List<Object> typeParams = null;
        String bodyParam1 = "";
        String bodyParam2 = "";
        String ret = "";
        if (response != null && !response.isEmpty()) {
            VariableTree classParam = maker.Variable(paramModifier, (CharSequence)"responseType", (Tree)maker.Identifier((CharSequence)"Class<T>"), null);
            responseTree = maker.Identifier((CharSequence)"T");
            bodyParam1 = "responseType";
            typeParams = Collections.singletonList(maker.TypeParameter((CharSequence)"T", Collections.emptyList()));
            if (classParam != null) {
                paramList.add(classParam);
            }
            ret = "return ";
        } else {
            responseTree = maker.Identifier((CharSequence)"void");
            typeParams = Collections.emptyList();
        }
        StringBuffer queryP = new StringBuffer();
        StringBuffer queryParamPart = new StringBuffer();
        StringBuffer commentBuffer = new StringBuffer("@param responseType Class representing the response\n");
        if (httpParams.hasFormParams() || httpParams.hasQueryParams() || httpParams.hasHeaderParams()) {
            Wadl2JavaHelper.addQueryAndHeaderParams(maker, httpParams, security, paramList, queryP, queryParamPart, commentBuffer);
        }
        if (requestMimeType != null) {
            if (requestMimeType == ClientJavaSourceHelper.HttpMimeType.FORM && httpParams.hasFormParams()) {
                bodyParam2 = (bodyParam1.length() > 0 ? ", " : "") + "getQueryOrFormParams(formParamNames, formParamValues)";
            } else {
                VariableTree objectParam = maker.Variable(paramModifier, (CharSequence)"requestEntity", (Tree)maker.Identifier((CharSequence)"Object"), null);
                paramList.add(0, objectParam);
                bodyParam2 = (bodyParam1.length() > 0 ? ", " : "") + "requestEntity";
                commentBuffer.append("@param requestEntity request data");
            }
        }
        commentBuffer.append("@return response object (instance of responseType class)");
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        ExpressionTree throwsTree = JavaSourceHelper.createTypeTree(copy, "com.sun.jersey.api.client.UniformInterfaceException");
        throwsList.add(throwsTree);
        if (Security.Authentication.SESSION_KEY == security.getAuthentication()) {
            ExpressionTree ioExceptionTree = JavaSourceHelper.createTypeTree(copy, "java.io.IOException");
            throwsList.add(ioExceptionTree);
        }
        if ((method = maker.Method(methodModifier, (CharSequence)methodName, (Tree)responseTree, typeParams, paramList, throwsList, body = "{" + queryParamPart + (requestMimeType == null ? "   " + ret + "webResource" + queryP + "." + methodPrefix + "(" + bodyParam1 + bodyParam2 + ");" : "   " + ret + "webResource" + queryP + ".type(" + requestMimeType.getMediaType() + ")." + methodPrefix + "(" + bodyParam1 + bodyParam2 + ");") + "}", null)) != null) {
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (String)commentBuffer.toString());
            maker.addComment((Tree)method, comment, true);
        }
        return method;
    }

    private static void addQueryAndHeaderParams(TreeMaker maker, HttpParams httpParams, Security security, List<VariableTree> paramList, StringBuffer queryP, StringBuffer queryParamPart, StringBuffer commentBuffer) {
        Pair<String> paramPair;
        VariableTree paramTree;
        String javaIdentifier;
        ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
        SecurityParams securityParams = security.getSecurityParams();
        if (httpParams.hasFormParams()) {
            for (String formParam : httpParams.getFormParams()) {
                if (securityParams != null && (Wadl2JavaHelper.isSecurityParam(formParam, securityParams) || Wadl2JavaHelper.isSignatureParam(formParam, securityParams))) continue;
                javaIdentifier = Wadl2JavaHelper.makeJavaIdentifier(formParam);
                paramTree = maker.Variable(paramModifier, (CharSequence)javaIdentifier, (Tree)maker.Identifier((CharSequence)"String"), null);
                paramList.add(paramTree);
                commentBuffer.append("@param " + javaIdentifier + " form parameter\n");
            }
            paramPair = null;
            paramPair = securityParams != null ? Wadl2JavaHelper.getParamList(httpParams.getFormParams(), httpParams.getFixedFormParams(), securityParams) : Wadl2JavaHelper.getParamList(httpParams.getFormParams(), httpParams.getFixedFormParams());
            queryParamPart.append("String[] formParamNames = new String[] {" + paramPair.getKey() + "}");
            queryParamPart.append("String[] formParamValues = new String[] {" + paramPair.getValue() + "}");
        }
        if (httpParams.hasQueryParams()) {
            if (httpParams.hasRequiredQueryParams()) {
                for (String requiredParam : httpParams.getRequiredQueryParams()) {
                    if (securityParams != null && (Wadl2JavaHelper.isSecurityParam(requiredParam, securityParams) || Wadl2JavaHelper.isSignatureParam(requiredParam, securityParams))) continue;
                    javaIdentifier = Wadl2JavaHelper.makeJavaIdentifier(requiredParam);
                    paramTree = maker.Variable(paramModifier, (CharSequence)javaIdentifier, (Tree)maker.Identifier((CharSequence)"String"), null);
                    paramList.add(paramTree);
                    commentBuffer.append("@param " + javaIdentifier + " query parameter[REQUIRED]\n");
                }
                if (httpParams.hasMultipleParamsInList()) {
                    paramPair = null;
                    paramPair = securityParams != null ? Wadl2JavaHelper.getParamList(httpParams.getRequiredQueryParams(), httpParams.getFixedQueryParams(), securityParams) : Wadl2JavaHelper.getParamList(httpParams.getRequiredQueryParams(), httpParams.getFixedQueryParams());
                    queryParamPart.append("String[] queryParamNames = new String[] {" + paramPair.getKey() + "}");
                    queryParamPart.append("String[] queryParamValues = new String[] {" + paramPair.getValue() + "}");
                    if (Security.Authentication.SESSION_KEY == security.getAuthentication() && securityParams != null) {
                        String optParams = "";
                        if (httpParams.hasOptionalQueryParams()) {
                            optParams = ", optionalQueryParams";
                        }
                        queryParamPart.append("String signature = signParams(queryParamNames, queryParamValues" + optParams + ");");
                        String sigParam = securityParams.getSignature();
                        queryP.append(".queryParams(getQueryOrFormParams(queryParamNames, queryParamValues)).queryParam(\"" + sigParam + "\", signature)");
                    } else {
                        queryP.append(".queryParams(getQueryOrFormParams(queryParamNames, queryParamValues))");
                    }
                } else {
                    List<String> requiredParams = httpParams.getRequiredQueryParams();
                    if (requiredParams.size() > 0) {
                        String paramName = requiredParams.get(0);
                        String paramValue = Wadl2JavaHelper.makeJavaIdentifier(requiredParams.get(0));
                        if (Security.Authentication.SESSION_KEY == security.getAuthentication() && securityParams != null && httpParams.hasFormParams()) {
                            String optParams = "";
                            if (httpParams.hasOptionalQueryParams()) {
                                optParams = ", optionalQueryParams";
                            }
                            queryParamPart.append("String signature = signParams(formParamNames, formParamValues" + optParams + ");");
                            String sigParam = securityParams.getSignature();
                            queryP.append(".queryParam(\"" + sigParam + "\", signature)");
                        } else {
                            queryP.append(".queryParam(\"" + paramName + "\"," + paramValue + ")");
                        }
                    } else {
                        Map<String, String> fixedParams = httpParams.getFixedQueryParams();
                        for (Map.Entry<String, String> entry : fixedParams.entrySet()) {
                            String paramName = entry.getKey();
                            String paramValue = entry.getValue();
                            queryP.append(".queryParam(\"" + paramName + "\",\"" + paramValue + "\")");
                        }
                    }
                }
            } else if (httpParams.hasOptionalQueryParams()) {
                for (String optionalParam : httpParams.getOptionalQueryParams()) {
                    javaIdentifier = Wadl2JavaHelper.makeJavaIdentifier(optionalParam);
                    paramTree = maker.Variable(paramModifier, (CharSequence)javaIdentifier, (Tree)maker.Identifier((CharSequence)"String"), null);
                    paramList.add(paramTree);
                    commentBuffer.append("@param " + javaIdentifier + " query parameter\n");
                }
                paramPair = Wadl2JavaHelper.getParamList(httpParams.getOptionalQueryParams(), Collections.<String, String>emptyMap());
                queryParamPart.append("String[] queryParamNames = new String[] {" + paramPair.getKey() + "}");
                queryParamPart.append("String[] queryParamValues = new String[] {" + paramPair.getValue() + "}");
                queryP.append(".queryParams(getQueryOrFormParams(queryParamNames, queryParamValues))");
            }
            if (httpParams.hasOptionalQueryParams() && httpParams.hasRequiredQueryParams() || httpParams.hasDefaultQueryParams()) {
                VariableTree paramTree2 = maker.Variable(paramModifier, (CharSequence)"optionalQueryParams", (Tree)maker.Identifier((CharSequence)"String..."), null);
                paramList.add(paramTree2);
                commentBuffer.append("@param optionalQueryParams List of optional query parameters in the form of \"param_name=param_value\",...<br>\nList of optional query parameters:\n");
                for (String otherParam : httpParams.getOptionalQueryParams()) {
                    commentBuffer.append("<LI>" + otherParam + " [OPTIONAL]\n");
                }
                Map<String, String> defaultParams = httpParams.getDefaultQueryParams();
                for (String key : defaultParams.keySet()) {
                    commentBuffer.append("<LI>" + key + " [OPTIONAL, DEFAULT VALUE: \"" + defaultParams.get(key) + "\"]\n");
                }
                queryP.append(".queryParams(getQParams(optionalQueryParams))");
            }
        }
        if (httpParams.hasHeaderParams()) {
            for (String headerParam : httpParams.getHeaderParams()) {
                javaIdentifier = Wadl2JavaHelper.makeJavaIdentifier(headerParam);
                paramTree = maker.Variable(paramModifier, (CharSequence)javaIdentifier, (Tree)maker.Identifier((CharSequence)"String"), null);
                paramList.add(paramTree);
                commentBuffer.append("@param " + javaIdentifier + " header parameter[REQUIRED]\n");
                queryP.append(".header(\"" + headerParam + "\"," + javaIdentifier + ")");
            }
            Map<String, String> fixedHeaderParams = httpParams.getFixedHeaderParams();
            for (String paramName : fixedHeaderParams.keySet()) {
                String paramValue = fixedHeaderParams.get(paramName);
                queryP.append(".header(\"" + paramName + "\",\"" + paramValue + "\")");
            }
        }
    }

    private static Pair<String> getParamList(List<String> requiredParams, Map<String, String> fixedParams) {
        StringBuilder paramNames = new StringBuilder();
        StringBuilder paramValues = new StringBuilder();
        boolean first = true;
        for (String string : requiredParams) {
            if (first) {
                first = false;
            } else {
                paramNames.append(",");
                paramValues.append(",");
            }
            paramNames.append("\"");
            paramNames.append(string);
            paramNames.append("\"");
            paramValues.append(Wadl2JavaHelper.makeJavaIdentifier(string));
        }
        for (Map.Entry entry : fixedParams.entrySet()) {
            String p = (String)entry.getKey();
            if (first) {
                first = false;
            } else {
                paramNames.append(",");
                paramValues.append(",");
            }
            paramNames.append("\"");
            paramNames.append(p);
            paramNames.append("\"");
            paramValues.append("\"");
            paramNames.append((String)entry.getValue());
            paramNames.append("\"");
        }
        return new Pair<String>(paramNames.toString(), paramValues.toString());
    }

    private static Pair<String> getParamList(List<String> requiredParams, Map<String, String> fixedParams, SecurityParams securityParams) {
        StringBuffer paramNames = new StringBuffer();
        StringBuffer paramValues = new StringBuffer();
        boolean first = true;
        for (String p : requiredParams) {
            if (Wadl2JavaHelper.isSignatureParam(p, securityParams)) continue;
            if (first) {
                first = false;
            } else {
                paramNames.append(",");
                paramValues.append(",");
            }
            paramNames.append("\"" + p + "\"");
            if (Wadl2JavaHelper.isSecurityParam(p, securityParams)) {
                paramValues.append(Wadl2JavaHelper.findGetterForParam(p, securityParams.getMethodDescriptors()));
                continue;
            }
            paramValues.append(Wadl2JavaHelper.makeJavaIdentifier(p));
        }
        for (String p : fixedParams.keySet()) {
            if (Wadl2JavaHelper.isSignatureParam(p, securityParams)) continue;
            if (first) {
                first = false;
            } else {
                paramNames.append(",");
                paramValues.append(",");
            }
            paramNames.append("\"" + p + "\"");
            if (Wadl2JavaHelper.isSecurityParam(p, securityParams)) {
                paramValues.append(Wadl2JavaHelper.findGetterForParam(p, securityParams.getMethodDescriptors()));
                continue;
            }
            paramValues.append("\"" + fixedParams.get(p) + "\"");
        }
        return new Pair<String>(paramNames.toString(), paramValues.toString());
    }

    private static String makeJavaIdentifier(String s) {
        int len = s.length();
        String result = s;
        for (int i = 0; i < len; ++i) {
            char ch = result.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            result = result.replace(ch, '_');
        }
        if (len > 0) {
            if (!Character.isJavaIdentifierStart(result.charAt(0))) {
                result = "_" + result;
            }
            result = result.substring(0, 1).toLowerCase() + result.substring(1);
        }
        return result;
    }

    static String getClientClassName(WadlSaasResource saasResource) {
        String path = saasResource.getResource().getPath();
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            char ch = path.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            path = path.replace(ch, '_');
        }
        while (path.startsWith("_")) {
            path = path.substring(1);
        }
        while (path.endsWith("_")) {
            path = path.substring(0, path.length() - 1);
        }
        String saasName = saasResource.getSaas().getDisplayName();
        if ((saasName = saasName.replace(" ", "_")).length() == 0) {
            saasName = "Resource";
        } else if (!Character.isJavaIdentifierStart(saasName.charAt(0))) {
            saasName = "Resource_" + saasName;
        } else if (Character.isLowerCase(saasName.charAt(0))) {
            saasName = saasName.substring(0, 1).toUpperCase() + saasName.substring(1);
        }
        return saasName + (path.length() == 0 ? "" : "_" + path) + "_JerseyClient";
    }

    static void generateJaxb(FileObject targetFo, WadlSaas wadlSaas) throws IOException {
        FileObject srcRoot;
        List schemaFiles;
        FileObject buildXml;
        Project project = FileOwnerQuery.getOwner((FileObject)targetFo);
        if (project != null && (buildXml = project.getProjectDirectory().getFileObject("build.xml")) != null && (schemaFiles = wadlSaas.getLocalSchemaFiles()).size() > 0 && (srcRoot = Wadl2JavaHelper.findSourceRootForFile(project, targetFo)) != null) {
            XmlStaxUtils staxUtils = new XmlStaxUtils();
            String saasDir = Wadl2JavaHelper.getSourceRootPath(project, srcRoot);
            String packagePrefix = wadlSaas.getPackageName();
            String targetName = "saas.xjc." + packagePrefix;
            try {
                boolean isXjcTarget = staxUtils.isTarget(buildXml, targetName);
                if (!isXjcTarget) {
                    NotifyDescriptor.Confirmation dd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(Wadl2JavaHelper.class, (String)"MSG_CreateJaxbArtifacts", (Object[])new Object[]{targetName, saasDir}), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                    if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                        FileObject metaInf = srcRoot.getFileObject("META-INF");
                        if (metaInf == null) {
                            metaInf = srcRoot.createFolder("META-INF");
                        }
                        String[] xmlSchemas = new String[schemaFiles.size()];
                        String[] packageNames = new String[schemaFiles.size()];
                        boolean isInitTarget = staxUtils.isTarget(buildXml, "saas-init-xjc");
                        int i = 0;
                        for (FileObject schemaFile : schemaFiles) {
                            if (metaInf != null && metaInf.isFolder() && metaInf.getFileObject(schemaFile.getNameExt()) == null) {
                                FileUtil.copyFile((FileObject)schemaFile, (FileObject)metaInf, (String)schemaFile.getName());
                                xmlSchemas[i] = saasDir + "/META-INF/" + schemaFile.getNameExt();
                            } else {
                                xmlSchemas[i] = schemaFile.getPath();
                            }
                            packageNames[i++] = packagePrefix + "." + SaasUtil.toValidJavaName((String)schemaFile.getName()).toLowerCase();
                        }
                        XmlDomUtils.addJaxbXjcTargets(buildXml, targetName, saasDir, xmlSchemas, packageNames, isInitTarget, PROJEC_TYPE_NB_MODULE.equals(Wadl2JavaHelper.getProjectType(project)));
                        for (FileObject schemaFile : schemaFiles) {
                            ExecutorTask executorTask = ActionUtils.runTarget((FileObject)buildXml, (String[])new String[]{targetName}, null);
                        }
                    }
                }
            }
            catch (XMLStreamException ex) {
                Logger.getLogger(Wadl2JavaHelper.class.getName()).log(Level.WARNING, "Can not parse wadl file", ex);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(Wadl2JavaHelper.class.getName()).log(Level.WARNING, "Can not configure parser for wadl file", ex);
            }
            catch (SAXException ex) {
                Logger.getLogger(Wadl2JavaHelper.class.getName()).log(Level.WARNING, "Can not parse wadl file", ex);
            }
        }
    }

    static String getProjectType(Project project) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            int projectType = restSupport.getProjectType();
            if (projectType == 1) {
                return PROJEC_TYPE_WEB;
            }
            if (projectType == 2) {
                return PROJEC_TYPE_NB_MODULE;
            }
        } else {
            AuxiliaryConfiguration aux = ProjectUtils.getAuxiliaryConfiguration((Project)project);
            for (int i = 1; i < 10; ++i) {
                if (aux.getConfigurationFragment("data", "http://www.netbeans.org/ns/nb-module-project/" + String.valueOf(i), true) != null) {
                    return PROJEC_TYPE_NB_MODULE;
                }
                if (aux.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/" + String.valueOf(i), true) == null) continue;
                return PROJEC_TYPE_WEB;
            }
        }
        return PROJEC_TYPE_DESKTOP;
    }

    private static FileObject findSourceRootForFile(Project project, FileObject fo) {
        SourceGroup[] sourceGroups;
        for (SourceGroup sourceGroup : sourceGroups = SourceGroupSupport.getJavaSourceGroups(project)) {
            FileObject srcRoot = sourceGroup.getRootFolder();
            if (!FileUtil.isParentOf((FileObject)srcRoot, (FileObject)fo)) continue;
            return srcRoot;
        }
        return null;
    }

    private static String getSourceRootPath(Project project, FileObject srcRoot) {
        return FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)srcRoot);
    }

    private static boolean isSecurityParam(String param, SecurityParams securityParams) {
        return securityParams.getParams().contains(param);
    }

    private static boolean isSignatureParam(String param, SecurityParams securityParams) {
        return param.equals(securityParams.getSignature());
    }

    private static String findGetterForParam(String param, List<MethodDescriptor> methodDescriptors) {
        for (MethodDescriptor method : methodDescriptors) {
            if (!param.equals(method.getId())) continue;
            return method.getName() + "()";
        }
        return Wadl2JavaHelper.makeJavaIdentifier(param);
    }

    static ClassTree addSessionAuthMethods(WorkingCopy copy, ClassTree originalClass, SecurityParams securityParams) {
        ClassTree modifiedClass = originalClass;
        TreeMaker maker = copy.getTreeMaker();
        for (FieldDescriptor field : securityParams.getFieldDescriptors()) {
            ModifiersTree fieldModifiers = maker.Modifiers(Wadl2JavaHelper.getModifiers(field.getModifiers()));
            ExpressionTree fieldType = JavaSourceHelper.createTypeTree(copy, field.getType());
            VariableTree fieldTree = maker.Variable(fieldModifiers, (CharSequence)field.getName(), (Tree)fieldType, null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)fieldTree);
        }
        for (MethodDescriptor m : securityParams.getMethodDescriptors()) {
            String body;
            ModifiersTree methodModifiers = maker.Modifiers(Wadl2JavaHelper.getModifiers(m.getModifiers()));
            ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
            String pList = m.getParamNames();
            if (pList != null) {
                List<String> paramN = Wadl2JavaHelper.getList(pList);
                List<String> paramT = Wadl2JavaHelper.getList(m.getParamTypes());
                ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
                for (int i = 0; i < paramN.size(); ++i) {
                    ExpressionTree paramTypeTree = JavaSourceHelper.createTypeTree(copy, paramT.get(i));
                    VariableTree paramTree = maker.Variable(paramModifier, (CharSequence)paramN.get(i), (Tree)paramTypeTree, null);
                    paramList.add(paramTree);
                }
            }
            ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
            String tList = m.getThrows();
            if (tList != null) {
                for (String thr : Wadl2JavaHelper.getList(tList)) {
                    throwsList.add(JavaSourceHelper.createTypeTree(copy, thr));
                }
            }
            if ((body = m.getBody()) == null) {
                String bodyTemplate = m.getBodyRef();
                if (bodyTemplate != null) {
                    body = Wadl2JavaHelper.getMethodBody(bodyTemplate);
                }
                if (body == null) {
                    body = "void".equals(m.getReturnType()) ? "{}" : "{return null;}";
                }
            }
            MethodTree methodTree = maker.Method(methodModifiers, (CharSequence)m.getName(), (Tree)JavaSourceHelper.createTypeTree(copy, m.getReturnType()), Collections.emptyList(), paramList, throwsList, body, null);
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)methodTree);
        }
        return modifiedClass;
    }

    private static List<String> getList(String s) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(s, ",");
        while (tokens.hasMoreTokens()) {
            list.add(tokens.nextToken().trim());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getMethodBody(String templatePath) {
        FileObject templateFo = FileUtil.getConfigFile((String)templatePath);
        if (templateFo != null) {
            String string;
            StringWriter writer;
            block10: {
                InputStreamReader is = null;
                writer = null;
                try {
                    int b;
                    is = new InputStreamReader(templateFo.getInputStream(), Charset.forName("UTF-8"));
                    writer = new StringWriter();
                    char[] buffer = new char[1024];
                    while ((b = is.read(buffer)) != -1) {
                        writer.write(buffer, 0, b);
                    }
                    string = writer.toString();
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (writer != null) {
                            writer.close();
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        return null;
                    }
                }
                is.close();
            }
            if (writer != null) {
                writer.close();
            }
            return string;
        }
        return null;
    }

    private static Set<Modifier> getModifiers(String modif) {
        HashSet<Modifier> modifs = new HashSet<Modifier>();
        if (modif != null) {
            if (modif.contains("public")) {
                modifs.add(Modifier.PUBLIC);
            } else if (modif.contains("protected")) {
                modifs.add(Modifier.PROTECTED);
            } else if (modif.contains("private")) {
                modifs.add(Modifier.PRIVATE);
            }
            if (modif.contains("static")) {
                modifs.add(Modifier.STATIC);
            }
            if (modif.contains("final")) {
                modifs.add(Modifier.FINAL);
            }
        }
        return modifs;
    }

    static ClassTree addSessionAuthServlets(WorkingCopy copy, ClassTree originalClass, SecurityParams securityParams, boolean annotateServlet) {
        ClassTree modifiedClass = originalClass;
        TreeMaker maker = copy.getTreeMaker();
        TypeElement servletAn = copy.getElements().getTypeElement("javax.servlet.annotation.WebServlet");
        for (ServletDescriptor classDescriptor : securityParams.getServletDescriptors()) {
            ClassTree innerClass;
            String className = classDescriptor.getClassName();
            ModifiersTree classModifiers = maker.Modifiers(Wadl2JavaHelper.getModifiers(classDescriptor.getModifiers()));
            if (annotateServlet && servletAn != null) {
                ArrayList<AssignmentTree> attrs = new ArrayList<AssignmentTree>();
                attrs.add(maker.Assignment((ExpressionTree)maker.Identifier((CharSequence)"name"), (ExpressionTree)maker.Literal((Object)className)));
                attrs.add(maker.Assignment((ExpressionTree)maker.Identifier((CharSequence)"urlPatterns"), (ExpressionTree)maker.Literal((Object)classDescriptor.getServletMapping())));
                AnnotationTree servletAnnotation = maker.Annotation((Tree)maker.QualIdent((Element)servletAn), attrs);
                classModifiers = maker.addModifiersAnnotation(classModifiers, servletAnnotation);
            }
            ExpressionTree extendsTree = JavaSourceHelper.createTypeTree(copy, "javax.servlet.http.HttpServlet");
            ClassTree modifiedInnerClass = innerClass = maker.Class(classModifiers, (CharSequence)className, Collections.emptyList(), (Tree)extendsTree, Collections.emptyList(), Collections.emptyList());
            for (MethodDescriptor m : classDescriptor.getMethodDescriptor()) {
                String body;
                ModifiersTree methodModifiers = maker.Modifiers(Wadl2JavaHelper.getModifiers(m.getModifiers()));
                ArrayList<VariableTree> paramList = new ArrayList<VariableTree>();
                String pList = m.getParamNames();
                if (pList != null) {
                    List<String> paramN = Wadl2JavaHelper.getList(pList);
                    List<String> paramT = Wadl2JavaHelper.getList(m.getParamTypes());
                    ModifiersTree paramModifier = maker.Modifiers(Collections.emptySet());
                    for (int i = 0; i < paramN.size(); ++i) {
                        ExpressionTree paramTypeTree = JavaSourceHelper.createTypeTree(copy, paramT.get(i));
                        VariableTree paramTree = maker.Variable(paramModifier, (CharSequence)paramN.get(i), (Tree)paramTypeTree, null);
                        paramList.add(paramTree);
                    }
                }
                ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
                String tList = m.getThrows();
                if (tList != null) {
                    for (String thr : Wadl2JavaHelper.getList(tList)) {
                        throwsList.add(JavaSourceHelper.createTypeTree(copy, thr));
                    }
                }
                if ((body = m.getBody()) == null && (body = Wadl2JavaHelper.getMethodBody(m.getBodyRef())) == null) {
                    body = "void".equals(m.getReturnType()) ? "{}" : "{return null;}";
                }
                MethodTree methodTree = maker.Method(methodModifiers, (CharSequence)m.getName(), (Tree)JavaSourceHelper.createTypeTree(copy, m.getReturnType()), Collections.emptyList(), paramList, throwsList, body, null);
                modifiedInnerClass = maker.addClassMember(modifiedInnerClass, (Tree)methodTree);
            }
            modifiedClass = maker.addClassMember(modifiedClass, (Tree)modifiedInnerClass);
        }
        return modifiedClass;
    }

    static class Pair<T> {
        private T key;
        private T value;

        public Pair(T key, T value) {
            this.key = key;
            this.value = value;
        }

        public T getKey() {
            return this.key;
        }

        public T getValue() {
            return this.value;
        }
    }
}

