/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.bind.JAXBException;
import org.netbeans.modules.websvc.rest.client.JerseyClientWizardPanel;
import org.netbeans.modules.websvc.rest.client.RESTExplorerPanel;
import org.netbeans.modules.websvc.rest.client.SaasExplorerPanel;
import org.netbeans.modules.websvc.rest.client.Security;
import org.netbeans.modules.websvc.rest.client.Wadl2JavaHelper;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasMetadata;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class RESTResourcesPanel
extends JPanel {
    private Object[] cbDefault = new Object[]{Security.Authentication.NONE, Security.Authentication.BASIC};
    boolean securityDefault = true;
    private Node resourceNode;
    private DialogDescriptor descriptor;
    private boolean nameChangedByUser = false;
    private JerseyClientWizardPanel wizardPanel;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public RESTResourcesPanel(JerseyClientWizardPanel wizardPanel) {
        this.init();
        this.wizardPanel = wizardPanel;
        this.jLabel2.setVisible(false);
        this.jTextField2.setVisible(false);
    }

    public RESTResourcesPanel() {
        this.init();
        this.jTextField2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RESTResourcesPanel.this.nameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RESTResourcesPanel.this.nameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RESTResourcesPanel.this.nameChanged();
            }
        });
    }

    private void init() {
        this.initComponents();
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RESTResourcesPanel.this.resourceChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RESTResourcesPanel.this.resourceChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RESTResourcesPanel.this.resourceChanged();
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(this.cbDefault));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RESTResourcesPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel2.setLabelFor(this.jTextField2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jLabel2.text"));
        this.jLabel3.setLabelFor(this.jTextField1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jLabel3.text"));
        this.jTextField1.setEditable(false);
        this.jLabel4.setLabelFor(this.jComboBox1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jLabel4.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jCheckBox1.text"));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton1, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jRadioButton1.text"));
        this.jRadioButton1.setToolTipText(NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jRadioButton1_hint"));
        this.jPanel1.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton2, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jRadioButton2.text"));
        this.jRadioButton2.setToolTipText(NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jRadioButton2_hint"));
        this.jPanel1.add(this.jRadioButton2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.jLabel3).addComponent(this.jTextField1, -1, 358, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, 0, 198, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(28, 28, 28).addComponent(this.jTextField2, -1, 249, Short.MAX_VALUE)).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 33, -2)).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3, -2, 17, -2).addGap(4, 4, 4).addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jComboBox1, -2, 23, -2).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
        descriptor.setValid(false);
    }

    private void resourceChanged() {
        WadlSaasResource saasResource = (WadlSaasResource)this.resourceNode.getLookup().lookup(WadlSaasResource.class);
        if (saasResource != null) {
            boolean isOauth = false;
            try {
                if (saasResource.getSaas().getOauthMetadata() != null) {
                    this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(new Object[]{Security.Authentication.OAUTH}));
                    this.securityDefault = false;
                    isOauth = true;
                }
            }
            catch (IOException ex) {
            }
            catch (JAXBException ex) {
                // empty catch block
            }
            if (!isOauth) {
                SaasMetadata.Authentication auth = saasResource.getSaas().getSaasMetadata().getAuthentication();
                if (auth != null) {
                    if (auth.getSessionKey().size() > 0) {
                        this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(new Object[]{Security.Authentication.SESSION_KEY}));
                        this.securityDefault = false;
                    } else if (auth.getHttpBasic() != null) {
                        if (!this.securityDefault) {
                            this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(this.cbDefault));
                            this.securityDefault = true;
                        }
                        this.jComboBox1.setSelectedItem((Object)Security.Authentication.BASIC);
                    } else if (!this.securityDefault) {
                        this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(this.cbDefault));
                        this.securityDefault = true;
                    }
                } else if (!this.securityDefault) {
                    this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(this.cbDefault));
                    this.securityDefault = true;
                }
            }
        } else if (!this.securityDefault) {
            this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(this.cbDefault));
            this.securityDefault = true;
        }
        this.jComboBox1.setEnabled(this.securityDefault);
        if (this.wizardPanel == null) {
            if (!this.nameChangedByUser || this.jTextField2.getText().trim().length() == 0) {
                if (saasResource != null) {
                    this.jTextField2.setText(Wadl2JavaHelper.getClientClassName(saasResource));
                } else {
                    RestServiceDescription restServiceDesc = (RestServiceDescription)this.resourceNode.getLookup().lookup(RestServiceDescription.class);
                    if (restServiceDesc != null) {
                        this.jTextField2.setText(restServiceDesc.getName() + "_JerseyClient");
                    }
                }
            }
        } else {
            this.wizardPanel.fireChangeEvent();
        }
    }

    private void nameChanged() {
        if (this.wizardPanel == null) {
            if (this.jTextField2.getText().trim().length() == 0) {
                this.descriptor.setValid(false);
            } else if (this.resourceNode == null) {
                this.descriptor.setValid(false);
            } else {
                this.descriptor.setValid(true);
            }
            this.nameChangedByUser = true;
        }
    }

    boolean isValid(WizardDescriptor wiz) {
        if (this.wizardPanel != null && wiz != null) {
            if (this.resourceNode != null) {
                return true;
            }
            wiz.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(RESTResourcesPanel.class, (String)"LBL_SelectRestResource"));
            return false;
        }
        return true;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.jRadioButton1.isSelected()) {
            RESTExplorerPanel explorerPanel = new RESTExplorerPanel();
            DialogDescriptor desc = new DialogDescriptor((Object)explorerPanel, NbBundle.getMessage(RESTResourcesPanel.class, (String)"TTL_RESTResources"));
            explorerPanel.setDescriptor(desc);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)desc).equals(NotifyDescriptor.OK_OPTION)) {
                this.resourceNode = explorerPanel.getSelectedService();
                boolean isChangedByUser = this.nameChangedByUser;
                this.jTextField1.setText(this.resourceNode.getDisplayName());
                if (!isChangedByUser) {
                    this.nameChangedByUser = false;
                }
            }
        } else {
            SaasExplorerPanel explorerPanel = new SaasExplorerPanel();
            DialogDescriptor desc = new DialogDescriptor((Object)explorerPanel, NbBundle.getMessage(RESTResourcesPanel.class, (String)"TTL_RESTResources"));
            explorerPanel.setDescriptor(desc);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)desc).equals(NotifyDescriptor.OK_OPTION)) {
                this.resourceNode = explorerPanel.getSelectedService();
                boolean isChangedByUser = this.nameChangedByUser;
                this.jTextField1.setText(RESTResourcesPanel.getSaasResourceName(this.resourceNode));
                if (!isChangedByUser) {
                    this.nameChangedByUser = false;
                }
            }
        }
        if (this.resourceNode != null && this.wizardPanel == null) {
            this.descriptor.setValid(true);
        }
    }

    public static String getSaasResourceName(Node node) {
        Node saasNode;
        WadlSaasResource saasResource = (WadlSaasResource)node.getLookup().lookup(WadlSaasResource.class);
        String resourceName = saasResource.getResource().getPath();
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        for (saasNode = node.getParentNode(); saasNode != null && saasNode.getLookup().lookup(WadlSaas.class) == null; saasNode = saasNode.getParentNode()) {
            saasResource = (WadlSaasResource)saasNode.getLookup().lookup(WadlSaasResource.class);
            if (saasResource != null) {
                String path = saasResource.getResource().getPath();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.length() <= 0) continue;
                resourceName = path + "/" + resourceName;
                continue;
            }
            resourceName = saasNode.getDisplayName() + "/" + resourceName;
        }
        if (saasNode != null) {
            resourceName = saasNode.getDisplayName() + " [" + resourceName + "]";
        }
        return resourceName;
    }

    public Node getResourceNode() {
        return this.resourceNode;
    }

    public String getResourceName() {
        return this.jTextField1.getText().trim();
    }

    public String getClassName() {
        return this.jTextField2.getText().trim();
    }

    public Security getSecurity() {
        return new Security(this.jCheckBox1.isSelected(), (Security.Authentication)((Object)this.jComboBox1.getSelectedItem()));
    }
}

